/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.dao.mongo.ApplicationDao;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployDetailV2Dao;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployLogDao;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployParamRecordDao;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployTaskDao;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.DeployLogParam;
import com.digiwin.athena.athenadeployer.dto.deployer.DeleteModelByEnvAndAppDto;
import com.digiwin.athena.athenadeployer.dto.deployer.DeleteModelDto;
import com.digiwin.athena.athenadeployer.dto.deployer.KmDeployCleanApp;
import com.digiwin.athena.athenadeployer.http.BackendApiHelper;
import com.digiwin.athena.athenadeployer.http.deployService.DeployServiceApiHelper;
import com.digiwin.athena.athenadeployer.service.DeleteApplicationService;
import com.digiwin.athena.athenadeployer.service.EnvService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DeleteApplicationServiceImpl
implements DeleteApplicationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeleteApplicationServiceImpl.class);
    @Autowired
    private BackendApiHelper backendApiHelper;
    @Autowired
    private DeployServiceApiHelper deployServiceApiHelper;
    @Autowired
    protected DeployLogDao deployLogDao;
    @Autowired
    private EnvService envService;
    @Autowired
    private DeployDetailV2Dao deployDetailV2Dao;
    @Autowired
    private ApplicationDao applicationDao;
    @Autowired
    private DeployParamRecordDao deployParamRecordDao;
    @Autowired
    private DeployTaskDao deployTaskDao;
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate mongoTemplate;

    public void queryDeployLogByAppDeleteKm(DeployLogParam deployLogParam) {
        log.info("\u8c03\u7528queryDeployLogByAppDeleteKm\u65b9\u6cd5\u5165\u53c2\u4e3a:{}", (Object)JSON.toJSONString((Object)deployLogParam));
        List envs = this.getDeployEnvs(deployLogParam.getApplication());
        log.info("queryDeployLogByAppDeleteKm \u65b9\u6cd5\u67e5\u8be2\u7684\u73af\u5883\u4fe1\u606f\u4e3a:{}", (Object)JSON.toJSONString((Object)envs));
        KmDeployCleanApp kmDeployCleanApp = new KmDeployCleanApp();
        String tenantId = AthenaUserLocal.getUser().getTenantId();
        kmDeployCleanApp.setAppId(deployLogParam.getApplication());
        kmDeployCleanApp.setTenantId(tenantId);
        if (CollUtil.isNotEmpty((Collection)envs)) {
            envs.forEach(env -> {
                this.backendApiHelper.deployCleanApp(kmDeployCleanApp, env);
                this.backendApiHelper.kmCacheReset(env, tenantId);
                this.backendApiHelper.atmcCacheReset(env);
                this.deployServiceApiHelper.deployCleanTenantApp(deployLogParam.getApplication(), env);
            });
        }
    }

    public List<String> queryDeployEnvByApp(DeployLogParam deployLogParam) {
        log.info("\u8c03\u7528queryDeployEnvByApp\u65b9\u6cd5\u5165\u53c2\u4e3a:{}", (Object)JSON.toJSONString((Object)deployLogParam));
        DeployLog deployLog = this.deployLogDao.getDeployByApplicationLimit(deployLogParam.getApplication());
        if (deployLog == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(deployLog.getId());
    }

    public void deleteModelByEnvAndApp(DeleteModelDto deleteModelDto) {
        log.info("\u3010\u5e94\u7528\u5220\u9664\u3011\u8bf7\u6c42deleteModelByEnvAndApp \u65b9\u6cd5\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)deleteModelDto));
        List deployEnvs = this.getDeployEnvs(deleteModelDto.getApplication());
        if (CollectionUtils.isEmpty((Collection)deployEnvs)) {
            log.info("\u8be5\u5e94\u7528\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u53d1\u7248\u73af\u5883\u4fe1\u606f");
        } else {
            log.info("deleteModelByEnvAndApp \u65b9\u6cd5\u67e5\u8be2\u7684\u73af\u5883\u4fe1\u606f\u4e3a:{}", (Object)JSON.toJSONString((Object)deployEnvs));
            ArrayList<DeleteModelByEnvAndAppDto> dtoList = new ArrayList<DeleteModelByEnvAndAppDto>();
            List modelInfoList = deleteModelDto.getModelInfoList();
            if (!CollectionUtils.isEmpty((Collection)modelInfoList)) {
                for (DeleteModelDto.ModelInfo modelInfo : modelInfoList) {
                    DeleteModelByEnvAndAppDto appDto = new DeleteModelByEnvAndAppDto();
                    appDto.setCode(modelInfo.getModelCode());
                    DeleteModelByEnvAndAppDto.AppInfo appInfo = new DeleteModelByEnvAndAppDto.AppInfo();
                    appInfo.setProd(modelInfo.getServiceCode());
                    appInfo.setTargetProd(modelInfo.getTargetProd());
                    appDto.setAppInfo(appInfo);
                    dtoList.add(appDto);
                }
            }
            if (!CollectionUtils.isEmpty(dtoList)) {
                String tenantId = AthenaUserLocal.getUser().getTenantId();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("publishModels", dtoList);
                jsonObject.put("tenantId", (Object)tenantId);
                jsonObject.put("appToken", (Object)deleteModelDto.getAppToken());
                if (CollUtil.isNotEmpty((Collection)deployEnvs)) {
                    deployEnvs.forEach(env -> this.backendApiHelper.deleteAppModel(jsonObject, env));
                }
            }
        }
    }

    private List<String> getDeployEnvs(String application) {
        return this.deployLogDao.getDeployByApplication(application);
    }

    public List<String> queryFormalZoneList(String application) {
        log.info("\u3010\u5e94\u7528\u5220\u9664\u3011\u5f00\u59cb\u67e5\u8be2\u53d1\u7248\u73af\u5883\u662f\u5426\u5305\u542b\u6b63\u5f0f\u533a,\u5f53\u524d\u5e94\u7528code:{}", (Object)application);
        List formalZoneLists = this.envService.queryFormalZone();
        if (CollectionUtils.isEmpty((Collection)formalZoneLists)) {
            return Collections.emptyList();
        }
        DeployLog deployLog = this.deployLogDao.getDeployByApplicationFormalZone(application, formalZoneLists);
        if (deployLog == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(deployLog.getDeployParam().getEnv());
    }

    public void deleteDeployLogByApplication(String application) {
        log.info("\u3010\u5e94\u7528\u5220\u9664\u3011\u5f00\u59cb\u5220\u9664\u53d1\u7248\u8bb0\u5f55\u76f8\u5173\u6570\u636e,\u5f53\u524d\u5e94\u7528code:{}", (Object)application);
        this.applicationDao.remove(application);
        this.deployLogDao.deleteDeployRecordByApplication(application);
        this.deployDetailV2Dao.deleteByDeployNo(application);
        this.deployParamRecordDao.removeByApplication(application);
        this.deployTaskDao.removeByApplication(application);
        this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application)), "modulePublishLog");
        this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application)), "modulePublishRecord");
    }
}

