/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployServiceInfoDao;
import com.digiwin.athena.athenadeployer.domain.Env;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployServiceInfo;
import com.digiwin.athena.athenadeployer.dto.manage.DeployServiceAndEnvInfoDto;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.service.DeployEnvService;
import com.digiwin.athena.athenadeployer.service.EnvService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeployEnvServiceImpl
implements DeployEnvService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployEnvServiceImpl.class);
    @Autowired
    private DeployServiceInfoDao deployServiceInfoDao;
    @Autowired
    private EnvService envService;

    public List<DeployServiceInfo> queryEnvServiceBriefInfo() {
        return this.deployServiceInfoDao.queryBriefDeployServiceInfo();
    }

    public List<DeployServiceAndEnvInfoDto> queryAllEnvService() {
        List deployServiceInfoList = this.deployServiceInfoDao.queryAllDeployServiceInfo();
        ArrayList<DeployServiceAndEnvInfoDto> result = new ArrayList<DeployServiceAndEnvInfoDto>();
        deployServiceInfoList.forEach(deployServiceInfo -> result.add(this.combineDeployServiceAndEnvInfoDto(deployServiceInfo)));
        return result;
    }

    @Transactional
    public void setSameArea(String serviceId) {
        List deployServiceInfos = this.deployServiceInfoDao.querySameAreaDeployServiceInfo();
        Boolean dbHasSameData = false;
        for (DeployServiceInfo ds : deployServiceInfos) {
            if (ds.getServiceId().equals(serviceId)) {
                dbHasSameData = true;
                continue;
            }
            this.deployServiceInfoDao.updateSameAreaByServiceId(ds.getServiceId(), Boolean.valueOf(false));
        }
        if (!dbHasSameData.booleanValue()) {
            this.deployServiceInfoDao.updateSameAreaByServiceId(serviceId, Boolean.valueOf(true));
        }
    }

    public DeployServiceAndEnvInfoDto queryEnvServiceByServiceId(String serviceId) {
        DeployServiceInfo deployServiceInfo = this.deployServiceInfoDao.queryDeployServiceInfoByServiceId(serviceId);
        if (null == deployServiceInfo) {
            return new DeployServiceAndEnvInfoDto();
        }
        return this.combineDeployServiceAndEnvInfoDto(deployServiceInfo);
    }

    private DeployServiceAndEnvInfoDto combineDeployServiceAndEnvInfoDto(DeployServiceInfo deployServiceInfo) {
        DeployServiceAndEnvInfoDto deployServiceAndEnvInfoDto = new DeployServiceAndEnvInfoDto();
        Env sandboxEnv = this.envService.queryEnvsByOperateAndServiceId(EnvOperateEnum.PUBLISH.getOperate(), deployServiceInfo.getServiceId());
        Env workingEnv = this.envService.queryEnvsByOperateAndServiceId(EnvOperateEnum.SWITCH.getOperate(), deployServiceInfo.getServiceId());
        BeanUtils.copyProperties((Object)deployServiceInfo, (Object)deployServiceAndEnvInfoDto);
        deployServiceAndEnvInfoDto.setSandboxEnv(sandboxEnv).setWorkingEnv(workingEnv);
        return deployServiceAndEnvInfoDto;
    }

    @Transactional
    public DeployServiceAndEnvInfoDto save(DeployServiceAndEnvInfoDto deployServiceAndEnvInfoDto) {
        Env workingEnv;
        DeployServiceInfo ds = this.deployServiceInfoDao.queryDeployServiceInfoByServiceId(deployServiceAndEnvInfoDto.getServiceId());
        if (ds != null) {
            throw new BusinessException("\u76f8\u540c\u4e91\u533a\u4ee3\u53f7\u6570\u636e\u5df2\u5b58\u5728\uff0c\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        Env sandboxEnvRe = new Env();
        Env workingEnvRe = new Env();
        Env sandboxEnv = deployServiceAndEnvInfoDto.getSandboxEnv();
        if (ObjectUtil.isNotEmpty((Object)sandboxEnv)) {
            if (CollUtil.isNotEmpty((Collection)this.envService.queryByEnv(sandboxEnv.getEnv()))) {
                throw new BusinessException("\u4e91\u533a\u76f8\u540c\u6c99\u7bb1\u73af\u5883\u6570\u636e\u5df2\u5b58\u5728\uff0c\u4fdd\u5b58\u5931\u8d25\uff01");
            }
            sandboxEnv.setServiceId(deployServiceAndEnvInfoDto.getServiceId());
            sandboxEnvRe = this.envService.insertEnv(sandboxEnv);
        }
        if (ObjectUtil.isNotEmpty((Object)(workingEnv = deployServiceAndEnvInfoDto.getWorkingEnv()))) {
            if (CollUtil.isNotEmpty((Collection)this.envService.queryByEnv(workingEnv.getEnv()))) {
                throw new BusinessException("\u4e91\u533a\u76f8\u540c\u8fd0\u884c\u73af\u5883\u6570\u636e\u5df2\u5b58\u5728\uff0c\u4fdd\u5b58\u5931\u8d25\uff01");
            }
            workingEnv.setServiceId(deployServiceAndEnvInfoDto.getServiceId());
            workingEnvRe = this.envService.insertEnv(workingEnv);
        }
        DeployServiceInfo deployServiceInfo = new DeployServiceInfo();
        BeanUtils.copyProperties((Object)deployServiceAndEnvInfoDto, (Object)deployServiceInfo);
        DeployServiceInfo deployServiceInfoRe = this.deployServiceInfoDao.insert(deployServiceInfo);
        return this.combineRespDeployServiceAndEnvInfo(deployServiceInfoRe, sandboxEnvRe, workingEnvRe);
    }

    @Transactional
    public DeployServiceAndEnvInfoDto update(DeployServiceAndEnvInfoDto deployServiceAndEnvInfoDto) {
        DeployServiceInfo ds = this.deployServiceInfoDao.queryDeployServiceInfoByServiceId(deployServiceAndEnvInfoDto.getServiceId());
        if (null == ds) {
            throw new BusinessException("\u8be5\u4e91\u533a\u4ee3\u53f7\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        Env sandboxEnvRe = new Env();
        Env workingEnvRe = new Env();
        Env sandboxEnv = deployServiceAndEnvInfoDto.getSandboxEnv();
        Env workingEnv = deployServiceAndEnvInfoDto.getWorkingEnv();
        sandboxEnv.setServiceId(deployServiceAndEnvInfoDto.getServiceId());
        workingEnv.setServiceId(deployServiceAndEnvInfoDto.getServiceId());
        DeployServiceInfo deployServiceInfo = new DeployServiceInfo().setObjectId(ds.getObjectId());
        BeanUtils.copyProperties((Object)deployServiceAndEnvInfoDto, (Object)deployServiceInfo);
        DeployServiceInfo deployServiceInfoRe = this.deployServiceInfoDao.update(deployServiceInfo);
        List sandboxEnvDb = this.envService.queryByEnv(sandboxEnv.getEnv());
        if (ObjectUtil.isNotEmpty((Object)sandboxEnv)) {
            if (CollUtil.isEmpty((Collection)sandboxEnvDb)) {
                sandboxEnvRe = this.envService.insertEnv(sandboxEnv);
            } else {
                sandboxEnv.setObjectId(((Env)sandboxEnvDb.get(0)).getObjectId());
                sandboxEnvRe = this.envService.updateEnv(sandboxEnv);
            }
        }
        List workingEnvDb = this.envService.queryByEnv(workingEnv.getEnv());
        if (ObjectUtil.isNotEmpty((Object)workingEnv)) {
            if (CollUtil.isEmpty((Collection)workingEnvDb)) {
                workingEnvRe = this.envService.insertEnv(workingEnv);
            } else {
                workingEnv.setObjectId(((Env)workingEnvDb.get(0)).getObjectId());
                workingEnvRe = this.envService.updateEnv(workingEnv);
            }
        }
        return this.combineRespDeployServiceAndEnvInfo(deployServiceInfoRe, sandboxEnvRe, workingEnvRe);
    }

    private DeployServiceAndEnvInfoDto combineRespDeployServiceAndEnvInfo(DeployServiceInfo deployServiceInfoRe, Env sandboxEnvRe, Env workingEnvRe) {
        DeployServiceAndEnvInfoDto re = new DeployServiceAndEnvInfoDto();
        BeanUtils.copyProperties((Object)deployServiceInfoRe, (Object)re);
        re.setSandboxEnv(sandboxEnvRe).setWorkingEnv(workingEnvRe);
        return re;
    }

    @Transactional
    public void deleteByServiceId(String serviceId) {
        this.deployServiceInfoDao.delete(serviceId);
        this.envService.deleteEnvByServiceId(serviceId);
    }
}

