/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.athenadeployer.config.ModuleConfig;
import com.digiwin.athena.athenadeployer.constant.DeployStepEnum;
import com.digiwin.athena.athenadeployer.constant.SwitchStepEnum;
import com.digiwin.athena.athenadeployer.dao.mongo.ApplicationDao;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployDetailV2Dao;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployLogDao;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployTaskDao;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.ApplicationPO;
import com.digiwin.athena.athenadeployer.domain.AssistantProjectModelPO;
import com.digiwin.athena.athenadeployer.domain.AssistantProjectPO;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.Cql;
import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.domain.Env;
import com.digiwin.athena.athenadeployer.domain.TenantUser;
import com.digiwin.athena.athenadeployer.domain.application.Application;
import com.digiwin.athena.athenadeployer.domain.application.ApplicationConfig;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import com.digiwin.athena.athenadeployer.domain.base.ResultBean;
import com.digiwin.athena.athenadeployer.domain.compile.CompileParam;
import com.digiwin.athena.athenadeployer.domain.deploy.AdTemplatePublishParam;
import com.digiwin.athena.athenadeployer.domain.deploy.Application2CommonRelationParam;
import com.digiwin.athena.athenadeployer.domain.deploy.ApplicationCopyParam;
import com.digiwin.athena.athenadeployer.domain.deploy.BsonInfo;
import com.digiwin.athena.athenadeployer.domain.deploy.CleanMongoParam;
import com.digiwin.athena.athenadeployer.domain.deploy.CleanNeo4jParam;
import com.digiwin.athena.athenadeployer.domain.deploy.CreateApplicationRelationParam;
import com.digiwin.athena.athenadeployer.domain.deploy.CustomPublishParam;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployDetailV2;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamRecord;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV2;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployPreTaskResult;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ExecuteBsonParam;
import com.digiwin.athena.athenadeployer.domain.deploy.GmcUpdateParam;
import com.digiwin.athena.athenadeployer.domain.deploy.IamAddPolicyParam;
import com.digiwin.athena.athenadeployer.domain.deploy.IamAssignmentAuthorizeParam;
import com.digiwin.athena.athenadeployer.domain.deploy.KmDeploySwitchParam;
import com.digiwin.athena.athenadeployer.domain.deploy.KmProcessLog;
import com.digiwin.athena.athenadeployer.domain.deploy.LcdpPublishParam;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.domain.deploy.QueryDeployLogParam;
import com.digiwin.athena.athenadeployer.domain.deploy.QueryDeployLogResult;
import com.digiwin.athena.athenadeployer.domain.deploy.Relation;
import com.digiwin.athena.athenadeployer.domain.deploy.Tenant2NodeRelationParam;
import com.digiwin.athena.athenadeployer.domain.deploy.WriteData2DbParam;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Node;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.TenantPipeLine;
import com.digiwin.athena.athenadeployer.domain.model.ApiMgmtBaseInfo;
import com.digiwin.athena.athenadeployer.dto.deployer.AddPlanResp;
import com.digiwin.athena.athenadeployer.dto.deployer.DeployTaskInfoResDto;
import com.digiwin.athena.athenadeployer.dto.deployer.UnableSwitchAppDTO;
import com.digiwin.athena.athenadeployer.dto.designer.ApplicationInfoDto;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.http.BackendApiHelper;
import com.digiwin.athena.athenadeployer.http.BmdApiHelper;
import com.digiwin.athena.athenadeployer.http.DesignerApiHelper;
import com.digiwin.athena.athenadeployer.http.IamApiHelper;
import com.digiwin.athena.athenadeployer.http.asa.AsaDeployerServiceApiHelper;
import com.digiwin.athena.athenadeployer.http.deployService.DeployServiceApiHelper;
import com.digiwin.athena.athenadeployer.http.designer.dto.SecurityTaskDto;
import com.digiwin.athena.athenadeployer.service.AsyncService;
import com.digiwin.athena.athenadeployer.service.CustomPublishService;
import com.digiwin.athena.athenadeployer.service.DeployServiceV3;
import com.digiwin.athena.athenadeployer.service.DeployerService;
import com.digiwin.athena.athenadeployer.service.DmcService;
import com.digiwin.athena.athenadeployer.service.EnvService;
import com.digiwin.athena.athenadeployer.service.PresetDataService;
import com.digiwin.athena.athenadeployer.service.ReleasePipeLineService;
import com.digiwin.athena.athenadeployer.service.deployTask.SyncModelCentralTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import com.digiwin.athena.athenadeployer.utils.BmdEnvMapUtil;
import com.digiwin.athena.athenadeployer.utils.CurThreadInfoUtils;
import com.digiwin.athena.athenadeployer.utils.RedisCache;
import com.digiwin.athena.athenadeployer.utils.StandardParamsUtil;
import com.digiwin.athena.athenadeployer.utils.TenantPipelineHelper;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import jakarta.annotation.Resource;
import java.io.File;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DeployServiceImplV3
implements DeployServiceV3 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployServiceImplV3.class);
    @Autowired
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate mongoTemplate;
    @Autowired
    private BackendApiHelper backendApiHelper;
    @Autowired
    private DesignerApiHelper designerApiHelper;
    @Autowired
    @Lazy
    private AsaDeployerServiceApiHelper asaDeployerServiceApiHelper;
    @Autowired
    private DeployerService deployerService;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private AsyncService asyncService;
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate deployerMongoTemplate;
    @Value(value="${compile.zipPath}")
    private String compileZipPath;
    @Value(value="${compile.dataPath}")
    private String compileDataPath;
    @Value(value="${espaction.bindapp}")
    private String bindApps;
    @Value(value="${env}")
    private String currentEnv;
    @Autowired
    private CustomPublishService customPublishService;
    @Autowired
    private PresetDataService presetDataService;
    @Autowired
    private EnvService envService;
    @Autowired
    private DeployLogDao deployLogDao;
    @Autowired
    private DeployDetailV2Dao deployDetailV2Dao;
    @Autowired
    private BmdApiHelper bmdApiHelper;
    @Autowired
    private DmcService dmcService;
    @Autowired
    private ApplicationDao applicationDao;
    @Autowired
    private ReleasePipeLineService releasePipeLineService;
    @Autowired
    private BmdEnvMapUtil bmdEnvMapUtil;
    @Autowired
    private StandardParamsUtil standardParamsUtil;
    @Autowired
    private DeployTaskDao deployTaskDao;
    private DeployServiceApiHelper deployServiceApiHelper;
    @Autowired
    private IamApiHelper iamApiHelper;
    @Value(value="${privateEnv}")
    private Boolean privateEnv;
    @Autowired
    private ModuleConfig moduleConfig;
    public static final List<String> PATTERN_TBB = Arrays.asList("STATEMENT", "MOBI-STATEMENT");
    public static final List<String> PATTERN_ABI = Arrays.asList("STATEMENT");
    public static final List<String> CATEGORY_TBB = Arrays.asList("STATEMENT");
    public static final List<String> CATEGORY_ABI = Arrays.asList("ABI-STATEMENT");
    public static String DEPLOY_LIST_KEY = "ATHENA_DEPLOYER_DEPLOY_LIST";
    public static int API_STATUS_CONFIRMED = 4;
    public static String SWITCH_LIST_KEY = "ATHENA_DEPLOYER_SWITCH_LIST";
    public static String DEPLOY_PROCESS_KEY = "ATHENA_DEPLOYER_DEPLOY_PROCESS_V2__";
    private static final BigDecimal APPLICATION_DEPLOY_STEP_NUM = new BigDecimal(12);
    private static final BigDecimal APPLICATION_SWITCH_STEP_NUM = new BigDecimal(10);
    private static String SYNC_ESP_EXECUTING_KEY = "SYNC_ESP_EXECUTING_STATUS";
    private static String SYNC_ESP_EXECUTING_LOCK = "SYNC_ESP_EXECUTING_LOCK";
    private static String APP_DEPLOY_OR_SWITCH_LOCK = "DEPLOYER_APP_DEPLOY_OR_SWITCH_LOCK";

    @Autowired
    public void setDeployServiceApiHelper(DeployServiceApiHelper deployServiceApiHelper) {
        this.deployServiceApiHelper = deployServiceApiHelper;
    }

    public void deploy(DeployParamV3 deployParam) {
        List tenantUsers = deployParam.getTenantUsers();
        List tenantIdList = tenantUsers.stream().map(tenantUser -> tenantUser.getTenantId()).collect(Collectors.toList());
        JSONArray tenantIdListCopy = JSON.parseArray((String)JSON.toJSONString(tenantIdList));
        List applicationDataList = deployParam.getApplicationDataList();
        Boolean syncEsp = deployParam.getSyncEsp();
        JSONObject neo4jNodeKeyJson = this.queryNeo4jNodeKeyJson();
        if (syncEsp != null && syncEsp.booleanValue()) {
            this.backendApiHelper.syncEspMetaData("1.0", deployParam.getEnv());
        }
        for (ApplicationData applicationData : applicationDataList) {
            Update update;
            String application = applicationData.getApplication();
            String compileDataCode = applicationData.getCompileDataCode();
            Tenant2NodeRelationParam tenant2NodeRelationParam = new Tenant2NodeRelationParam().setTenantIds(tenantIdList).setApplication(application).setTenantVersion("1.0");
            List authAppTenantIdList = this.backendApiHelper.getAuthAppTenantIdList(tenant2NodeRelationParam, deployParam.getEnv());
            tenantIdList.addAll(authAppTenantIdList);
            tenantIdList = tenantIdList.stream().distinct().collect(Collectors.toList());
            Application2CommonRelationParam findApplication2CommonParam = new Application2CommonRelationParam().setTenantIdList(tenantIdList).setApplicationList((List)ListUtil.toList((Object[])new String[]{application, "common", "espCommon"})).setNeo4jNodeKeyJson(neo4jNodeKeyJson).setApplicationVersion("1.0").setCommonVersion("1.0");
            List testApplication2testCommonRelations = this.backendApiHelper.findApplication2CommonRelations(findApplication2CommonParam, deployParam.getEnv());
            ApplicationPO applicationPO = this.designerApiHelper.getApplicationByCode(application, AthenaUserLocal.getUser().getToken());
            JSONObject compiledData = this.designerApiHelper.queryCompiledDataByCode(compileDataCode, AthenaUserLocal.getUser().getToken());
            WriteData2DbParam writeData2DbParam = new WriteData2DbParam();
            writeData2DbParam.setApplication(application).setCompiledData(compiledData).setDeployVersion("1.0").setCurrentUser(AthenaUserLocal.getUser()).setAppToken(applicationPO.getAppToken()).setTenantUsers(tenantUsers);
            JSONObject res = this.backendApiHelper.writeData2Db(writeData2DbParam, deployParam.getEnv());
            this.backendApiHelper.parseResponse(res);
            res = this.backendApiHelper.switchVersion(tenantIdList, application, "1.0", deployParam.getEnv(), Boolean.valueOf(false));
            this.backendApiHelper.parseResponse(res);
            CreateApplicationRelationParam createApplicationRelationParam = new CreateApplicationRelationParam().setRelationList(testApplication2testCommonRelations).setApplicationVersion("1.0").setCommonVersion("1.0").setNeo4jNodeKeyJson(neo4jNodeKeyJson);
            this.backendApiHelper.createApplication2CommonRelation(createApplicationRelationParam, deployParam.getEnv());
            tenant2NodeRelationParam = new Tenant2NodeRelationParam().setTenantIds(tenantIdList).setApplication(application).setTenantVersion("1.0");
            this.backendApiHelper.createTenantAndApplicationRelation(tenant2NodeRelationParam, deployParam.getEnv());
            this.backendApiHelper.createTenantAndCommonRelation(tenant2NodeRelationParam, deployParam.getEnv());
            DeployParamV2 deployParamV2 = (DeployParamV2)JSON.parseObject((String)JSON.toJSONString((Object)deployParam), DeployParamV2.class);
            this.backendApiHelper.authUser(deployParamV2, AthenaUserLocal.getUser().getToken(), deployParam.getEnv());
            this.backendApiHelper.addReportPolicy(writeData2DbParam, deployParam.getEnv());
            JSONObject applicationObj = (JSONObject)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("latestEnv").is((Object)deployParam.getEnv())), JSONObject.class, "application");
            Integer status = Optional.ofNullable(applicationObj).orElse(new JSONObject()).getInteger("status");
            status = Optional.ofNullable(status).orElse(1);
            if (status == 1) {
                update = new Update();
                update.set("status", (Object)2);
                this.mongoTemplate.upsert(new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("latestEnv").is((Object)deployParam.getEnv())), (UpdateDefinition)update, "application");
            }
            this.saveDeployLog(application, "1.0", "publish", compiledData, null, null, deployParam.getEnv(), deployParam);
            update = new Update();
            update.set("latestEnv", (Object)deployParam.getEnv());
            update.set("latestTenant", tenantIdListCopy.get(0));
            update.set("latestCompileDataCode", (Object)compileDataCode);
            this.mongoTemplate.upsert(new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("latestEnv").is((Object)deployParam.getEnv())), (UpdateDefinition)update, "application");
        }
        this.backendApiHelper.kmCacheReset(deployParam.getEnv(), (String)tenantIdList.get(0));
        this.backendApiHelper.atmcCacheReset(deployParam.getEnv());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addDeployPlan(DeployParamV3 deployParam) {
        String deployNo = IdUtil.fastSimpleUUID();
        deployParam.setId(deployNo);
        Object errmsg = "";
        try {
            HashMap compatibleParam;
            boolean individual = ((ApplicationData)deployParam.getApplicationDataList().get(0)).getApplicationInfoDto().isIndividual();
            List<Object> tenantIdList = new ArrayList<String>();
            List tenantUsers = deployParam.getTenantUsers();
            if (null != tenantUsers && !tenantUsers.isEmpty()) {
                tenantIdList = deployParam.getTenantUsers().stream().map(tenantUser -> tenantUser.getTenantId()).collect(Collectors.toList());
            } else if (!individual) {
                String tenantId = deployParam.getCurrentUser().getTenantId();
                tenantIdList.add(tenantId);
                TenantUser tenantUser2 = new TenantUser();
                tenantUser2.setTenantId(tenantId);
                deployParam.setTenantUsers(Stream.of(tenantUser2).collect(Collectors.toList()));
            }
            JSONObject deployBlackList = this.presetDataService.getJSONObjByKey("deployBlackList");
            String blackList = deployBlackList.getString(deployParam.getEnv());
            if (null != blackList) {
                String[] blackTenantIdList = blackList.split(",");
                tenantIdList.retainAll(Arrays.asList(blackTenantIdList));
                if (CollUtil.isNotEmpty(tenantIdList)) {
                    errmsg = "\u53d1\u7248\u5931\u8d25\uff1a\u6240\u9009\u79df\u6237" + String.valueOf(tenantIdList) + "\u7981\u6b62\u8fdb\u884c\u53d1\u7248\u64cd\u4f5c";
                    throw new BusinessException((String)errmsg);
                }
            }
            if ((compatibleParam = (HashMap)this.presetDataService.getValueByKey("deploy_switch_compatible_param", (TypeReference)new /* Unavailable Anonymous Inner Class!! */)) == null) {
                compatibleParam = new HashMap();
            }
            this.checkDeployInfo(deployParam);
            this.checkDeployLogAppStatus(deployParam);
            RLock rLock = this.redissonClient.getLock(APP_DEPLOY_OR_SWITCH_LOCK);
            Boolean isLock = rLock.tryLock();
            Integer tryTimes = 1;
            while (!isLock.booleanValue() && tryTimes <= 20) {
                Thread.sleep(500L);
                Integer n = tryTimes;
                tryTimes = tryTimes + 1;
                isLock = rLock.tryLock();
            }
            if (isLock.booleanValue()) {
                try {
                    this.checkDeployLogAppStatus(deployParam);
                    List applicationDataList = deployParam.getApplicationDataList();
                    String env = deployParam.getEnv();
                    if (!this.privateEnv.booleanValue()) {
                        ArrayList<String> errApp = new ArrayList<String>();
                        for (ApplicationData applicationData : applicationDataList) {
                            JSONObject compiledData;
                            String application = applicationData.getApplication();
                            if (org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)compatibleParam.get("globalSwitch"))) && (!compatibleParam.containsKey(env) || !((Set)compatibleParam.get(env)).contains(application)) || (compiledData = this.designerApiHelper.queryCompiledDataByCode(applicationData.getCompileDataCode(), AthenaUserLocal.getUser().getToken())) == null || "new".equals(compiledData.get((Object)"publishMode"))) continue;
                            errApp.add(application);
                        }
                        if (!errApp.isEmpty()) {
                            errmsg = (String)errmsg + String.join((CharSequence)",", errApp) + "\u8001\u7f16\u8bd1\u8bb0\u5f55\u4e0d\u80fd\u53d1\u65b0\u6d41\u7a0b\uff0c\u8bf7\u91cd\u65b0\u7f16\u8bd1\u53d1\u7248;";
                            throw new RuntimeException((String)errmsg);
                        }
                    }
                    for (ApplicationData applicationData : applicationDataList) {
                        String application = applicationData.getApplication();
                        ApplicationInfoDto applicationInfoDto = applicationData.getApplicationInfoDto();
                        JSONObject compileData = new JSONObject();
                        compileData.put("description", (Object)applicationData.getDescription());
                        deployParam.setApplicationDataList((List)ListUtil.toList((Object[])new ApplicationData[]{applicationData}));
                        deployParam.setPublishMode("old");
                        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)compatibleParam.get("globalSwitch")))) {
                            Set globalSwitch = (Set)compatibleParam.get("globalSwitch");
                            if (!globalSwitch.contains(application)) {
                                deployParam.setPublishMode("new");
                            }
                        } else if (compatibleParam.containsKey(env) && ((Set)compatibleParam.get(env)).contains(application)) {
                            deployParam.setPublishMode("new");
                        }
                        String integrationToken = this.deployServiceApiHelper.getIntegrationToken(this.currentEnv + "-TEST", AthenaUserLocal.getUser().getTenantId());
                        deployParam.getCurrentUser().setToken(integrationToken);
                        DeployLog deployLog = DeployLog.create((String)application, (JSONObject)compileData, (String)deployNo, (String)"waiting", (DeployParamV3)deployParam, (EnvOperateEnum)EnvOperateEnum.PUBLISH, null);
                        if (applicationInfoDto != null) {
                            deployLog.setIndividual(applicationInfoDto.getIndividual());
                        }
                        this.deployLogDao.insert(deployLog);
                        String content = "{\"content\":{\"en_US\":\"Enter the release queue\",\"zh_CN\":\"\u8fdb\u5165\u53d1\u7248\u961f\u5217\",\"zh_TW\":\"\u9032\u5165\u767c\u7248\u968a\u5217\"}}";
                        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setApplication(application).setDeployNo(deployNo).setTime(new Date()).setContent("\u8fdb\u5165\u53d1\u7248\u961f\u5217").setLang((Map)JSONObject.parseObject((String)content, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0])).setResult("success");
                        this.insertDeployDetail(deployDetailV2);
                        this.redisCache.rpush(DEPLOY_LIST_KEY, (Object)deployParam, 0L);
                    }
                }
                finally {
                    rLock.unlock();
                }
            } else {
                throw new BusinessException("\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            }
            return deployNo;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new BusinessException("\u53d1\u7248\u5931\u8d25," + e.getMessage());
        }
        catch (Exception e) {
            if (StrUtil.isEmpty((CharSequence)errmsg)) {
                log.error("\u53d1\u7248\u5931\u8d25,\u62a5\u9519\u4fe1\u606f\uff1a", (Throwable)e);
                throw new BusinessException("\u53d1\u7248\u5931\u8d25," + e.getMessage());
            }
            throw new BusinessException((String)errmsg);
        }
    }

    public String addPrivateDeployApp(DeployParamV3 deployParam) {
        List tenantUsers = deployParam.getTenantUsers();
        this.addTenantSid(tenantUsers, deployParam.getEnv());
        List envs = this.envService.queryByEnv(deployParam.getEnv());
        if (CollUtil.isEmpty((Collection)envs)) {
            throw new BusinessException("\u672a\u627e\u5230env\u5bf9\u5e94\uff0c\u8bf7\u68c0\u67e5deployer\u6570\u636e\u5e93env\u8868\u914d\u7f6e\uff01");
        }
        deployParam.setEnvServiceId(((Env)envs.get(0)).getServiceId());
        return this.addDeployPlan(deployParam);
    }

    private void addTenantSid(List<TenantUser> tenantUsers, String env) {
        for (TenantUser tenantUser : tenantUsers) {
            String ti = tenantUser.getTenantId();
            JSONObject jsonObject = this.backendApiHelper.allTenant(AthenaUserLocal.getUser().getToken(), ti, env);
            if (jsonObject.getInteger("code") == null || 200 != jsonObject.getInteger("code")) continue;
            List data = jsonObject.getJSONArray("data").toJavaList(JSONObject.class);
            Long sid = data.stream().filter(da -> ti.equals(da.getString("id"))).findFirst().orElse(new JSONObject()).getLong("sid");
            if (null == sid) {
                log.warn(ti + "\u5728\u5f53\u524d\u53d1\u5e03\u73af\u5883\u672a\u627e\u5230\u5bf9\u5e94sid\uff01");
                continue;
            }
            tenantUser.setTenantSid(sid);
        }
    }

    private void checkDeployInfo(DeployParamV3 deployParam) {
        List applicationDataList = deployParam.getApplicationDataList();
        Assert.isFalse((boolean)org.springframework.util.CollectionUtils.isEmpty((Collection)applicationDataList), (String)"\u9009\u62e9\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashSet<String> codeSet = new HashSet<String>();
        HashSet<String> repeatCode = new HashSet<String>();
        HashSet<String> individualApps = new HashSet<String>();
        for (ApplicationData applicationData : applicationDataList) {
            ApplicationInfoDto applicationInfoDto;
            if (codeSet.contains(applicationData.getApplication())) {
                repeatCode.add(applicationData.getApplication());
            } else {
                codeSet.add(applicationData.getApplication());
            }
            if (!(applicationInfoDto = applicationData.getApplicationInfoDto()).isIndividual()) continue;
            individualApps.add(applicationInfoDto.getSourceApplicationCode());
        }
        Assert.isTrue((boolean)repeatCode.isEmpty(), (String)("\u53d1\u5e03\u5e94\u7528\u91cd\u590d:" + String.join((CharSequence)",", repeatCode)), (Object[])new Object[0]);
        if (!individualApps.isEmpty()) {
            List logs = this.deployLogDao.selectByApplicationsAndEnv(individualApps, deployParam.getEnv());
            Set existAppCode = logs.stream().map(DeployLog::getApplication).collect(Collectors.toSet());
            individualApps.remove(existAppCode);
            Assert.isTrue((individualApps.size() > 0 ? 1 : 0) != 0, (String)(String.join((CharSequence)",", individualApps) + " \u672a\u53d1\u5e03\u5bf9\u5e94\u73af\u5883"), (Object[])new Object[0]);
        }
    }

    private void checkDeployLogAppStatus(DeployParamV3 deployParam) {
        List applicationDataList = deployParam.getApplicationDataList();
        Assert.isTrue((!applicationDataList.isEmpty() ? 1 : 0) != 0, (String)"\u6ca1\u6709\u9009\u62e9\u5e94\u7528", (Object[])new Object[0]);
        List applicationList = applicationDataList.stream().map(ApplicationData::getApplication).collect(Collectors.toList());
        List existsApplication = this.getWaitingOrExecutingApplications(applicationList, deployParam.getEnv(), EnvOperateEnum.PUBLISH);
        Assert.isTrue((boolean)existsApplication.isEmpty(), (String)("\u5e94\u7528\uff1a" + String.join((CharSequence)",", existsApplication) + "\u6b63\u5728\u53d1\u7248\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5"), (Object[])new Object[0]);
        existsApplication = this.getWaitingOrExecutingApplications(applicationList, deployParam.getEnv(), EnvOperateEnum.SWITCH);
        Assert.isTrue((boolean)existsApplication.isEmpty(), (String)("\u5e94\u7528\uff1a" + String.join((CharSequence)",", existsApplication) + "\u6b63\u5728\u5207\u677f\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5"), (Object[])new Object[0]);
    }

    private List<String> getWaitingOrExecutingApplications(Collection<String> applicationList, String env, EnvOperateEnum operateEnum) {
        List<String> checkStatus = Arrays.asList("executing", "waiting");
        List existsApplication = this.deployLogDao.selectApplicationByApplicationAndStatusAndEnvAndType(applicationList, checkStatus, env, operateEnum);
        return existsApplication;
    }

    private Boolean judgeDeployLogAppStatus(String application, List<String> status, String env, String type) {
        DateTime startTime = DateUtil.offsetMinute((Date)DateUtil.date(), (int)-60);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"result").in(status).and("application").is((Object)application).and("deployParam.env").is((Object)env).and("type").is((Object)type).and("date").gte((Object)startTime));
        List deployLogs = this.mongoTemplate.find(query, DeployLog.class, "deployLog");
        if (ObjectUtils.isEmpty((Object)deployLogs)) {
            return false;
        }
        return true;
    }

    public void asyncDeploy(DeployParamV3 deployParam) {
        List tenantUsers = deployParam.getTenantUsers();
        List tenantIdList = tenantUsers.stream().map(tenantUser -> tenantUser.getTenantId()).collect(Collectors.toList());
        JSONArray tenantIdListCopy = JSON.parseArray((String)JSON.toJSONString(tenantIdList));
        List applicationDataList = deployParam.getApplicationDataList();
        String env = deployParam.getEnv();
        String id = deployParam.getId();
        BigDecimal deployStepNo = APPLICATION_DEPLOY_STEP_NUM.multiply(new BigDecimal(applicationDataList.size()));
        JSONObject neo4jNodeKeyJson = this.queryNeo4jNodeKeyJson();
        for (ApplicationData applicationData : applicationDataList) {
            List publishEntityList = applicationData.getPublishEntityList();
            String application = applicationData.getApplication();
            if ("DATASTANDARDS".equals(application)) {
                this.deployDataStandards(env, id, tenantIdListCopy, deployStepNo, applicationData);
                continue;
            }
            if (CollUtil.isNotEmpty((Collection)publishEntityList)) {
                this.customDeploy(deployParam, id, applicationData);
            } else {
                this.deployApplication(deployParam, tenantUsers, tenantIdList, tenantIdListCopy, env, id, deployStepNo, neo4jNodeKeyJson, applicationData);
            }
            this.addSecurityTask(deployParam, applicationData);
        }
    }

    public void asyncDeployV2(DeployParamV3 deployParam) {
        List<String> tenantIdList = new ArrayList<String>();
        List tenantUsers = deployParam.getTenantUsers();
        if (null != tenantUsers && !tenantUsers.isEmpty()) {
            tenantIdList = tenantUsers.stream().map(tenantUser -> tenantUser.getTenantId()).collect(Collectors.toList());
        } else {
            tenantIdList.add(deployParam.getCurrentUser().getTenantId());
        }
        JSONArray tenantIdListCopy = JSON.parseArray((String)JSON.toJSONString(tenantIdList));
        List applicationDataList = deployParam.getApplicationDataList();
        String env = deployParam.getEnv();
        String id = deployParam.getId();
        JSONObject neo4jNodeKeyJson = this.queryNeo4jNodeKeyJson();
        ApplicationData applicationData = (ApplicationData)applicationDataList.get(0);
        List publishEntityList = applicationData.getPublishEntityList();
        if (CollUtil.isNotEmpty((Collection)publishEntityList)) {
            this.customDeploy(deployParam, id, applicationData);
        } else {
            if ("DATASTANDARDS".equals(applicationData.getApplication())) {
                BigDecimal deployStepNo = APPLICATION_DEPLOY_STEP_NUM.multiply(new BigDecimal(applicationDataList.size()));
                this.deployDataStandards(env, id, tenantIdListCopy, deployStepNo, applicationData);
                return;
            }
            ApplicationPO applicationPO = this.designerApiHelper.getApplicationByCode(applicationData.getApplication(), deployParam.getCurrentUser().getToken());
            JSONObject compiledData = this.designerApiHelper.queryCompiledDataByCode(applicationData.getCompileDataCode(), deployParam.getCurrentUser().getToken());
            if (7 == applicationPO.getAppType()) {
                JSONObject jsonObject = new JSONObject();
                AssistantProjectPO assistantProjectPO = this.designerApiHelper.getProjectByAssistantCode(applicationData.getApplication(), deployParam.getCurrentUser().getToken());
                if (Objects.isNull(assistantProjectPO)) {
                    log.info("entry type project is null");
                } else {
                    AssistantProjectModelPO assistantProjectModelPO = this.designerApiHelper.getModel(assistantProjectPO.getProjectCode(), deployParam.getCurrentUser().getToken());
                    if (Objects.isNull(assistantProjectModelPO)) {
                        log.info("model applyStatus = 1 is null");
                    } else {
                        jsonObject.fluentPut("projectCode", (Object)assistantProjectPO.getProjectCode());
                        jsonObject.fluentPut("modelTypes", (Object)assistantProjectModelPO.getModelTypes());
                        jsonObject.fluentPut("modelCode", (Object)assistantProjectModelPO.getModelCode());
                        jsonObject.fluentPut("llmPromptId", (Object)assistantProjectModelPO.getLlmPromptId());
                    }
                }
                this.deployApplication2Asa(applicationData.getApplication(), compiledData, tenantUsers, tenantIdListCopy, env, id, this.currentEnv, jsonObject);
            } else {
                this.deployApplication(deployParam, tenantUsers, tenantIdList, tenantIdListCopy, env, id, APPLICATION_DEPLOY_STEP_NUM, neo4jNodeKeyJson, applicationData);
            }
        }
        this.addSecurityTask(deployParam, applicationData);
    }

    private void deployApplication2Asa(String application, JSONObject compiledData, List<TenantUser> tenantUsers, JSONArray tenantIdList, String env, String id, String currentEnv, JSONObject modelInfo) {
        String compileDataCode = compiledData.getString("code");
        this.updateDeployLog(application, compiledData, id, "executing", null);
        try {
            this.dmcShareFile(compiledData);
            DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setApplication(application).setContent(DeployStepEnum.PUBLISH_APPLICATION.getStepName() + ":" + application).setResult("start");
            this.insertDeployDetail(deployDetailV2);
            this.updateLogProcess(id, application, BigDecimal.ONE, new BigDecimal(4));
            this.recordLatestDeployParam(application, env, compileDataCode, "application", Arrays.asList(compiledData));
            this.updateLogProcess(id, application, new BigDecimal(2), new BigDecimal(4));
            this.asaDeployerServiceApiHelper.deploy(application, compiledData, tenantUsers, tenantIdList, env, id, currentEnv, modelInfo);
            this.updateLogProcess(id, application, new BigDecimal(3), new BigDecimal(4));
            this.updateApplicationStatus(env, tenantIdList.getString(0), compileDataCode, application);
            this.updateLogProcess(id, application, new BigDecimal(4), new BigDecimal(4));
            DeployDetailV2 finish = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(id).setResult("finish").setApplication(application);
            this.insertDeployDetail(finish);
            log.info("\u5e94\u7528:{}\u53d1\u5e03\u7ed3\u675f", (Object)application);
        }
        catch (Exception e) {
            log.error("\u5e94\u7528:{}\u53d1\u5e03\u5230\u5a1c\u5a1c\u52a9\u7406\u5f02\u5e38", (Throwable)e);
            this.updateDeployLog(application, compiledData, id, "fail", null);
            throw new BusinessException((Throwable)e);
        }
    }

    private void updateLogProcess(String id, String application, BigDecimal deployStepNo, BigDecimal deployStepNum) {
        BigDecimal progress = deployStepNo.divide(deployStepNum, 2, 3);
        this.deployLogDao.updateProcessByApplicationAndId(application, id, progress);
    }

    private void dmcShareFile(JSONObject compiledData) {
        String compiledDataFileId = compiledData.getString("compiledDataFileId");
        if (StrUtil.isNotEmpty((CharSequence)compiledDataFileId)) {
            Map midWareResponse = this.dmcService.shareFile(compiledDataFileId);
            Object compiledDataShareUrl = midWareResponse.get("url");
            Object compiledDataShareKeyId = midWareResponse.get("id");
            compiledData.put("compiledDataShareUrl", compiledDataShareUrl);
            compiledData.put("compiledDataShareKeyId", compiledDataShareKeyId);
            log.info("dmcShareFile.compiledDataShareUrl:{},compiledDataShareKeyId:{}", compiledDataShareUrl, compiledDataShareKeyId);
        }
    }

    private void addSecurityTask(DeployParamV3 deployParam, ApplicationData applicationData) {
        try {
            JSONObject compileData = this.designerApiHelper.queryCompiledDataByCode(applicationData.getCompileDataCode(), AthenaUserLocal.getUser().getToken());
            SecurityTaskDto securityTaskDto = new SecurityTaskDto();
            securityTaskDto.setDeployId(deployParam.getId());
            securityTaskDto.setEnv(deployParam.getEnv());
            securityTaskDto.setPublishTime(new Date());
            securityTaskDto.setApplication(applicationData.getApplication());
            securityTaskDto.setCompiledDataFileId(compileData.getString("compiledDataFileId"));
            securityTaskDto.setCompileVersion(compileData.getString("version"));
            ResultBean resultBean = this.designerApiHelper.addSecurityTask(securityTaskDto, AthenaUserLocal.getUser().getToken());
            Assert.isTrue((boolean)resultBean.getCode().equals(0), (String)("addSecurityTask fail " + resultBean.getMsg()), (Object[])new Object[0]);
        }
        catch (Exception e) {
            log.error(String.format("\u5b89\u5168\u5ba1\u67e5\u4efb\u52a1\u6dfb\u52a0\u5931\u8d25:" + e.getMessage(), new Object[0]), (Throwable)e);
        }
    }

    private void customDeploy(DeployParamV3 deployParam, String id, ApplicationData applicationData) {
        String application = applicationData.getApplication();
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setApplication(application).setTime(new Date()).setContent(DeployStepEnum.PUBLISH_APPLICATION.getStepName() + ":" + application).setResult("start");
        try {
            this.updateDeployLog(applicationData.getApplication(), new JSONObject(), id, "executing", null);
            this.insertDeployDetail(deployDetailV2);
            CustomPublishParam customPublishParam = new CustomPublishParam();
            customPublishParam.setTenantUsers(deployParam.getTenantUsers()).setEnv(deployParam.getEnv()).setCurrentUser(AthenaUserLocal.getUser()).setApplication(applicationData.getApplication()).setPublishEntityList(applicationData.getPublishEntityList()).setCompileDataCode(applicationData.getCompileDataCode());
            this.customPublishService.publish(customPublishParam);
            deployDetailV2.setApplication(application).setResult("success");
            this.insertDeployDetail(deployDetailV2);
            deployDetailV2.setApplication(application).setResult("finish");
            this.insertDeployDetail(deployDetailV2);
            this.updateDeployLog(applicationData.getApplication(), new JSONObject(), id, "success", null);
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)BigDecimal.ONE, 3600L);
        }
        catch (Exception e) {
            deployDetailV2.setApplication(application).setResult("fail");
            this.updateDeployLog(applicationData.getApplication(), new JSONObject(), id, "fail", null);
            this.insertDeployDetail(deployDetailV2);
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
    }

    public void deployApplication(DeployParamV3 deployParam, List<TenantUser> tenantUsers, List<String> tenantIdList, JSONArray tenantIdListCopy, String env, String id, BigDecimal deployStepNo, JSONObject neo4jNodeKeyJson, ApplicationData applicationData) {
        String application = applicationData.getApplication();
        JSONObject compiledData = new JSONObject();
        compiledData.put("description", (Object)applicationData.getDescription());
        JSONObject applicationConfig = null;
        this.updateDeployLog(applicationData.getApplication(), compiledData, id, "executing", applicationConfig);
        String result = null;
        try {
            DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setApplication(application).setContent(DeployStepEnum.PUBLISH_APPLICATION.getStepName() + ":" + application).setResult("start");
            this.insertDeployDetail(deployDetailV2);
            String compileDataCode = applicationData.getCompileDataCode();
            if (StrUtil.isBlank((CharSequence)compileDataCode)) {
                compileDataCode = this.getCompileDataCode(id, applicationData.getBranch(), applicationData.getDescription(), application);
                applicationData.setCompileDataCode(compileDataCode);
            }
            ParseCompileFileResult parseCompileFileResult = this.parseFileData(id, application, compileDataCode);
            compiledData = parseCompileFileResult.getCompileData();
            this.setProcess(id, application, BigDecimal.ONE, deployStepNo);
            JSONObject compileAppData = parseCompileFileResult.getApplication();
            Integer appType = compileAppData.getInteger("appType");
            List applicationConfigList = parseCompileFileResult.getApplicationConfigList();
            if (CollUtil.isNotEmpty((Collection)applicationConfigList)) {
                applicationConfig = applicationConfigList.stream().filter(ac -> ac.getInteger("appType").equals(appType)).findFirst().orElse(null);
            }
            Boolean commonApp = Optional.ofNullable(compileAppData.getBoolean("commonApp")).orElse(false);
            DeployPreTaskResult deployPreTaskResult = this.executeDeployPreTask(deployParam.getTenantUsers(), id, application, env, tenantIdList, neo4jNodeKeyJson, commonApp);
            tenantIdList = deployPreTaskResult.getTenantIdList();
            this.setProcess(id, application, new BigDecimal(2), deployStepNo);
            List cqlList = parseCompileFileResult.getCqlList();
            Map collectionInfo = this.getNeedToDeleteMongocollectionInfo(application, env, parseCompileFileResult.getCollectionInfo());
            List bsonInfoList = parseCompileFileResult.getBsonInfoList();
            CleanMongoParam cleanMongoParam = new CleanMongoParam().setDeployVersion("1.0").setApplication(application).setCollectionInfo(collectionInfo);
            CleanNeo4jParam cleanNeo4jParam = new CleanNeo4jParam().setDeployVersion("1.0").setApplication(application);
            this.cleanApplicationData(env, id, cleanMongoParam, cleanNeo4jParam);
            if (CollUtil.isNotEmpty((Collection)cqlList)) {
                this.executeCql(application, env, id, cqlList);
            }
            if (CollUtil.isNotEmpty((Collection)bsonInfoList)) {
                this.executeBson(application, env, id, bsonInfoList);
            }
            this.executeMechanismFirstCompile(env, bsonInfoList, application, id);
            this.modifyDifferenceData(env, id, application);
            this.setProcess(id, application, new BigDecimal(3), deployStepNo);
            Bson bson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"code", (Object)application)});
            FindIterable documents = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("athenadesginer").getCollection("application").find(bson);
            Document first = (Document)documents.first();
            List publishDbMongoData = this.getPublishDbMongoData(bsonInfoList);
            if (Objects.nonNull(first) && Objects.nonNull(first.getInteger((Object)"appType")) && first.getInteger((Object)"appType") == 4) {
                List kitDbMongoData = this.getKitPublishDbMongoData();
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)publishDbMongoData) && !org.springframework.util.CollectionUtils.isEmpty((Collection)kitDbMongoData)) {
                    ArrayList<JSONObject> same = new ArrayList<JSONObject>();
                    for (JSONObject dataMongo : publishDbMongoData) {
                        for (JSONObject kitMongo : kitDbMongoData) {
                            if (!StringUtils.equals((CharSequence)dataMongo.getString("dbName"), (CharSequence)kitMongo.getString("dbName"))) continue;
                            JSONArray collectionNames = dataMongo.getJSONArray("collectionName");
                            JSONArray kitCollectionNames = kitMongo.getJSONArray("collectionName");
                            collectionNames.addAll((Collection)kitCollectionNames);
                            List collect = collectionNames.stream().distinct().collect(Collectors.toList());
                            dataMongo.put("collectionName", collect);
                            same.add(kitMongo);
                        }
                    }
                    kitDbMongoData.removeAll(same);
                    publishDbMongoData.addAll(kitDbMongoData);
                }
            }
            this.recordLatestDeployParam(application, env, compileDataCode, "application", Arrays.asList(compileAppData));
            this.recordLatestDeployParam(application, env, compileDataCode, "publishDbMongoData", publishDbMongoData);
            this.deployAppUseOtherService(deployParam, application, commonApp, parseCompileFileResult, tenantUsers, env, id, deployStepNo, tenantIdList, compileDataCode);
            String[] bindAppList = this.bindApps.split(";");
            if (Arrays.asList(bindAppList).contains(application)) {
                JSONObject espActionEnumKeyObj = parseCompileFileResult.getEspActionEnumKey();
                this.syncEspActionEnumKey(env, id, application, espActionEnumKeyObj);
                this.setProcess(id, application, new BigDecimal(9), deployStepNo);
            }
            Object tenantVersionMap = this.backendApiHelper.queryCurTenantVersion(tenantIdList, env);
            this.bindTenantAndApplication(tenantIdList, env, id, application, commonApp);
            this.setProcess(id, application, new BigDecimal(10), deployStepNo);
            this.executeDeployPostTask(deployParam.getTenantUsers(), env, tenantIdList, tenantIdListCopy, id, neo4jNodeKeyJson, compileDataCode, application, deployPreTaskResult, tenantVersionMap, commonApp);
            this.setProcess(id, application, new BigDecimal(11), deployStepNo);
            this.clearCache(env, id, application, AthenaUserLocal.getUser().getTenantId());
            this.setProcess(id, application, new BigDecimal(12), deployStepNo);
            deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.PUBLISH_APPLICATION.getStepName() + ":" + application).setResult("success").setApplication(application);
            this.insertDeployDetail(deployDetailV2);
            result = "success";
            DeployDetailV2 finish = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(id).setResult("finish").setApplication(application);
            this.insertDeployDetail(finish);
            log.info("\u5e94\u7528:{}\u53d1\u5e03\u7ed3\u675f", (Object)application);
            if (Objects.nonNull(first) && Objects.nonNull(first.getInteger((Object)"appType")) && first.getInteger((Object)"appType") == 6) {
                List publish = this.envService.queryEnvsWithoutAuth("publish");
                String envCode = this.bmdEnvMapUtil.getBmdEnv(publish, env);
                String token = AthenaUserLocal.getUser().getToken();
                String tenantId = AthenaUserLocal.getUser().getTenantId();
                List synonymList = parseCompileFileResult.getSynonymList();
                this.recordLatestDeployParam(application, env, compileDataCode, "publishSynonymData", synonymList);
                List standardParamsList = parseCompileFileResult.getStandardParamsList();
                this.recordLatestDeployParam(application, env, compileDataCode, "publishStandardParamsData", standardParamsList);
                AthenaUser user = AthenaUserLocal.getUser();
                ThreadUtil.execute(() -> this.pushStandardParams(application, env, tenantUsers, tenantId, "1.0", standardParamsList, user));
                ThreadUtil.execute(() -> this.pushSynonym(application, env, tenantUsers, tenantId, "1.0", synonymList, user));
                ThreadUtil.execute(() -> this.pushSynonymToAI(application, env, tenantUsers, tenantId, "1.0", synonymList, user));
                String source = first.getString((Object)"source");
                ThreadUtil.execute(() -> this.syncModelCentral(application, envCode, tenantUsers, token, "1.0", user, source));
                ThreadUtil.execute(() -> this.syncPushData(application, env, tenantUsers, token, tenantId, "1.0", user));
            }
        }
        catch (Exception e) {
            try {
                result = "fail";
                throw new BusinessException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.updateDeployLog(application, compiledData, id, result, applicationConfig);
                throw throwable;
            }
        }
        this.updateDeployLog(application, compiledData, id, result, applicationConfig);
    }

    private void pushSynonymToAI(String application, String env, List<TenantUser> tenantUsers, String tenantId, String version, List<JSONObject> synonymList, AthenaUser user) {
        if (org.springframework.util.CollectionUtils.isEmpty(synonymList)) {
            log.info("\u5e94\u7528\u6ca1\u6709\u540c\u4e49\u8bcd\u6570\u636e\u9700\u8981\u63a8\u9001!");
            return;
        }
        AthenaUserLocal.setUser((AthenaUser)user);
        this.backendApiHelper.pushSynonymToAI(application, env, tenantUsers, tenantId, version, synonymList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeMechanismFirstCompile(String env, List<BsonInfo> bsonInfoList, String application, String deployNo) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(deployNo).setTime(new Date()).setContent(DeployStepEnum.DATA_IN_KNOWLEDGE_GRAPH_MECHANISM_FIRST_COMPILE.getStepName()).setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        List mechanismCodes = bsonInfoList.stream().filter(each -> "knowledgegraphSystem".equals(each.getDbName()) && "mechanism".equals(each.getCollectionName())).findFirst().map(each -> each.getDocumentList().stream().map(doc -> doc.get((Object)"code").toString()).collect(Collectors.toList())).orElseGet(Collections::emptyList);
        try {
            this.backendApiHelper.executeMechanismCompile(env, application, mechanismCodes);
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("warn").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void pushStandardParams(String application, String env, List<TenantUser> tenantUsers, String tenantId, String version, List<JSONObject> standardParamsList, AthenaUser user) {
        if (org.springframework.util.CollectionUtils.isEmpty(standardParamsList)) {
            log.info("\u5e94\u7528\u6ca1\u6709\u6807\u51c6\u53c2\u6570\u6570\u636e\u9700\u8981\u63a8\u9001");
            return;
        }
        AthenaUserLocal.setUser((AthenaUser)user);
        this.backendApiHelper.pushStandardParams(application, env, tenantUsers, tenantId, version, standardParamsList);
    }

    private void pushSynonym(String application, String env, List<TenantUser> tenantUsers, String tenantId, String version, List<JSONObject> synonymList, AthenaUser user) {
        if (org.springframework.util.CollectionUtils.isEmpty(synonymList)) {
            log.info("\u5e94\u7528\u6ca1\u6709\u540c\u4e49\u8bcd\u6570\u636e\u9700\u8981\u63a8\u9001");
            return;
        }
        AthenaUserLocal.setUser((AthenaUser)user);
        this.backendApiHelper.pushSynonym(application, env, tenantUsers, tenantId, version, synonymList);
    }

    private void syncPushData(String application, String env, List<TenantUser> tenantUsers, String token, String tenantId, String version, AthenaUser user) {
        AthenaUserLocal.setUser((AthenaUser)user);
        this.backendApiHelper.syncPushData(application, env, tenantUsers, tenantId, version);
    }

    private void syncModelCentral(String appId, String envCode, List<TenantUser> tenantUsers, String token, String version, AthenaUser user, String source) {
        AthenaUserLocal.setUser((AthenaUser)user);
        this.bmdApiHelper.modelRelease(appId, envCode, tenantUsers, token, version, new SyncModelCentralTask.SyncModelCentralParam());
    }

    public void deployDataStandards(String env, String id, JSONArray tenantIdListCopy, BigDecimal deployStepNo, ApplicationData applicationData) {
        String application = applicationData.getApplication();
        JSONObject compiledData = new JSONObject();
        compiledData.put("description", (Object)applicationData.getDescription());
        this.updateDeployLog(applicationData.getApplication(), compiledData, id, "executing", null);
        String result = null;
        try {
            String compileDataCode = applicationData.getCompileDataCode();
            if (StrUtil.isBlank((CharSequence)compileDataCode)) {
                compileDataCode = this.getCompileDataCode(id, applicationData.getBranch(), applicationData.getDescription(), application);
                applicationData.setCompileDataCode(compileDataCode);
            }
            ParseCompileFileResult parseCompileFileResult = this.parseFileData(id, application, compileDataCode);
            compiledData = parseCompileFileResult.getCompileData();
            this.setProcess(id, application, BigDecimal.ONE, deployStepNo);
            Map collectionInfo = this.getNeedToDeleteMongocollectionInfo(application, env, parseCompileFileResult.getCollectionInfo());
            List bsonInfoList = parseCompileFileResult.getBsonInfoList();
            CleanMongoParam cleanMongoParam = new CleanMongoParam().setDeployVersion("1.0").setApplication(application).setCollectionInfo(collectionInfo);
            CleanNeo4jParam cleanNeo4jParam = new CleanNeo4jParam().setDeployVersion("1.0").setApplication(application);
            this.cleanApplicationData(env, id, cleanMongoParam, cleanNeo4jParam);
            if (CollUtil.isNotEmpty((Collection)bsonInfoList)) {
                this.executeBson(application, env, id, bsonInfoList);
            }
            List publishDbMongoData = this.getPublishDbMongoData(bsonInfoList);
            this.recordLatestDeployParam(application, env, compileDataCode, "publishDbMongoData", publishDbMongoData);
            this.updateApplicationStatus(env, tenantIdListCopy.getString(0), compileDataCode, application);
            result = "success";
            this.clearCache(env, id, application, AthenaUserLocal.getUser().getTenantId());
            this.setProcess(id, application, new BigDecimal(12), deployStepNo);
            log.info("\u5e94\u7528:{}\u53d1\u5e03\u7ed3\u675f", (Object)application);
            DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.PUBLISH_APPLICATION.getStepName() + ":" + application).setResult("success").setApplication(application);
            this.insertDeployDetail(deployDetailV2);
            DeployDetailV2 finish = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(id).setResult("finish").setApplication(application);
            this.insertDeployDetail(finish);
        }
        catch (Exception e) {
            result = "fail";
            throw new BusinessException((Throwable)e);
        }
        finally {
            this.updateDeployLog(application, compiledData, id, result, null);
        }
    }

    private void deployAppUseOtherService(DeployParamV3 deployParam, String application, Boolean commonApp, ParseCompileFileResult parseCompileFileResult, List<TenantUser> tenantUsers, String env, String id, BigDecimal deployStepNo, List<String> tenantIdList, String compileDataCode) {
        List standardParamsList;
        List needAuthorizeDataEntrys;
        List statementList;
        List needAuthorizeStartProjects;
        this.iamTenantAuthorize(application, deployParam);
        List pageDesignList = parseCompileFileResult.getPageDesignList();
        List dataEntryList = parseCompileFileResult.getDataEntryList();
        List activityConfigList = parseCompileFileResult.getActivityConfigList();
        List mobilePageDesignList = parseCompileFileResult.getMobilePageDesignList();
        this.delRecordLatestDeployParam(application, env, Arrays.asList("needAuthorizeTbbStatements", "needAuthorizeAbiStatements", "needAuthorizeDataEntrys", "needAuthorizestartProjects", "needAuthorizeOtherStatements", "needAuthorizeMobilePageDesigns", "needAuthorizeTriggerData", "needAuthorizeSceneData", "needAuthorizeStandardParamsData"));
        if (CollUtil.isNotEmpty((Collection)pageDesignList)) {
            this.lcdpPublish(tenantUsers, env, id, application, pageDesignList);
        }
        this.setProcess(id, application, new BigDecimal(4), deployStepNo);
        List assignments = DeployServiceImplV3.getAssignments((List)pageDesignList);
        if (!commonApp.booleanValue()) {
            this.iamAssignmentAuthorize(tenantUsers, env, id, application, "basicDataEntry", assignments);
        } else {
            this.commonUpdateGmc(env, id, application, assignments, parseCompileFileResult.getApplication());
            this.commonIamAssignmentAuthorize(tenantUsers, env, id, application, assignments);
        }
        this.tbbAuthorize(tenantUsers, env, id, application, pageDesignList);
        this.setProcess(id, application, new BigDecimal(5), deployStepNo);
        List modelDrivenList = parseCompileFileResult.getModelDrivenList();
        if (CollUtil.isNotEmpty((Collection)modelDrivenList)) {
            this.modelDrivenPublish(application, env, id, modelDrivenList, tenantUsers, parseCompileFileResult.getBranch());
            this.deleteApiMetaData(application, env, id, modelDrivenList);
            this.deleteModelDriven(application, env, id, modelDrivenList);
            this.deleteActionMetaData(application, env, id, modelDrivenList);
        }
        this.setProcess(id, application, new BigDecimal(6), deployStepNo);
        AthenaUser user = AthenaUserLocal.getUser();
        String token = user.getToken();
        String tenantId = user.getTenantId();
        List kitAssignList = parseCompileFileResult.getKitAssignList();
        if (CollUtil.isNotEmpty((Collection)kitAssignList)) {
            log.info("kitAssign publish start");
            this.kitAssignPublish(application, env, id, kitAssignList, tenantUsers, token, tenantId);
        }
        this.setProcess(id, application, new BigDecimal(7), deployStepNo);
        Bson bson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"code", (Object)application)});
        FindIterable documents = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("athenadesginer").getCollection("application").find(bson);
        Document first = (Document)documents.first();
        if (Objects.nonNull(first) && Objects.nonNull(first.getInteger((Object)"appType")) && first.getInteger((Object)"appType") == 5) {
            log.info("dataView publish start");
            this.dataViewPublish(application, env, id, tenantUsers, token, parseCompileFileResult.getCompileData(), parseCompileFileResult.getDataViewList(), parseCompileFileResult.getBranch());
            this.setProcess(id, application, new BigDecimal(7), deployStepNo);
            log.info("process publish start");
            this.processPublish(application, env, id, tenantUsers, token, tenantId, compileDataCode, parseCompileFileResult.getCompileData());
            this.setProcess(id, application, new BigDecimal(7), deployStepNo);
            log.info("event publish start");
            this.eventPublish(application, env, id, tenantUsers, token, tenantId, compileDataCode, parseCompileFileResult.getCompileData());
            this.setProcess(id, application, new BigDecimal(7), deployStepNo);
        }
        List adTemplateList = parseCompileFileResult.getAdTemplateList();
        List ucAdTemplateList = parseCompileFileResult.getUcAdTemplateList();
        if (CollUtil.isNotEmpty((Collection)adTemplateList) || CollUtil.isNotEmpty((Collection)ucAdTemplateList)) {
            this.recordLatestDeployParam(application, env, compileDataCode, "adTemplate", adTemplateList);
            this.recordLatestDeployParam(application, env, compileDataCode, "ucAdTemplate", ucAdTemplateList);
            this.adTemplatePublish(application, tenantUsers, env, id, adTemplateList);
            this.adTemplatePublish(application, tenantUsers, env, id, ucAdTemplateList);
            this.recordAdTemplateTenantDeployInfo(application, tenantUsers, env, adTemplateList, ucAdTemplateList);
        }
        this.setProcess(id, application, new BigDecimal(8), deployStepNo);
        List startProjectList = parseCompileFileResult.getStartProjectList();
        if (CollUtil.isNotEmpty((Collection)startProjectList) && CollUtil.isNotEmpty(needAuthorizeStartProjects = startProjectList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getString("authorityPrefix"))).collect(Collectors.toList()))) {
            if (!commonApp.booleanValue()) {
                this.iamAssignmentAuthorize(tenantUsers, env, id, application, "startProject", needAuthorizeStartProjects);
            } else {
                this.commonUpdateGmc(env, id, application, needAuthorizeStartProjects, parseCompileFileResult.getApplication());
                this.commonIamAssignmentAuthorize(tenantUsers, env, id, application, needAuthorizeStartProjects);
            }
            List needAuthorizeSysStartProjects = needAuthorizeStartProjects.stream().filter(data -> this.isUcOrNot(data) == false).collect(Collectors.toList());
            this.recordLatestDeployParam(application, env, id, "needAuthorizestartProjects", needAuthorizeSysStartProjects);
        }
        if (CollUtil.isNotEmpty((Collection)(statementList = parseCompileFileResult.getStatementList()))) {
            List otherStatementList;
            List abiStatementList;
            List tbbStatementList = statementList.stream().filter(t -> this.isTbbStatement(t.getString("pattern"), t.getString("category"))).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(tbbStatementList)) {
                List ucTbbStatementList;
                this.recordLatestDeployParam(application, env, id, "tbb", tbbStatementList);
                List sysTbbStatementList = tbbStatementList.stream().filter(data -> this.isUcOrNot(data) == false).collect(Collectors.toList());
                if (CollUtil.isNotEmpty(sysTbbStatementList)) {
                    this.tbbStatementPublish(deployParam, tenantIdList, env, application, sysTbbStatementList, token, Boolean.valueOf(false), "\u6807\u51c6tbb", parseCompileFileResult.getBranch());
                }
                if (CollUtil.isNotEmpty(ucTbbStatementList = tbbStatementList.stream().filter(arg_0 -> this.isUcOrNot(arg_0)).collect(Collectors.toList()))) {
                    this.tbbStatementPublish(deployParam, tenantIdList, env, application, ucTbbStatementList, token, Boolean.valueOf(true), "\u4e2a\u6848tbb", parseCompileFileResult.getBranch());
                }
                List needAuthorizeTbbStatements = this.filterNeedAuthStatements(activityConfigList, tbbStatementList);
                List needAuthorizeSysTbbStatements = needAuthorizeTbbStatements.stream().filter(data -> this.isUcOrNot(data) == false).collect(Collectors.toList());
                List needAuthorizeUcTbbStatements = needAuthorizeTbbStatements.stream().filter(arg_0 -> this.isUcOrNot(arg_0)).collect(Collectors.toList());
                if (!commonApp.booleanValue()) {
                    this.iamAssignmentAuthorize(tenantUsers, env, id, application, "report", needAuthorizeTbbStatements);
                    this.iamAddPolicy(tenantUsers, env, id, application, "report", needAuthorizeSysTbbStatements, needAuthorizeUcTbbStatements, token);
                } else {
                    this.commonUpdateGmc(env, id, application, needAuthorizeTbbStatements, parseCompileFileResult.getApplication());
                    this.commonIamAssignmentAuthorize(tenantUsers, env, id, application, needAuthorizeTbbStatements);
                    this.commonIamAddPolicy(tenantUsers, env, id, application, needAuthorizeSysTbbStatements, token);
                }
                this.recordLatestDeployParam(application, env, id, "needAuthorizeTbbStatements", needAuthorizeSysTbbStatements);
            }
            if (CollUtil.isNotEmpty(abiStatementList = statementList.stream().filter(t -> this.isAbiStatement(t.getString("pattern"), t.getString("category"))).collect(Collectors.toList()))) {
                this.syncAbi(id, application, env, activityConfigList, abiStatementList, token, tenantId);
                Env envObj = this.envService.queryByEnvAndModule(env, "deploy_service");
                Boolean currentArea = envObj.getCurrentArea();
                if (currentArea != null && currentArea.booleanValue()) {
                    this.abiStatementPublish(env, application, id, activityConfigList, abiStatementList);
                }
                List needAuthorizeAbiStatements = this.filterNeedAuthStatements(activityConfigList, abiStatementList);
                List needAuthorizeSysAbiStatements = needAuthorizeAbiStatements.stream().filter(data -> this.isUcOrNot(data) == false).collect(Collectors.toList());
                List needAuthorizeUcAbiStatements = needAuthorizeAbiStatements.stream().filter(arg_0 -> this.isUcOrNot(arg_0)).collect(Collectors.toList());
                if (!commonApp.booleanValue()) {
                    this.iamAssignmentAuthorize(tenantUsers, env, id, application, "report", needAuthorizeAbiStatements);
                    this.iamAddPolicy(tenantUsers, env, id, application, "report", needAuthorizeSysAbiStatements, needAuthorizeUcAbiStatements, token);
                } else {
                    this.commonUpdateGmc(env, id, application, needAuthorizeAbiStatements, parseCompileFileResult.getApplication());
                    this.commonIamAssignmentAuthorize(tenantUsers, env, id, application, needAuthorizeAbiStatements);
                    this.commonIamAddPolicy(tenantUsers, env, id, application, needAuthorizeAbiStatements, token);
                }
                this.recordLatestDeployParam(application, env, id, "needAuthorizeAbiStatements", needAuthorizeSysAbiStatements);
            }
            if (CollUtil.isNotEmpty(otherStatementList = statementList.stream().filter(t -> !this.isAbiStatement(t.getString("pattern"), t.getString("category")) && !this.isTbbStatement(t.getString("pattern"), t.getString("category"))).collect(Collectors.toList()))) {
                List needAuthorizeOtherStatements = this.filterNeedAuthStatements(activityConfigList, otherStatementList);
                List needAuthorizeSysOtherStatements = needAuthorizeOtherStatements.stream().filter(data -> this.isUcOrNot(data) == false).collect(Collectors.toList());
                List needAuthorizeUcOtherStatements = needAuthorizeOtherStatements.stream().filter(arg_0 -> this.isUcOrNot(arg_0)).collect(Collectors.toList());
                if (!commonApp.booleanValue()) {
                    this.iamAssignmentAuthorize(tenantUsers, env, id, application, "report", needAuthorizeOtherStatements);
                    this.iamAddPolicy(tenantUsers, env, id, application, "report", needAuthorizeSysOtherStatements, needAuthorizeUcOtherStatements, token);
                } else {
                    this.commonUpdateGmc(env, id, application, needAuthorizeOtherStatements, parseCompileFileResult.getApplication());
                    this.commonIamAssignmentAuthorize(tenantUsers, env, id, application, needAuthorizeOtherStatements);
                    this.commonIamAddPolicy(tenantUsers, env, id, application, needAuthorizeSysOtherStatements, token);
                }
                this.recordLatestDeployParam(application, env, id, "needAuthorizeOtherStatements", needAuthorizeSysOtherStatements);
            }
        }
        if (CollUtil.isNotEmpty((Collection)(needAuthorizeDataEntrys = this.filterNeedAuthStatements(activityConfigList, dataEntryList)))) {
            List needAuthorizeSysDataEntrys = needAuthorizeDataEntrys.stream().filter(data -> this.isUcOrNot(data) == false).collect(Collectors.toList());
            List needAuthorizeUcDataEntrys = needAuthorizeDataEntrys.stream().filter(arg_0 -> this.isUcOrNot(arg_0)).collect(Collectors.toList());
            if (!commonApp.booleanValue()) {
                this.iamAssignmentAuthorize(tenantUsers, env, id, application, "basicDataEntry", needAuthorizeDataEntrys);
                this.iamAddPolicy(tenantUsers, env, id, application, "basicDataEntry", needAuthorizeSysDataEntrys, needAuthorizeUcDataEntrys, token);
            } else {
                this.commonUpdateGmc(env, id, application, needAuthorizeDataEntrys, parseCompileFileResult.getApplication());
                this.commonIamAssignmentAuthorize(tenantUsers, env, id, application, needAuthorizeDataEntrys);
                this.commonIamAddPolicy(tenantUsers, env, id, application, needAuthorizeSysDataEntrys, token);
            }
            this.recordLatestDeployParam(application, env, id, "needAuthorizeDataEntrys", needAuthorizeSysDataEntrys);
        }
        this.setProcess(id, application, new BigDecimal(9), deployStepNo);
        List needAuthorizeMobilePageDesigns = this.filterNeedAuthStatements(mobilePageDesignList, mobilePageDesignList);
        if (CollUtil.isNotEmpty((Collection)needAuthorizeMobilePageDesigns)) {
            List needAuthorizeSysMobilePageDesigns = needAuthorizeMobilePageDesigns.stream().filter(data -> this.isUcOrNot(data) == false).collect(Collectors.toList());
            List needAuthorizeUcMobilePageDesigns = needAuthorizeMobilePageDesigns.stream().filter(arg_0 -> this.isUcOrNot(arg_0)).collect(Collectors.toList());
            if (!commonApp.booleanValue()) {
                this.iamAssignmentAuthorize(tenantUsers, env, id, application, "mobilePageDesign", needAuthorizeMobilePageDesigns);
                this.iamAddPolicy(tenantUsers, env, id, application, "mobilePageDesign", needAuthorizeSysMobilePageDesigns, needAuthorizeUcMobilePageDesigns, token);
            } else {
                this.commonUpdateGmc(env, id, application, needAuthorizeMobilePageDesigns, parseCompileFileResult.getApplication());
                this.commonIamAssignmentAuthorize(tenantUsers, env, id, application, needAuthorizeMobilePageDesigns);
                this.commonIamAddPolicy(tenantUsers, env, id, application, needAuthorizeSysMobilePageDesigns, token);
            }
            this.recordLatestDeployParam(application, env, id, "needAuthorizeMobilePageDesigns", needAuthorizeSysMobilePageDesigns);
        }
        List triggerList = parseCompileFileResult.getTriggerList();
        HashSet productLines = new HashSet();
        if (CollUtil.isNotEmpty((Collection)triggerList)) {
            List metric;
            List scene;
            this.standardParamsUtil.collectProductLines(triggerList, productLines);
            List screen = triggerList.stream().filter(trigger -> StringUtils.isNotEmpty((CharSequence)trigger.getString("authorityPrefix")) && StringUtils.equals((CharSequence)"screen", (CharSequence)trigger.getString("viewType"))).collect(Collectors.toList());
            if (!org.springframework.util.CollectionUtils.isEmpty(screen)) {
                this.iamAssignmentAuthorize(tenantUsers, env, id, application, "bigScreen", screen);
                this.iamAddPolicy(tenantUsers, env, id, application, "bigScreen", screen, new ArrayList(), token);
            }
            if (!org.springframework.util.CollectionUtils.isEmpty(scene = triggerList.stream().filter(trigger -> StringUtils.isNotEmpty((CharSequence)trigger.getString("authorityPrefix")) && StringUtils.equals((CharSequence)"scene", (CharSequence)trigger.getString("viewType"))).collect(Collectors.toList()))) {
                this.iamAssignmentAuthorize(tenantUsers, env, id, application, "scene", scene);
                this.iamAddPolicy(tenantUsers, env, id, application, "scene", scene, new ArrayList(), token);
            }
            if (!org.springframework.util.CollectionUtils.isEmpty(metric = triggerList.stream().filter(trigger -> StringUtils.isNotEmpty((CharSequence)trigger.getString("authorityPrefix")) && StringUtils.equals((CharSequence)"metric", (CharSequence)trigger.getString("viewType"))).collect(Collectors.toList()))) {
                this.iamAssignmentAuthorize(tenantUsers, env, id, application, "metric", metric);
                this.iamAddPolicy(tenantUsers, env, id, application, "metric", metric, new ArrayList(), token);
            }
            this.recordLatestDeployParam(application, env, compileDataCode, "needAuthorizeTriggerData", triggerList);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)(standardParamsList = parseCompileFileResult.getStandardParamsList()))) {
            ArrayList standardParams = new ArrayList();
            this.standardParamsUtil.buildPrdLineStandardParams(standardParams, productLines, application);
            this.iamAssignmentAuthorize(tenantUsers, env, id, application, "appData", standardParams);
            this.iamAddPolicy(tenantUsers, env, id, application, "appData", standardParams, new ArrayList(), token);
            this.recordLatestDeployParam(application, env, compileDataCode, "needAuthorizeStandardParamsData", standardParams);
        }
        this.setProcess(id, application, new BigDecimal(10), deployStepNo);
    }

    private void eventPublish(String application, String env, String id, List<TenantUser> tenantUsers, String token, String tenantId, String compileDataCode, JSONObject compileData) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.PUBLISH_EVENT.getStepName() + "\u4e8b\u4ef6\u5165\u5e93").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        Object executeContent = null;
        try {
            CustomPublishParam customPublishParam = new CustomPublishParam();
            customPublishParam.setTenantUsers(tenantUsers).setEnv(env).setCurrentUser(AthenaUserLocal.getUser()).setApplication(application).setPublishEntityList(new ArrayList()).setCompileData(compileData).setAppToken(token).setDeployVersion("1.0").setCompileVersion(compileData.getString("version"));
            this.backendApiHelper.customEventPublish(customPublishParam);
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setExecuteContent(executeContent).setApiParam((Object)"").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private Boolean isUcOrNot(JSONObject data) {
        return null != data.getString("tenantId") && !"SYSTEM".equals(data.getString("tenantId"));
    }

    private void dataViewPublish(String application, String env, String id, List<TenantUser> tenantUsers, String token, JSONObject compileData, List<JSONObject> dataViewList, String branch) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.PUBLISH_DATA_VIEW.getStepName() + "\u6570\u636e\u89c6\u56fe\u5165\u5e93").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        Object executeContent = null;
        try {
            CustomPublishParam customPublishParam = new CustomPublishParam();
            customPublishParam.setTenantUsers(tenantUsers).setEnv(env).setCurrentUser(AthenaUserLocal.getUser()).setApplication(application).setPublishEntityList(new ArrayList()).setCompileData(compileData).setAppToken(token).setDeployVersion("1.0").setCompileVersion(compileData.getString("version"));
            this.backendApiHelper.customDataViewPublish(customPublishParam);
            if (CollUtil.isNotEmpty(dataViewList)) {
                this.backendApiHelper.syncDataViewToDapAndTbb(customPublishParam, dataViewList, branch);
            }
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setExecuteContent(executeContent).setApiParam((Object)"").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void processPublish(String application, String env, String id, List<TenantUser> tenantUsers, String token, String tenantId, String compileDataCode, JSONObject compileData) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.PUBLISH_PROCESS.getStepName() + "\u6d41\u7a0b\u5165\u5e93").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        Object executeContent = null;
        try {
            CustomPublishParam customPublishParam = new CustomPublishParam();
            customPublishParam.setTenantUsers(tenantUsers).setEnv(env).setCurrentUser(AthenaUserLocal.getUser()).setApplication(application).setPublishEntityList(new ArrayList()).setCompileData(compileData).setAppToken(token).setDeployVersion("1.0").setCompileVersion(compileData.getString("version"));
            this.backendApiHelper.customProcessPublish(customPublishParam);
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setExecuteContent(executeContent).setApiParam((Object)"").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private List<JSONObject> getKitPublishDbMongoData() {
        ArrayList<JSONObject> publishDbMongoData = new ArrayList<JSONObject>();
        Object o = this.presetDataService.getObjByKey("kitSwitch");
        JSONArray objects = (JSONArray)JSONObject.parseObject((String)JSON.toJSONString((Object)o), JSONArray.class);
        for (int i = 0; i < objects.size(); ++i) {
            publishDbMongoData.add(objects.getJSONObject(i));
        }
        return publishDbMongoData;
    }

    private Map<String, Set<String>> getNeedToDeleteMongocollectionInfo(String application, String env, Map<String, Set<String>> compileCollectionInfo) {
        HashMap<String, Set<String>> mongoDbInfo = new HashMap<String, Set<String>>();
        List publishDbMongoData = this.queryDeployParamRecords(application, env, "publishDbMongoData", null);
        if (CollUtil.isNotEmpty((Collection)publishDbMongoData)) {
            HashMap mongoCollection = new HashMap();
            publishDbMongoData.forEach(pdd -> {
                if (StringUtils.isNotEmpty((CharSequence)pdd.getString("dbName")) && CollUtil.isNotEmpty((Collection)pdd.getJSONArray("collectionName"))) {
                    mongoCollection.put(pdd.getString("dbName"), JSONArray.parseArray((String)JSON.toJSONString((Object)pdd.get((Object)"collectionName")), String.class));
                }
            });
            Set mongoKeySet = mongoCollection.keySet();
            Set<String> compileKeySet = compileCollectionInfo.keySet();
            HashSet<Object> dbNameSet = new HashSet<Object>();
            dbNameSet.addAll(mongoKeySet);
            dbNameSet.addAll(compileKeySet);
            dbNameSet.forEach(dbName -> {
                HashSet collection = new HashSet();
                if (CollUtil.isNotEmpty((Collection)((Collection)mongoCollection.get(dbName)))) {
                    collection.addAll((Collection)mongoCollection.get(dbName));
                }
                if (CollUtil.isNotEmpty((Collection)((Collection)compileCollectionInfo.get(dbName)))) {
                    collection.addAll((Collection)compileCollectionInfo.get(dbName));
                }
                mongoDbInfo.put((String)dbName, collection);
            });
            return mongoDbInfo;
        }
        return compileCollectionInfo;
    }

    private void kitAssignPublish(String application, String env, String id, List<JSONObject> kitAssignList, List<TenantUser> tenantUsers, String token, String tenantId) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.PUBLISH_KIT_ASSIGN.getStepName() + ":\u8c03\u7528km/CompileAndSaveSets").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        Object executeContent = null;
        try {
            ArrayList<JSONObject> kitAssigns = new ArrayList<JSONObject>();
            for (JSONObject kitAssign : kitAssignList) {
                JSONObject kitAssign1;
                JSONObject publishKitAssignInfo = kitAssign.getJSONObject("publishKitAssignInfo");
                kitAssign.put("tenantId", (Object)AthenaUserLocal.getUser().getTenantId());
                if (!ObjectUtils.isNotEmpty((Object)publishKitAssignInfo) || !ObjectUtils.isNotEmpty((Object)(kitAssign1 = publishKitAssignInfo.getJSONObject("kitAssign")))) continue;
                kitAssigns.add(kitAssign1);
            }
            if (!org.springframework.util.CollectionUtils.isEmpty(kitAssigns)) {
                log.info("kitAssigns:" + JSONObject.toJSONString(kitAssigns));
                this.backendApiHelper.publishKitAssign(env, kitAssigns, token, tenantId);
                log.info("publish to km success");
                for (TenantUser tenantUser : tenantUsers) {
                    String targetTenantId = tenantUser.getTenantId();
                    for (JSONObject jsonObject : kitAssigns) {
                        String code = jsonObject.getString("code");
                        this.asyncService.moduleAssignPublishRecord(targetTenantId, "", env, application, code, "KIT_ASSIGN", AthenaUserLocal.getUser(), null);
                    }
                }
                deployDetailV2.setResult("success");
            } else {
                log.info("no kits need to publish");
            }
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setExecuteContent(executeContent).setApiParam((Object)"").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void recordLatestDeployParam(String appCode, String env, String compileDataCode, String type, List<JSONObject> values) {
        if (StringUtils.isEmpty((CharSequence)appCode) || StringUtils.isEmpty((CharSequence)env) || StringUtils.isEmpty((CharSequence)compileDataCode) || StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)appCode).and("env").is((Object)env).and("type").is((Object)type));
        this.mongoTemplate.remove(query, "deployParamRecord");
        if (CollUtil.isEmpty(values)) {
            return;
        }
        for (JSONObject value : values) {
            DeployParamRecord record = new DeployParamRecord().setApplication(appCode).setEnv(env).setCompileDataCode(compileDataCode).setType(type).setValue(value);
            this.mongoTemplate.insert((Object)record, "deployParamRecord");
        }
    }

    private void delRecordLatestDeployParam(String appCode, String env, List<String> typeList) {
        if (StringUtils.isEmpty((CharSequence)appCode) || StringUtils.isEmpty((CharSequence)env) || CollUtil.isEmpty(typeList)) {
            return;
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)appCode).and("env").is((Object)env).and("type").in(typeList));
        this.mongoTemplate.remove(query, "deployParamRecord");
    }

    private static List<JSONObject> getAssignments(List<JSONObject> pageDesignList) {
        List<JSONObject> assignments = pageDesignList.stream().filter(pageDesign -> StringUtils.isNotEmpty((CharSequence)pageDesign.getString("authorityPrefix"))).map(pageDesign -> {
            JSONObject form = pageDesign.getJSONObject("form");
            JSONObject formName = form.getJSONObject("formName");
            String formNameZhCn = formName.getString("zh_CN");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code", (Object)pageDesign.getString("code"));
            jsonObject.put("name", (Object)formNameZhCn);
            return jsonObject;
        }).collect(Collectors.toList());
        return assignments;
    }

    private void setProcess(String id, String application, BigDecimal deployStepNo, BigDecimal deployStepNum) {
        BigDecimal progress = deployStepNo.divide(deployStepNum, 2, 3);
        this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)progress.toString(), 3600L);
    }

    private void setDeploySwitchProcess(String id, String application, BigDecimal curStepNum, BigDecimal totalStepNum) {
        BigDecimal progress = curStepNum.divide(totalStepNum, 2, 3);
        this.updateDeployLogAppProcess(application, id, progress);
    }

    public QueryDeployLogResult queryDeployLog(QueryDeployLogParam queryDeployLogParam) {
        Integer pageNum = queryDeployLogParam.getPageNum();
        Integer pageSize = queryDeployLogParam.getPageSize();
        Date startDate = queryDeployLogParam.getStartDate();
        Date endDate = queryDeployLogParam.getEndDate();
        String targetTenant = queryDeployLogParam.getTargetTenant();
        String operate = queryDeployLogParam.getOperate();
        Criteria criteria = new Criteria();
        if (StrUtil.isNotBlank((CharSequence)targetTenant)) {
            criteria.and("deployParam.tenantUsers.tenantId").is((Object)targetTenant);
        }
        if (StringUtils.isNotEmpty((CharSequence)queryDeployLogParam.getApplication())) {
            criteria.and("application").is((Object)queryDeployLogParam.getApplication());
        } else {
            List applicationList = this.designerApiHelper.allAppInTenant();
            Set appCodeList = applicationList.stream().map(item -> item.getString("code")).collect(Collectors.toSet());
            criteria.and("application").in(appCodeList);
        }
        if (StringUtils.isNotEmpty((CharSequence)queryDeployLogParam.getEnv())) {
            criteria.and("deployParam.env").is((Object)queryDeployLogParam.getEnv());
        }
        if (startDate != null && endDate != null) {
            criteria.and("date").gte((Object)startDate).lte((Object)endDate);
        }
        criteria.and("type").is((Object)operate);
        if (CurThreadInfoUtils.getIndividualCase().booleanValue()) {
            criteria.and("individual").is((Object)true);
        } else {
            criteria.and("individual").ne((Object)true);
        }
        Query query = new Query((CriteriaDefinition)criteria);
        long count = this.deployerMongoTemplate.count(query, DeployLog.class, "deployLog");
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"date"})).skip((long)((pageNum - 1) * pageSize)).limit(queryDeployLogParam.getPageSize().intValue());
        List deployLogList = this.deployerMongoTemplate.find(query, DeployLog.class, "deployLog");
        List appCodes = deployLogList.stream().map(item -> item.getApplication()).collect(Collectors.toList());
        List applications = this.designerApiHelper.queryApplicationByCodes(appCodes);
        block0: for (DeployLog deployLog2 : deployLogList) {
            for (JSONObject app : applications) {
                if (!app.getString("code").equals(deployLog2.getApplication())) continue;
                deployLog2.setApplicationName(app.getString("name"));
                deployLog2.setApplicationNameLang(app.getJSONObject("lang"));
                continue block0;
            }
        }
        Map envMap = this.envService.getAllEnvNameMap();
        deployLogList.forEach(deployLog -> {
            if (null != deployLog.getDeployParam() && null != deployLog.getDeployParam().getEnv()) {
                deployLog.setEnvName((String)envMap.get(deployLog.getDeployParam().getEnv()));
            }
            deployLog.setProcess(null);
        });
        QueryDeployLogResult queryDeployLogResult = new QueryDeployLogResult().setDeployLogList(deployLogList).setCount(Long.valueOf(count));
        return queryDeployLogResult;
    }

    private String getCompileDataCode(String id, String branch, String description, String application) {
        String compileDataCode;
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.COMPILE.getStepName() + application).setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        try {
            CompileParam compileParam = new CompileParam().setApplication(application).setBranch(branch).setDescription((String)(StrUtil.isBlank((CharSequence)description) ? DateUtil.now() + "\u7f16\u8bd1" : description));
            compileDataCode = this.designerApiHelper.compile(compileParam, AthenaUserLocal.getUser().getToken());
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
        return compileDataCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache(String env, String id, String application, String tenantId) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setApplication(application).setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.CLEAR_CACHE.getStepName()).setResult("start");
        this.insertDeployDetail(deployDetailV2);
        try {
            this.backendApiHelper.kmCacheReset(env, tenantId);
            this.backendApiHelper.atmcCacheReset(env);
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("warn").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void executeDeployPostTask(List<TenantUser> tenantUsers, String env, List<String> tenantIdList, JSONArray tenantIdListCopy, String id, JSONObject neo4jNodeKeyJson, String compileDataCode, String application, DeployPreTaskResult deployPreTaskResult, Object tenantVersionMap, Boolean commonApp) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.EXECUTE_DEPLOY_POST_TASK.getStepName()).setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        try {
            if (commonApp.booleanValue()) {
                List testApplication2testCommonRelations = deployPreTaskResult.getTestApplication2testCommonRelations();
                CreateApplicationRelationParam createApplicationRelationParam = new CreateApplicationRelationParam().setRelationList(testApplication2testCommonRelations).setApplicationVersion("1.0").setCommonVersion("1.0").setNeo4jNodeKeyJson(neo4jNodeKeyJson);
                this.backendApiHelper.createApplication2CommonRelation(createApplicationRelationParam, env);
            } else {
                Tenant2NodeRelationParam tenant2NodeRelationParam = new Tenant2NodeRelationParam().setTenantIds(tenantIdList).setApplication(application).setTenantVersion("1.0").setAppVersion("1.0");
                this.backendApiHelper.createTenantAndApplicationRelation(tenant2NodeRelationParam, env);
            }
            this.backendApiHelper.mergeRelationBetweenTenantAndAppInVersionChange(tenantIdList, env, application, "1.0", tenantVersionMap);
            this.backendApiHelper.modifyTenantRelaWithNotMatchAppDataInPublish(env, application, tenantIdList);
            this.backendApiHelper.kmUpdateAppComponentList(env, application, "1.0", AthenaUserLocal.getUser().getTenantId());
            this.backendApiHelper.monitorChange(tenantUsers, application, env, "publish", "end", "1.0");
            this.updateApplicationStatus(env, tenantIdListCopy.getString(0), compileDataCode, application);
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void updateApplicationStatus(String env, String tenantId, String compileDataCode, String application) {
        Update update;
        JSONObject applicationObj = (JSONObject)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("latestEnv").is((Object)env)), JSONObject.class, "application");
        Integer status = Optional.ofNullable(applicationObj).orElse(new JSONObject()).getInteger("status");
        if ((status = Optional.ofNullable(status).orElse(1)) == 1) {
            update = new Update();
            update.set("status", (Object)2);
            this.mongoTemplate.upsert(new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("latestEnv").is((Object)env)), (UpdateDefinition)update, "application");
        }
        update = new Update();
        update.set("latestEnv", (Object)env);
        update.set("latestTenant", (Object)tenantId);
        update.set("latestCompileDataCode", (Object)compileDataCode);
        this.mongoTemplate.upsert(new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("latestEnv").is((Object)env)), (UpdateDefinition)update, "application");
    }

    private void bindTenantAndApplication(List<String> tenantIdList, String env, String id, String application, Boolean commonApp) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.BIND_TENANT_APPLICATION.getStepName()).setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        try {
            Date sdate = new Date();
            this.backendApiHelper.switchVersion(tenantIdList, application, "1.0", env, commonApp);
            Date edate = new Date();
            System.out.printf("\u7ed1\u5b9a\u79df\u6237\u4e0e\u5e94\u7528\u6210\u679c\u5173\u7cfb\uff1a%d \u6beb\u79d2.", edate.getTime() - sdate.getTime());
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private List<JSONObject> filterNeedAuthStatements(List<JSONObject> activityConfigList, List<JSONObject> tbbStatementList) {
        List<JSONObject> needAuthorizeTbbStatements = tbbStatementList.stream().filter(tbbStatement -> {
            JSONObject activityConfigObj = activityConfigList.stream().filter(activityConfig -> activityConfig.getString("code").equals(tbbStatement.getString("code"))).findFirst().orElse(new JSONObject());
            String authorityPrefix = activityConfigObj.getString("authorityPrefix");
            return StrUtil.isNotBlank((CharSequence)authorityPrefix);
        }).collect(Collectors.toList());
        return needAuthorizeTbbStatements;
    }

    private DeployPreTaskResult executeDeployPreTask(List<TenantUser> tenantUsers, String deployNo, String application, String env, List<String> tenantIdList, JSONObject neo4jNodeKeyJson, Boolean commonApp) {
        DeployPreTaskResult deployPreTaskResult = new DeployPreTaskResult();
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(deployNo).setTime(new Date()).setContent(DeployStepEnum.EXECUTE_DEPLOY_PRE_TASK.getStepName()).setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        try {
            Tenant2NodeRelationParam tenant2NodeRelationParam;
            this.backendApiHelper.monitorChange(tenantUsers, application, env, "publish", "begin", "1.0");
            if (commonApp.booleanValue()) {
                Application2CommonRelationParam findApplication2CommonParam = new Application2CommonRelationParam().setTenantIdList(tenantIdList).setApplicationList((List)ListUtil.toList((Object[])new String[]{application, "espCommon"})).setNeo4jNodeKeyJson(neo4jNodeKeyJson).setApplicationVersion("1.0").setCommonVersion("1.0");
                List testApplication2testCommonRelations = this.backendApiHelper.findApp2OtherAppRelations(findApplication2CommonParam, env);
                deployPreTaskResult.setTenantIdList(tenantIdList).setTestApplication2testCommonRelations(testApplication2testCommonRelations);
            } else {
                tenant2NodeRelationParam = new Tenant2NodeRelationParam().setTenantIds(tenantIdList).setApplication(application).setTenantVersion("1.0");
                List authAppTenantIdList = this.backendApiHelper.getAuthAppTenantIdList(tenant2NodeRelationParam, env);
                tenantIdList.addAll(authAppTenantIdList);
                tenantIdList = tenantIdList.stream().distinct().collect(Collectors.toList());
                deployPreTaskResult.setTenantIdList(tenantIdList);
            }
            deployDetailV2.setResult("success");
            tenant2NodeRelationParam = deployPreTaskResult;
            return tenant2NodeRelationParam;
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + deployNo, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abiStatementPublish(String env, String application, String deployId, List<JSONObject> activityConfigList, List<JSONObject> abiStatementList) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(deployId).setTime(new Date()).setContent(DeployStepEnum.UPDATE_STATEMENT.getStepName() + ":\u8c03\u7528/abi/lcdp.rpt.release").setApplication(application);
        JSONObject executeContent = null;
        try {
            String isvCode = this.backendApiHelper.getIsvCode(AthenaUserLocal.getUser().getTenantId(), env);
            Iterator<JSONObject> iterator = abiStatementList.iterator();
            while (iterator.hasNext()) {
                JSONObject abiStatement;
                executeContent = abiStatement = iterator.next();
                String code = abiStatement.getString("code");
                JSONObject activityConfig = activityConfigList.stream().filter(item -> item.getString("code").equals(code)).findFirst().orElse(null);
                if (activityConfig == null) continue;
                Map residMap = this.getResidByAc(activityConfig);
                for (String key : residMap.keySet()) {
                    String resid = (String)residMap.get(key);
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("isvCode", (Object)isvCode);
                    jsonObject.put("resid", (Object)resid);
                    jsonObject.put("tenantId", (Object)AthenaUserLocal.getUser().getTenantId());
                    jsonObject.put("token", (Object)AthenaUserLocal.getUser().getToken());
                    jsonObject.put("code", (Object)code);
                    jsonObject.put("appCode", (Object)application);
                    this.backendApiHelper.abiStatementPublish(jsonObject, AthenaUserLocal.getUser().getToken(), env);
                }
            }
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("warn").setExecuteContent(executeContent).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tbbStatementPublish(DeployParamV3 deployParam, List<String> tenantIdList, String env, String application, List<JSONObject> tbbStatementList, String token, Boolean isUcTbb, String preContent, String branch) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(deployParam.getId()).setTime(new Date()).setContent(preContent + DeployStepEnum.UPDATE_STATEMENT.getStepName() + ":\u8c03\u7528/tbb-system/platform_integration/publish_report").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        JSONObject param = new JSONObject();
        ArrayList<String> resCodes = new ArrayList<String>();
        try {
            param.put("token", (Object)token);
            param.put("appCode", (Object)application);
            param.put("env", (Object)env);
            param.put("operate", (Object)"publish");
            if (isUcTbb.booleanValue()) {
                for (i = 0; i < tbbStatementList.size(); ++i) {
                    JSONObject tbbStatement = tbbStatementList.get(i);
                    String resCode = tbbStatement.getString("resCode");
                    if (StringUtils.isEmpty((CharSequence)resCode)) {
                        resCode = tbbStatement.getString("code");
                    }
                    param.put("reportList", Collections.singletonList(resCode));
                    param.put("tenantIds", (Object)tbbStatement.getString("tenantId").split(";"));
                    this.backendApiHelper.tbbStatementPublish(param, branch, token);
                }
            } else {
                for (i = 0; i < tbbStatementList.size(); ++i) {
                    JSONObject tbbStatement = tbbStatementList.get(i);
                    String resCode = tbbStatement.getString("resCode");
                    if (StringUtils.isEmpty((CharSequence)resCode)) {
                        resCode = tbbStatement.getString("code");
                    }
                    resCodes.add(resCode);
                }
                param.put("tenantIds", tenantIdList);
                param.put("reportList", resCodes);
                this.backendApiHelper.tbbStatementPublish(param, branch, token);
            }
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("warn").setApiParam((Object)param).setExecuteContent(tbbStatementList).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void iamTenantAuthorize(String application, DeployParamV3 deployParam) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(deployParam.getId()).setTime(new Date()).setContent(DeployStepEnum.UPDATE_ASSIGNMENT_AUTH.getStepName() + ":\u8c03\u7528/athena-deployer-service/tenant/authTenantUser").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        try {
            DeployParamV2 deployParamV2 = (DeployParamV2)JSON.parseObject((String)JSON.toJSONString((Object)deployParam), DeployParamV2.class);
            List applicationDataList = deployParamV2.getApplicationDataList();
            applicationDataList.removeIf(applicationData -> !application.equals(applicationData.getApplication()));
            this.backendApiHelper.authUser(deployParamV2, AthenaUserLocal.getUser().getToken(), deployParam.getEnv());
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setFailMessage("iam\u79df\u6237\u6388\u6743\u5931\u8d25").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + deployParam.getId(), (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void tbbAuthorize(List<TenantUser> tenantUsers, String env, String id, String application, List<JSONObject> pageDesignList) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.UPDATE_ASSIGNMENT_AUTH.getStepName() + ":\u8c03\u7528/tbb-system/platform_integration/data_entry").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        LcdpPublishParam lcdpPublishParam = new LcdpPublishParam();
        JSONObject executeContent = null;
        try {
            Iterator<JSONObject> iterator = pageDesignList.iterator();
            while (iterator.hasNext()) {
                JSONObject pageDesign;
                executeContent = pageDesign = iterator.next();
                lcdpPublishParam.setEnv(env).setTenantUsers(tenantUsers).setCurrentUser(AthenaUserLocal.getUser()).setApplication(application).setPageDesign(pageDesign);
                this.backendApiHelper.tbbAuthorize(lcdpPublishParam);
            }
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setFailMessage("tbb\u6388\u6743\u5931\u8d25").setApiParam((Object)lcdpPublishParam).setExecuteContent((Object)executeContent).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void iamAddPolicy(List<TenantUser> tenantUsers, String env, String id, String application, String moduleId, List<JSONObject> sysAssignmentList, List<JSONObject> ucAssignmentList, String token) {
        if (org.springframework.util.CollectionUtils.isEmpty(sysAssignmentList) && org.springframework.util.CollectionUtils.isEmpty(ucAssignmentList)) {
            return;
        }
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.UPDATE_ASSIGNMENT_AUTH.getStepName() + ":\u8c03\u7528/api/iam/v2/policy/batch/add").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        Object executeContent = null;
        IamAddPolicyParam iamAddPolicyParam = new IamAddPolicyParam();
        try {
            if (CollUtil.isNotEmpty(sysAssignmentList)) {
                iamAddPolicyParam.setToken(token).setTenantUsers(tenantUsers).setAssignmentList(sysAssignmentList).setApplication(application).setModuleId(moduleId).setEnv(env);
                this.backendApiHelper.iamAddPolicy(iamAddPolicyParam);
            }
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setApiParam((Object)iamAddPolicyParam).setExecuteContent(executeContent).setFailMessage("\u5f00\u542f\u4f5c\u4e1a\u79df\u6237\u6388\u6743\u5931\u8d25").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void commonIamAddPolicy(List<TenantUser> tenantUsers, String env, String id, String application, List<JSONObject> sysAssignmentList, String token) {
        if (org.springframework.util.CollectionUtils.isEmpty(sysAssignmentList)) {
            return;
        }
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.UPDATE_ASSIGNMENT_AUTH.getStepName() + ":\u8c03\u7528/api/iam/v2/policy/batch/add").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        Object executeContent = null;
        IamAddPolicyParam iamAddPolicyParam = new IamAddPolicyParam();
        try {
            if (CollUtil.isNotEmpty(sysAssignmentList)) {
                iamAddPolicyParam.setToken(token).setTenantUsers(tenantUsers).setAssignmentList(sysAssignmentList).setApplication(application).setEnv(env);
                this.backendApiHelper.commonIamAddPolicy(iamAddPolicyParam);
            }
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setApiParam((Object)iamAddPolicyParam).setExecuteContent(executeContent).setFailMessage("\u5f00\u542f\u4f5c\u4e1a\u79df\u6237\u6388\u6743\u5931\u8d25").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncAbi(String id, String application, String env, List<JSONObject> activityConfigList, List<JSONObject> abiStatementList, String token, String tenantId) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.SYNC_ABI.getStepName() + ":\u8c03\u7528/abi/lcdp.rpt.imports").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        IamAddPolicyParam iamAddPolicyParam = new IamAddPolicyParam();
        try {
            ArrayList resIds = new ArrayList();
            for (JSONObject item : abiStatementList) {
                JSONObject activityConfig = activityConfigList.stream().filter(ac -> ac.getString("code").equals(item.getString("code"))).findFirst().orElse(null);
                if (activityConfig == null) continue;
                Map resIdMap = this.getResidByAc(activityConfig);
                resIds.addAll(resIdMap.values());
            }
            this.backendApiHelper.syncAbi(env, resIds, application, token, tenantId);
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("warn").setApiParam((Object)iamAddPolicyParam).setFailMessage("\u540c\u6b65Abi\u62a5\u8868\u5931\u8d25").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void iamAssignmentAuthorize(List<TenantUser> tenantUsers, String env, String id, String application, String moduleId, List<JSONObject> assignmentList) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.UPDATE_ASSIGNMENT_AUTH.getStepName() + ":\u8c03\u7528/api/iam/v2/app/action/update").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        JSONObject executeContent = null;
        ArrayList<CallSite> errorCodeList = new ArrayList<CallSite>();
        String token = AthenaUserLocal.getUser().getToken();
        IamAssignmentAuthorizeParam iamAssignmentAuthorizeParam = new IamAssignmentAuthorizeParam();
        Iterator<JSONObject> iterator = assignmentList.iterator();
        while (iterator.hasNext()) {
            JSONObject assignment;
            executeContent = assignment = iterator.next();
            iamAssignmentAuthorizeParam.setEnv(env).setTenantUsers(tenantUsers).setCurrentUser(AthenaUserLocal.getUser()).setApplication(application).setAssignment(assignment).setModuleId(moduleId);
            try {
                if (this.isUcOrNot(assignment).booleanValue()) {
                    iamAssignmentAuthorizeParam.setTenantUsers(this.getTenantUsersByTenantId(application, assignment.getString("tenantId"), token, env));
                }
                this.backendApiHelper.iamAssignmentAuthorize(iamAssignmentAuthorizeParam);
            }
            catch (Exception e) {
                errorCodeList.add((CallSite)((Object)(assignment.getString("code") + ":" + e.getMessage())));
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(errorCodeList)) {
            deployDetailV2.setResult("warn").setExecuteContent((Object)executeContent).setApiParam((Object)iamAssignmentAuthorizeParam).setFailMessage("iam\u4f5c\u4e1a\u6388\u6743\u5931\u8d25").setCause(String.join((CharSequence)"; ", errorCodeList)).setErrorMessage(String.join((CharSequence)";", errorCodeList));
        } else {
            deployDetailV2.setResult("success");
        }
        long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
        deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
        this.insertDeployDetail(deployDetailV2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commonUpdateGmc(String env, String id, String application, List<JSONObject> assignmentList, JSONObject appJson) {
        if (CollectionUtil.isEmpty(assignmentList)) {
            return;
        }
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.UPDATE_ASSIGNMENT_AUTH.getStepName() + ":\u8c03\u7528/api/iam/v2/app/action/update").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        GmcUpdateParam executeContent = null;
        ArrayList errorCodeList = new ArrayList();
        GmcUpdateParam gmcUpdateParam = new GmcUpdateParam();
        try {
            gmcUpdateParam.setTenantId(AthenaUserLocal.getUser().getTenantId()).setAssignmentList(assignmentList).setToken(AthenaUserLocal.getUser().getToken()).setApplication(application).setEnv(env).setAppJson(appJson).setVersion("1.0");
            executeContent = gmcUpdateParam;
            log.info("\u66f4\u65b0GMC\u5546\u54c1:" + JSONObject.toJSONString((Object)gmcUpdateParam));
            this.backendApiHelper.updateCommonGmcMoudle(gmcUpdateParam);
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("warn").setExecuteContent(executeContent).setApiParam(executeContent).setFailMessage("iam\u4f5c\u4e1a\u6388\u6743\u5931\u8d25").setCause(String.join((CharSequence)"; ", errorCodeList)).setErrorMessage(String.join((CharSequence)";", errorCodeList));
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void commonIamAssignmentAuthorize(List<TenantUser> tenantUsers, String env, String id, String application, List<JSONObject> assignmentList) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.UPDATE_ASSIGNMENT_AUTH.getStepName() + ":\u8c03\u7528/api/iam/v2/app/action/update").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        JSONObject executeContent = null;
        ArrayList<CallSite> errorCodeList = new ArrayList<CallSite>();
        IamAssignmentAuthorizeParam iamAssignmentAuthorizeParam = new IamAssignmentAuthorizeParam();
        Iterator<JSONObject> iterator = assignmentList.iterator();
        while (iterator.hasNext()) {
            JSONObject assignment;
            executeContent = assignment = iterator.next();
            iamAssignmentAuthorizeParam.setEnv(env).setTenantUsers(tenantUsers).setCurrentUser(AthenaUserLocal.getUser()).setApplication(application).setAssignment(assignment);
            try {
                this.backendApiHelper.commonIamAssignmentAuthorize(iamAssignmentAuthorizeParam);
            }
            catch (Exception e) {
                errorCodeList.add((CallSite)((Object)(assignment.getString("code") + ":" + e.getMessage())));
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(errorCodeList)) {
            deployDetailV2.setResult("warn").setExecuteContent((Object)executeContent).setApiParam((Object)iamAssignmentAuthorizeParam).setFailMessage("iam\u4f5c\u4e1a\u6388\u6743\u5931\u8d25").setCause(String.join((CharSequence)"; ", errorCodeList)).setErrorMessage(String.join((CharSequence)";", errorCodeList));
        } else {
            deployDetailV2.setResult("success");
        }
        long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
        deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
        this.insertDeployDetail(deployDetailV2);
    }

    public void modelDrivenPublish(String application, String env, String id, List<JSONObject> modelDrivenList, List<TenantUser> tenantUsers, String branch) {
        String contentLang = String.format("{\"content\":{\"en_US\":\"%s :esp/modeldriven.schema.update\",\"zh_CN\":\"%s :esp/modeldriven.schema.update\",\"zh_TW\":\"%s :esp/modeldriven.schema.update\"}}", "Publishing Model-Driven Tables", "\u53d1\u5e03\u6a21\u578b\u9a71\u52a8\u8868", "\u767c\u5e03\u6a21\u578b\u9a45\u52d5\u8868");
        Map lang = (Map)JSONObject.parseObject((String)contentLang, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        DeployDetailV2 deployDetailV1 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.PUBLISH_MODEL_DRIVEN_TABLE.getStepName() + ":esp/modeldriven.schema.update").setResult("start").setLang(lang).setApplication(application);
        this.insertDeployDetail(deployDetailV1);
        JSONObject executeContent = null;
        String contentLang2 = String.format("{\"content\":{\"en_US\":\"%s :/restful/standard/apimgmt/ApiSpec/Save\",\"zh_CN\":\"%s :/restful/standard/apimgmt/ApiSpec/Save\",\"zh_TW\":\"%s :/restful/standard/apimgmt/ApiSpec/Save\"}}", "Publish metadata to the API management platform", "\u53d1\u5e03\u5143\u6570\u636e\u5230Api\u7ba1\u7406\u5e73\u53f0", "\u767c\u5e03\u5143\u6578\u64da\u5230Api\u7ba1\u7406\u5e73\u53f0");
        Map lang2 = (Map)JSONObject.parseObject((String)contentLang2, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.PUBLISH_ACTIONMETADATA.getStepName() + ":/restful/standard/apimgmt/ApiSpec/Save").setResult("start").setApplication(application).setLang(lang2);
        this.insertDeployDetail(deployDetailV2);
        for (JSONObject modelDriven : modelDrivenList) {
            String modelCode;
            String operateType;
            JSONObject publishModelDrivenInfo = modelDriven.getJSONObject("publishModelDrivenInfo");
            modelDriven.put("tenantId", (Object)AthenaUserLocal.getUser().getTenantId());
            if (ObjectUtils.isEmpty((Object)publishModelDrivenInfo)) {
                log.info(application + "\u5e94\u7528\u4e0b\u6ca1\u6709\u9700\u8981\u53d1\u5e03\u7684\u6a21\u578b");
                continue;
            }
            String serviceCode = publishModelDrivenInfo.getString("serviceCode");
            String code = modelDriven.getString("code");
            String string = operateType = code.startsWith("DataEntry") ? "DATA_ENTRY" : "MODEL_DRIVEN";
            if (operateType.equals("DATA_ENTRY")) {
                this.asyncService.moduleAssignPublishRecord(AthenaUserLocal.getUser().getTenantId(), serviceCode, env, application, code, operateType, AthenaUserLocal.getUser(), null);
                continue;
            }
            JSONArray publishModels = publishModelDrivenInfo.getJSONArray("publishModels");
            if (Objects.isNull(publishModels)) {
                log.info(application + "\u5e94\u7528\u4e0b\u6ca1\u6709\u9700\u8981\u53d1\u5e03\u7684\u6a21\u578b!");
                continue;
            }
            ArrayList noPublishApis = new ArrayList();
            ArrayList<String> noPublishModelCodes = new ArrayList<String>();
            for (int i = 0; i < publishModels.size(); ++i) {
                modelCode = publishModels.getJSONObject(i).getString("code");
                Date editDate = publishModels.getJSONObject(i).getJSONObject("schema").getDate("editDate");
                JSONObject modelSchema = publishModels.getJSONObject(i).getJSONObject("schema");
                if (this.backendApiHelper.checkIsNeedPublish(AthenaUserLocal.getUser().getTenantId(), serviceCode, application, modelCode, editDate, env, AthenaUserLocal.getUser().getToken(), "MODEL_DRIVEN", modelSchema)) continue;
                log.info("The model " + modelCode + " does not need to publish");
                this.getNoPublishApis(noPublishApis, modelSchema);
                log.info("The model " + modelCode + " does not need to publish" + String.valueOf(noPublishApis));
                noPublishModelCodes.add(modelCode);
            }
            JSONArray apiBaseInfos = this.publishpublishActionMetaData(noPublishApis, modelDriven, deployDetailV2, application, env, executeContent, id);
            modelCode = "";
            for (int i = 0; i < publishModels.size(); ++i) {
                try {
                    modelCode = publishModels.getJSONObject(i).getString("code");
                    if (noPublishModelCodes.contains(modelCode)) {
                        log.info(modelCode + " does not need to publish to esp");
                        continue;
                    }
                    log.info("begin to deal this model, modelId={}", (Object)modelCode);
                    JSONObject publishModel = publishModels.getJSONObject(i);
                    JSONObject modelSchema = publishModels.getJSONObject(i).getJSONObject("schema");
                    modelDriven.put("publishModel", (Object)publishModel);
                    modelDriven.put("serviceCode", (Object)serviceCode);
                    modelDriven.put("apiBaseInfos", (Object)apiBaseInfos);
                    this.asyncService.syncTbb(application, "table", modelCode, serviceCode, AthenaUserLocal.getUser(), branch);
                    this.backendApiHelper.publishModel(env, modelDriven);
                    Boolean isPublished = publishModels.getJSONObject(i).getJSONObject("schema").getBoolean("isPublished");
                    if (isPublished == null || !isPublished.booleanValue()) {
                        this.designerApiHelper.updatePageDesignModelPulishState(modelCode, serviceCode, AthenaUserLocal.getUser().getToken(), branch);
                    }
                    this.asyncService.moduleAssignPublishRecord(AthenaUserLocal.getUser().getTenantId(), serviceCode, env, application, modelCode, "MODEL_DRIVEN", AthenaUserLocal.getUser(), modelSchema);
                    deployDetailV1.setResult("success");
                    deployDetailV1.setContent(DeployStepEnum.PUBLISH_MODEL_DRIVEN_TABLE.getStepName() + ":\u8c03\u7528esp/modeldriven.schema.update(code:" + modelCode + ")");
                    continue;
                }
                catch (Exception e) {
                    String content = deployDetailV1.getContent();
                    deployDetailV1.setContent(content + "(code:" + modelCode + ")");
                    deployDetailV1.setResult("fail").setExecuteContent(executeContent).setApiParam((Object)JSON.toJSONString((Object)modelDriven)).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
                    this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
                    throw new BusinessException((Throwable)e);
                }
                finally {
                    long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV1.getTime());
                    deployDetailV1.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
                    this.insertDeployDetail(deployDetailV1);
                }
            }
        }
    }

    private JSONArray publishpublishActionMetaData(List<String> noPublishApis, JSONObject modelDriven, DeployDetailV2 deployDetailV2, String application, String env, JSONObject executeContent, String id) {
        JSONArray publishActionMetaDataInfo = modelDriven.getJSONArray("publishActionMetaDataInfo");
        JSONArray apiBaseInfos = null;
        try {
            if (CollUtil.isNotEmpty((Collection)publishActionMetaDataInfo)) {
                modelDriven.put("application", (Object)application);
                modelDriven.put("noPublishApis", noPublishApis);
                modelDriven.put("apimgmtUrl", (Object)this.moduleConfig.getApimgmt().getDomain());
                modelDriven.put("apimgmtIntegrationToken", (Object)this.iamApiHelper.getIamIntegrationToken(AthenaUserLocal.getUser().getTenantId()));
                apiBaseInfos = this.backendApiHelper.publishActionMetaData(env, modelDriven);
                deployDetailV2.setResult("success");
            } else {
                log.info(application + "\u5e94\u7528\u4e0b\u6ca1\u6709\u9700\u8981\u53d1\u5e03\u5230api\u7ba1\u7406\u5e73\u53f0\u7684\u5143\u6570\u636e");
            }
        }
        catch (Exception e) {
            String content = deployDetailV2.getContent();
            deployDetailV2.setContent(content + "(code:" + modelDriven.getString("code") + ")");
            deployDetailV2.setResult("fail").setExecuteContent((Object)executeContent).setApiParam((Object)JSON.toJSONString((Object)modelDriven)).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
        return apiBaseInfos;
    }

    private void getNoPublishApis(List<String> noPublishModels, JSONObject modelSchema) {
        JSONArray childrenList;
        JSONArray bindApiListConfig = modelSchema.getJSONArray("bindApiListConfig");
        if (null != bindApiListConfig && bindApiListConfig.size() > 0) {
            for (Object apiConfig : bindApiListConfig) {
                noPublishModels.add(((JSONObject)apiConfig).getString("apiName"));
            }
        }
        if (null != (childrenList = modelSchema.getJSONArray("children")) && childrenList.size() > 0) {
            for (Object children : childrenList) {
                this.getNoPublishApis(noPublishModels, (JSONObject)children);
            }
        }
    }

    public void deleteModelDriven(String application, String env, String id, List<JSONObject> modelDrivenList) {
        String contentLang = String.format("{\"content\":{\"en_US\":\"%s :/restful/service/lcdp/modelDesign\",\"zh_CN\":\"%s :/restful/service/lcdp/modelDesign\",\"zh_TW\":\"%s :/restful/service/lcdp/modelDesign\"}}", "Deleting obsolete model-driven tables", "\u5220\u9664\u5e9f\u5f03\u6a21\u578b\u9a71\u52a8\u8868", "\u522a\u9664\u5ee2\u68c4\u6a21\u578b\u9a45\u52d5\u8868");
        Map lang = (Map)JSONObject.parseObject((String)contentLang, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.DELETE_MODEL_DRIVEN_TABLE.getStepName() + ":/restful/service/lcdp/modelDesign").setResult("start").setLang(lang).setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        Object executeContent = null;
        String code = "";
        try {
            for (JSONObject modelDriven : modelDrivenList) {
                modelDriven.put("tenantId", (Object)AthenaUserLocal.getUser().getTenantId());
                JSONObject deleteModelDrivenInfo = modelDriven.getJSONObject("deleteModelDrivenInfo");
                if (ObjectUtils.isEmpty((Object)deleteModelDrivenInfo)) {
                    log.info(application + "\u5e94\u7528\u4e0b\u6ca1\u6709\u9700\u8981\u5220\u9664\u7684\u6a21\u578b\u8868");
                    continue;
                }
                code = modelDriven.getString("code");
                if (StringUtils.isEmpty((CharSequence)code) || code.startsWith("DataEntry_")) continue;
                this.backendApiHelper.deleteModel(env, modelDriven);
                String serviceCode = deleteModelDrivenInfo.getString("serviceCode");
                JSONArray publishModels = deleteModelDrivenInfo.getJSONArray("publishModels");
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)publishModels)) continue;
                ArrayList<String> modelCodes = new ArrayList<String>();
                for (int i = 0; i < publishModels.size(); ++i) {
                    String modelCode = publishModels.getJSONObject(i).getString("code");
                    modelCodes.add(modelCode);
                }
                this.designerApiHelper.deleteAbandonModel(modelCodes, serviceCode, AthenaUserLocal.getUser().getToken());
                log.info("model deleted success:{}", modelCodes);
            }
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            String content = deployDetailV2.getContent();
            deployDetailV2.setContent(content + "(code:" + code + ")");
            deployDetailV2.setResult("fail").setExecuteContent(executeContent).setApiParam((Object)"").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    public void deleteActionMetaData(String application, String env, String id, List<JSONObject> modelDrivenList) {
        String contentLang = String.format("{\"content\":{\"en_US\":\"%s :/restful/service/lcdp/modelDesign\",\"zh_CN\":\"%s :/restful/service/lcdp/modelDesign\",\"zh_TW\":\"%s :/restful/service/lcdp/modelDesign\"}}", "Delete the deprecated API management platform metadata", "\u5220\u9664\u5df2\u5e9f\u5f03\u7684Api\u7ba1\u7406\u5e73\u53f0\u5143\u6570\u636e", "\u522a\u9664\u5df2\u5ee2\u68c4\u7684Api\u7ba1\u7406\u5e73\u53f0\u5143\u6578\u64da");
        Map lang = (Map)JSONObject.parseObject((String)contentLang, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.DELETE_ACTIONMETADATA.getStepName() + ":/restful/standard/apimgmt/ApiDelete/Delete").setResult("start").setLang(lang).setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        Object executeContent = null;
        String code = "";
        try {
            for (JSONObject modelDriven : modelDrivenList) {
                modelDriven.put("tenantId", (Object)AthenaUserLocal.getUser().getTenantId());
                modelDriven.put("token", (Object)AthenaUserLocal.getUser().getToken());
                code = modelDriven.getString("code");
                if (StringUtils.isEmpty((CharSequence)code) || code.startsWith("DataEntry_")) continue;
                JSONObject deleteActionMetaDataInfo = modelDriven.getJSONObject("deleteActionMetaDataInfo");
                if (deleteActionMetaDataInfo != null && ObjectUtils.isNotEmpty((Object)deleteActionMetaDataInfo.get((Object)"apiList"))) {
                    modelDriven.put("application", (Object)application);
                    modelDriven.put("apimgmtUrl", (Object)this.moduleConfig.getApimgmt().getDomain());
                    modelDriven.put("apimgmtIntegrationToken", (Object)this.iamApiHelper.getIamIntegrationToken(AthenaUserLocal.getUser().getTenantId()));
                    this.backendApiHelper.deleteActionMetaData(env, modelDriven);
                    JSONArray apiList = (JSONArray)deleteActionMetaDataInfo.get((Object)"apiList");
                    ArrayList<String> serviceNames = new ArrayList<String>();
                    ArrayList<ApiMgmtBaseInfo> list = new ArrayList<ApiMgmtBaseInfo>();
                    for (int i = 0; i < apiList.size(); ++i) {
                        String apiName = apiList.getJSONObject(i).getString("apiName");
                        serviceNames.add(apiName);
                        JSONObject queryApiObject = new JSONObject();
                        queryApiObject.put("apiName", (Object)apiName);
                        queryApiObject.put("tenantId", (Object)AthenaUserLocal.getUser().getTenantId());
                        queryApiObject.put("token", (Object)AthenaUserLocal.getUser().getToken());
                        queryApiObject.put("apimgmtUrl", (Object)this.moduleConfig.getApimgmt().getDomain());
                        queryApiObject.put("apimgmtIntegrationToken", (Object)this.iamApiHelper.getIamIntegrationToken(AthenaUserLocal.getUser().getTenantId()));
                        JSONObject jsonObject = this.backendApiHelper.queryApiVersionAndStatus(env, queryApiObject);
                        if (jsonObject == null) {
                            log.info("can not get api info, apiName is = {}", (Object)apiName);
                            continue;
                        }
                        ApiMgmtBaseInfo apiMgmtBaseInfo = new ApiMgmtBaseInfo();
                        if (API_STATUS_CONFIRMED == jsonObject.getInteger("approvedStatusCode")) {
                            log.info("do not delete confirmed api , apiName is = {}", (Object)apiName);
                            continue;
                        }
                        apiMgmtBaseInfo.setApiName(apiName);
                        apiMgmtBaseInfo.setVersion(jsonObject.getString("version"));
                        list.add(apiMgmtBaseInfo);
                    }
                    Bson bson = Filters.and((Bson[])new Bson[]{Filters.in((String)"serviceName", serviceNames)});
                    this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("athenadesginer").getCollection("actionMetadata").deleteMany(bson);
                    if (!CollUtil.isNotEmpty(list)) continue;
                    log.info("service deleteApiMetaData success");
                    this.designerApiHelper.upsertDeleteApiFlag(list.stream().map(ApiMgmtBaseInfo::getApiName).collect(Collectors.toList()), AthenaUserLocal.getUser().getToken());
                    continue;
                }
                log.info(application + "\u5e94\u7528\u4e0b\u6ca1\u6709\u9700\u8981\u4eceapi\u7ba1\u7406\u5e73\u53f0\u5220\u9664\u7684\u5143\u6570\u636e");
            }
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            String content = deployDetailV2.getContent();
            deployDetailV2.setContent(content + "(code:" + code + ")");
            deployDetailV2.setResult("fail").setExecuteContent(executeContent).setApiParam((Object)"").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    public void deleteApiMetaData(String application, String env, String id, List<JSONObject> modelDrivenList) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.DELETE_ACTIONMETADATA.getStepName() + ":\u8c03\u7528/restful/standard/apimgmt/ApiDelete/Delete\u5220\u9664\u8457\u6a21\u578b\u9664\u5916\u7684\u6570\u636e").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        Object executeContent = null;
        String code = "";
        try {
            String tenantId = AthenaUserLocal.getUser().getTenantId();
            for (JSONObject modelDriven : modelDrivenList) {
                code = modelDriven.getString("code");
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("tenantId", (Object)tenantId);
                jsonObject.put("apimgmtIntegrationToken", (Object)this.iamApiHelper.getIamIntegrationToken(tenantId));
                jsonObject.put("apimgmtUrl", (Object)this.moduleConfig.getApimgmt().getDomain());
                if (!ObjectUtil.isNotEmpty((Object)modelDriven.get((Object)"deleteApiMetaDataInfos")) || modelDriven.getJSONArray("deleteApiMetaDataInfos").size() <= 0) continue;
                jsonObject.put("deleteApiMetaDataInfos", (Object)modelDriven.getJSONArray("deleteApiMetaDataInfos"));
                this.backendApiHelper.deleteApiMetaData(env, jsonObject);
            }
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            String content = deployDetailV2.getContent();
            deployDetailV2.setContent(content + "(code:" + code + ")");
            deployDetailV2.setResult("fail").setExecuteContent(executeContent).setApiParam((Object)"").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.putHash(DEPLOY_PROCESS_KEY + application, id, (Object)new BigDecimal(-1));
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void adTemplatePublish(String application, List<TenantUser> tenantUsers, String env, String id, List<JSONObject> adTemplateList) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.DEPLOY_AD_TEMPLATE.getStepName() + ":\u8c03\u7528/restful/standard/scdispatcher/template/publish").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        JSONObject executeContent = null;
        AdTemplatePublishParam adTemplatePublishParam = new AdTemplatePublishParam();
        try {
            Iterator<JSONObject> iterator = adTemplateList.iterator();
            while (iterator.hasNext()) {
                JSONObject adTemplate;
                executeContent = adTemplate = iterator.next();
                adTemplatePublishParam.setAdTemplate(adTemplate).setEnv(env).setCurrentUser(AthenaUserLocal.getUser()).setTenantUsers(tenantUsers);
                String tenantId = adTemplate.getString("tenantId");
                if (tenantId != null && !tenantId.equals("SYSTEM")) {
                    String[] ucTenantIdList = tenantId.split(";");
                    ArrayList<TenantUser> ucTenantUsers = new ArrayList<TenantUser>();
                    for (String ti : ucTenantIdList) {
                        ucTenantUsers.add(new TenantUser().setTenantId(ti));
                    }
                    adTemplatePublishParam.setTenantUsers(ucTenantUsers);
                }
                this.backendApiHelper.adTemplatePublish(adTemplatePublishParam);
            }
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setExecuteContent(executeContent).setApiParam((Object)adTemplatePublishParam).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private List<TenantUser> getTenantUsersByTenantId(String application, String tenantId, String token, String env) {
        String[] ucTenantIdList = tenantId.split(";");
        ArrayList<TenantUser> ucTenantUsers = new ArrayList<TenantUser>();
        for (String ti : ucTenantIdList) {
            JSONObject jsonObject = this.backendApiHelper.allTenant(token, ti, env);
            if (jsonObject.getInteger("code") == null || 200 != jsonObject.getInteger("code")) continue;
            List data = jsonObject.getJSONArray("data").toJavaList(JSONObject.class);
            Long sid = data.stream().filter(da -> ti.equals(da.getString("id"))).findFirst().orElse(new JSONObject()).getLong("sid");
            if (null == sid) {
                log.warn(application + "\u5e94\u7528\u53d1\u5e03\u4e2a\u6848\u6570\u636e\u65f6\u79df\u6237\uff1a" + ti + "\u5728\u5f53\u524d\u53d1\u5e03\u73af\u5883\u672a\u627e\u5230\u5bf9\u5e94sid\uff01");
                continue;
            }
            ucTenantUsers.add(new TenantUser().setTenantId(ti).setOption(Integer.valueOf(1)).setTenantSid(sid));
        }
        return ucTenantUsers;
    }

    public void recordAdTemplateTenantDeployInfo(String application, List<TenantUser> tenantUsers, String env, List<JSONObject> adTemplateList, List<JSONObject> ucAdTemplateList) {
        HashMap ucAdTemplateIdAndTenantId = new HashMap();
        if (CollUtil.isNotEmpty(ucAdTemplateList)) {
            ucAdTemplateList.forEach(ad -> {
                if (StringUtils.isNotEmpty((CharSequence)ad.getString("id")) && StringUtils.isNotEmpty((CharSequence)ad.getString("tenantId"))) {
                    ucAdTemplateIdAndTenantId.put(ad.getString("id"), ad.getString("tenantId"));
                }
            });
        }
        List tenantIds = tenantUsers.stream().map(t -> t.getTenantId()).collect(Collectors.toList());
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("env").is((Object)env).and("type").is((Object)"deployAdTemplateTenantId").and("status").is((Object)"Active"));
        DeployParamRecord deployParamRecord = (DeployParamRecord)this.mongoTemplate.findOne(query, DeployParamRecord.class);
        if (null != deployParamRecord) {
            JSONObject adTemplateTenantMap = deployParamRecord.getValue();
            adTemplateList.forEach(ad -> {
                String id = ad.getString("id");
                if (StringUtils.isNotEmpty((CharSequence)id)) {
                    if (ObjectUtils.isNotEmpty((Object)adTemplateTenantMap.get((Object)id))) {
                        List tenantIdList = (List)adTemplateTenantMap.get((Object)id);
                        HashSet tenantIdSet = new HashSet(tenantIdList);
                        tenantIdSet.addAll(tenantIds);
                        tenantIdSet.removeAll(Arrays.asList((String)ucAdTemplateIdAndTenantId.get(id)));
                        adTemplateTenantMap.put(id, tenantIdSet);
                    } else {
                        HashSet tenantIdSet = new HashSet();
                        tenantIdSet.addAll(tenantIds);
                        tenantIdSet.removeAll(Arrays.asList((String)ucAdTemplateIdAndTenantId.get(id)));
                        adTemplateTenantMap.put(id, tenantIdSet);
                    }
                }
            });
            deployParamRecord.setValue(adTemplateTenantMap);
            this.mongoTemplate.save((Object)deployParamRecord);
        } else {
            DeployParamRecord dpr = new DeployParamRecord().setApplication(application).setEnv(env).setType("deployAdTemplateTenantId").setStatus("Active");
            JSONObject adTemplateTenantMap = new JSONObject();
            adTemplateList.forEach(ad -> {
                String id = ad.getString("id");
                if (StringUtils.isNotEmpty((CharSequence)id)) {
                    HashSet tenantIdSet = new HashSet();
                    tenantIdSet.addAll(tenantIds);
                    tenantIdSet.removeAll(Arrays.asList((String)ucAdTemplateIdAndTenantId.get(id)));
                    adTemplateTenantMap.put(id, tenantIdSet);
                }
            });
            dpr.setValue(adTemplateTenantMap);
            this.mongoTemplate.insert((Object)dpr);
        }
    }

    private void lcdpPublish(List<TenantUser> tenantUsers, String env, String id, String application, List<JSONObject> pageDesignList) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.CREATE_DATA_ENTRY.getStepName() + ":\u8c03\u7528/restful/service/lcdp/FormDesign/PublishSchema").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        JSONObject executeContent = null;
        LcdpPublishParam lcdpPublishParam = new LcdpPublishParam();
        try {
            ApplicationPO applicationPO = this.designerApiHelper.getApplicationByCode(application, AthenaUserLocal.getUser().getToken());
            Iterator<JSONObject> iterator = pageDesignList.iterator();
            while (iterator.hasNext()) {
                JSONObject pageDesign;
                executeContent = pageDesign = iterator.next();
                lcdpPublishParam.setEnv(env).setTenantUsers(tenantUsers).setCurrentUser(AthenaUserLocal.getUser()).setAppToken(applicationPO.getAppToken()).setApplication(application).setPageDesign(pageDesign);
                this.backendApiHelper.lcdpPublish(lcdpPublishParam);
            }
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setExecuteContent(executeContent).setApiParam((Object)lcdpPublishParam).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void syncEspActionEnumKey(String env, String id, String application, JSONObject espActionEnumKeyObj) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.UPDATE_ESPACTION_ENUMKEY.getStepName()).setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        Object executeContent = null;
        LcdpPublishParam lcdpPublishParam = new LcdpPublishParam();
        try {
            this.backendApiHelper.updateEspActionEnumKey(env, espActionEnumKeyObj);
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setExecuteContent(executeContent).setApiParam((Object)lcdpPublishParam).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void modifyDifferenceData(String env, String id, String application) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.DATA_IN_KNOWLEDGE_GRAPH.getStepName()).setApplication(application);
        try {
            this.backendApiHelper.modifyDifferenceData(application, "1.0", env);
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setFailMessage("modifyDifferenceData \u5931\u8d25").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        finally {
            deployDetailV2.setTime(new Date());
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void executeBson(String application, String env, String id, List<BsonInfo> bsonInfoList) {
        for (BsonInfo bsonInfo : bsonInfoList) {
            List documentList = bsonInfo.getDocumentList();
            DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.DATA_IN_KNOWLEDGE_GRAPH_EXECUTE_BSON.getStepName()).setApplication(application);
            ExecuteBsonParam executeBsonParam = null;
            try {
                documentList.forEach(document -> this.removeLanguage(document));
                executeBsonParam = new ExecuteBsonParam().setDbName(bsonInfo.getDbName()).setCollectionName(bsonInfo.getCollectionName()).setDocumentList(documentList);
                this.backendApiHelper.executeBson(executeBsonParam, env);
                deployDetailV2.setResult("success");
            }
            catch (Exception e) {
                deployDetailV2.setResult("fail").setFailMessage("\u6267\u884cbson\u5931\u8d25").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setExecuteContent((Object)executeBsonParam).setErrorMessage(e.getMessage());
                this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
                throw new BusinessException((Throwable)e);
            }
            finally {
                long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
                deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
                this.insertDeployDetail(deployDetailV2);
            }
        }
    }

    public void removeLanguage(Document doc) {
        Iterator iterator = doc.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if ("language".equals(key)) {
                iterator.remove();
                continue;
            }
            if (!(value instanceof Document)) continue;
            this.removeLanguage((Document)value);
        }
    }

    private void executeCql(String application, String env, String id, List<String> cqlList) {
        List cqlListSplit = ListUtil.split(cqlList, (int)100);
        for (List cqlPartition : cqlListSplit) {
            DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.DATA_IN_KNOWLEDGE_GRAPH_EXECUTE_CQL.getStepName()).setApplication(application);
            List collect = cqlPartition.stream().map(cql -> new Cql().setCql(cql)).collect(Collectors.toList());
            try {
                this.backendApiHelper.executeCql(collect, env);
                deployDetailV2.setResult("success");
            }
            catch (Exception e) {
                deployDetailV2.setResult("fail").setFailMessage("\u6267\u884ccql\u5931\u8d25").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setExecuteContent(collect).setErrorMessage(e.getMessage());
                this.redisCache.set(DEPLOY_PROCESS_KEY + application + id, (Object)new BigDecimal(-1), 3600L);
                throw new BusinessException((Throwable)e);
            }
            finally {
                long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
                deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
                this.insertDeployDetail(deployDetailV2);
            }
        }
    }

    private void cleanApplicationData(String env, String id, CleanMongoParam cleanMongoParam, CleanNeo4jParam cleanNeo4jParam) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.DATA_IN_KNOWLEDGE_GRAPH.getStepName()).setResult("start").setApplication(cleanMongoParam.getApplication());
        this.insertDeployDetail(deployDetailV2);
        deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.DATA_IN_KNOWLEDGE_GRAPH_CLEAN_APPLICATION.getStepName()).setResult("start").setApplication(cleanMongoParam.getApplication());
        this.insertDeployDetail(deployDetailV2);
        try {
            this.backendApiHelper.cleanMongoData(cleanMongoParam, env);
            this.backendApiHelper.cleanNeo4jData(cleanNeo4jParam, env);
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setFailMessage("\u6e05\u9664\u5e94\u7528\u6570\u636e\u5931\u8d25").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage()).setTime(new Date());
            this.redisCache.set(DEPLOY_PROCESS_KEY + cleanMongoParam.getApplication() + id, (Object)new BigDecimal(-1), 3600L);
            this.insertDeployDetail(deployDetailV2);
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void syncEsp(Boolean syncEsp, String application, String env, String deployNo) {
        if (syncEsp == null || !syncEsp.booleanValue()) return;
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(deployNo).setTime(new Date()).setContent(DeployStepEnum.SYNC_ESP.getStepName()).setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        RLock lock = this.redissonClient.getLock(SYNC_ESP_EXECUTING_LOCK);
        if (!lock.isLocked()) {
            try {
                lock.lock(5L, TimeUnit.MINUTES);
                Object status = this.redisCache.get(SYNC_ESP_EXECUTING_KEY);
                if (status != null && Convert.toBool((Object)status).booleanValue()) return;
                this.redisCache.set(SYNC_ESP_EXECUTING_KEY, (Object)true);
                this.backendApiHelper.syncEspMetaData("1.0", env);
                deployDetailV2.setResult("success");
                return;
            }
            catch (Exception e) {
                deployDetailV2.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
                throw new BusinessException((Throwable)e);
            }
            finally {
                long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
                deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
                this.insertDeployDetail(deployDetailV2);
                this.redisCache.set(SYNC_ESP_EXECUTING_KEY, (Object)false);
                lock.unlock();
            }
        } else {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills)).setResult("success");
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private static long calculateExecuteMills(Date time) {
        Date now = new Date();
        long mills = now.getTime() - time.getTime();
        return mills;
    }

    public void insertDeployDetail(DeployDetailV2 deployDetailV2) {
        DeployTask deployTaskInfo = CurThreadInfoUtils.getDeployTaskInfo();
        if (deployTaskInfo != null) {
            deployDetailV2.setTaskType(deployTaskInfo.getType());
        }
        this.deployDetailV2Dao.insert(deployDetailV2);
    }

    public List<DeployTaskInfoResDto> queryDeployDetail(String deployNo, String application) {
        List deployDetailList = this.deployDetailV2Dao.selectByApplicationAndDeployNoOrderAscTime(deployNo, application);
        List deployTaskList = this.deployTaskDao.selectByApplicationAndDeployNoAscOrder(deployNo, application);
        DeployLog deployLog = this.deployLogDao.selectByApplicationAndDeployNo(application, deployNo);
        ArrayList<DeployTaskInfoResDto> res = new ArrayList<DeployTaskInfoResDto>();
        if ("old".equals(deployLog.getDeployParam().getPublishMode())) {
            DeployTaskInfoResDto deployTaskInfoResDto = new DeployTaskInfoResDto();
            deployTaskInfoResDto.setTaskName(application);
            deployTaskInfoResDto.setStatus(deployLog.getResult());
            deployTaskInfoResDto.setDetailList(deployDetailList);
            if ("success".equals(deployLog.getResult()) || "fail".equals(deployLog.getResult())) {
                Long executeTime = ((DeployDetailV2)deployDetailList.get(deployDetailList.size() - 1)).getTime().getTime() - ((DeployDetailV2)deployDetailList.get(0)).getTime().getTime();
                deployTaskInfoResDto.setExecuteTimeMills(executeTime);
            } else {
                Long executeTime = new Date().getTime() - ((DeployDetailV2)deployDetailList.get(0)).getTime().getTime();
                deployTaskInfoResDto.setExecuteTimeMills(executeTime);
            }
            res.add(deployTaskInfoResDto);
        } else {
            DeployTask deployTask = new DeployTask();
            deployTask.setDeployNo(deployNo);
            deployTask.setApplication(application);
            deployTask.setStatus("executing".equals(deployLog.getResult()) ? "success" : "executing");
            deployTask.setCreateDate(((DeployDetailV2)deployDetailList.get(0)).getTime());
            deployTask.setType("publish".equals(deployLog.getType()) ? DeployTaskTypeEnum.DEPLOY_PRE.getType() : SwitchTaskTypeEnum.SWITCH_PRE.getType());
            deployTask.setOrder("publish".equals(deployLog.getType()) ? DeployTaskTypeEnum.DEPLOY_PRE.getOrder() : SwitchTaskTypeEnum.SWITCH_PRE.getOrder());
            deployTaskList.add(0, deployTask);
            deployDetailList.remove(0);
            Map<String, List<DeployDetailV2>> typeMapDetails = deployDetailList.stream().collect(Collectors.groupingBy(DeployDetailV2::getTaskType));
            for (DeployTask task : deployTaskList) {
                DeployTaskInfoResDto deployTaskInfoResDto = new DeployTaskInfoResDto();
                deployTaskInfoResDto.setStatus(task.getStatus());
                if ("publish".equals(deployLog.getType())) {
                    deployTaskInfoResDto.setTaskName(DeployTaskTypeEnum.getEnum((String)task.getType()).getContent());
                } else {
                    deployTaskInfoResDto.setTaskName(SwitchTaskTypeEnum.getEnum((String)task.getType()).getContent());
                }
                List<DeployDetailV2> details = typeMapDetails.get(task.getType());
                deployTaskInfoResDto.setDetailList(details);
                if ("executing".equals(task.getStatus())) {
                    if (!details.isEmpty()) {
                        deployTaskInfoResDto.setExecuteTimeMills(Long.valueOf(new Date().getTime() - details.get(0).getTime().getTime()));
                    }
                } else if ("waiting".equals(task.getStatus())) {
                    deployTaskInfoResDto.setExecuteTimeMills(Long.valueOf(0L));
                } else if (!details.isEmpty()) {
                    deployTaskInfoResDto.setExecuteTimeMills(Long.valueOf(details.get(details.size() - 1).getTime().getTime() - details.get(0).getTime().getTime()));
                }
                res.add(deployTaskInfoResDto);
            }
        }
        return res;
    }

    public BigDecimal getApplicationProcess4Agile(String application, String deployNo) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("deployNo").is((Object)deployNo));
        DeployLog deployLog = (DeployLog)this.mongoTemplate.findOne(query, DeployLog.class);
        if (null != deployLog) {
            String result = deployLog.getResult();
            BigDecimal process = deployLog.getProcess();
            if ("success".equals(result)) {
                return BigDecimal.valueOf(1L);
            }
            if ("fail".equals(result)) {
                return BigDecimal.valueOf(-1L);
            }
            return process;
        }
        return null;
    }

    private ParseCompileFileResult parseFileData(String deployNo, String application, String compileDataCode) {
        ParseCompileFileResult parseCompileFileResult;
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(deployNo).setTime(new Date()).setContent(DeployStepEnum.PARSE_COMPILE_FILE.getStepName()).setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        String compileVersion = null;
        try {
            JSONObject compiledData = this.designerApiHelper.queryCompiledDataByCode(compileDataCode, AthenaUserLocal.getUser().getToken());
            compileVersion = compiledData.getString("version");
            ParseCompileFileResult compiledDataFiles = this.deployerService.getCompiledDataFiles(application, compiledData);
            ParseCompileFileResult parseCompileFileResult2 = new ParseCompileFileResult().setCompileData(compiledData);
            ArrayList<Object> cqlList = new ArrayList<Object>();
            ArrayList<BsonInfo> bsonInfoList = new ArrayList<BsonInfo>();
            ArrayList<JSONObject> pageDesignList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> modelDrivenList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> sysAdTemplateList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> ucAdTemplateList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> activityConfigList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> statementList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> dataEntryList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> mobilePageDesignList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> kitAssignList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> startProjectList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> synonymList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> standardParamsList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> triggerList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> dataViewList = new ArrayList<JSONObject>();
            ArrayList proLinesList = new ArrayList();
            ArrayList<JSONObject> processList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> applicationConfigList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> assetConfigList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> assetConfigCollectList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> aimEventList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> aimSceneList = new ArrayList<JSONObject>();
            JSONObject espActionEnumKeyList = new JSONObject();
            JSONObject appJson = new JSONObject();
            HashMap collectionInfo = new HashMap();
            for (File compileDataFile : compiledDataFiles) {
                if (!compileDataFile.isDirectory()) continue;
                String dbName = compileDataFile.getName();
                HashSet<String> collectionNameList = new HashSet<String>();
                if ("cypher".equals(dbName)) {
                    for (File file : files = compileDataFile.listFiles()) {
                        if (".DS_Store".equals(file.getName())) continue;
                        List data = FileUtil.readLines((File)file, (Charset)Charset.forName("utf-8"));
                        for (Object line : data) {
                            line = ((String)line).replaceAll("\\{athena_version}", "1.0");
                            line = ((String)line).replaceAll("\\{common_version}", "1.0");
                            cqlList.add(line);
                        }
                    }
                } else {
                    for (File file : files = compileDataFile.listFiles()) {
                        if (!file.isDirectory()) continue;
                        String collectionName = file.getName();
                        File[] dataFile = file.listFiles();
                        if ("athenadesigner".equals(dbName) || "designer".equals(dbName)) {
                            for (File f : dataFile) {
                                if (".DS_Store".equals(f.getName())) continue;
                                List data = FileUtil.readLines((File)f, (Charset)Charset.forName("utf-8"));
                                for (String line : data) {
                                    JSONObject jsonObject = JSON.parseObject((String)line);
                                    if ("pageDesign".equals(collectionName)) {
                                        pageDesignList.add(jsonObject);
                                        continue;
                                    }
                                    if ("adTemplate".equals(collectionName)) {
                                        String tenantId = jsonObject.getString("tenantId");
                                        if (tenantId != null && !tenantId.equals("SYSTEM")) {
                                            ucAdTemplateList.add(jsonObject);
                                            continue;
                                        }
                                        sysAdTemplateList.add(jsonObject);
                                        continue;
                                    }
                                    if ("neo4jActivity".equals(collectionName) && ("STATEMENT".equals(jsonObject.getString("pattern")) || "MOBI-STATEMENT".equals(jsonObject.getString("pattern")))) {
                                        statementList.add(jsonObject);
                                        continue;
                                    }
                                    if ("neo4jActivity".equals(collectionName) && "DATA_ENTRY".equals(jsonObject.getString("pattern"))) {
                                        dataEntryList.add(jsonObject);
                                        continue;
                                    }
                                    if ("modelDriven".equals(collectionName)) {
                                        modelDrivenList.add(jsonObject);
                                        continue;
                                    }
                                    if ("espActionEnumKey".equals(collectionName)) {
                                        espActionEnumKeyList = jsonObject;
                                        continue;
                                    }
                                    if ("kitAssign".equals(collectionName)) {
                                        kitAssignList.add(jsonObject);
                                        continue;
                                    }
                                    if ("agiledata_synonym".equals(collectionName)) {
                                        synonymList.add(jsonObject);
                                        continue;
                                    }
                                    if ("agiledata_scene_trigger".equals(collectionName)) {
                                        triggerList.add(jsonObject);
                                        continue;
                                    }
                                    if ("applicationConfig".equals(collectionName)) {
                                        applicationConfigList.add(jsonObject);
                                        continue;
                                    }
                                    if ("assetConfig".equals(collectionName)) {
                                        assetConfigList.add(jsonObject);
                                        continue;
                                    }
                                    if ("assetConfigCollect".equals(collectionName)) {
                                        assetConfigCollectList.add(jsonObject);
                                        continue;
                                    }
                                    if ("aim_event".equals(collectionName)) {
                                        aimEventList.add(jsonObject);
                                        continue;
                                    }
                                    if (!"aim_scene".equals(collectionName)) continue;
                                    aimSceneList.add(jsonObject);
                                }
                            }
                            continue;
                        }
                        collectionNameList.add(collectionName);
                        ArrayList<Document> documentList = new ArrayList<Document>();
                        for (File f : dataFile) {
                            JSONObject jsonObject;
                            if (".DS_Store".equals(f.getName())) continue;
                            List data = FileUtil.readLines((File)f, (Charset)Charset.forName("utf-8"));
                            if ("activityConfigs".equals(collectionName)) {
                                for (String line : data) {
                                    jsonObject = JSON.parseObject((String)line);
                                    activityConfigList.add(jsonObject);
                                }
                            }
                            if ("mobilePageDesign".equals(collectionName)) {
                                for (String line : data) {
                                    jsonObject = JSON.parseObject((String)line);
                                    mobilePageDesignList.add(jsonObject);
                                }
                            } else if ("project".equals(collectionName)) {
                                for (String line : data) {
                                    jsonObject = JSON.parseObject((String)line);
                                    Boolean manualAble = jsonObject.getBoolean("manualAble");
                                    if (manualAble == null || !manualAble.booleanValue()) continue;
                                    startProjectList.add(jsonObject);
                                }
                            } else if ("dataView".equals(collectionName)) {
                                for (String line : data) {
                                    jsonObject = JSON.parseObject((String)line);
                                    dataViewList.add(jsonObject);
                                }
                            } else if ("process".equals(collectionName)) {
                                for (String line : data) {
                                    jsonObject = JSON.parseObject((String)line);
                                    processList.add(jsonObject);
                                }
                            } else if ("application".equals(collectionName)) {
                                appJson = JSON.parseObject((String)((String)data.get(0)));
                            } else if ("agiledata_standard_params".equals(collectionName)) {
                                for (String line : data) {
                                    jsonObject = JSON.parseObject((String)line);
                                    standardParamsList.add(jsonObject);
                                }
                            }
                            for (String line : data) {
                                Document document = Document.parse((String)line);
                                document.remove((Object)"_id");
                                document.remove((Object)"isMigrate");
                                document.put("athena_namespace", (Object)application);
                                document.put("compileVersion", (Object)compileVersion);
                                document.put("application", (Object)application);
                                document.put("version", (Object)"1.0");
                                documentList.add(document);
                            }
                        }
                        BsonInfo bsonInfo = new BsonInfo().setDbName(dbName).setCollectionName(collectionName).setDocumentList(documentList);
                        bsonInfoList.add(bsonInfo);
                    }
                }
                if ("athenadesigner".equals(dbName) || "designer".equals(dbName) || "cypher".equals(dbName)) continue;
                collectionInfo.put(dbName, collectionNameList);
            }
            parseCompileFileResult2.setCqlList(cqlList).setBsonInfoList(bsonInfoList).setStatementList(statementList).setDataEntryList(dataEntryList).setActivityConfigList(activityConfigList).setAdTemplateList(sysAdTemplateList).setPageDesignList(pageDesignList).setCollectionInfo(collectionInfo).setModelDrivenList(modelDrivenList).setKitAssignList(kitAssignList).setStartProjectList(startProjectList).setEspActionEnumKey(espActionEnumKeyList).setUcAdTemplateList(ucAdTemplateList).setApplication(appJson).setMobilePageDesignList(mobilePageDesignList).setSynonymList(synonymList).setStandardParamsList(standardParamsList).setTriggerList(triggerList).setBranch(compiledData.getString("branch")).setDataViewList(dataViewList).setProcessList(processList).setApplicationConfigList(applicationConfigList).setAssetConfigList(assetConfigList).setAssetConfigCollectList(assetConfigCollectList).setAimEventList(aimEventList).setAimSceneList(aimSceneList);
            deployDetailV2.setResult("success");
            parseCompileFileResult = parseCompileFileResult2;
        }
        catch (Exception e) {
            try {
                deployDetailV2.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
                this.redisCache.set(DEPLOY_PROCESS_KEY + application + deployNo, (Object)new BigDecimal(-1), 3600L);
                throw new BusinessException((Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtil.del((String)(this.compileDataPath + File.separator + application + File.separator));
                FileUtil.del((String)StrUtil.format((CharSequence)(this.compileZipPath + File.separator + application + File.separator + application + "_{}.zip"), (Object[])new Object[]{compileVersion}));
                long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
                deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
                this.insertDeployDetail(deployDetailV2);
                throw throwable;
            }
        }
        FileUtil.del((String)(this.compileDataPath + File.separator + application + File.separator));
        FileUtil.del((String)StrUtil.format((CharSequence)(this.compileZipPath + File.separator + application + File.separator + application + "_{}.zip"), (Object[])new Object[]{compileVersion}));
        long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
        deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
        this.insertDeployDetail(deployDetailV2);
        return parseCompileFileResult;
    }

    public void switch2Prod(DeployParamV3 deployParam) {
        List tenantUsers = deployParam.getTenantUsers();
        Boolean switchEspAction = deployParam.getSwitchEspAction();
        List tenantIdList = tenantUsers.stream().map(tenantUser -> tenantUser.getTenantId()).collect(Collectors.toList());
        List applicationDataList = deployParam.getApplicationDataList();
        JSONObject neo4jNodeKeyJson = this.queryNeo4jNodeKeyJson();
        String env = deployParam.getEnv();
        String id = deployParam.getId();
        for (ApplicationData applicationData : applicationDataList) {
            String application = applicationData.getApplication();
            log.info("\u5e94\u7528\uff1a" + application + "\u51c6\u5907\u5207\u7248");
            this.backendApiHelper.monitorChange(deployParam.getTenantUsers(), applicationData.getApplication(), env, "switch", "begin", "2.0");
            com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env envData = this.getPublishEnv(applicationData.getApplication(), deployParam.getEnvServiceId());
            String deployDbMapEnv = envData.getEnv();
            try {
                DeployDetailV2 deployDetailV2;
                if ("DATASTANDARDS".equals(application)) {
                    deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setApplication(application).setContent(application + SwitchStepEnum.SWITCH_APPLICATION.getStepName()).setResult("start");
                    this.insertDeployDetail(deployDetailV2);
                    List publishDbMongoData = this.queryDeployParamRecords(application, deployDbMapEnv, "publishDbMongoData", null);
                    this.updateVersion2DataStandards(application, id, env, tenantIdList, publishDbMongoData);
                    this.setDeploySwitchProcess(id, application, new BigDecimal(2), APPLICATION_SWITCH_STEP_NUM);
                    this.restoreVersion1DataStandards(application, id, env, publishDbMongoData);
                    this.setDeploySwitchProcess(id, application, new BigDecimal(3), APPLICATION_SWITCH_STEP_NUM);
                    this.clearCacheInSwitch(env, id, application);
                    this.setDeploySwitchProcess(id, application, new BigDecimal(9), APPLICATION_SWITCH_STEP_NUM);
                    Update update = new Update();
                    update.set("status", (Object)4);
                    this.mongoTemplate.upsert(new Query(), (UpdateDefinition)update, "application");
                    this.updateDeployLogResult(application, id, "success");
                    deployDetailV2.setTime(new Date()).setResult("success");
                    this.insertDeployDetail(deployDetailV2);
                    deployDetailV2.setTime(new Date()).setResult("finish");
                    this.insertDeployDetail(deployDetailV2);
                    this.setDeploySwitchProcess(id, application, new BigDecimal(10), APPLICATION_SWITCH_STEP_NUM);
                    log.info("\u5e94\u7528:{}\u5207\u7248\u7ed3\u675f", (Object)application);
                    continue;
                }
                deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setApplication(application).setContent(application + SwitchStepEnum.SWITCH_APPLICATION.getStepName()).setResult("start");
                this.insertDeployDetail(deployDetailV2);
                this.updateDeployLogResult(application, id, "executing");
                List recordApplications = this.queryDeployParamRecords(application, deployDbMapEnv, "application", null);
                Boolean commonApp = Optional.ofNullable(((JSONObject)recordApplications.get(0)).getBoolean("commonApp")).orElse(false);
                Application2CommonRelationParam findApplication2CommonParam = new Application2CommonRelationParam().setTenantIdList(tenantIdList).setNeo4jNodeKeyJson(neo4jNodeKeyJson);
                List prodApplication2ProdCommonRelations = this.switchPreTask(application, id, findApplication2CommonParam, env, commonApp);
                this.setDeploySwitchProcess(id, application, BigDecimal.ONE, APPLICATION_SWITCH_STEP_NUM);
                List publishDbMongoData = this.queryDeployParamRecords(application, deployDbMapEnv, "publishDbMongoData", null);
                Object tenantVersionMap = this.backendApiHelper.queryCurTenantVersion(tenantIdList, env);
                CreateApplicationRelationParam createApplicationRelationParam = new CreateApplicationRelationParam().setRelationList(prodApplication2ProdCommonRelations).setApplicationVersion("2.0").setCommonVersion("2.0").setNeo4jNodeKeyJson(neo4jNodeKeyJson);
                this.updateVersion2Data(application, id, createApplicationRelationParam, env, tenantIdList, publishDbMongoData);
                this.setDeploySwitchProcess(id, application, new BigDecimal(2), APPLICATION_SWITCH_STEP_NUM);
                this.restoreVersion1Data(application, id, findApplication2CommonParam, createApplicationRelationParam, env, publishDbMongoData, commonApp);
                this.setDeploySwitchProcess(id, application, new BigDecimal(3), APPLICATION_SWITCH_STEP_NUM);
                this.excutePostprocessTasks(application, id, env, tenantIdList, tenantVersionMap, commonApp);
                this.setDeploySwitchProcess(id, application, new BigDecimal(4), APPLICATION_SWITCH_STEP_NUM);
                this.switchAppUseOtherService(application, id, env, deployDbMapEnv, tenantUsers, tenantIdList, deployParam);
                if (switchEspAction.booleanValue()) {
                    this.incrementalUpdateEspAction(application, id, env);
                }
                this.setDeploySwitchProcess(id, application, new BigDecimal(8), APPLICATION_SWITCH_STEP_NUM);
                this.clearCacheInSwitch(env, id, application);
                this.setDeploySwitchProcess(id, application, new BigDecimal(9), APPLICATION_SWITCH_STEP_NUM);
                Update update = new Update();
                update.set("status", (Object)4);
                this.mongoTemplate.upsert(new Query(), (UpdateDefinition)update, "application");
                this.updateDeployLogResult(application, id, "success");
                deployDetailV2.setTime(new Date()).setResult("success");
                this.insertDeployDetail(deployDetailV2);
                deployDetailV2.setTime(new Date()).setResult("finish");
                this.insertDeployDetail(deployDetailV2);
                this.setDeploySwitchProcess(id, application, new BigDecimal(10), APPLICATION_SWITCH_STEP_NUM);
                this.backendApiHelper.monitorChange(deployParam.getTenantUsers(), applicationData.getApplication(), env, "switch", "end", "2.0");
                log.info("\u5e94\u7528:{}\u5207\u7248\u7ed3\u675f", (Object)application);
                Bson bson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"code", (Object)application)});
                FindIterable documents = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("athenadesginer").getCollection("application").find(bson);
                Document first = (Document)documents.first();
                if (!Objects.nonNull(first) || !Objects.nonNull(first.getInteger((Object)"appType")) || first.getInteger((Object)"appType") != 6) continue;
                String token = AthenaUserLocal.getUser().getToken();
                String tenantId = AthenaUserLocal.getUser().getTenantId();
                List publish = this.envService.queryEnvsWithoutAuth("switch");
                String envCode = this.bmdEnvMapUtil.getBmdEnv(publish, env);
                List synonymList = this.queryDeployParamRecords(application, deployDbMapEnv, "publishSynonymData", null);
                List standardParamsList = this.queryDeployParamRecords(application, deployDbMapEnv, "publishStandardParamsData", null);
                AthenaUser user = AthenaUserLocal.getUser();
                ThreadUtil.execute(() -> this.pushStandardParams(application, env, tenantUsers, tenantId, "2.0", standardParamsList, user));
                ThreadUtil.execute(() -> this.pushSynonym(application, env, tenantUsers, tenantId, "2.0", synonymList, user));
                ThreadUtil.execute(() -> this.pushSynonymToAI(application, env, tenantUsers, tenantId, "2.0", synonymList, user));
                String source = first.getString((Object)"source");
                ThreadUtil.execute(() -> this.syncModelCentral(application, envCode, tenantUsers, token, "2.0", user, source));
                ThreadUtil.execute(() -> this.syncPushData(application, env, tenantUsers, token, tenantId, "2.0", user));
            }
            catch (Exception e) {
                this.updateDeployLogResult(application, id, "fail");
                this.insertErrorMsgInDeployDetail(application, id, env, "\u5207\u7248\u62a5\u9519", e);
                throw new BusinessException("Switch app:" + application + " failed : " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env getPublishEnv(String application, String envServiceId) {
        TenantPipeLine tenantPipeLine = this.releasePipeLineService.queryTenantPipelineByApplication(application);
        Node node = TenantPipelineHelper.findNodeByServiceId((TenantPipeLine)tenantPipeLine, (String)envServiceId);
        com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env env = node.getEnvByOperate(EnvOperateEnum.PUBLISH.getOperate());
        return env;
    }

    private void switchAppUseOtherService(String application, String id, String env, String deployDbMapEnv, List<TenantUser> tenantUsers, List<String> tenantIdList, DeployParamV3 deployParam) {
        this.publishAdTemplate(application, id, env, tenantUsers, deployDbMapEnv);
        this.setDeploySwitchProcess(id, application, BigDecimal.valueOf(4.5), APPLICATION_SWITCH_STEP_NUM);
        this.switchPublishTbb(application, id, env, tenantIdList, deployDbMapEnv);
        this.setDeploySwitchProcess(id, application, new BigDecimal(5), APPLICATION_SWITCH_STEP_NUM);
        this.iamAuthorizationInSwitch(application, id, deployParam);
        this.setDeploySwitchProcess(id, application, new BigDecimal(6), APPLICATION_SWITCH_STEP_NUM);
        this.gmcProductmoduleUpdate(application, id, env, deployDbMapEnv);
        this.setDeploySwitchProcess(id, application, new BigDecimal(7), APPLICATION_SWITCH_STEP_NUM);
    }

    private List<Relation> switchPreTask(String application, String id, Application2CommonRelationParam findApplication2CommonParam, String env, Boolean commonApp) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(SwitchStepEnum.EXECUTE_SWITCH_PRE_TASK.getStepName()).setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        try {
            List prodApplication2ProdCommonRelations;
            long stime = System.currentTimeMillis();
            if (commonApp.booleanValue()) {
                findApplication2CommonParam.setApplicationList((List)ListUtil.toList((Object[])new String[]{application, "espCommon"})).setApplicationVersion("2.0").setCommonVersion("2.0");
                prodApplication2ProdCommonRelations = this.backendApiHelper.findApp2OtherAppRelations(findApplication2CommonParam, env);
            } else {
                findApplication2CommonParam.setApplicationList((List)ListUtil.toList((Object[])new String[]{application})).setApplicationVersion("1.0").setCommonVersion("1.0");
                prodApplication2ProdCommonRelations = this.backendApiHelper.findSpecialApp2OtherCommonAppRelations(findApplication2CommonParam, env);
            }
            if (commonApp.booleanValue()) {
                this.backendApiHelper.mergeCommonAppRelaWithVirtualTenant(application, "1.0", "2.0", env);
            } else {
                Tenant2NodeRelationParam tenant2NodeRelationParam = new Tenant2NodeRelationParam().setApplication(application).setTenantVersion("2.0").setAppVersion("1.0");
                this.backendApiHelper.createAllAuthTenantAndApplicationRelation(tenant2NodeRelationParam, env);
            }
            long t2 = System.currentTimeMillis();
            log.info(application + "\u5e94\u7528\u5207\u7248-\u5f00\u59cb\u5230\u6b65\u9aa42\u7684\u8017\u65f6\uff1a" + (t2 - stime));
            deployDetailV2.setResult("success");
            List list = prodApplication2ProdCommonRelations;
            return list;
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setApiParam(null).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.updateDeployLogAppProcess(application, id, new BigDecimal(-1));
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void updateVersion2Data(String application, String id, CreateApplicationRelationParam createApplicationRelationParam, String env, List<String> tenantIdList, List<JSONObject> publishDbMongoData) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(SwitchStepEnum.UPDATE_VERSION2_DATA.getStepName()).setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        try {
            long stime = System.currentTimeMillis();
            ArrayList executeCqlList = new ArrayList();
            List updateAppDataVersionCqlList = this.backendApiHelper.getUpdateAppDataVersionCqlList(application, "1.0", "2.0", tenantIdList, env, publishDbMongoData);
            executeCqlList.addAll(updateAppDataVersionCqlList);
            List relationCqlList = this.backendApiHelper.getCqlByRelation(createApplicationRelationParam, env);
            executeCqlList.addAll(relationCqlList);
            long t3 = System.currentTimeMillis();
            log.info(application + "\u5e94\u7528\u5207\u7248-\u6b65\u9aa43\u5230\u6b65\u9aa44\u83b7\u53d6cql\u8bed\u53e5\u7684\u8017\u65f6\uff1a" + (t3 - stime));
            this.backendApiHelper.transExecute(executeCqlList, env);
            long t4 = System.currentTimeMillis();
            log.info(application + "\u5e94\u7528\u5207\u7248-\u6267\u884c\u4e0a\u8ff0cql\u7684\u8017\u65f6\uff1a" + (t4 - t3));
            this.backendApiHelper.modifyTenantConfig(env, tenantIdList, "2.0");
            long t5 = System.currentTimeMillis();
            log.info(application + "\u5e94\u7528\u5207\u7248-\u6b65\u9aa44\u5230\u6b65\u9aa45\u7684\u8017\u65f6\uff1a" + (t5 - t4));
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setApiParam(null).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.updateDeployLogAppProcess(application, id, new BigDecimal(-1));
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void updateVersion2DataStandards(String application, String id, String env, List<String> tenantIdList, List<JSONObject> publishDbMongoData) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(SwitchStepEnum.UPDATE_VERSION2_DATA.getStepName()).setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        try {
            long stime = System.currentTimeMillis();
            this.backendApiHelper.getUpdateAppDataVersionCqlList(application, "1.0", "2.0", tenantIdList, env, publishDbMongoData);
            long t3 = System.currentTimeMillis();
            log.info(application + "\u5e94\u7528\u5207\u7248-\u6b65\u9aa43\u5230\u6b65\u9aa44\u83b7\u53d6cql\u8bed\u53e5\u7684\u8017\u65f6\uff1a" + (t3 - stime));
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setApiParam(null).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.updateDeployLogAppProcess(application, id, new BigDecimal(-1));
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void restoreVersion1Data(String application, String id, Application2CommonRelationParam findApplication2CommonParam, CreateApplicationRelationParam createApplicationRelationParam, String env, List<JSONObject> publishDbMongoData, Boolean commonApp) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(SwitchStepEnum.RESTORE_VERSION1_DATA.getStepName()).setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        try {
            List testApplication2ProdCommonRelations;
            long stime = System.currentTimeMillis();
            if (commonApp.booleanValue()) {
                findApplication2CommonParam.setApplicationList((List)ListUtil.toList((Object[])new String[]{application, "espCommon"})).setApplicationVersion("1.0").setCommonVersion("2.0");
                testApplication2ProdCommonRelations = this.backendApiHelper.findApp2OtherAppRelations(findApplication2CommonParam, env);
                this.backendApiHelper.deleteCommonApp2OtherAppRelations(findApplication2CommonParam, env);
            } else {
                findApplication2CommonParam.setApplicationList((List)ListUtil.toList((Object[])new String[]{application})).setApplicationVersion("2.0").setCommonVersion("1.0");
                testApplication2ProdCommonRelations = this.backendApiHelper.findSpecialApp2OtherCommonAppRelations(findApplication2CommonParam, env);
                this.backendApiHelper.deleteSpecialApp2CommonAppRelations(findApplication2CommonParam, env);
            }
            long t6 = System.currentTimeMillis();
            log.info(application + "\u5e94\u7528\u5207\u7248-\u6b65\u9aa45\u5230\u6b65\u9aa46\u7684\u8017\u65f6\uff1a" + (t6 - stime));
            ApplicationCopyParam applicationCopyParam = new ApplicationCopyParam().setApplication(application).setOldVersion("2.0").setNewVersion("1.0").setPublishDbMongoData(publishDbMongoData);
            this.backendApiHelper.copyApplication(applicationCopyParam, env);
            long t7 = System.currentTimeMillis();
            log.info(application + "\u5e94\u7528\u5207\u7248-\u6b65\u9aa46\u5230\u6b65\u9aa47\u7684\u8017\u65f6\uff1a" + (t7 - t6));
            createApplicationRelationParam.setCommonVersion("1.0").setApplicationVersion("1.0").setRelationList(testApplication2ProdCommonRelations);
            this.backendApiHelper.createApplication2CommonRelation(createApplicationRelationParam, env);
            long t8 = System.currentTimeMillis();
            log.info(application + "\u5e94\u7528\u5207\u7248-\u6b65\u9aa47\u5230\u6b65\u9aa48\u7684\u8017\u65f6\uff1a" + (t8 - t7));
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setApiParam(null).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.updateDeployLogAppProcess(application, id, new BigDecimal(-1));
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void restoreVersion1DataStandards(String application, String id, String env, List<JSONObject> publishDbMongoData) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(SwitchStepEnum.RESTORE_VERSION1_DATA.getStepName()).setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        try {
            long stime = System.currentTimeMillis();
            ApplicationCopyParam applicationCopyParam = new ApplicationCopyParam().setApplication(application).setOldVersion("2.0").setNewVersion("1.0").setPublishDbMongoData(publishDbMongoData);
            this.backendApiHelper.copyApplication(applicationCopyParam, env);
            long t7 = System.currentTimeMillis();
            log.info(application + "\u5e94\u7528\u5207\u7248-\u6b65\u9aa46\u5230\u6b65\u9aa47\u7684\u8017\u65f6\uff1a" + (t7 - stime));
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setApiParam(null).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.updateDeployLogAppProcess(application, id, new BigDecimal(-1));
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void excutePostprocessTasks(String application, String id, String env, List<String> tenantIdList, Object tenantVersionMap, Boolean commonApp) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(SwitchStepEnum.EXECUTE_POST_PROCESSING_TASKS.getStepName()).setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        Object executeContent = null;
        try {
            long stime = System.currentTimeMillis();
            if (commonApp.booleanValue()) {
                this.backendApiHelper.deleteCommonAppRelaWithVirtualTenant(application, "2.0", "1.0", env);
                this.backendApiHelper.mergeCommonAppRelaWithVirtualTenant(application, "1.0", "1.0", env);
            }
            this.backendApiHelper.mergeRelationBetweenTenantAndAppInVersionChange(tenantIdList, env, application, "2.0", tenantVersionMap);
            this.backendApiHelper.modifyTenantRelaWithNotMatchAppDataInSwitch(env, application, tenantIdList, commonApp);
            this.backendApiHelper.kmUpdateAppComponentList(env, application, "2.0", AthenaUserLocal.getUser().getTenantId());
            long t9 = System.currentTimeMillis();
            log.info(application + "\u5e94\u7528\u5207\u7248-\u6b65\u9aa48\u5230\u6b65\u9aa49\u7684\u8017\u65f6\uff1a" + (t9 - stime));
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setExecuteContent(executeContent).setApiParam(null).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.updateDeployLogAppProcess(application, id, new BigDecimal(-1));
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void publishAdTemplate(String application, String id, String env, List<TenantUser> tenantUsers, String deployDbMapEnv) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(SwitchStepEnum.PUBLISH_ADTEMPLATE.getStepName()).setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        List executeContent = null;
        try {
            List adTemplateList;
            executeContent = adTemplateList = this.queryDeployParamRecords(application, deployDbMapEnv, "adTemplate", null);
            if (CollectionUtils.isEmpty((Collection)adTemplateList)) {
                deployDetailV2.setResult("success");
                return;
            }
            List adTemplateTenantIdMap = this.queryDeployParamRecords(application, deployDbMapEnv, "deployAdTemplateTenantId", "Active");
            for (JSONObject adTemplate : adTemplateList) {
                JSONArray tenantIds;
                AdTemplatePublishParam adTemplatePublishParam = new AdTemplatePublishParam();
                adTemplatePublishParam.setAdTemplate(adTemplate).setEnv(env).setCurrentUser(AthenaUserLocal.getUser()).setTenantUsers(tenantUsers).setNeedRouterKey(Boolean.valueOf(true));
                this.backendApiHelper.publishScDispatcherTemplate(adTemplatePublishParam);
                adTemplatePublishParam.setNeedRouterKey(Boolean.valueOf(false));
                this.backendApiHelper.publishScDispatcherTemplate(adTemplatePublishParam);
                if (!CollUtil.isNotEmpty((Collection)adTemplateTenantIdMap) || !CollUtil.isNotEmpty((Collection)(tenantIds = ((JSONObject)adTemplateTenantIdMap.get(0)).getJSONArray(String.valueOf(adTemplate.get((Object)"id")))))) continue;
                adTemplatePublishParam.setTenantIds((Collection)tenantIds.toJavaList(String.class));
                this.backendApiHelper.disableTemplateAllVersion(adTemplatePublishParam);
            }
            this.updateDeployParamRecordsStatus(application, deployDbMapEnv, "deployAdTemplateTenantId", "Delete");
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setExecuteContent(executeContent).setApiParam(null).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.updateDeployLogAppProcess(application, id, new BigDecimal(-1));
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchPublishTbb(String application, String id, String env, List<String> tenantIdList, String deployDbMapEnv) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(SwitchStepEnum.PUBLISH_TBB.getStepName() + "\u8c03\u7528\u63a5\u53e3\uff1a/athena-deployer-service/deploy/tbbStatementPublish").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        List executeContent = null;
        try {
            List tbbStatementList = this.queryDeployParamRecords(application, deployDbMapEnv, "tbb", null);
            if (CollectionUtil.isEmpty((Collection)tbbStatementList)) {
                deployDetailV2.setResult("success");
                return;
            }
            Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"date"});
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"type").is((Object)"publish").and("deployParam.env").is((Object)env)).with(sort);
            DeployLog deployLog = (DeployLog)this.mongoTemplate.findOne(query, DeployLog.class, "deployLog");
            String branch = "develop";
            if (deployLog != null) {
                branch = deployLog.getCompileData().getString("branch");
            }
            executeContent = tbbStatementList;
            List tbbCodes = tbbStatementList.stream().map(r -> {
                if (r.containsKey((Object)"resCode") && StringUtils.isNotBlank((CharSequence)r.getString("resCode"))) {
                    return r.getString("resCode");
                }
                return r.getString("code");
            }).collect(Collectors.toList());
            JSONObject param = new JSONObject();
            param.put("token", (Object)AthenaUserLocal.getUser().getToken());
            param.put("tenantIdList", tenantIdList);
            param.put("appCode", (Object)application);
            param.put("env", (Object)env);
            param.put("reportList", tbbCodes);
            param.put("operate", (Object)"switch");
            this.backendApiHelper.tbbStatementPublish(param, branch, AthenaUserLocal.getUser().getToken());
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("warn").setExecuteContent(executeContent).setApiParam(null).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void iamAuthorizationInSwitch(String application, String id, DeployParamV3 deployParam) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(SwitchStepEnum.IAM_AUTHORIZATION.getStepName() + "\u8c03\u7528\u63a5\u53e3\uff1a/athena-deployer-service/tenant/authTenantUser").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        try {
            DeployParamV2 deployParamV2 = (DeployParamV2)JSON.parseObject((String)JSON.toJSONString((Object)deployParam), DeployParamV2.class);
            this.backendApiHelper.authUser(deployParamV2, AthenaUserLocal.getUser().getToken(), deployParam.getEnv());
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setFailMessage("iam\u6388\u6743\u5931\u8d25").setApiParam(null).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.updateDeployLogAppProcess(application, id, new BigDecimal(-1));
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void gmcProductmoduleUpdate(String application, String id, String env, String deployDbMapEnv) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(SwitchStepEnum.GMC_PRODUCT_MODULE_UPDATE.getStepName() + "\u8c03\u7528\u63a5\u53e3\uff1a/athena-deployer-service/tenant/updateGmcMoudle").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        GmcUpdateParam executeContent = null;
        try {
            GmcUpdateParam gmcUpdateParam;
            List list = this.policyParam(application, deployDbMapEnv);
            List applications = this.queryDeployParamRecords(application, deployDbMapEnv, "application", null);
            JSONObject appJson = (JSONObject)applications.get(0);
            Boolean commonApp = appJson.getBoolean("commonApp");
            commonApp = commonApp == null ? false : commonApp;
            executeContent = gmcUpdateParam = new GmcUpdateParam().setTenantId(AthenaUserLocal.getUser().getTenantId()).setAssignmentList(list).setToken(AthenaUserLocal.getUser().getToken()).setApplication(application).setEnv(env).setAppJson(appJson);
            log.info("\u66f4\u65b0GMC\u5546\u54c1:" + JSONObject.toJSONString((Object)gmcUpdateParam));
            if (commonApp.booleanValue()) {
                gmcUpdateParam.setVersion("2.0");
                this.backendApiHelper.updateCommonGmcMoudle(gmcUpdateParam);
            } else {
                this.backendApiHelper.updateGmcMoudle(gmcUpdateParam);
            }
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setFailMessage("gmc\u5546\u54c1\u6a21\u5757\u66f4\u65b0\u5931\u8d25").setExecuteContent(executeContent).setApiParam(null).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.updateDeployLogAppProcess(application, id, new BigDecimal(-1));
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void incrementalUpdateEspAction(String application, String id, String env) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(SwitchStepEnum.INCREMENTAL_UPDATE_ESPACTION.getStepName() + "\u8c03\u7528\u63a5\u53e3\uff1a/athena-deployer-service/action/incrementSwitchEspAction").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        try {
            ResultBean resultBean = this.backendApiHelper.incrementSwitchEspAction(env, id);
            if (resultBean.getCode().equals(0)) {
                deployDetailV2.setResult("success");
            } else {
                deployDetailV2.setResult("warn").setCause(resultBean.getMsg());
            }
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setFailMessage("\u589e\u91cf\u66f4\u65b0espAction\u5931\u8d25").setApiParam(null).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.updateDeployLogAppProcess(application, id, new BigDecimal(-1));
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCacheInSwitch(String env, String id, String application) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setApplication(application).setDeployNo(id).setTime(new Date()).setContent(SwitchStepEnum.CLEAR_CACHE.getStepName()).setResult("start");
        this.insertDeployDetail(deployDetailV2);
        try {
            this.backendApiHelper.kmCacheReset(env, AthenaUserLocal.getUser().getTenantId());
            this.backendApiHelper.atmcCacheReset(env);
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("warn").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    public void insertErrorMsgInDeployDetail(String application, String id, String env, String errorMsg, Exception e) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setApplication(application).setDeployNo(id).setTime(new Date()).setContent(errorMsg).setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
        this.updateDeployLogAppProcess(application, id, new BigDecimal(-1));
        this.insertDeployDetail(deployDetailV2);
    }

    public void insertWarnMsgInDeployDetail(String application, String id, String env, String errorMsg, Exception e) {
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setApplication(application).setDeployNo(id).setTime(new Date()).setContent(errorMsg).setResult("warn").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
        this.insertDeployDetail(deployDetailV2);
    }

    public BigDecimal getApplicationProcess(String application, String id) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("deployNo").is((Object)id));
        DeployLog deployLog = (DeployLog)this.mongoTemplate.findOne(query, DeployLog.class);
        if (null != deployLog) {
            return deployLog.getProcess();
        }
        return null;
    }

    private void updateDeployLogAppProcess(String application, String id, BigDecimal process) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("deployNo").is((Object)id));
        Update update = new Update();
        update.set("process", (Object)process);
        this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, DeployLog.class);
    }

    private List<JSONObject> queryDeployParamRecords(String application, String env, String type, String status) {
        Query query;
        List values;
        if (StringUtils.isEmpty((CharSequence)application) || StringUtils.isEmpty((CharSequence)env) || StringUtils.isEmpty((CharSequence)type)) {
            return Collections.EMPTY_LIST;
        }
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("env").is((Object)env).and("type").is((Object)type);
        if (null != status) {
            criteria.and("status").is((Object)status);
        }
        if (CollectionUtils.isEmpty((Collection)(values = this.mongoTemplate.find(query = new Query((CriteriaDefinition)criteria), JSONObject.class, "deployParamRecord")))) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        for (JSONObject value : values) {
            DeployParamRecord record = (DeployParamRecord)JSON.parseObject((String)JSON.toJSONString((Object)value), DeployParamRecord.class);
            result.add(record.getValue());
        }
        return result;
    }

    private void updateDeployParamRecordsStatus(String application, String env, String type, String status) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("env").is((Object)env).and("type").is((Object)type).and("status").is((Object)"Active"));
        DeployParamRecord deployParamRecord = (DeployParamRecord)this.mongoTemplate.findOne(query, DeployParamRecord.class);
        if (null != deployParamRecord) {
            deployParamRecord.setStatus(status);
            this.mongoTemplate.save((Object)deployParamRecord);
        }
    }

    public JSONObject queryLatestApplicationInfo(String application) {
        List applications = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"application").in((Collection)ListUtil.toList((Object[])application.split(",")))), JSONObject.class, "application");
        if (CollUtil.isNotEmpty((Collection)applications)) {
            JSONObject jsonObject = (JSONObject)applications.get(0);
            HashMap<String, String> map = new HashMap<String, String>();
            for (JSONObject app : applications) {
                map.put(app.getString("application"), app.getString("latestCompileDataCode"));
            }
            jsonObject.put("latestCompileDataCode", map);
            return jsonObject;
        }
        return new JSONObject();
    }

    public void saveDeployLog(String application, String version, String type, JSONObject compiledData, String deployNo, String result, String env, DeployParamV3 deployerParam) {
        DeployLog deployLog = new DeployLog();
        deployLog.setApplication(application).setVersion(version).setUser(AthenaUserLocal.getUser()).setType(type).setCompileData(compiledData).setDeployNo(deployNo).setResult(result).setAllowCustomPublish(compiledData.getBoolean("allowCustomPublish")).setDeployTenant(AthenaUserLocal.getUser().getTenantId()).setDate(new Date()).setDeployParam(deployerParam);
        this.mongoTemplate.insert((Object)deployLog, "deployLog");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddPlanResp addSwitchPlan(DeployParamV3 deployParam) {
        String id = IdUtil.fastSimpleUUID();
        deployParam.setId(id);
        Object errmsg = "";
        try {
            boolean individual = ((ApplicationData)deployParam.getApplicationDataList().get(0)).getApplicationInfoDto().isIndividual();
            List<Object> tenantIdList = new ArrayList<String>();
            List tenantUsers = deployParam.getTenantUsers();
            if (null != tenantUsers && !tenantUsers.isEmpty()) {
                tenantIdList = deployParam.getTenantUsers().stream().map(tenantUser -> tenantUser.getTenantId()).collect(Collectors.toList());
            } else if (!individual) {
                String tenantId = deployParam.getCurrentUser().getTenantId();
                tenantIdList.add(tenantId);
                TenantUser tenantUser2 = new TenantUser();
                tenantUser2.setTenantId(tenantId);
                deployParam.setTenantUsers(Stream.of(tenantUser2).collect(Collectors.toList()));
            }
            JSONObject switchBlackList = this.presetDataService.getJSONObjByKey("switchBlackList");
            String blackList = switchBlackList.getString(deployParam.getEnv());
            if (null != blackList) {
                String[] blackTenantIdList = blackList.split(",");
                tenantIdList.retainAll(Arrays.asList(blackTenantIdList));
                if (CollUtil.isNotEmpty(tenantIdList)) {
                    errmsg = "\u5207\u7248\u5931\u8d25\uff1a\u6240\u9009\u79df\u6237" + String.valueOf(tenantIdList) + "\u7981\u6b62\u8fdb\u884c\u5207\u7248\u64cd\u4f5c";
                    throw new BusinessException((String)errmsg);
                }
            }
            UnableSwitchAppDTO unableSwitchAppDTO = new UnableSwitchAppDTO();
            HashMap compatibleParam = (HashMap)this.presetDataService.getValueByKey("deploy_switch_compatible_param", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (compatibleParam == null) {
                compatibleParam = new HashMap();
            }
            this.checkDeployInfo(deployParam);
            RLock rLock = this.redissonClient.getLock(APP_DEPLOY_OR_SWITCH_LOCK);
            Boolean isLock = rLock.tryLock();
            Integer tryTimes = 1;
            while (!isLock.booleanValue() && tryTimes <= 20) {
                Thread.sleep(500L);
                Integer n = tryTimes;
                tryTimes = tryTimes + 1;
                isLock = rLock.tryLock();
            }
            if (isLock.booleanValue()) {
                try {
                    this.collectUnablePublishApp(deployParam, unableSwitchAppDTO, compatibleParam);
                    for (ApplicationData applicationData : deployParam.getApplicationDataList()) {
                        String application = applicationData.getApplication();
                        ApplicationInfoDto applicationInfoDto = applicationData.getApplicationInfoDto();
                        if (!unableSwitchAppDTO.getSwitchApp().contains(application)) continue;
                        deployParam.setPublishMode("old");
                        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)compatibleParam.get("globalSwitch")))) {
                            Set globalSwitch = (Set)compatibleParam.get("globalSwitch");
                            if (!globalSwitch.contains(application)) {
                                deployParam.setPublishMode("new");
                            }
                        } else if (compatibleParam.containsKey(deployParam.getEnv()) && ((Set)compatibleParam.get(deployParam.getEnv())).contains(application)) {
                            deployParam.setPublishMode("new");
                        }
                        HashMap applicationMapDeployLog = unableSwitchAppDTO.getApplicationMapDeployLog();
                        DeployLog deployLog = (DeployLog)applicationMapDeployLog.get(application);
                        deployParam.setApplicationDataList((List)ListUtil.toList((Object[])new ApplicationData[]{applicationData}));
                        String integrationToken = this.deployServiceApiHelper.getIntegrationToken(this.currentEnv + "-TEST", AthenaUserLocal.getUser().getTenantId());
                        deployParam.getCurrentUser().setToken(integrationToken);
                        DeployLog swtichDeployLog = DeployLog.create((String)application, (JSONObject)deployLog.getCompileData(), (String)id, (String)"waiting", (DeployParamV3)deployParam, (EnvOperateEnum)EnvOperateEnum.SWITCH, (ApplicationConfig)deployLog.getApplicationConfig());
                        if (applicationInfoDto != null) {
                            swtichDeployLog.setIndividual(applicationInfoDto.getIndividual());
                        }
                        this.deployLogDao.insert(swtichDeployLog);
                        String content = "{\"content\":{\"en_US\":\"Enter the cutting queue\",\"zh_CN\":\"\u8fdb\u5165\u5207\u7248\u961f\u5217\",\"zh_TW\":\"\u9032\u5165\u5207\u7248\u968a\u5217\"}}";
                        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setApplication(application).setDeployNo(id).setTime(new Date()).setContent("\u8fdb\u5165\u5207\u7248\u961f\u5217").setLang((Map)JSONObject.parseObject((String)content, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0])).setResult("success");
                        this.insertDeployDetail(deployDetailV2);
                        this.redisCache.rpush(SWITCH_LIST_KEY, (Object)deployParam, 0L);
                    }
                }
                finally {
                    rLock.unlock();
                }
            } else {
                throw new BusinessException("\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            }
            Object warnMsg = "";
            if (CollUtil.isNotEmpty((Collection)unableSwitchAppDTO.getSwitchingApp())) {
                warnMsg = (String)warnMsg + String.valueOf(unableSwitchAppDTO.getSwitchingApp()) + "\u5e94\u7528\u6b63\u5728\u5207\u7248\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01\n";
            }
            if (CollUtil.isNotEmpty((Collection)unableSwitchAppDTO.getPublishingApp())) {
                warnMsg = (String)warnMsg + String.valueOf(unableSwitchAppDTO.getPublishingApp()) + "\u5e94\u7528\u6b63\u5728\u53d1\u7248\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01\n";
            }
            if (CollUtil.isNotEmpty((Collection)unableSwitchAppDTO.getNotNewPublishApp())) {
                warnMsg = (String)warnMsg + String.valueOf(unableSwitchAppDTO.getNotNewPublishApp()) + "\u5e94\u7528\u4e0a\u6b21\u53d1\u7248\u6ca1\u6709\u8d70\u65b0\u6d41\u7a0b\u53d1\u5e03\uff0c\u8bf7\u91cd\u65b0\u7f16\u8bd1\u53d1\u5e03\n";
            }
            AddPlanResp addPlanResp = new AddPlanResp();
            if (StringUtils.isNotEmpty((CharSequence)warnMsg)) {
                String msg = ((String)warnMsg).substring(0, ((String)warnMsg).length() - 1);
                addPlanResp.setWarnMsg(msg);
            }
            addPlanResp.setId(id);
            addPlanResp.setExecuteApp(unableSwitchAppDTO.getSwitchApp());
            return addPlanResp;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("\u5207\u7248\u5931\u8d25,\u62a5\u9519\u4fe1\u606f\uff1a", (Throwable)e);
            throw new BusinessException("\u5207\u7248\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\uff01");
        }
        catch (Exception e) {
            if (StrUtil.isEmpty((CharSequence)errmsg)) {
                log.error("\u5207\u7248\u5931\u8d25,\u62a5\u9519\u4fe1\u606f\uff1a", (Throwable)e);
                throw new BusinessException("\u5207\u7248\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\uff01");
            }
            throw new BusinessException((String)errmsg);
        }
    }

    public AddPlanResp addPrivateSwitchPlan(DeployParamV3 deployParam) {
        List tenantUsers = deployParam.getTenantUsers();
        this.addTenantSid(tenantUsers, deployParam.getEnv());
        List envs = this.envService.queryByEnv(deployParam.getEnv());
        if (CollUtil.isEmpty((Collection)envs)) {
            throw new BusinessException("\u672a\u627e\u5230env\u5bf9\u5e94\uff0c\u8bf7\u68c0\u67e5deployer\u6570\u636e\u5e93env\u8868\u914d\u7f6e\uff01");
        }
        deployParam.setEnvServiceId(((Env)envs.get(0)).getServiceId());
        return this.addSwitchPlan(deployParam);
    }

    private void collectUnablePublishApp(DeployParamV3 deployParam, UnableSwitchAppDTO unableSwitchAppDTO, Map<String, Set<String>> compatibleParam) {
        List applicationDataList = deployParam.getApplicationDataList();
        Set applicationList = applicationDataList.stream().map(ApplicationData::getApplication).collect(Collectors.toSet());
        String env = deployParam.getEnv();
        String envServiceId = deployParam.getEnvServiceId();
        HashMap<String, DeployLog> applicationMapDeployLog = new HashMap<String, DeployLog>();
        for (String app : applicationList) {
            TenantPipeLine tenantPipeLine = this.releasePipeLineService.queryTenantPipelineByApplication(app);
            Node node = TenantPipelineHelper.findNodeByServiceId((TenantPipeLine)tenantPipeLine, (String)envServiceId);
            com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env publishEnv = node.getEnvByOperate("publish");
            DeployLog deployLog = this.deployLogDao.selectRecentOneByDeployParamEnvAndTypeAndApplicationAndResult(app, publishEnv.getEnv());
            applicationMapDeployLog.put(app, deployLog);
        }
        unableSwitchAppDTO.setApplicationMapDeployLog(applicationMapDeployLog);
        List notNewPublishApp = applicationList.stream().filter(a -> {
            if (applicationMapDeployLog.containsKey(a)) {
                DeployLog deployLog = (DeployLog)applicationMapDeployLog.get(a);
                if (compatibleParam.containsKey(env) && ((Set)compatibleParam.get(env)).contains(a)) {
                    DeployParamV3 oldDeployParam = deployLog.getDeployParam();
                    return !"new".equals(oldDeployParam.getPublishMode());
                }
            }
            return false;
        }).collect(Collectors.toList());
        unableSwitchAppDTO.setNotNewPublishApp(notNewPublishApp);
        unableSwitchAppDTO.getUnablePublishApp().addAll(notNewPublishApp);
        for (String a2 : applicationList) {
            if (unableSwitchAppDTO.getUnablePublishApp().contains(a2)) continue;
            unableSwitchAppDTO.getSwitchApp().add(a2);
        }
    }

    private List<DeployLog> getRecentOnePublishDeployLog(Collection<String> applicationList, String deployDbMapEnv) {
        ArrayList<DeployLog> res = new ArrayList<DeployLog>();
        if (org.springframework.util.CollectionUtils.isEmpty(applicationList)) {
            return res;
        }
        for (String application : applicationList) {
            DeployLog deployLog = this.deployLogDao.selectRecentOneByDeployParamEnvAndTypeAndApplicationAndResult(application, deployDbMapEnv);
            if (deployLog == null) continue;
            res.add(deployLog);
        }
        return res;
    }

    private List<Application> getLastEnvPublishInfo(Collection<String> applicationList, String env) {
        if (org.springframework.util.CollectionUtils.isEmpty(applicationList)) {
            return null;
        }
        return this.applicationDao.selectByApplicationListAndLatestEnv(applicationList, env);
    }

    private void updateDeployLog(String application, JSONObject compiledData, String deployNo, String result, JSONObject applicationConfig) {
        Update update = new Update();
        update.set("result", (Object)result);
        update.set("compileData", (Object)compiledData);
        if (applicationConfig != null) {
            update.set("applicationConfig", (Object)applicationConfig);
        }
        update.set("allowCustomPublish", (Object)compiledData.getBoolean("allowCustomPublish"));
        this.mongoTemplate.upsert(new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("deployNo").is((Object)deployNo)), (UpdateDefinition)update, "deployLog");
    }

    public void updateDeployLogResult(String application, String deployNo, String result) {
        Update update = new Update();
        update.set("result", (Object)result);
        this.mongoTemplate.upsert(new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("deployNo").is((Object)deployNo)), (UpdateDefinition)update, "deployLog");
    }

    public void saveDeployLog(List<String> tenantIdList, String application, Boolean allowCustomPublish) {
        DeployLog deployLog = new DeployLog();
        deployLog.setApplication(application).setVersion("1.0").setTenantIdList(tenantIdList).setUser(AthenaUserLocal.getUser()).setType("publish").setAllowCustomPublish(allowCustomPublish).setDeployTenant(AthenaUserLocal.getUser().getTenantId()).setDate(new Date());
        this.mongoTemplate.insert((Object)deployLog, "deployLog");
    }

    public List<DeployDetailV2> queryDeployDetails(String deployNo) {
        List deployDetailV2s = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"deployNo").is((Object)deployNo)), DeployDetailV2.class, "deployDetail");
        return deployDetailV2s;
    }

    public List<DeployDetailV2> queryDeployDetailByApplication(String deployNo, String application) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"deployNo").is((Object)deployNo).and("application").is((Object)application));
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"time"}));
        query.fields().exclude("apiParam").exclude("executeContent").exclude("errorMessage");
        List deployDetailV2s = this.mongoTemplate.find(query, DeployDetailV2.class, "deployDetail");
        return deployDetailV2s;
    }

    private JSONObject queryNeo4jNodeKeyJson() {
        return this.designerApiHelper.queryNeo4jNodeKeyJson(AthenaUserLocal.getUser().getToken());
    }

    private boolean isTbbStatement(String pattern, String category) {
        return CATEGORY_TBB.contains(category) && PATTERN_TBB.contains(pattern);
    }

    private boolean isAbiStatement(String pattern, String category) {
        return CATEGORY_ABI.contains(category) && PATTERN_ABI.contains(pattern);
    }

    private Map<String, String> getResidByAc(JSONObject activityConfig) {
        Map condition_detail;
        JSONObject pages = activityConfig.getJSONObject("pages");
        Map<String, String> extendedFields = new HashMap();
        if (!(ObjectUtils.isEmpty((Object)pages) || ObjectUtils.isEmpty((Object)pages.get((Object)"condition-detail")) || ObjectUtils.isEmpty((Object)(condition_detail = (Map)pages.get((Object)"condition-detail"))))) {
            if (!condition_detail.containsKey("extendedFields")) {
                return new HashMap<String, String>();
            }
            extendedFields = (Map)condition_detail.get("extendedFields");
            if (extendedFields.containsKey("STATEMENT__resid")) {
                String defaultResid = (String)extendedFields.get("STATEMENT__resid");
                if (!extendedFields.containsKey("STATEMENT__resid_en_US")) {
                    extendedFields.put("STATEMENT__resid_en_US", defaultResid);
                }
                if (!extendedFields.containsKey("STATEMENT__resid_zh_CN")) {
                    extendedFields.put("STATEMENT__resid_zh_CN", defaultResid);
                }
                if (!extendedFields.containsKey("STATEMENT__resid_zh_TW")) {
                    extendedFields.put("STATEMENT__resid_zh_TW", defaultResid);
                }
            }
        }
        HashMap<String, String> returnExtendedFields = new HashMap<String, String>();
        if (extendedFields.containsKey("STATEMENT__resid")) {
            returnExtendedFields.put("STATEMENT__resid", (String)extendedFields.get("STATEMENT__resid"));
        }
        if (extendedFields.containsKey("STATEMENT__resid_en_US")) {
            returnExtendedFields.put("STATEMENT__resid_en_US", (String)extendedFields.get("STATEMENT__resid_en_US"));
        }
        if (extendedFields.containsKey("STATEMENT__resid_zh_CN")) {
            returnExtendedFields.put("STATEMENT__resid_zh_CN", (String)extendedFields.get("STATEMENT__resid_zh_CN"));
        }
        if (extendedFields.containsKey("STATEMENT__resid_zh_TW")) {
            returnExtendedFields.put("STATEMENT__resid_zh_TW", (String)extendedFields.get("STATEMENT__resid_zh_TW"));
        }
        return returnExtendedFields;
    }

    private List<JSONObject> getPublishDbMongoData(List<BsonInfo> bsonInfoList) {
        ArrayList re = new ArrayList();
        HashMap dbAndCollection = new HashMap();
        bsonInfoList.forEach(bsonInfo -> {
            if (null != dbAndCollection.get(bsonInfo.getDbName())) {
                ((Set)dbAndCollection.get(bsonInfo.getDbName())).add(bsonInfo.getCollectionName());
            } else {
                HashSet<String> collection = new HashSet<String>();
                collection.add(bsonInfo.getCollectionName());
                dbAndCollection.put(bsonInfo.getDbName(), collection);
            }
        });
        for (Map.Entry entry : dbAndCollection.entrySet()) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put("dbName", entry.getKey());
            temp.put("collectionName", entry.getValue());
            re.add(temp);
        }
        return JSONArray.parseArray((String)JSON.toJSONString(re), JSONObject.class);
    }

    private List<JSONObject> policyParam(String application, String deployDbMapEnv) {
        List tbbList = this.queryDeployParamRecords(application, deployDbMapEnv, "needAuthorizeTbbStatements", null);
        List abiList = this.queryDeployParamRecords(application, deployDbMapEnv, "needAuthorizeAbiStatements", null);
        List dataRntryList = this.queryDeployParamRecords(application, deployDbMapEnv, "needAuthorizeDataEntrys", null);
        List startProjectList = this.queryDeployParamRecords(application, deployDbMapEnv, "needAuthorizestartProjects", null);
        List otherReportList = this.queryDeployParamRecords(application, deployDbMapEnv, "needAuthorizeOtherStatements", null);
        List mobilePageDesignList = this.queryDeployParamRecords(application, deployDbMapEnv, "needAuthorizeMobilePageDesigns", null);
        List triggerList = this.queryDeployParamRecords(application, deployDbMapEnv, "needAuthorizeTriggerData", null);
        List<JSONObject> screen = triggerList.stream().filter(trigger -> StringUtils.isNotEmpty((CharSequence)trigger.getString("authorityPrefix")) && StringUtils.equals((CharSequence)"screen", (CharSequence)trigger.getString("viewType"))).collect(Collectors.toList());
        List<JSONObject> scene = triggerList.stream().filter(trigger -> StringUtils.isNotEmpty((CharSequence)trigger.getString("authorityPrefix")) && StringUtils.equals((CharSequence)"scene", (CharSequence)trigger.getString("viewType"))).collect(Collectors.toList());
        List<JSONObject> metric = triggerList.stream().filter(trigger -> StringUtils.isNotEmpty((CharSequence)trigger.getString("authorityPrefix")) && StringUtils.equals((CharSequence)"metric", (CharSequence)trigger.getString("viewType"))).collect(Collectors.toList());
        List standardParamsList = this.queryDeployParamRecords(application, deployDbMapEnv, "needAuthorizeStandardParamsData", null);
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        tbbList.forEach(tbb -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)tbb.getString("code"));
            jsonObject.put("name", (Object)tbb.getString("name"));
            jsonObject.put("moduleId", (Object)"report");
            jsonObject.put("lang", (Object)tbb.getJSONObject("lang"));
            list.add(jsonObject);
        });
        abiList.forEach(abi -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)abi.getString("code"));
            jsonObject.put("name", (Object)abi.getString("name"));
            jsonObject.put("moduleId", (Object)"report");
            jsonObject.put("lang", (Object)abi.getJSONObject("lang"));
            list.add(jsonObject);
        });
        otherReportList.forEach(otherReport -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)otherReport.getString("code"));
            jsonObject.put("name", (Object)otherReport.getString("name"));
            jsonObject.put("moduleId", (Object)"report");
            jsonObject.put("lang", (Object)otherReport.getJSONObject("lang"));
            list.add(jsonObject);
        });
        dataRntryList.forEach(dataRntry -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)dataRntry.getString("code"));
            jsonObject.put("name", (Object)dataRntry.getString("name"));
            jsonObject.put("moduleId", (Object)"basicDataEntry");
            jsonObject.put("lang", (Object)dataRntry.getJSONObject("lang"));
            list.add(jsonObject);
        });
        mobilePageDesignList.forEach(mobilePageDesign -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)mobilePageDesign.getString("code"));
            jsonObject.put("name", (Object)mobilePageDesign.getString("name"));
            jsonObject.put("moduleId", (Object)"mobilePageDesign");
            jsonObject.put("lang", (Object)mobilePageDesign.getJSONObject("lang"));
            list.add(jsonObject);
        });
        startProjectList.forEach(startProject -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)startProject.getString("code"));
            jsonObject.put("name", (Object)startProject.getString("name"));
            jsonObject.put("moduleId", (Object)"startProject");
            jsonObject.put("lang", (Object)startProject.getJSONObject("lang"));
            list.add(jsonObject);
        });
        screen.forEach(trigger -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)trigger.getString("code"));
            jsonObject.put("name", (Object)trigger.getString("name"));
            jsonObject.put("moduleId", (Object)"bigScreen");
            jsonObject.put("lang", (Object)trigger.getJSONObject("lang"));
            list.add(jsonObject);
        });
        scene.forEach(trigger -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)trigger.getString("code"));
            jsonObject.put("name", (Object)trigger.getString("name"));
            jsonObject.put("moduleId", (Object)"scene");
            jsonObject.put("lang", (Object)trigger.getJSONObject("lang"));
            list.add(jsonObject);
        });
        metric.forEach(trigger -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)trigger.getString("code"));
            jsonObject.put("name", (Object)trigger.getString("name"));
            jsonObject.put("moduleId", (Object)"metric");
            jsonObject.put("lang", (Object)trigger.getJSONObject("lang"));
            list.add(jsonObject);
        });
        standardParamsList.forEach(param -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)param.getString("code"));
            jsonObject.put("name", (Object)param.getString("name"));
            jsonObject.put("moduleId", (Object)"appData");
            jsonObject.put("lang", (Object)param.getJSONObject("lang"));
            list.add(jsonObject);
        });
        return list;
    }

    private void deployAppDataByKm(String deployNo, String application, String env, KmDeploySwitchParam kmDeploySwitchParam) {
        String content = "km\u6570\u636e\u53d1\u7248";
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(deployNo).setTime(new Date()).setContent("km\u6570\u636e\u53d1\u7248").setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        try {
            String eventId = this.backendApiHelper.deployAppDataByKm(env, kmDeploySwitchParam);
            KmDeploySwitchParam kdsp = new KmDeploySwitchParam().setEventId(eventId).setCurTenantId(AthenaUserLocal.getUser().getTenantId());
            this.getProcessInKmTask(application, deployNo, content, env, kdsp);
            deployDetailV2.setResult("success");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            deployDetailV2.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + deployNo, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.redisCache.set(DEPLOY_PROCESS_KEY + application + deployNo, (Object)new BigDecimal(-1), 3600L);
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void switchAppDataByKm(String application, String id, String env, KmDeploySwitchParam kmDeploySwitchParam) {
        String content = "km\u6570\u636e\u5207\u7248";
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(content).setResult("start").setApplication(application);
        this.insertDeployDetail(deployDetailV2);
        try {
            String eventId = this.backendApiHelper.switchAppDataByKm(env, kmDeploySwitchParam);
            KmDeploySwitchParam kdsp = new KmDeploySwitchParam().setEventId(eventId).setCurTenantId(AthenaUserLocal.getUser().getTenantId());
            this.getProcessInKmTask(application, id, content, env, kdsp);
            deployDetailV2.setResult("success");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            deployDetailV2.setResult("fail").setApiParam((Object)kmDeploySwitchParam).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.updateDeployLogAppProcess(application, id, new BigDecimal(-1));
            throw new BusinessException((Throwable)e);
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setApiParam((Object)kmDeploySwitchParam).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setErrorMessage(e.getMessage());
            this.updateDeployLogAppProcess(application, id, new BigDecimal(-1));
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV3.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.insertDeployDetail(deployDetailV2);
        }
    }

    private void getProcessInKmTask(String application, String deployNo, String content, String env, KmDeploySwitchParam kmDeploySwitchParam) throws InterruptedException {
        boolean executing = true;
        while (executing) {
            Thread.sleep(1000L);
            Object data = this.backendApiHelper.processLogsByKm(env, kmDeploySwitchParam);
            if (!ObjectUtils.isNotEmpty((Object)data)) continue;
            List kmProcessLogs = JSONArray.parseArray((String)JSON.toJSONString((Object)data), KmProcessLog.class);
            List contentDetail = kmProcessLogs.stream().map(KmProcessLog::getMsg).collect(Collectors.toList());
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("deployNo").is((Object)deployNo).and("content").is((Object)content).and("result").is((Object)"start"));
            Update update = new Update();
            update.set("contentDetail", contentDetail);
            this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, "deployDetail");
            if (((KmProcessLog)kmProcessLogs.get(kmProcessLogs.size() - 1)).getProcess() != 100) continue;
            executing = false;
        }
    }

    public void adjustAbnormalDataInDeployerLog(String type) {
        DateTime startTime = DateUtil.offsetMinute((Date)DateUtil.date(), (int)-65);
        DateTime endTime = DateUtil.offsetMinute((Date)DateUtil.date(), (int)-5);
        Criteria criteria1 = Criteria.where((String)"result").is((Object)"waiting").and("type").is((Object)type).and("deployParam.publishMode").ne((Object)"new").and("date").gte((Object)startTime).lte((Object)endTime);
        Query query = new Query((CriteriaDefinition)criteria1);
        List deployLogs = this.mongoTemplate.find(query, DeployLog.class, "deployLog");
        if (CollUtil.isEmpty((Collection)deployLogs)) {
            return;
        }
        deployLogs.forEach(deployLog -> {
            String application = deployLog.getApplication();
            String deployNo = deployLog.getDeployNo();
            DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(deployNo).setTime(new Date()).setContent("\u83b7\u53d6\u53d1\u5e03\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u53d1\u5e03").setApplication(application).setResult("fail").setErrorMessage("\u6570\u636e\u5e93\u4e2d\u6709waiting\u72b6\u6001\u6570\u636e\uff0c\u4f46\u662fredis\u961f\u5217\u4e2d\u6ca1\u6709\u62ff\u5230\u5e94\u7528\u7684\u53d1\u5e03\u6570\u636e");
            this.insertDeployDetail(deployDetailV2);
            Query query2 = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("deployNo").is((Object)deployNo));
            Update update = new Update().set("result", (Object)"fail");
            this.mongoTemplate.updateFirst(query2, (UpdateDefinition)update, DeployLog.class);
        });
    }

    public List<DeployLog> getAllDeployExecutingRecord() {
        return this.deployLogDao.selectByTypeAndResultAndOldPublishMode("publish", "executing");
    }

    public List<DeployLog> getDeployExecutingResultByIds(List<String> ids) {
        if (org.springframework.util.CollectionUtils.isEmpty(ids)) {
            return new ArrayList<DeployLog>();
        }
        return this.deployLogDao.selectByIdsAndResult(ids, "executing");
    }

    public void updateFailResultByIds(List<String> ids) {
        this.deployLogDao.updateResultByIds(ids, "fail");
    }

    public void batchInsert(List<DeployDetailV2> detailList) {
        if (org.springframework.util.CollectionUtils.isEmpty(detailList)) {
            return;
        }
        this.deployDetailV2Dao.insertAll(detailList);
    }

    public List<DeployLog> getAllSwitchExecutingRecord() {
        return this.deployLogDao.selectByTypeAndResultAndOldPublishMode("switch", "executing");
    }

    public void deleteRuntimeAppData(String appCode, String env, String version) {
        CleanNeo4jParam cleanNeo4jParam = new CleanNeo4jParam().setDeployVersion(version).setApplication(appCode);
        this.backendApiHelper.cleanNeo4jData(cleanNeo4jParam, env);
        List publishDbMongoData = this.queryDeployParamRecords(appCode, env, "publishDbMongoData", null);
        if (CollUtil.isNotEmpty((Collection)publishDbMongoData)) {
            HashMap mongoCollection = new HashMap();
            publishDbMongoData.forEach(pdd -> {
                if (StringUtils.isNotEmpty((CharSequence)pdd.getString("dbName")) && CollUtil.isNotEmpty((Collection)pdd.getJSONArray("collectionName"))) {
                    List collectionName = JSONArray.parseArray((String)JSON.toJSONString((Object)pdd.get((Object)"collectionName")), String.class);
                    mongoCollection.put(pdd.getString("dbName"), new HashSet(collectionName));
                }
            });
            CleanMongoParam cleanMongoParam = new CleanMongoParam().setDeployVersion(version).setApplication(appCode).setCollectionInfo(mongoCollection);
            this.backendApiHelper.cleanMongoData(cleanMongoParam, env);
            log.info(appCode + "\u5e94\u7528\u5220\u9664\u8fd0\u884c\u6001" + version + "\u6570\u636e\u7ed3\u675f");
        }
    }

    public List<JSONObject> queryDeployData(String application, String token) {
        return this.designerApiHelper.queryCompiledDataList(application, token);
    }

    public void switchAsaApplicationVersion(DeployParamV3 appSwitchParam) {
        String application = ((ApplicationData)appSwitchParam.getApplicationDataList().get(0)).getApplication();
        String deployNo = appSwitchParam.getId();
        this.updateDeployLogResult(application, deployNo, "executing");
        try {
            DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(deployNo).setTime(new Date()).setApplication(application).setContent(DeployStepEnum.PUBLISH_APPLICATION.getStepName() + ":" + application).setResult("start");
            this.insertDeployDetail(deployDetailV2);
            JSONObject neo4jNodeKeyJson = this.queryNeo4jNodeKeyJson();
            List tenantUsers = appSwitchParam.getTenantUsers();
            List<String> tenantIdList = new ArrayList<String>();
            if (null != tenantUsers && !tenantUsers.isEmpty()) {
                tenantIdList = tenantUsers.stream().map(tenantUser -> tenantUser.getTenantId()).collect(Collectors.toList());
            } else {
                tenantIdList.add(appSwitchParam.getCurrentUser().getTenantId());
            }
            JSONArray tenantIdListCopy = JSON.parseArray((String)JSON.toJSONString(tenantIdList));
            this.asaDeployerServiceApiHelper.switchVersion(application, tenantUsers, tenantIdListCopy, appSwitchParam.getEnv(), deployNo, neo4jNodeKeyJson);
            DeployDetailV2 finish = new DeployDetailV2().setDeployNo(deployNo).setTime(new Date()).setContent(deployNo).setResult("finish").setApplication(application);
            this.insertDeployDetail(finish);
            this.setDeploySwitchProcess(deployNo, application, BigDecimal.ONE, BigDecimal.ONE);
            log.info("\u5e94\u7528:{}\u5207\u7248\u7ed3\u675f", (Object)application);
        }
        catch (Exception e) {
            log.error("\u5e94\u7528\uff1a{}\u5728\u5a1c\u5a1c\u52a9\u7406\u5207\u7248\u5f02\u5e38", (Throwable)e);
            this.updateDeployLogResult(application, deployNo, "fail");
            throw new BusinessException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String privateUploadCompiledData(MultipartFile file, String appCode, String verison) {
        try {
            if (!file.getContentType().equals("application/zip") && !file.getContentType().equals("application/x-zip-compressed")) {
                throw new BusinessException("\u53ea\u5141\u8bb8\u4e0a\u4f20zip\u6587\u4ef6");
            }
            File tempFile = File.createTempFile("prefix-", "-suffix");
            try {
                String fileId;
                file.transferTo(tempFile);
                DateTime expireDate = DateUtil.offsetDay((Date)new Date(), (int)1);
                String string = fileId = this.dmcService.uploadFile2Dmc(tempFile, (Date)expireDate);
                return string;
            }
            catch (Exception e) {
                tempFile.delete();
                throw new BusinessException("\u4e0a\u4f20\u6587\u4ef6\u5230dmc\u5931\u8d25", (Throwable)e);
            }
            finally {
                tempFile.deleteOnExit();
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4e0a\u4f20\u7f16\u8bd1\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public List<DeployLog> privateQueryDeployLog(String type) {
        List res = this.deployLogDao.selectRecentByType(type, Integer.valueOf(20));
        return res;
    }
}

