/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.athenadeployer.constant.DeployStepEnum;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployDetailV2Dao;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployLogDao;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployParamRecordDao;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployTaskDao;
import com.digiwin.athena.athenadeployer.dao.mongo.EnvDao;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.ApplicationPO;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.domain.Env;
import com.digiwin.athena.athenadeployer.domain.TenantUser;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import com.digiwin.athena.athenadeployer.domain.compile.CompileParam;
import com.digiwin.athena.athenadeployer.domain.deploy.BsonInfo;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployDetailV2;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamRecord;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.dto.deployer.ChangeDataPublishStatusReqDto;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.http.BackendApiHelper;
import com.digiwin.athena.athenadeployer.http.DesignerApiHelper;
import com.digiwin.athena.athenadeployer.http.deployService.DeployServiceApiHelper;
import com.digiwin.athena.athenadeployer.http.deployService.dto.DataPublishStatusReqDto;
import com.digiwin.athena.athenadeployer.service.DeployServiceV3;
import com.digiwin.athena.athenadeployer.service.DeployServiceV4;
import com.digiwin.athena.athenadeployer.service.DeployerService;
import com.digiwin.athena.athenadeployer.service.PresetDataService;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.DeployTaskFactory;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import com.digiwin.athena.athenadeployer.utils.CurThreadInfoUtils;
import java.io.File;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DeployServiceImplV4
implements DeployServiceV4 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployServiceImplV4.class);
    @Autowired
    private DesignerApiHelper designerApiHelper;
    @Autowired
    private DeployServiceV3 deployServiceV3;
    @Autowired
    private DeployTaskDao deployTaskDao;
    @Autowired
    private DeployLogDao deployLogDao;
    @Autowired
    private DeployTaskFactory deployTaskFactory;
    @Autowired
    private DeployerService deployerService;
    @Value(value="${compile.zipPath}")
    private String compileZipPath;
    @Value(value="${compile.dataPath}")
    private String compileDataPath;
    @Autowired
    private DeployDetailV2Dao deployDetailV2Dao;
    @Autowired
    private PresetDataService presetDataService;
    @Autowired
    private DeployParamRecordDao deployParamRecordDao;
    @Autowired
    private BackendApiHelper backendApiHelper;
    @Value(value="${privateEnv}")
    private Boolean privateEnv;
    private DeployServiceApiHelper deployServiceApiHelper;
    private EnvDao envDao;

    @Autowired
    public void setDeployServiceApiHelper(DeployServiceApiHelper deployServiceApiHelper) {
        this.deployServiceApiHelper = deployServiceApiHelper;
    }

    @Autowired
    public void setEnvDao(EnvDao envDao) {
        this.envDao = envDao;
    }

    public void asyncDeployV4(DeployParamV3 deployParam) {
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        Integer appType = 0;
        if (this.privateEnv.booleanValue()) {
            appType = applicationData.getApplicationInfoDto().getAppType();
        } else {
            ApplicationPO applicationPO = this.designerApiHelper.getApplicationByCode(applicationData.getApplication(), deployParam.getCurrentUser().getToken());
            if (applicationPO != null) {
                appType = applicationPO.getAppType();
            }
        }
        if (appType != null && 7 == appType) {
            this.deployServiceV3.asyncDeployV2(deployParam);
        } else {
            try {
                DeployTask task;
                String id = deployParam.getId();
                DeployLog deployLog = this.deployLogDao.selectByApplicationAndDeployNo(applicationData.getApplication(), id);
                log.info("\u518d\u6b21\u67e5\u8be2\u7684deployLog\u7684\u72b6\u6001:" + deployLog.getResult());
                if ("executing".equals(deployLog.getResult())) {
                    DeployTask deployTask = this.deployTaskDao.selectLastOneByApplicationAndDeployNo(applicationData.getApplication(), id);
                    if (deployTask == null || "fail".equals(deployTask.getStatus())) {
                        String failContent = "{\"content\":{\"en_US\":\"Release failed\",\"zh_CN\":\"\u53d1\u7248\u5931\u8d25\",\"zh_TW\":\"\u767c\u7248\u5931\u6557\"}}";
                        DeployDetailV2 fail = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent("\u53d1\u7248\u5931\u8d25").setResult("fail").setLang((Map)JSONObject.parseObject((String)failContent, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0])).setApplication(applicationData.getApplication());
                        this.deployDetailV2Dao.insert(fail);
                        deployLog.setResult("fail");
                        deployLog.setProcess(new BigDecimal(-1));
                        this.deployLogDao.save(deployLog);
                        return;
                    }
                    if ("success".equals(deployTask.getStatus())) {
                        deployLog.setProcess(new BigDecimal(1));
                        deployLog.setResult("success");
                        this.deployLogDao.save(deployLog);
                        return;
                    }
                    if ("warn".equals(deployTask.getStatus())) {
                        deployLog.setProcess(new BigDecimal(1));
                        deployLog.setResult("warn");
                        this.deployLogDao.save(deployLog);
                        return;
                    }
                    if ("waitingExecuteResult".equals(deployTask.getStatus())) {
                        return;
                    }
                } else if ("waiting".equals(deployLog.getResult())) {
                    AbstractDeployTaskNode preDeployNode = this.deployTaskFactory.getDeployPreTaskNode();
                    preDeployNode.executeDeploy((Object)deployParam);
                } else {
                    return;
                }
                do {
                    if ((task = this.deployTaskDao.selectFirstOneByApplicationAndDeployNoAndStatus(applicationData.getApplication(), deployParam.getId(), Arrays.asList("waiting", "executing", "waitingExecuteResult"))) == null || "waitingExecuteResult".equals(task.getStatus())) {
                        return;
                    }
                    CurThreadInfoUtils.setDeployTaskInfo((DeployTask)task);
                    AbstractDeployTaskNode deployNode = this.deployTaskFactory.getDeployNode(task);
                    deployNode.executeDeploy((Object)task);
                } while (!"waitingExecuteResult".equals(task.getStatus()));
                log.info("\u7b49\u5f85\u6267\u884c\u7ed3\u679c\uff1a" + task.getType());
                return;
            }
            catch (Exception e) {
                log.error(deployParam.getId() + " \u6267\u884c\u53d1\u5e03\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void switch2ProdV4(DeployParamV3 appSwitchParam) {
        ApplicationData applicationData = (ApplicationData)appSwitchParam.getApplicationDataList().get(0);
        String id = appSwitchParam.getId();
        DeployLog deployLog = this.deployLogDao.selectByApplicationAndDeployNo(applicationData.getApplication(), id);
        log.info("\u518d\u6b21\u67e5\u8be2\u7684deployLog\u7684\u72b6\u6001:" + deployLog.getResult());
        try {
            DeployTask task;
            if ("executing".equals(deployLog.getResult())) {
                DeployTask deployTask = this.deployTaskDao.selectLastOneByApplicationAndDeployNo(applicationData.getApplication(), id);
                if (deployTask == null || "fail".equals(deployTask.getStatus())) {
                    String failContent = "{\"content\":{\"en_US\":\"Cutting failure\",\"zh_CN\":\"\u5207\u677f\u5931\u8d25\",\"zh_TW\":\"\u5207\u7248\u5931\u6557\"}}";
                    DeployDetailV2 fail = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent("\u5207\u677f\u5931\u8d25").setResult("fail").setLang((Map)JSONObject.parseObject((String)failContent, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0])).setApplication(applicationData.getApplication());
                    this.deployDetailV2Dao.insert(fail);
                    deployLog.setResult("fail");
                    deployLog.setProcess(new BigDecimal(-1));
                    this.deployLogDao.save(deployLog);
                    return;
                }
                if ("success".equals(deployTask.getStatus())) {
                    deployLog.setResult("success");
                    deployLog.setProcess(new BigDecimal(1));
                    this.deployLogDao.save(deployLog);
                    return;
                }
                if ("warn".equals(deployTask.getStatus())) {
                    deployLog.setResult("warn");
                    deployLog.setProcess(new BigDecimal(1));
                    this.deployLogDao.save(deployLog);
                    return;
                }
                if ("waitingExecuteResult".equals(deployTask.getStatus())) {
                    return;
                }
            } else if ("waiting".equals(deployLog.getResult())) {
                AbstractDeployTaskNode preDeployNode = this.deployTaskFactory.getSwitchPreTaskNode();
                preDeployNode.executeSwitch((Object)appSwitchParam);
            } else {
                return;
            }
            do {
                if ((task = this.deployTaskDao.selectFirstOneByApplicationAndDeployNoAndStatus(applicationData.getApplication(), appSwitchParam.getId(), Arrays.asList("waiting", "executing", "waitingExecuteResult"))) == null || "waitingExecuteResult".equals(task.getStatus())) {
                    return;
                }
                CurThreadInfoUtils.setDeployTaskInfo((DeployTask)task);
                AbstractDeployTaskNode deployNode = this.deployTaskFactory.getSwitchNode(task);
                deployNode.executeSwitch((Object)task);
            } while (!"waitingExecuteResult".equals(task.getStatus()));
            log.info("\u7b49\u5f85\u6267\u884c\u7ed3\u679c\uff1a" + task.getType());
            return;
        }
        catch (Exception e) {
            log.error(appSwitchParam.getId() + " \u6267\u884c\u5207\u677f\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            return;
        }
    }

    public List<DeployParamRecord> queryDeployParamRecords(String application, String env, String type, String status) {
        if (StringUtils.isEmpty((CharSequence)application) || StringUtils.isEmpty((CharSequence)env) || StringUtils.isEmpty((CharSequence)type)) {
            return Collections.EMPTY_LIST;
        }
        if (StringUtils.isEmpty((CharSequence)status)) {
            return this.deployParamRecordDao.selectByApplicationAndEnvAndType(application, env, type);
        }
        return this.deployParamRecordDao.selectByApplicationAndEnvAndTypeAndStatus(application, env, type, status);
    }

    public void updateDeployParamRecordsStatus(String application, String env, String type, String status) {
        List deployParamRecords = this.deployParamRecordDao.selectByApplicationAndEnvAndTypeAndStatus(application, env, type, "Active");
        if (deployParamRecords.isEmpty()) {
            return;
        }
        for (DeployParamRecord deployParamRecord : deployParamRecords) {
            deployParamRecord.setStatus(status);
            this.deployParamRecordDao.save(deployParamRecord);
        }
    }

    public List<DeployLog> getNeedCheckDeployLog() {
        List res = this.deployLogDao.selectByResultsAndDeployMode(Arrays.asList("waiting", "executing"), "new");
        return res;
    }

    public void changeKmDataPublishStatus(ChangeDataPublishStatusReqDto changeDataPublishStatusReqDto) {
        if (EnvOperateEnum.PUBLISH.getOperate().equals(changeDataPublishStatusReqDto.getType())) {
            this.publishTaskChange(changeDataPublishStatusReqDto);
        } else {
            this.switchTaskChange(changeDataPublishStatusReqDto);
        }
    }

    public DeployTask getTask(String application, String type, String deployNo) {
        return this.deployTaskDao.selectByApplicationAndDeployNoAndType(application, deployNo, type);
    }

    public DeployLog getDeployLog(String application, String deployNo) {
        return this.deployLogDao.selectByApplicationAndDeployNo(application, deployNo);
    }

    public List<Env> getDeployServiceDomain(String appCode) {
        Collection serviceIds = this.deployLogDao.selectDeployServiceIdByApplication(appCode);
        if (!serviceIds.isEmpty()) {
            return this.envDao.selectUriByServiceIds(serviceIds);
        }
        return new ArrayList<Env>();
    }

    public void removeByDeployNoAndApplication(String application, String deployNo) {
        this.deployTaskDao.removeByDeployNoAndApplication(application, deployNo);
    }

    public List<DeployTask> getWaitingResultTask() {
        return this.deployTaskDao.selectByStatus("waitingExecuteResult");
    }

    public void checkTaskStatus(String env, List<DeployTask> deployTasks) {
        if (CollectionUtils.isEmpty(deployTasks)) {
            return;
        }
        List dataPublishStatusReqDtos = deployTasks.stream().map(DataPublishStatusReqDto::create).collect(Collectors.toList());
        List res = this.deployServiceApiHelper.checkKmTaskStatus(env, dataPublishStatusReqDtos);
        block0: for (ChangeDataPublishStatusReqDto cd : res) {
            if (!cd.isFinishStatus()) continue;
            for (DeployTask deployTask : deployTasks) {
                if (!deployTask.getDeployNo().equals(cd.getDeployLogId()) || !deployTask.getApplication().equals(cd.getApplication())) continue;
                if (EnvOperateEnum.PUBLISH.getOperate().equals(cd.getType())) {
                    this.executePublishTaskChange(cd, deployTask, DeployTaskTypeEnum.getEnum((String)deployTask.getType()).getContent());
                    continue block0;
                }
                this.executeSwitchTaskChange(cd, deployTask, SwitchTaskTypeEnum.getEnum((String)deployTask.getType()).getContent());
                continue block0;
            }
        }
    }

    public void deployTaskClean(Date end) {
        this.deployTaskDao.removeByLtCreateDate(end);
        log.info("\u5df2\u6e05\u7406{}\u65f6\u95f4\u4e4b\u524d\u7684deployTask\u6570\u636e", (Object)end);
    }

    public void deployDetailClean(Date end) {
        this.deployDetailV2Dao.removeByLtTime(end);
        log.info("\u5df2\u6e05\u7406{}\u65f6\u95f4\u4e4b\u524d\u7684deployDetail\u6570\u636e", (Object)end);
    }

    private void switchTaskChange(ChangeDataPublishStatusReqDto changeDataPublishStatusReqDto) {
        DeployTask deployTask = this.deployTaskDao.selectSwitchDataPublishTaskByApplicationAndDeployNo(changeDataPublishStatusReqDto.getApplication(), changeDataPublishStatusReqDto.getDeployLogId());
        Assert.isTrue((!"executing".equals(deployTask.getStatus()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u4efb\u52a1\u72b6\u6001\u8fd8\u662fexecuting\uff0c\u7b49\u72b6\u6001\u53d8\u5316\u518d\u66f4\u65b0");
        this.executeSwitchTaskChange(changeDataPublishStatusReqDto, deployTask, SwitchTaskTypeEnum.KM_DATA_SWITCH.getContent());
    }

    private void executeSwitchTaskChange(ChangeDataPublishStatusReqDto changeDataPublishStatusReqDto, DeployTask deployTask, String content) {
        DeployLog deployLog = this.deployLogDao.selectByApplicationAndDeployNo(changeDataPublishStatusReqDto.getApplication(), changeDataPublishStatusReqDto.getDeployLogId());
        DeployDetailV2 deployDetailV2 = this.deployDetailV2Dao.selectOneByApplicationAndDeployNoAndContent(changeDataPublishStatusReqDto.getApplication(), changeDataPublishStatusReqDto.getDeployLogId(), content);
        deployTask.setStatus(changeDataPublishStatusReqDto.getStatus());
        deployTask.setEditDate(new Date());
        this.deployTaskDao.save(deployTask);
        Date curDateTime = new Date();
        deployDetailV2.setExecuteTimeMills(Long.valueOf(curDateTime.getTime() - deployDetailV2.getTime().getTime())).setTime(curDateTime);
        deployDetailV2.setResult(changeDataPublishStatusReqDto.getStatus());
        if ("success".equals(changeDataPublishStatusReqDto.getStatus())) {
            BigDecimal progress = new BigDecimal(DeployTaskTypeEnum.KM_DATA_PUBLISH.ordinal() + 1).divide(new BigDecimal(DeployTaskTypeEnum.values().length), 2, 3);
            deployLog.setProcess(progress);
            this.deployLogDao.save(deployLog);
        } else if ("warn".equals(changeDataPublishStatusReqDto.getStatus())) {
            BigDecimal progress = new BigDecimal(DeployTaskTypeEnum.KM_DATA_PUBLISH.ordinal() + 1).divide(new BigDecimal(DeployTaskTypeEnum.values().length), 2, 3);
            deployLog.setProcess(progress);
            this.deployLogDao.save(deployLog);
            this.setDeployDetailErrorLog(changeDataPublishStatusReqDto, deployDetailV2);
        } else {
            RuntimeException runtimeException = new RuntimeException(JSONObject.toJSONString((Object)changeDataPublishStatusReqDto.getLogs()));
            deployLog.setResult("fail");
            deployDetailV2.setCause(JSONObject.toJSONString((Object)changeDataPublishStatusReqDto.getLogs())).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)runtimeException.getStackTrace())));
            this.deployLogDao.save(deployLog);
        }
        this.deployDetailV2Dao.insert(deployDetailV2);
    }

    private void publishTaskChange(ChangeDataPublishStatusReqDto changeDataPublishStatusReqDto) {
        DeployTask deployTask = this.deployTaskDao.selectDeployDataPublishTaskByApplicationAndDeployNo(changeDataPublishStatusReqDto.getApplication(), changeDataPublishStatusReqDto.getDeployLogId());
        Assert.isTrue((!"executing".equals(deployTask.getStatus()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u4efb\u52a1\u72b6\u6001\u8fd8\u662fexecuting\uff0c\u7b49\u72b6\u6001\u53d8\u5316\u518d\u66f4\u65b0");
        this.executePublishTaskChange(changeDataPublishStatusReqDto, deployTask, DeployTaskTypeEnum.KM_DATA_PUBLISH.getContent());
    }

    private void executePublishTaskChange(ChangeDataPublishStatusReqDto changeDataPublishStatusReqDto, DeployTask deployTask, String content) {
        DeployLog deployLog = this.deployLogDao.selectByApplicationAndDeployNo(changeDataPublishStatusReqDto.getApplication(), changeDataPublishStatusReqDto.getDeployLogId());
        DeployDetailV2 deployDetailV2 = this.deployDetailV2Dao.selectOneByApplicationAndDeployNoAndContent(changeDataPublishStatusReqDto.getApplication(), changeDataPublishStatusReqDto.getDeployLogId(), content);
        deployTask.setStatus(changeDataPublishStatusReqDto.getStatus());
        deployTask.setEditDate(new Date());
        this.deployTaskDao.save(deployTask);
        Date curDateTime = new Date();
        deployDetailV2.setExecuteTimeMills(Long.valueOf(curDateTime.getTime() - deployDetailV2.getTime().getTime())).setTime(curDateTime);
        deployDetailV2.setResult(changeDataPublishStatusReqDto.getStatus());
        if ("success".equals(changeDataPublishStatusReqDto.getStatus())) {
            deployLog.setProcess(new BigDecimal(DeployTaskTypeEnum.KM_DATA_PUBLISH.ordinal() + 1).divide(new BigDecimal(DeployTaskTypeEnum.values().length), 2, 3));
            this.deployLogDao.save(deployLog);
        } else if ("warn".equals(changeDataPublishStatusReqDto.getStatus())) {
            deployLog.setProcess(new BigDecimal(DeployTaskTypeEnum.KM_DATA_PUBLISH.ordinal() + 1).divide(new BigDecimal(DeployTaskTypeEnum.values().length), 2, 3));
            this.deployLogDao.save(deployLog);
            this.setDeployDetailErrorLog(changeDataPublishStatusReqDto, deployDetailV2);
        } else {
            deployLog.setResult("fail");
            this.setDeployDetailErrorLog(changeDataPublishStatusReqDto, deployDetailV2);
            this.deployLogDao.save(deployLog);
        }
        this.deployDetailV2Dao.insert(deployDetailV2);
    }

    private void setDeployDetailErrorLog(ChangeDataPublishStatusReqDto changeDataPublishStatusReqDto, DeployDetailV2 deployDetailV2) {
        RuntimeException runtimeException = new RuntimeException(JSONObject.toJSONString((Object)changeDataPublishStatusReqDto.getLogs()));
        deployDetailV2.setCause(JSONObject.toJSONString((Object)changeDataPublishStatusReqDto.getLogs())).setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)runtimeException.getStackTrace())));
    }

    private void setProgress(ChangeDataPublishStatusReqDto changeDataPublishStatusReqDto) {
    }

    public boolean isUcOrNot(JSONObject data) {
        return null != data.getString("tenantId") && !"SYSTEM".equals(data.getString("tenantId"));
    }

    public List<TenantUser> getTenantUsersByTenantId(String application, String tenantId, String token, String env) {
        String[] ucTenantIdList = tenantId.split(";");
        ArrayList<TenantUser> ucTenantUsers = new ArrayList<TenantUser>();
        for (String ti : ucTenantIdList) {
            JSONObject jsonObject = this.backendApiHelper.allTenant(token, ti, env);
            if (jsonObject.getInteger("code") == null || 200 != jsonObject.getInteger("code")) continue;
            List data = jsonObject.getJSONArray("data").toJavaList(JSONObject.class);
            Long sid = data.stream().filter(da -> ti.equals(da.getString("id"))).findFirst().orElse(new JSONObject()).getLong("sid");
            if (null == sid) {
                log.warn(application + "\u5e94\u7528\u53d1\u5e03\u4e2a\u6848\u6570\u636e\u65f6\u79df\u6237\uff1a" + ti + "\u5728\u5f53\u524d\u53d1\u5e03\u73af\u5883\u672a\u627e\u5230\u5bf9\u5e94sid\uff01");
                continue;
            }
            ucTenantUsers.add(new TenantUser().setTenantId(ti).setOption(Integer.valueOf(1)).setTenantSid(sid));
        }
        return ucTenantUsers;
    }

    public List<JSONObject> filterNeedAuthStatements(List<JSONObject> activityConfigList, List<JSONObject> statementList) {
        List<JSONObject> needAuthorizeTbbStatements = statementList.stream().filter(tbbStatement -> {
            JSONObject activityConfigObj = activityConfigList.stream().filter(activityConfig -> activityConfig.getString("code").equals(tbbStatement.getString("code"))).findFirst().orElse(new JSONObject());
            String authorityPrefix = activityConfigObj.getString("authorityPrefix");
            return StrUtil.isNotBlank((CharSequence)authorityPrefix);
        }).collect(Collectors.toList());
        return needAuthorizeTbbStatements;
    }

    public Map<String, String> getResidByAc(JSONObject activityConfig) {
        Map condition_detail;
        JSONObject pages = activityConfig.getJSONObject("pages");
        Map<String, String> extendedFields = new HashMap();
        if (!(ObjectUtils.isEmpty((Object)pages) || ObjectUtils.isEmpty((Object)pages.get((Object)"condition-detail")) || ObjectUtils.isEmpty((Object)(condition_detail = (Map)pages.get((Object)"condition-detail"))))) {
            if (!condition_detail.containsKey("extendedFields")) {
                return new HashMap<String, String>();
            }
            extendedFields = (Map)condition_detail.get("extendedFields");
            if (extendedFields.containsKey("STATEMENT__resid")) {
                String defaultResid = (String)extendedFields.get("STATEMENT__resid");
                if (!extendedFields.containsKey("STATEMENT__resid_en_US")) {
                    extendedFields.put("STATEMENT__resid_en_US", defaultResid);
                }
                if (!extendedFields.containsKey("STATEMENT__resid_zh_CN")) {
                    extendedFields.put("STATEMENT__resid_zh_CN", defaultResid);
                }
                if (!extendedFields.containsKey("STATEMENT__resid_zh_TW")) {
                    extendedFields.put("STATEMENT__resid_zh_TW", defaultResid);
                }
            }
        }
        HashMap<String, String> returnExtendedFields = new HashMap<String, String>();
        if (extendedFields.containsKey("STATEMENT__resid")) {
            returnExtendedFields.put("STATEMENT__resid", (String)extendedFields.get("STATEMENT__resid"));
        }
        if (extendedFields.containsKey("STATEMENT__resid_en_US")) {
            returnExtendedFields.put("STATEMENT__resid_en_US", (String)extendedFields.get("STATEMENT__resid_en_US"));
        }
        if (extendedFields.containsKey("STATEMENT__resid_zh_CN")) {
            returnExtendedFields.put("STATEMENT__resid_zh_CN", (String)extendedFields.get("STATEMENT__resid_zh_CN"));
        }
        if (extendedFields.containsKey("STATEMENT__resid_zh_TW")) {
            returnExtendedFields.put("STATEMENT__resid_zh_TW", (String)extendedFields.get("STATEMENT__resid_zh_TW"));
        }
        return returnExtendedFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParseCompileFileResult parseFileData(String deployNo, String application, String compileDataCode, JSONObject compileData) {
        ParseCompileFileResult parseCompileFileResult;
        String compileVersion = null;
        try {
            ParseCompileFileResult parseCompileFileResult2 = new ParseCompileFileResult().setCompileData(compileData);
            if (null == compileData) {
                compileData = this.designerApiHelper.queryCompiledDataByCode(compileDataCode, AthenaUserLocal.getUser().getToken());
            }
            compileVersion = compileData.getString("version");
            ParseCompileFileResult compiledDataFiles = this.deployerService.getCompiledDataFiles(application, compileData);
            parseCompileFileResult2.setCompileData(compileData);
            ArrayList<Object> cqlList = new ArrayList<Object>();
            ArrayList<BsonInfo> bsonInfoList = new ArrayList<BsonInfo>();
            ArrayList<JSONObject> pageDesignList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> modelDrivenList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> sysAdTemplateList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> ucAdTemplateList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> activityConfigList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> statementList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> dataEntryList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> kitAssignList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> startProjectList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> synonymList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> classificationList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> standardParamsList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> mobilePageDesignList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> triggerList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> dataViewList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> processList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> applicationConfigList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> assetConfigList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> assetConfigCollectList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> boardList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> aimEventList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> aimSceneList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> assetDefinitionList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> assetRelationList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> datasetV2List = new ArrayList<JSONObject>();
            ArrayList<JSONObject> nounKnowledgeList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> habitKnowledgeList = new ArrayList<JSONObject>();
            JSONObject mobileDslCodes = null;
            JSONObject espActionEnumKeyList = new JSONObject();
            JSONObject appJson = new JSONObject();
            HashMap collectionInfo = new HashMap();
            for (File compileDataFile : compiledDataFiles) {
                if (!compileDataFile.isDirectory()) continue;
                String dbName = compileDataFile.getName();
                HashSet<String> collectionNameList = new HashSet<String>();
                if ("cypher".equals(dbName)) {
                    for (File file : files = compileDataFile.listFiles()) {
                        if (".DS_Store".equals(file.getName())) continue;
                        List data = FileUtil.readLines((File)file, (Charset)Charset.forName("utf-8"));
                        for (Object line : data) {
                            line = ((String)line).replaceAll("\\{athena_version}", "1.0");
                            cqlList.add(line);
                        }
                    }
                } else {
                    for (File file : files = compileDataFile.listFiles()) {
                        if (!file.isDirectory()) continue;
                        String collectionName = file.getName();
                        File[] dataFile = file.listFiles();
                        if ("athenadesigner".equals(dbName) || "designer".equals(dbName)) {
                            for (File f : dataFile) {
                                if (".DS_Store".equals(f.getName())) continue;
                                List data = FileUtil.readLines((File)f, (Charset)Charset.forName("utf-8"));
                                for (String line : data) {
                                    JSONObject jsonObject = JSON.parseObject((String)line);
                                    if ("pageDesign".equals(collectionName)) {
                                        pageDesignList.add(jsonObject);
                                        continue;
                                    }
                                    if ("adTemplate".equals(collectionName)) {
                                        String tenantId = jsonObject.getString("tenantId");
                                        if (tenantId != null && !tenantId.equals("SYSTEM")) {
                                            ucAdTemplateList.add(jsonObject);
                                            continue;
                                        }
                                        sysAdTemplateList.add(jsonObject);
                                        continue;
                                    }
                                    if ("neo4jActivity".equals(collectionName) && ("STATEMENT".equals(jsonObject.getString("pattern")) || "MOBI-STATEMENT".equals(jsonObject.getString("pattern")))) {
                                        statementList.add(jsonObject);
                                        continue;
                                    }
                                    if ("neo4jActivity".equals(collectionName) && "DATA_ENTRY".equals(jsonObject.getString("pattern"))) {
                                        dataEntryList.add(jsonObject);
                                        continue;
                                    }
                                    if ("modelDriven".equals(collectionName)) {
                                        modelDrivenList.add(jsonObject);
                                        continue;
                                    }
                                    if ("espActionEnumKey".equals(collectionName)) {
                                        espActionEnumKeyList = jsonObject;
                                        continue;
                                    }
                                    if ("kitAssign".equals(collectionName)) {
                                        kitAssignList.add(jsonObject);
                                        continue;
                                    }
                                    if ("agiledata_synonym".equals(collectionName)) {
                                        synonymList.add(jsonObject);
                                        continue;
                                    }
                                    if ("agiledata_scene_trigger".equals(collectionName)) {
                                        triggerList.add(jsonObject);
                                        continue;
                                    }
                                    if ("agiledata_classification".equals(collectionName)) {
                                        classificationList.add(jsonObject);
                                        continue;
                                    }
                                    if ("applicationConfig".equals(collectionName)) {
                                        applicationConfigList.add(jsonObject);
                                        continue;
                                    }
                                    if ("assetConfig".equals(collectionName)) {
                                        assetConfigList.add(jsonObject);
                                        continue;
                                    }
                                    if ("assetConfigCollect".equals(collectionName)) {
                                        assetConfigCollectList.add(jsonObject);
                                        continue;
                                    }
                                    if ("aim_event".equals(collectionName)) {
                                        aimEventList.add(jsonObject);
                                        continue;
                                    }
                                    if ("aim_scene".equals(collectionName)) {
                                        aimSceneList.add(jsonObject);
                                        continue;
                                    }
                                    if ("mobileDslCodesDto".equals(collectionName)) {
                                        mobileDslCodes = jsonObject;
                                        continue;
                                    }
                                    if ("agiledatainquiry_knowledge_base_noun".equals(collectionName)) {
                                        jsonObject.put("version", (Object)"1.0");
                                        nounKnowledgeList.add(jsonObject);
                                        continue;
                                    }
                                    if ("agiledatainquiry_knowledge_base_habit".equals(collectionName)) {
                                        jsonObject.put("version", (Object)"1.0");
                                        habitKnowledgeList.add(jsonObject);
                                        continue;
                                    }
                                    if ("assetDefinition".equals(collectionName)) {
                                        assetDefinitionList.add(jsonObject);
                                        continue;
                                    }
                                    if (!"assetRelation".equals(collectionName)) continue;
                                    assetRelationList.add(jsonObject);
                                }
                            }
                            continue;
                        }
                        collectionNameList.add(collectionName);
                        ArrayList<Document> documentList = new ArrayList<Document>();
                        for (File f : dataFile) {
                            JSONObject jsonObject;
                            if (".DS_Store".equals(f.getName())) continue;
                            List data = FileUtil.readLines((File)f, (Charset)Charset.forName("utf-8"));
                            if ("activityConfigs".equals(collectionName)) {
                                for (String line : data) {
                                    jsonObject = JSON.parseObject((String)line);
                                    activityConfigList.add(jsonObject);
                                }
                            }
                            if ("mobilePageDesign".equals(collectionName)) {
                                for (String line : data) {
                                    jsonObject = JSON.parseObject((String)line);
                                    mobilePageDesignList.add(jsonObject);
                                }
                            } else if ("project".equals(collectionName)) {
                                for (String line : data) {
                                    jsonObject = JSON.parseObject((String)line);
                                    Boolean manualAble = jsonObject.getBoolean("manualAble");
                                    if (manualAble == null || !manualAble.booleanValue()) continue;
                                    startProjectList.add(jsonObject);
                                }
                            } else if ("dataView".equals(collectionName)) {
                                for (String line : data) {
                                    jsonObject = JSON.parseObject((String)line);
                                    dataViewList.add(jsonObject);
                                }
                            } else if ("process".equals(collectionName)) {
                                for (String line : data) {
                                    jsonObject = JSON.parseObject((String)line);
                                    processList.add(jsonObject);
                                }
                            } else if ("application".equals(collectionName)) {
                                appJson = JSON.parseObject((String)((String)data.get(0)));
                            } else if ("agiledata_standard_params".equals(collectionName)) {
                                for (String line : data) {
                                    jsonObject = JSON.parseObject((String)line);
                                    standardParamsList.add(jsonObject);
                                }
                            } else if ("agiledata_board_info".equals(collectionName)) {
                                for (String line : data) {
                                    jsonObject = JSON.parseObject((String)line);
                                    boardList.add(jsonObject);
                                }
                            } else if ("agiledatainquiry_data_set".equals(collectionName)) {
                                for (String line : data) {
                                    jsonObject = JSON.parseObject((String)line);
                                    datasetV2List.add(jsonObject);
                                }
                            }
                            for (String line : data) {
                                Document document = Document.parse((String)line);
                                document.remove((Object)"_id");
                                document.remove((Object)"isMigrate");
                                document.put("athena_namespace", (Object)application);
                                document.put("compileVersion", (Object)compileVersion);
                                document.put("application", (Object)application);
                                document.put("version", (Object)"1.0");
                                documentList.add(document);
                            }
                        }
                        BsonInfo bsonInfo = new BsonInfo().setDbName(dbName).setCollectionName(collectionName).setDocumentList(documentList);
                        bsonInfoList.add(bsonInfo);
                    }
                }
                if ("athenadesigner".equals(dbName) || "designer".equals(dbName) || "cypher".equals(dbName)) continue;
                collectionInfo.put(dbName, collectionNameList);
            }
            parseCompileFileResult2.setCqlList(cqlList).setBsonInfoList(bsonInfoList).setStatementList(statementList).setDataEntryList(dataEntryList).setActivityConfigList(activityConfigList).setAdTemplateList(sysAdTemplateList).setPageDesignList(pageDesignList).setCollectionInfo(collectionInfo).setModelDrivenList(modelDrivenList).setKitAssignList(kitAssignList).setStartProjectList(startProjectList).setEspActionEnumKey(espActionEnumKeyList).setUcAdTemplateList(ucAdTemplateList).setApplication(appJson).setSynonymList(synonymList).setStandardParamsList(standardParamsList).setBranch(compileData.getString("branch")).setTriggerList(triggerList).setDataViewList(dataViewList).setProcessList(processList).setMobilePageDesignList(mobilePageDesignList).setApplicationConfigList(applicationConfigList).setAssetConfigList(assetConfigList).setAssetConfigCollectList(assetConfigCollectList).setBoardList(boardList).setAimEventList(aimEventList).setAimSceneList(aimSceneList).setMobileDslCodes(mobileDslCodes).setClassificationList(classificationList).setDatasetV2List(datasetV2List).setNounKnowledgeList(nounKnowledgeList).setHabitKnowledgeList(habitKnowledgeList).setAssetDefinitionList(assetDefinitionList).setAssetRelationList(assetRelationList);
            parseCompileFileResult = parseCompileFileResult2;
        }
        catch (Throwable throwable) {
            FileUtil.del((String)(this.compileDataPath + File.separator + application + File.separator));
            FileUtil.del((String)StrUtil.format((CharSequence)(this.compileZipPath + File.separator + application + File.separator + application + "_{}.zip"), (Object[])new Object[]{compileVersion}));
            throw throwable;
        }
        FileUtil.del((String)(this.compileDataPath + File.separator + application + File.separator));
        FileUtil.del((String)StrUtil.format((CharSequence)(this.compileZipPath + File.separator + application + File.separator + application + "_{}.zip"), (Object[])new Object[]{compileVersion}));
        return parseCompileFileResult;
    }

    public void collectPublishDbMongoData(String env, String application, List<BsonInfo> bsonInfoList, String compileDataCode, JSONObject compileAppData) {
        List publishDbMongoData = this.getPublishDbMongoData(bsonInfoList);
        if (compileAppData.getInteger("appType") != null && 4 == compileAppData.getInteger("appType")) {
            List kitDbMongoData = this.getKitPublishDbMongoData();
            if (!CollectionUtils.isEmpty((Collection)publishDbMongoData) && !CollectionUtils.isEmpty((Collection)kitDbMongoData)) {
                ArrayList<JSONObject> same = new ArrayList<JSONObject>();
                for (JSONObject dataMongo : publishDbMongoData) {
                    for (JSONObject kitMongo : kitDbMongoData) {
                        if (!StringUtils.equals((CharSequence)dataMongo.getString("dbName"), (CharSequence)kitMongo.getString("dbName"))) continue;
                        JSONArray collectionNames = dataMongo.getJSONArray("collectionName");
                        JSONArray kitCollectionNames = kitMongo.getJSONArray("collectionName");
                        collectionNames.addAll((Collection)kitCollectionNames);
                        List collect = collectionNames.stream().distinct().collect(Collectors.toList());
                        dataMongo.put("collectionName", collect);
                        same.add(kitMongo);
                    }
                }
                kitDbMongoData.removeAll(same);
                publishDbMongoData.addAll(kitDbMongoData);
            }
        }
        compileAppData.put("commonApp", (Object)Optional.ofNullable(compileAppData.getBoolean("commonApp")).orElse(false));
        this.recordLatestDeployParam(application, env, compileDataCode, "application", Arrays.asList(compileAppData));
        this.recordLatestDeployParam(application, env, compileDataCode, "publishDbMongoData", publishDbMongoData);
    }

    public String getCompileDataCode(DeployParamV3 deployParam) {
        String compileDataCode;
        String id = deployParam.getId();
        ApplicationData applicationData = (ApplicationData)deployParam.getApplicationDataList().get(0);
        String application = applicationData.getApplication();
        String description = applicationData.getDescription();
        String branch = applicationData.getBranch();
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(id).setTime(new Date()).setContent(DeployStepEnum.COMPILE.getStepName() + application).setResult("start").setApplication(application);
        this.deployDetailV2Dao.insert(deployDetailV2);
        try {
            CompileParam compileParam = new CompileParam().setApplication(application).setBranch(branch).setDescription((String)(StrUtil.isBlank((CharSequence)description) ? DateUtil.now() + "\u7f16\u8bd1" : description));
            compileDataCode = this.designerApiHelper.compile(compileParam, AthenaUserLocal.getUser().getToken());
            deployDetailV2.setResult("success");
        }
        catch (Exception e) {
            deployDetailV2.setResult("fail").setErrorStack((Object)JSON.parseArray((String)JSON.toJSONString((Object)e.getStackTrace()))).setCause(e.toString()).setCause(e.toString()).setErrorMessage(e.getMessage());
            throw new BusinessException((Throwable)e);
        }
        finally {
            long mills = DeployServiceImplV4.calculateExecuteMills((Date)deployDetailV2.getTime());
            deployDetailV2.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
            this.deployDetailV2Dao.insert(deployDetailV2);
        }
        return compileDataCode;
    }

    private static long calculateExecuteMills(Date time) {
        Date now = new Date();
        long mills = now.getTime() - time.getTime();
        return mills;
    }

    public void recordLatestDeployParam(String appCode, String env, String compileDataCode, String type, List<JSONObject> values) {
        if (StringUtils.isEmpty((CharSequence)appCode) || StringUtils.isEmpty((CharSequence)env) || StringUtils.isEmpty((CharSequence)compileDataCode) || StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        this.deployParamRecordDao.removeByApplicationAndEnvAndType(appCode, env, type);
        if (CollUtil.isEmpty(values)) {
            return;
        }
        for (JSONObject value : values) {
            DeployParamRecord record = new DeployParamRecord().setApplication(appCode).setEnv(env).setCompileDataCode(compileDataCode).setType(type).setValue(value);
            this.deployParamRecordDao.insert(record);
        }
    }

    public void delRecordLatestDeployParam(String appCode, String env, List<String> typeList) {
        if (StringUtils.isEmpty((CharSequence)appCode) || StringUtils.isEmpty((CharSequence)env) || CollUtil.isEmpty(typeList)) {
            return;
        }
        this.deployParamRecordDao.removeByApplicationAndEnvAndTypeList(appCode, env, typeList);
    }

    private List<JSONObject> getKitPublishDbMongoData() {
        ArrayList<JSONObject> publishDbMongoData = new ArrayList<JSONObject>();
        Object o = this.presetDataService.getObjByKey("kitSwitch");
        JSONArray objects = (JSONArray)JSONObject.parseObject((String)JSON.toJSONString((Object)o), JSONArray.class);
        for (int i = 0; i < objects.size(); ++i) {
            publishDbMongoData.add(objects.getJSONObject(i));
        }
        return publishDbMongoData;
    }

    private List<JSONObject> getPublishDbMongoData(List<BsonInfo> bsonInfoList) {
        ArrayList re = new ArrayList();
        HashMap dbAndCollection = new HashMap();
        bsonInfoList.forEach(bsonInfo -> {
            if (null != dbAndCollection.get(bsonInfo.getDbName())) {
                ((Set)dbAndCollection.get(bsonInfo.getDbName())).add(bsonInfo.getCollectionName());
            } else {
                HashSet<String> collection = new HashSet<String>();
                collection.add(bsonInfo.getCollectionName());
                dbAndCollection.put(bsonInfo.getDbName(), collection);
            }
        });
        for (Map.Entry entry : dbAndCollection.entrySet()) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put("dbName", entry.getKey());
            temp.put("collectionName", entry.getValue());
            re.add(temp);
        }
        return JSONArray.parseArray((String)JSON.toJSONString(re), JSONObject.class);
    }
}

