/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.ApplicationPO;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV2;
import com.digiwin.athena.athenadeployer.domain.deploy.WriteData2DbParam;
import com.digiwin.athena.athenadeployer.http.BackendApiHelper;
import com.digiwin.athena.athenadeployer.http.DesignerApiHelper;
import com.digiwin.athena.athenadeployer.service.DeployServiceV2;
import com.digiwin.athena.athenadeployer.service.PublishAfterService;
import jakarta.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class DeployServiceV2Impl
implements DeployServiceV2 {
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate mongoTemplate;
    @Autowired
    private BackendApiHelper backendApiHelper;
    @Autowired
    private DesignerApiHelper designerApiHelper;
    @Autowired
    private PublishAfterService publishAfterService;

    public void deployTest(DeployParamV2 deployParamV2) {
        List applicationDataList = deployParamV2.getApplicationDataList();
        List tenantUsers = deployParamV2.getTenantUsers();
        List tenantIdList = tenantUsers.stream().map(tenantUser -> tenantUser.getTenantId()).collect(Collectors.toList());
        List tenantSids = tenantUsers.stream().map(tenantUser -> tenantUser.getTenantSid()).collect(Collectors.toList());
        for (ApplicationData applicationData : applicationDataList) {
            String application = applicationData.getApplication();
            JSONObject applicationObj = (JSONObject)this.mongoTemplate.findOne(new Query(), JSONObject.class, "globalConfig");
            Integer status = Optional.ofNullable(applicationObj).orElse(new JSONObject()).getInteger("applicationStatus");
            status = Optional.ofNullable(status).orElse(1);
            switch (status) {
                case 1: 
                case 2: 
                case 4: {
                    ApplicationPO applicationPO = this.designerApiHelper.getApplicationByCode(application, AthenaUserLocal.getUser().getToken());
                    String compileDataCode = applicationData.getCompileDataCode();
                    JSONObject compiledData = this.designerApiHelper.queryCompiledDataByCode(compileDataCode, AthenaUserLocal.getUser().getToken());
                    List pageDesignList = this.designerApiHelper.queryPageDesignList(application, AthenaUserLocal.getUser().getToken());
                    WriteData2DbParam writeData2DbParam = new WriteData2DbParam();
                    writeData2DbParam.setApplication(application).setCompiledData(compiledData).setDeployVersion("1.0").setCurrentUser(AthenaUserLocal.getUser()).setAppToken(applicationPO.getAppToken()).setTenantUsers(tenantUsers).setPageDesignList(pageDesignList);
                    JSONObject res = this.backendApiHelper.writeData2Db(writeData2DbParam, "HuaweiTest-TEST");
                    this.backendApiHelper.parseResponse(res);
                    res = this.backendApiHelper.switchVersion(tenantIdList, application, "1.0", "HuaweiTest-TEST", Boolean.valueOf(false));
                    this.backendApiHelper.parseResponse(res);
                    break;
                }
                case 3: {
                    JSONObject res;
                    JSONObject globalConfig = (JSONObject)this.mongoTemplate.findOne(new Query(), JSONObject.class, "globalConfig");
                    Boolean applicationCopied = globalConfig.getBoolean("applicationCopied");
                    if (applicationCopied == null || applicationCopied.booleanValue()) {
                        res = this.backendApiHelper.switchVersion(tenantIdList, application, "1.0", "HuaweiTest-TEST", Boolean.valueOf(false));
                        this.backendApiHelper.parseResponse(res);
                        break;
                    }
                    throw new BusinessException("Application data has not been copied completely, unable to perform this operation!");
                }
            }
            switch (status) {
                case 2: 
                case 4: {
                    break;
                }
                case 1: {
                    Update update = new Update();
                    update.set("applicationStatus", (Object)2);
                    this.mongoTemplate.upsert(new Query(), (UpdateDefinition)update, "globalConfig");
                    this.backendApiHelper.authUser(deployParamV2, AthenaUserLocal.getUser().getToken(), "HuaweiTest-TEST");
                    break;
                }
                case 3: {
                    Update update = new Update();
                    update.set("applicationStatus", (Object)4);
                    update.set("applicationCopied", (Object)false);
                    this.mongoTemplate.upsert(new Query(), (UpdateDefinition)update, "globalConfig");
                    this.backendApiHelper.authUser(deployParamV2, AthenaUserLocal.getUser().getToken(), "HuaweiTest-TEST");
                }
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("time", (Object)new Date());
            jsonObject.put("application", (Object)application);
            jsonObject.put("compiledDataCode", (Object)applicationData.getCompileDataCode());
            this.mongoTemplate.save((Object)jsonObject, "deployLog");
        }
        this.publishAfterService.cacheReset();
    }

    public void deployProd(DeployParamV2 deployParamV2) {
        List tenantUsers = deployParamV2.getTenantUsers();
        List tenantIdList = tenantUsers.stream().map(tenantUser -> tenantUser.getTenantId()).collect(Collectors.toList());
        JSONObject applicationObj = (JSONObject)this.mongoTemplate.findOne(new Query(), JSONObject.class, "globalConfig");
        Integer status = Optional.ofNullable(applicationObj).orElse(new JSONObject()).getInteger("applicationStatus");
        status = Optional.ofNullable(status).orElse(1);
        switch (status) {
            case 1: 
            case 3: {
                throw new BusinessException("Please conduct a release test first!");
            }
            case 2: 
            case 4: {
                JSONObject res = this.backendApiHelper.updateDataVersion("1.0", "2.0", "HuaweiTest-TEST");
                this.backendApiHelper.parseResponse(res);
                res = this.backendApiHelper.switchVersion(tenantIdList, null, "2.0", "HuaweiTest-TEST", Boolean.valueOf(false));
                this.backendApiHelper.parseResponse(res);
            }
        }
        switch (status) {
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                Update update = new Update();
                update.set("applicationStatus", (Object)3);
                this.mongoTemplate.upsert(new Query(), (UpdateDefinition)update, "globalConfig");
                break;
            }
            case 4: {
                this.backendApiHelper.addApplicationVersion("2.0", "1.0", "HuaweiTest-TEST");
                Update update = new Update();
                update.set("applicationStatus", (Object)3);
                this.mongoTemplate.upsert(new Query(), (UpdateDefinition)update, "globalConfig");
            }
        }
    }
}

