/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import com.digiwin.athena.athenadeployer.domain.Application;
import com.digiwin.athena.athenadeployer.enums.DeployerProgressEnum;
import com.digiwin.athena.athenadeployer.service.DeployerProgressService;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import jakarta.annotation.Resource;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class DeployerProgressServiceImpl
implements DeployerProgressService {
    @Generated
    private static final Logger log = LogManager.getLogger(DeployerProgressServiceImpl.class);
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate deployerMongoTemplate;

    public void addPublishEvent(Application application) {
        Bson bson = Filters.and((Bson[])new Bson[]{Filters.ne((String)"status", (Object)DeployerProgressEnum.SWITCHCOMPLETE.getCode()), Filters.ne((String)"status", (Object)DeployerProgressEnum.SWITCHEND.getCode())});
        FindIterable documents = this.deployerMongoTemplate.getCollection("publishProgressResult").find(bson);
        documents.forEach(document -> {
            throw new RuntimeException(String.valueOf(document.get((Object)"code")) + " publishing has not ended yet, simultaneous publishing is prohibited");
        });
        Document document2 = new Document();
        document2.put("code", (Object)(String.valueOf(application.getTenantId()) + "_" + String.valueOf(application.getApplicationCode()) + "(" + application.getVersion() + ")"));
        document2.put("status", (Object)DeployerProgressEnum.CREATE.getCode());
        document2.put("msg", (Object)DeployerProgressEnum.CREATE.getName());
        this.deployerMongoTemplate.getCollection("publishProgressResult").insertOne((Object)document2);
    }

    public void updatePublishEvent(Application application, DeployerProgressEnum deployerProgressEnum) {
        Bson filter = Filters.eq((String)"code", (Object)(String.valueOf(application.getTenantId()) + "_" + String.valueOf(application.getApplicationCode()) + "(" + application.getVersion() + ")"));
        Document update = new Document("$set", (Object)new Document().append("version", (Object)application.getVersion()).append("status", (Object)deployerProgressEnum.getCode()).append("msg", (Object)deployerProgressEnum.getName()));
        this.deployerMongoTemplate.getCollection("publishProgressResult").updateOne(filter, (Bson)update);
    }

    public void updatePublishEvent(Application application, Exception exception) {
        Bson filter = Filters.eq((String)"code", (Object)(String.valueOf(application.getTenantId()) + "_" + String.valueOf(application.getApplicationCode()) + "(" + application.getVersion() + ")"));
        Document update = new Document("$set", (Object)new Document().append("errorMsg", (Object)exception.getMessage()));
        this.deployerMongoTemplate.getCollection("publishProgressResult").updateOne(filter, (Bson)update);
    }

    public DeployerProgressEnum queryPublishEvent(Application application) {
        Bson bson = Filters.eq((String)"code", (Object)(String.valueOf(application.getTenantId()) + "_" + String.valueOf(application.getApplicationCode()) + "(" + application.getVersion() + ")"));
        FindIterable documents = this.deployerMongoTemplate.getCollection("publishProgressResult").find(bson);
        Document first = (Document)documents.first();
        return DeployerProgressEnum.getValue((String)Objects.requireNonNull(first).getString((Object)"code"));
    }

    public int gePublishVersionCount() {
        FindIterable documents = this.deployerMongoTemplate.getCollection("publishProgressResult").find();
        AtomicInteger count = new AtomicInteger();
        documents.forEach(document -> count.getAndIncrement());
        return count.get();
    }

    public String getProdVersion() {
        Bson bson = Filters.eq((String)"prod", (Object)true);
        FindIterable documents = this.deployerMongoTemplate.getCollection("publishProgressResult").find(bson);
        AtomicInteger prodCount = new AtomicInteger();
        documents.forEach(document -> prodCount.getAndIncrement());
        if (prodCount.get() > 1) {
            throw new RuntimeException("Multiple prod versions found, please check the data");
        }
        Document first = (Document)documents.first();
        return Objects.requireNonNull(first).getString((Object)"version");
    }

    public void updateProdVersion(Application application) {
        Bson oldProdFilter = Filters.eq((String)"prod", (Object)true);
        Document oldProdUpdate = new Document("$set", (Object)new Document().append("prod", (Object)false));
        this.deployerMongoTemplate.getCollection("publishProgressResult").updateOne(oldProdFilter, (Bson)oldProdUpdate);
        Bson filter = Filters.eq((String)"code", (Object)(String.valueOf(application.getTenantId()) + "_" + String.valueOf(application.getApplicationCode()) + "(" + application.getVersion() + ")"));
        Document update = new Document("$set", (Object)new Document().append("status", (Object)DeployerProgressEnum.SWITCHCOMPLETE.getCode()).append("msg", (Object)DeployerProgressEnum.SWITCHCOMPLETE.getName()).append("prod", (Object)true));
        this.deployerMongoTemplate.getCollection("publishProgressResult").updateOne(filter, (Bson)update);
    }

    public void addTenantBPMInitErrorResult(String templateTenant, String tenant, String applicationCode, Application application, Exception exception) {
        Document document = new Document();
        document.put("code", (Object)(String.valueOf(application.getTenantId()) + "_" + String.valueOf(application.getApplicationCode()) + "(" + application.getVersion() + ")"));
        document.put("fromTenantId", (Object)templateTenant);
        document.put("toTenantId", (Object)tenant);
        document.put("appCode", (Object)applicationCode);
        document.put("errorMsg", (Object)exception.getMessage());
        this.deployerMongoTemplate.getCollection("BPMInitResult").insertOne((Object)document);
    }

    public void deleteApplicationVersion(String deployVersion) {
        Bson bson = Filters.eq((String)"version", (Object)deployVersion);
        this.deployerMongoTemplate.getCollection("publishProgressResult").deleteMany(bson);
    }
}

