/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.config.ModuleConfig;
import com.digiwin.athena.athenadeployer.config.neo4j.Neo4jManager;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.CollectionPKPO;
import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.domain.MongoData;
import com.digiwin.athena.athenadeployer.domain.TenantUser;
import com.digiwin.athena.athenadeployer.domain.application.ApplicationCustomPublishDto;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployProcess;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployVersion;
import com.digiwin.athena.athenadeployer.dto.deployer.Pagination;
import com.digiwin.athena.athenadeployer.http.DesignerApiHelper;
import com.digiwin.athena.athenadeployer.service.AppEntityService;
import com.digiwin.athena.athenadeployer.service.AthenaDataService;
import com.digiwin.athena.athenadeployer.service.DataVersionService;
import com.digiwin.athena.athenadeployer.service.DeployerService;
import com.digiwin.athena.athenadeployer.service.DesignerDataService;
import com.digiwin.athena.athenadeployer.service.DmcService;
import com.digiwin.athena.athenadeployer.service.EnvService;
import com.digiwin.athena.athenadeployer.service.TenantService;
import com.digiwin.athena.athenadeployer.utils.DeployUtil;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import com.digiwin.athena.athenadeployer.utils.RedisCache;
import com.digiwin.athena.athenadeployer.utils.SafeFileUtils;
import com.mongodb.MongoWriteException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import jakarta.annotation.Resource;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class DeployerServiceImpl
implements DeployerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployerServiceImpl.class);
    @Autowired(required=false)
    @Qualifier(value="designerMongoTemplate")
    private MongoTemplate designerMongoTemplate;
    @Autowired(required=false)
    @Qualifier(value="tenantDesignerMongoTemplate")
    private MongoTemplate tenantDesignerMongoTemplate;
    @Value(value="${compile.zipPath}")
    private String compileZipPath;
    @Value(value="${compile.dataPath}")
    private String compileDataPath;
    @Value(value="${design.zipPath}")
    private String designZipPath;
    @Value(value="${design.dataPath}")
    private String designDataPath;
    @Value(value="${designer.domain}")
    private String designerDomain;
    @Autowired
    private AthenaDataService athenaDataService;
    @Autowired
    private AppEntityService appEntityService;
    @Autowired
    private DataVersionService dataVersionService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate deployerMongoTemplate;
    @Autowired
    private DesignerApiHelper designerApiHelper;
    @Autowired
    private DesignerDataService designerDataService;
    @Autowired
    private ModuleConfig moduleConfig;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private DmcService dmcService;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private EnvService envService;
    private static final String RELEASE_TASK_URL = "/api/ai/v1/bot/designer/template/task/release/";
    private static final String QUERY_PARAM_CONFIG_URL = "/restful/standard/scdispatcher/paramConfig/query";
    private static final String ADD_PARAM_CONFIG_URL = "/restful/standard/scdispatcher/paramConfig/add";
    private static final String UPDATE_PARAM_CONFIG_URL = "/restful/standard/scdispatcher/paramConfig/update";
    private static final String DELETE_PARAM_CONFIG_URL = "/restful/standard/scdispatcher/paramConfig/delete";
    public static final String PARTITION = "DEPLOY_PROCESS";

    public void deploy(String application, String compileVersion, String currentVersion, String deployVersion, Boolean copyOtherApplication, AthenaUser currentUser) {
        deployVersion = "1.0";
        if (copyOtherApplication != null && copyOtherApplication.booleanValue()) {
            try {
                log.info("\u5f00\u59cb\u590d\u5236\u8001\u7248\u672c\u6570\u636e......");
                this.athenaDataService.addApplicationVersion(deployVersion, currentVersion);
                log.info("\u590d\u5236\u5b8c\u6210");
            }
            catch (Exception e) {
                log.error("\u65e7\u7248\u6570\u636e\u590d\u5236\u5931\u8d25,", (Throwable)e);
                this.revert(deployVersion);
                throw new BusinessException("Legacy data replication failed!");
            }
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("version").is((Object)compileVersion));
        JSONObject compiledData = (JSONObject)this.designerMongoTemplate.findOne(query, JSONObject.class, "compiledData");
        File[] compiledDataFiles = this.getCompiledDataFiles(application, compiledData);
        try {
            this.deploy(application, compiledDataFiles, compileVersion, deployVersion);
        }
        catch (Exception e) {
            log.error("\u90e8\u7f72\u5931\u8d25\uff1a", (Throwable)e);
            for (File compileDataFile : compiledDataFiles) {
                this.delFolder(compileDataFile.getAbsolutePath());
            }
            throw new BusinessException("Deployment failed, please contact the developer");
        }
        this.athenaDataService.modifyDifferenceData(application, compileVersion);
        DeployProcess deployProcess = (DeployProcess)this.redisCache.get(PARTITION, application, DeployProcess.class);
        if (deployProcess != null) {
            deployProcess.setDeployedNum(deployProcess.getTotal());
        }
    }

    public DeployVersion queryLatestVersion() {
        FindIterable documents = this.deployerMongoTemplate.getCollection("publishProgressResult").find().sort(Sorts.descending((String[])new String[]{"majorVersionNum"})).limit(1);
        Object obj = this.getDocument(documents, DeployVersion.class);
        if (obj != null) {
            return (DeployVersion)obj;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("status", (Object)7);
        jsonObject.put("msg", (Object)"Switching completed");
        jsonObject.put("version", (Object)"1.0");
        jsonObject.put("majorVersionNum", (Object)1);
        jsonObject.put("minorVersion", (Object)"0");
        jsonObject.put("prod", (Object)false);
        jsonObject.put("time", (Object)new Date());
        jsonObject.put("code", (Object)IdUtil.fastSimpleUUID());
        Document document = Document.parse((String)JSON.toJSONString((Object)jsonObject));
        this.deployerMongoTemplate.getCollection("publishProgressResult").insertOne((Object)document);
        return (DeployVersion)jsonObject.toJavaObject(DeployVersion.class);
    }

    public void versionIncrease(DeployVersion currentDeployVersion, Map<String, String> applicationCompileVersionMap) {
        Integer majorVersionNum;
        if (currentDeployVersion == null) {
            currentDeployVersion = this.queryLatestVersion();
        }
        Integer n = majorVersionNum = currentDeployVersion.getMajorVersionNum();
        majorVersionNum = majorVersionNum + 1;
        String version = majorVersionNum + "." + currentDeployVersion.getMinorVersion();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("status", (Object)7);
        jsonObject.put("msg", (Object)"Switching completed");
        jsonObject.put("version", (Object)version);
        jsonObject.put("majorVersionNum", (Object)majorVersionNum);
        jsonObject.put("minorVersion", (Object)"0");
        jsonObject.put("prod", (Object)false);
        jsonObject.put("time", (Object)new Date());
        jsonObject.put("code", (Object)IdUtil.fastSimpleUUID());
        jsonObject.put("applicationCompileVersionMap", applicationCompileVersionMap);
        Document document = Document.parse((String)JSON.toJSONString((Object)jsonObject));
        this.deployerMongoTemplate.getCollection("publishProgressResult").insertOne((Object)document);
    }

    public List<String> queryVersionList() {
        FindIterable documents = this.deployerMongoTemplate.getCollection("publishProgressResult").find().sort(Sorts.ascending((String[])new String[]{"majorVersionNum"}));
        HashSet<String> versionList = new HashSet<String>();
        for (Document document : documents) {
            DeployVersion deployVersion = (DeployVersion)JSON.parseObject((String)document.toJson(), DeployVersion.class);
            versionList.add(deployVersion.getVersion());
        }
        return new ArrayList<String>(versionList);
    }

    public List<DeployLog> queryDeployLogs() {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"type").is((Object)"publish").and("deployTenant").is((Object)AthenaUserLocal.getUser().getTenantId()));
        return this.deployerMongoTemplate.find(query, DeployLog.class, "deployLog");
    }

    public Map<String, Boolean> queryAllowCustomPublishApplication(ApplicationCustomPublishDto applicationCustomPublishDto) {
        List appCodeList = applicationCustomPublishDto.getAppCodeList();
        String env = applicationCustomPublishDto.getEnv();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").in((Collection)appCodeList).and("allowCustomPublish").is((Object)true).and("deployParam.env").is((Object)env).orOperator(new Criteria[]{Criteria.where((String)"result").is((Object)"success"), Criteria.where((String)"result").is(null)}));
        List publishedApplications = this.deployerMongoTemplate.findDistinct(query, "application", DeployLog.class, String.class);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (String application : appCodeList) {
            result.put(application, publishedApplications.contains(application));
        }
        return result;
    }

    public List<DeployLog> queryPublishApplication(ApplicationCustomPublishDto applicationCustomPublishDto) {
        List appCodeList = applicationCustomPublishDto.getAppCodeList();
        String env = applicationCustomPublishDto.getEnv();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").in((Collection)appCodeList).and("allowCustomPublish").is((Object)true).and("deployParam.env").is((Object)env).and("type").is((Object)"publish"));
        List<DeployLog> publishedApplications = this.deployerMongoTemplate.find(query, DeployLog.class);
        publishedApplications = publishedApplications.stream().collect(Collectors.toMap(DeployLog::getApplication, Function.identity(), (existing, replacement) -> existing.getDate().before(replacement.getDate()) ? existing : replacement)).values().stream().sorted(Comparator.comparing(DeployLog::getApplication)).collect(Collectors.toList());
        return publishedApplications;
    }

    public Map<String, Boolean> queryCustomPublishApplication(ApplicationCustomPublishDto applicationCustomPublishDto) {
        List appCodeList = applicationCustomPublishDto.getAppCodeList();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").in((Collection)appCodeList).and("allowCustomPublish").is((Object)true).and("result").is((Object)"success"));
        List publishedApplications = this.deployerMongoTemplate.findDistinct(query, "application", DeployLog.class, String.class);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (String application : appCodeList) {
            result.put(application, publishedApplications.contains(application));
        }
        return result;
    }

    public List<DeployLog> querySwitchLogs() {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"type").is((Object)"switch").and("deployTenant").is((Object)AthenaUserLocal.getUser().getTenantId()));
        return this.deployerMongoTemplate.find(query, DeployLog.class, "deployLog");
    }

    public JSONObject queryGlobalVersion(String globalVersion) {
        FindIterable globalVersionList = this.deployerMongoTemplate.getCollection("publishProgressResult").find(Filters.eq((String)"version", (Object)globalVersion)).limit(1);
        return this.getDocument(globalVersionList);
    }

    public void addDeployLog(DeployLog deployLog) {
        deployLog.setDate(new Date());
        this.deployerMongoTemplate.insert((Object)deployLog, "deployLog");
    }

    public void addSwitchLog(DeployLog deployLog) {
        deployLog.setDate(new Date());
        this.deployerMongoTemplate.insert((Object)deployLog, "switchLog");
    }

    public void switchVersion(List<String> tenantIdList, String deployVersion) {
        this.appEntityService.updateVersion(deployVersion);
        this.dataVersionService.updateTenantVersion(deployVersion, tenantIdList);
        if (CollUtil.isEmpty(tenantIdList)) {
            List maps = this.tenantService.queryAllTenantId();
            tenantIdList = new ArrayList<String>(maps.stream().map(item -> String.valueOf(item.get("tenantId"))).collect(Collectors.toSet()));
        }
        DeployLog deployLog = new DeployLog();
        deployLog.setVersion(deployVersion).setTenantIdList(tenantIdList).setUser(AthenaUserLocal.getUser());
        this.addSwitchLog(deployLog);
    }

    public void revert(String version) {
        if ("1.0".equals(version)) {
            throw new BusinessException("Illegal version number!");
        }
        String cql1 = StrUtil.format((CharSequence)"MATCH (node)  where node.version ='{}' and not any(label in labels(node) WHERE label in ['AppEntity','TenantEntity']) detach delete node", (Object[])new Object[]{version});
        String cql2 = StrUtil.format((CharSequence)"MATCH (node)  where node.version ='{}' and node.nameSpace in ['espCommon','common'] and not any(label in labels(node) WHERE label in ['AppEntity','TenantEntity']) detach delete node", (Object[])new Object[]{version});
        Neo4jManager.getNeo4jManager().ExecuteNoQuery(cql1);
        Neo4jManager.getNeo4jManager().ExecuteNoQuery(cql2);
        List mongoCollection = this.athenaDataService.getMongoCollection();
        Bson bson = Filters.eq((String)"version", (Object)version);
        for (HashMap map : mongoCollection) {
            String dbName = (String)map.get("dbName");
            List collections = (List)map.get("collectionName");
            collections.forEach(collection -> this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(dbName).getCollection(collection).deleteMany(bson));
        }
        this.deployerMongoTemplate.getCollection("publishProgressResult").deleteMany(bson);
    }

    public void tenantDeploy(String application, List<String> tenantIdList) {
        for (String tenantId : tenantIdList) {
            this.designerDataService.deleteDesignerData();
            JSONObject jsonObject = (JSONObject)FileUtils.readObjectFromFilePath((String)"enterprise_allow_design.json", JSONObject.class);
            List collectionNames = jsonObject.getJSONArray("mongo").toJavaList(String.class);
            this.downloadMongoData2Local(application, tenantId, collectionNames);
            List labels = jsonObject.getJSONArray("neo4j").toJavaList(String.class);
            this.downloadNeo4jData2Local(application, tenantId, labels);
            this.athenaDataService.deleteTempAthenaData();
            this.designerDataService.compileDesignerData(application);
            DeployVersion deployVersion = this.queryLatestVersion();
            List mongoDataFromLocal = DeployUtil.getMongoDataFromLocal((String)application, (String)deployVersion.getVersion());
            List neo4jDataFromLocal = DeployUtil.getNeo4jDataFromLocal((String)application, (String)tenantId, (String)deployVersion.getVersion());
            try {
                this.deleteTenantMongoData(application, tenantId, mongoDataFromLocal);
                for (MongoData mongoData2 : mongoDataFromLocal) {
                    String dbName = mongoData2.getDbName();
                    String collectionName = mongoData2.getCollectionName();
                    if ("preset".equals(dbName) && "rules".equals(collectionName)) {
                        collectionName = "tenantRules";
                    }
                    JSONObject data = mongoData2.getData();
                    this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(dbName).getCollection(collectionName).insertOne((Object)Document.parse((String)JSON.toJSONString((Object)data)));
                }
                Neo4jManager.getNeo4jManager().ExecuteTransactionNoQuery(neo4jDataFromLocal);
            }
            catch (Exception e) {
                log.info("\u53d1\u7248\u5931\u8d25,", (Throwable)e);
                Bson bson1 = Filters.eq((String)"application", (Object)application);
                Bson bson2 = Filters.eq((String)"version", (Object)deployVersion.getVersion());
                Bson bson3 = Filters.eq((String)"tenantId", (Object)tenantId);
                for (MongoData mongoData3 : mongoDataFromLocal) {
                    String dbName = mongoData3.getDbName();
                    String collectionName = mongoData3.getCollectionName();
                    this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(dbName).getCollection(collectionName).deleteMany(Filters.and((Bson[])new Bson[]{bson1, bson2, bson3}));
                }
            }
            List taskDataList = mongoDataFromLocal.stream().filter(mongoData -> "datamap".equals(mongoData.getDbName()) && "task".equals(mongoData.getCollectionName())).collect(Collectors.toList());
            for (MongoData mongoData4 : taskDataList) {
                try {
                    this.taskRelease(deployVersion.getVersion(), mongoData4.getData().getString("code"));
                }
                catch (Exception e) {
                    log.error("\u754c\u9762\u8bbe\u8ba1\u53d1\u5e03\u5931\u8d25\uff1a", (Throwable)e);
                }
            }
            try {
                this.systemParamSync();
            }
            catch (Exception e) {
                log.error("\u670d\u52a1\u7f16\u6392\u53d1\u5e03\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }

    private void deleteTenantMongoData(String application, String tenantId, List<MongoData> mongoDataFromLocal) {
        HashSet<CallSite> collectionSet = new HashSet<CallSite>();
        for (MongoData mongoData : mongoDataFromLocal) {
            String dbName = mongoData.getDbName();
            String collectionName = mongoData.getCollectionName();
            if ("preset".equals(dbName) && "rules".equals(collectionName)) {
                collectionName = "tenantRules";
            }
            collectionSet.add((CallSite)((Object)(dbName + "." + collectionName)));
        }
        for (String string : collectionSet) {
            String[] split = string.split("\\.");
            String dbName = split[0];
            String collectionName = split[1];
            Bson bson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"tenantId", (Object)tenantId), Filters.eq((String)"application", (Object)application)});
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(dbName).getCollection(collectionName).deleteMany(bson);
        }
    }

    private void downloadNeo4jData2Local(String application, String tenantId, List<String> labels) {
        String path = Constant.DESIGNER_DATA_PATH + "{}/{}/{}/";
        for (String label : labels) {
            String pathFormat = StrUtil.format((CharSequence)path, (Object[])new Object[]{application, "neo4j", label});
            String cql = null;
            switch (label) {
                case "AdTag": {
                    cql = StrUtil.format((CharSequence)"match (n:{}) where n.tenantId = '{}' return properties(n) as properties", (Object[])new Object[]{label, tenantId});
                    break;
                }
                case "Activity": {
                    cql = StrUtil.format((CharSequence)"match (n:{}) where n.nameSpace = '{}' and n.tenantId = '{}' return properties(n) as properties", (Object[])new Object[]{label, application, tenantId});
                }
            }
            if (!StrUtil.isNotBlank(cql)) continue;
            List queryResults = Neo4jManager.getNeo4jManager().ExecuteQuery(cql);
            int i = 1;
            for (Map properties : queryResults) {
                FileUtil.writeString((String)JSON.toJSONString((Object)properties), (String)(pathFormat + i + ".json"), (String)"utf-8");
                ++i;
            }
        }
    }

    private void downloadMongoData2Local(String application, String tenantId, List<String> collectionNames) {
        List collectionPKPOList = this.designerApiHelper.queryAllCollectionPk(AthenaUserLocal.getUser().getToken());
        HashMap<String, String> collection_database_map = new HashMap<String, String>();
        for (CollectionPKPO collectionPKPO : collectionPKPOList) {
            collection_database_map.put(collectionPKPO.getCollection(), collectionPKPO.getDatabaseName());
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("tenantId").is((Object)tenantId));
        String path = Constant.DESIGNER_DATA_PATH + "{}/{}/{}/{}/";
        for (String collectionName : collectionNames) {
            String database = (String)collection_database_map.get(collectionName);
            String pathFormat = StrUtil.format((CharSequence)path, (Object[])new Object[]{application, "mongo", database, collectionName});
            List entityList = this.tenantDesignerMongoTemplate.find(query, JSONObject.class, collectionName);
            int i = 1;
            for (JSONObject js : entityList) {
                FileUtil.writeString((String)JSON.toJSONString((Object)js), (String)(pathFormat + i + ".json"), (String)"utf-8");
                ++i;
            }
        }
    }

    public void deploy(String application, File[] compileDataFiles, String compileVersion, String deployVersion) {
        for (File compileDataFile : compileDataFiles) {
            File[] files;
            if (!compileDataFile.isDirectory()) continue;
            String dbName = compileDataFile.getName();
            if ("cypher".equals(dbName)) {
                for (File file : files = compileDataFile.listFiles()) {
                    if (".DS_Store".equals(file.getName())) continue;
                    List data = FileUtil.readLines((File)file, (Charset)Charset.forName("utf-8"));
                    this.cleanNeo4jCopyData(application, deployVersion, data);
                    for (String line : data) {
                        DeployProcess deployProcess = (DeployProcess)this.redisCache.get(PARTITION, application, DeployProcess.class);
                        if (deployProcess != null) {
                            deployProcess.deployedNumIncrease();
                            String label = StrUtil.subBetween((CharSequence)"node:", (CharSequence)"{");
                            if (StrUtil.isBlank((CharSequence)label)) {
                                label = "Relation";
                            }
                            deployProcess.setType("neo4j." + label);
                        }
                        line = line.replaceAll("\\{athena_version}", deployVersion);
                        Neo4jManager.getNeo4jManager().ExecuteNoQuery(line);
                    }
                }
                continue;
            }
            for (File file : files = compileDataFile.listFiles()) {
                if (!file.isDirectory()) continue;
                String collectionName = file.getName();
                File[] dataFile = file.listFiles();
                this.cleanMongoData(application, deployVersion, dbName, collectionName);
                for (File f : dataFile) {
                    if (".DS_Store".equals(f.getName())) continue;
                    List data = FileUtil.readLines((File)f, (Charset)Charset.forName("utf-8"));
                    for (String line : data) {
                        DeployProcess deployProcess = (DeployProcess)this.redisCache.get(PARTITION, application, DeployProcess.class);
                        if (deployProcess != null) {
                            deployProcess.deployedNumIncrease();
                            deployProcess.setType(dbName + "." + collectionName);
                        }
                        Document document = Document.parse((String)line);
                        document.remove((Object)"_id");
                        document.remove((Object)"application");
                        document.remove((Object)"isMigrate");
                        document.put("athena_namespace", (Object)application);
                        document.put("compileVersion", (Object)compileVersion);
                        document.put("version", (Object)deployVersion);
                        try {
                            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(dbName).getCollection(collectionName).insertOne((Object)document);
                        }
                        catch (MongoWriteException e) {
                            log.error("insert data error: ", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private void cleanMongoData(String application, String deployVersion, String dbName, String collectionName) {
        Bson bson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"version", (Object)deployVersion), Filters.or((Bson[])new Bson[]{Filters.eq((String)"application", (Object)application), Filters.eq((String)"athena_namespace", (Object)application)})});
        this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(dbName).getCollection(collectionName).deleteMany(bson);
    }

    private void cleanNeo4jCopyData(String application, String deployVersion, List<String> data) {
        HashMap<String, String> param;
        if (data.contains("Create (action:Action:EspAction")) {
            param = new HashMap<String, String>();
            param.put("version", deployVersion);
            Neo4jManager.getNeo4jManager().ExecuteNoQuery("MATCH (node)  where node.version =$version and node.athena_namespace in ['espCommon','common'] and not any(label in labels(node) WHERE label in ['AppEntity','TenantEntity']) detach delete node", param);
        }
        param = new HashMap();
        param.put("nameSpace", application);
        param.put("version", deployVersion);
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("MATCH (node)  where node.version =$version and node.athena_namespace =$nameSpace and not any(label in labels(node) WHERE label in ['AppEntity','TenantEntity']) detach delete node", param);
    }

    public File[] getCompiledDataFiles(String application, JSONObject compiledData) {
        String applicationCompileZipPath = this.compileZipPath + File.separator + application + File.separator;
        String applicationCompileDataPath = this.compileDataPath + File.separator + application + File.separator;
        String compiledDataFileId = compiledData.getString("compiledDataFileId");
        String compileVersion = compiledData.getString("version");
        String compileDataZipPath = StrUtil.format((CharSequence)(applicationCompileZipPath + application + "_{}.zip"), (Object[])new Object[]{compileVersion});
        InputStream inputStream = this.dmcService.download(compiledDataFileId);
        FileUtil.writeFromStream((InputStream)inputStream, (String)compileDataZipPath);
        ZipUtil.unzip((String)compileDataZipPath, (String)applicationCompileDataPath);
        File compileDataDirector = SafeFileUtils.createFile((String)applicationCompileDataPath);
        NameFileFilter nameFileFilter = new NameFileFilter(".DS_Store");
        NotFileFilter notFileFilter = new NotFileFilter((IOFileFilter)nameFileFilter);
        List files = FileUtil.loopFiles((File)compileDataDirector, (FileFilter)notFileFilter);
        int total = files.stream().mapToInt(file -> FileUtil.readLines((File)file, (String)"utf-8").size()).sum();
        DeployProcess deployProcess = new DeployProcess().setTotal(Integer.valueOf(total)).setLeft(Integer.valueOf(total));
        this.redisCache.set(PARTITION, application, (Object)deployProcess);
        File[] compileDataFiles = compileDataDirector.listFiles();
        return compileDataFiles;
    }

    public Pagination queryOperateLogs(String appCode, String env, String type, Integer pageNum, Integer pageSize) {
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type));
        if (StrUtil.isNotEmpty((CharSequence)appCode)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"application").is((Object)appCode));
        }
        if (StrUtil.isNotEmpty((CharSequence)env)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"deployParam.env").is((Object)env));
        }
        Long count = this.deployerMongoTemplate.count(query, DeployLog.class, "deployLog");
        PageRequest pageable = PageRequest.of((int)(pageNum - 1), (int)pageSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"date"}));
        query.with((Pageable)pageable);
        List logList = this.deployerMongoTemplate.find(query, DeployLog.class, "deployLog");
        Map envMap = this.envService.getAllEnvNameMap();
        logList.forEach(deployLog -> {
            if (null != deployLog.getDeployParam()) {
                List tenantUsers;
                if (null != deployLog.getDeployParam().getEnv()) {
                    deployLog.setEnvName((String)envMap.get(deployLog.getDeployParam().getEnv()));
                }
                if (CollUtil.isNotEmpty((Collection)(tenantUsers = deployLog.getDeployParam().getTenantUsers()))) {
                    List tenantIdList = tenantUsers.stream().map(TenantUser::getTenantId).collect(Collectors.toList());
                    deployLog.setTenantIdList(tenantIdList);
                }
                deployLog.setCompileData(null).setDeployParam(null).setProcess(null);
            }
        });
        PageImpl page = new PageImpl(logList, (Pageable)pageable, count.longValue());
        Pagination pagination = Pagination.builder().curPageNum(pageNum).totalPageNum(Integer.valueOf(page.getTotalPages())).limit(pageSize).total(Long.valueOf(page.getTotalElements())).data(logList).build();
        return pagination;
    }

    public String getSomeValue(String type, String key, String application) {
        DeployProcess deployProcess;
        String result = "";
        if (type.equals("justKey")) {
            Object vauleObject = this.redisCache.get(key);
            if (vauleObject != null) {
                result = JSON.toJSONString((Object)vauleObject);
            }
        } else if (type.equals("merge") && (deployProcess = (DeployProcess)this.redisCache.get(key, application, DeployProcess.class)) != null) {
            result = JSON.toJSONString((Object)deployProcess);
        }
        return result;
    }

    private void copyMongoData(String application, String deployVersion, File applicationFile) {
        File[] mongoDataFiles = applicationFile.listFiles();
        if (mongoDataFiles == null || mongoDataFiles.length <= 0) {
            return;
        }
        for (File mongoDataFile : mongoDataFiles) {
            File[] files;
            if (!mongoDataFile.isDirectory()) continue;
            for (File file : files = mongoDataFile.listFiles()) {
                if (!file.isDirectory()) continue;
                String collectionName = file.getName();
                File[] collectionFiles = file.listFiles();
                String applicationKey = "application";
                if ("application".equals(collectionName)) {
                    applicationKey = "code";
                }
                this.tenantDesignerMongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)applicationKey).is((Object)application).and("tenantId").is((Object)"SYSTEM")), collectionName);
                for (File f : collectionFiles) {
                    if (".DS_Store".equals(f.getName())) continue;
                    String json = FileUtil.readString((File)f, (Charset)Charset.forName("utf-8"));
                    Document document = Document.parse((String)json);
                    document.remove((Object)"_id");
                    document.put("version", (Object)deployVersion);
                    document.put("tenantId", (Object)"SYSTEM");
                    try {
                        this.tenantDesignerMongoTemplate.insert((Object)document, collectionName);
                    }
                    catch (Exception e) {
                        log.error("insert data error: ", (Throwable)e);
                    }
                }
            }
        }
    }

    private void delFolder(String folderPath) {
        this.delAllFile(folderPath);
        String filePath = folderPath;
        File myFilePath = SafeFileUtils.createFile((String)filePath);
        FileUtil.del((File)myFilePath);
    }

    private boolean delAllFile(String path) {
        boolean flag = false;
        File file = SafeFileUtils.createFile((String)path);
        if (!file.exists()) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        String[] tempList = file.list();
        for (int i = 0; i < tempList.length; ++i) {
            File temp = path.endsWith(File.separator) ? SafeFileUtils.createFile((String)(path + tempList[i])) : SafeFileUtils.createFile((String)(path + File.separator + tempList[i]));
            if (temp.isFile()) {
                FileUtil.del((File)temp);
            }
            if (!temp.isDirectory()) continue;
            this.delAllFile(path + "/" + tempList[i]);
            this.delFolder(path + "/" + tempList[i]);
            flag = true;
        }
        return flag;
    }

    public void taskRelease(String version, String tmActivityId) {
        String tenantId = AthenaUserLocal.getUser().getTenantId();
        String iamToken = AthenaUserLocal.getUser().getToken();
        HashMap paramMap = MapUtil.newHashMap();
        paramMap.put("token", iamToken);
        StringBuilder builder = new StringBuilder();
        builder.append(this.moduleConfig.getUibot().getDomain()).append(RELEASE_TASK_URL).append(version).append("/" + tenantId).append("/" + tmActivityId);
        this.sendRequest(builder.toString(), HttpMethod.GET, (Map)paramMap, "Service Orchestration Task Publishing", this.restTemplate);
    }

    public void systemParamSync() {
        String tenantId = AthenaUserLocal.getUser().getTenantId();
        String iamToken = AthenaUserLocal.getUser().getToken();
        RestTemplate commonRestTemplate = this.restTemplate;
        ArrayList localParamsAdapter = this.generateList();
        ArrayList remoteParamsAdapter = this.generateList();
        List localParams = this.findSvcParamListByTypeAndTenantId(1, tenantId);
        localParamsAdapter.addAll(localParams);
        HashMap paramMap = MapUtil.newHashMap();
        paramMap.put("tenantId", tenantId);
        paramMap.put("token", iamToken);
        paramMap.put("routerKey", tenantId);
        Map contents = this.sendRequest(this.moduleConfig.getSmartdata().getDomain() + QUERY_PARAM_CONFIG_URL, HttpMethod.POST, (Map)paramMap, "smartdata query service orchestration parameters", commonRestTemplate);
        if (!CollectionUtils.isEmpty((Map)((Map)contents.get("response")))) {
            ((Map)contents.get("response")).forEach((key, value) -> {
                HashMap tmp = MapUtil.newHashMap();
                tmp.put("name", key);
                tmp.put("value", value);
                remoteParamsAdapter.add(tmp);
            });
        }
        List<Map> updateParams = localParamsAdapter.stream().filter(item -> remoteParamsAdapter.contains(item)).collect(Collectors.toList());
        List<Map> deleteParams = remoteParamsAdapter.stream().filter(item -> !localParamsAdapter.contains(item)).collect(Collectors.toList());
        List<Map> addParams = localParamsAdapter.stream().filter(item -> !remoteParamsAdapter.contains(item)).collect(Collectors.toList());
        updateParams.forEach(item -> {
            Map params = BeanUtil.beanToMap((Object)item, (String[])new String[0]);
            params.put("value", params.get("desc"));
            params.put("tenantId", tenantId);
            params.put("desc", null);
            params.put("token", iamToken);
            params.put("routerKey", tenantId);
            this.sendRequest(this.moduleConfig.getSmartdata().getDomain() + UPDATE_PARAM_CONFIG_URL, HttpMethod.POST, params, "smartdata update service orchestration parameters", commonRestTemplate);
        });
        deleteParams.forEach(item -> {
            Map params = BeanUtil.beanToMap((Object)item, (String[])new String[0]);
            params.put("tenantId", tenantId);
            params.put("token", iamToken);
            params.put("routerKey", tenantId);
            this.sendRequest(this.moduleConfig.getSmartdata().getDomain() + DELETE_PARAM_CONFIG_URL, HttpMethod.POST, params, "smartdata deleting service orchestration parameters", commonRestTemplate);
        });
        addParams.forEach(item -> {
            Map params = BeanUtil.beanToMap((Object)item, (String[])new String[0]);
            params.put("value", params.get("desc"));
            params.put("tenantId", tenantId);
            params.put("desc", null);
            params.put("token", iamToken);
            params.put("routerKey", tenantId);
            this.sendRequest(this.moduleConfig.getSmartdata().getDomain() + ADD_PARAM_CONFIG_URL, HttpMethod.POST, params, "smartdata New Service Choreography Parameters", commonRestTemplate);
        });
    }

    private ArrayList<Map> generateList() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public List<Map> findSvcParamListByTypeAndTenantId(int type, String tenantId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"type").is((Object)type).and("tenantId").is((Object)tenantId));
        return this.designerMongoTemplate.find(query, Map.class, "SvcParam");
    }

    private Map sendRequest(String url, HttpMethod method, Map params, String desc, RestTemplate template) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", MapUtils.getString((Map)params, (Object)"token", (String)""));
        params.remove("token");
        if (!StringUtils.isEmpty(params.get("routerKey"))) {
            headers.add("routerKey", params.get("routerKey").toString());
            params.remove("routerKey");
        }
        Map contents = null;
        try {
            contents = (Map)(switch (method.name()) {
                case "GET" -> {
                    HttpEntity httpEntity0 = new HttpEntity(null, (MultiValueMap)headers);
                    yield template.exchange(url, HttpMethod.GET, httpEntity0, Map.class, params);
                }
                case "POST" -> {
                    HttpEntity httpEntity1 = new HttpEntity((Object)params, (MultiValueMap)headers);
                    yield template.exchange(url, HttpMethod.POST, httpEntity1, Map.class, new Object[0]);
                }
                default -> throw new BusinessException(String.format("do not support method: %s", method.name()));
            }).getBody();
            if (HttpStatus.OK.value() != ((Integer)contents.get("status")).intValue()) {
                log.error(desc + "\u9519\u8bef:{}", (Object)contents);
                throw new BusinessException(desc + "error message:" + String.valueOf(contents.get("errorMessage")));
            }
            return contents;
        }
        catch (RestClientException e) {
            log.error(desc + "\u8bf7\u6c42\u5f02\u5e38:{}", (Object)e.getMessage());
            throw new BusinessException(desc + "Request exception:" + e.getMessage());
        }
    }

    public Object getDocument(FindIterable<Document> documents, Class clazz) {
        if (CollUtil.isNotEmpty(documents)) {
            Object obj = null;
            for (Document document : documents) {
                obj = JSON.parseObject((String)document.toJson(), (Class)clazz);
            }
            return obj;
        }
        return null;
    }

    public JSONObject getDocument(FindIterable<Document> documents) {
        if (CollUtil.isNotEmpty(documents)) {
            JSONObject obj = null;
            for (Document document : documents) {
                obj = JSON.parseObject((String)document.toJson());
            }
            return obj;
        }
        return null;
    }
}

