/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import com.digiwin.athena.athenadeployer.domain.deploy.FileInfo;
import com.digiwin.athena.athenadeployer.domain.dmc.DMCConfig;
import com.digiwin.athena.athenadeployer.domain.dmc.DMCTokenBean;
import com.digiwin.athena.athenadeployer.domain.dmc.MidWareResponse;
import com.digiwin.athena.athenadeployer.service.DmcService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class DmcServiceImpl
implements DmcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DmcServiceImpl.class);
    @Autowired
    @Qualifier(value="dmcRestTemplate")
    RestTemplate dmcRestTemplate;
    @Autowired
    private DMCConfig dmcConfig;
    @Autowired
    private DMCTokenBean dmcTokenBean;

    public void refreshToken() {
        String appToken = this.dmcConfig.getAppToken();
        String dmcUrl = this.dmcConfig.getUrl();
        String url = dmcUrl + "/api/dmc/v1/auth/login";
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.APPLICATION_JSON);
        header.set("digi-middleware-auth-app", appToken);
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("username", this.dmcConfig.getUserName());
        reqMap.put("pwdhash", this.dmcConfig.getPassword());
        HttpEntity httpEntity = new HttpEntity(reqMap, (MultiValueMap)header);
        ResponseEntity resMap = this.dmcRestTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        log.info("/api/dmc/v1/auth/login response:" + JSONObject.toJSONString((Object)resMap.getBody()));
        String token = (String)((Map)resMap.getBody()).get("userToken");
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new BusinessException("Failed to obtain token");
        }
        this.dmcTokenBean.setToken(token);
    }

    public String upload(File file, String contentType, FileInfo fileInfo) {
        String appToken = this.dmcConfig.getAppToken();
        String dmcUrl = this.dmcConfig.getUrl();
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.MULTIPART_FORM_DATA);
        header.add("digi-middleware-auth-user", this.dmcTokenBean.getToken());
        header.add("digi-middleware-auth-app", appToken);
        HttpHeaders fileHeader = new HttpHeaders();
        fileHeader.setContentType(MediaType.parseMediaType((String)contentType));
        fileHeader.setContentDispositionFormData("file", file.getName());
        HttpHeaders fileInfoHeader = new HttpHeaders();
        fileInfoHeader.setContentType(MediaType.APPLICATION_JSON);
        try {
            HttpEntity fileEntity = new HttpEntity((Object)new ByteArrayResource(FileUtil.readBytes((File)file)), (MultiValueMap)fileHeader);
            HttpEntity fileInfoEntity = new HttpEntity((Object)fileInfo, (MultiValueMap)fileInfoHeader);
            multiValueMap.add((Object)"file", (Object)fileEntity);
            multiValueMap.add((Object)"fileInfo", (Object)fileInfoEntity);
            String url = dmcUrl + "/api/dmc/v2/file/Athena/upload";
            HttpEntity httpEntity = new HttpEntity((Object)multiValueMap, (MultiValueMap)header);
            log.info("\u8c03\u7528DMC\u7684url\u662f: {}", (Object)url);
            log.info("\u8c03\u7528DMC\u7684header\u662f: {}", (Object)JSONObject.toJSONString((Object)header));
            ResponseEntity postForEntity = this.dmcRestTemplate.postForEntity(url, (Object)httpEntity, MidWareResponse.class, new Object[0]);
            MidWareResponse midWareResponse = (MidWareResponse)postForEntity.getBody();
            if (midWareResponse.getSuccess().booleanValue()) {
                return (String)((Map)midWareResponse.getData()).get("id");
            }
            log.error("\u8c03\u7528\u4e0a\u4f20api\u5931\u8d25,\u8fd4\u56de\u6570\u636e:" + String.valueOf(midWareResponse));
            throw new BusinessException("Failed to call the upload API");
        }
        catch (Exception e) {
            if (e instanceof HttpClientErrorException) {
                HttpClientErrorException httpClientErrorException = (HttpClientErrorException)e;
                int statusCode = httpClientErrorException.getStatusCode().value();
                if (statusCode == 401) {
                    this.refreshToken();
                }
                log.error("dmc\u7528\u6237token\u5931\u6548\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
                throw new BusinessException("dmc\u7528\u6237token\u5931\u6548\uff01\u7528\u6237token\u73b0\u5df2\u66f4\u65b0\uff0c\u8bf7\u91cd\u65b0\u7f16\u8bd1");
            }
            log.error("\u8c03\u7528DMC\u4e0a\u4f20\u6587\u4ef6api\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
            throw new BusinessException("\u8c03\u7528DMC\u4e0a\u4f20\u6587\u4ef6api\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public InputStream download(String fileId) {
        String dmcUrl = this.dmcConfig.getUrl();
        String appToken = this.dmcConfig.getAppToken();
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", this.dmcTokenBean.getToken());
        headers.add("digi-middleware-auth-app", appToken);
        String url = dmcUrl + "/api/dmc/v2/file/" + this.dmcConfig.getBucket() + "/download/" + fileId;
        log.info(String.format("download url:%s,header:%s", url, JSONObject.toJSONString((Object)headers)));
        ResponseEntity restRes = this.dmcRestTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), byte[].class, new Object[0]);
        return new ByteArrayInputStream((byte[])restRes.getBody());
    }

    public Map<String, Object> shareFile(String fileId) {
        String token = this.dmcTokenBean.getToken();
        String appToken = this.dmcConfig.getAppToken();
        String url = this.dmcConfig.getUrl() + "/api/dmc/v2/file/" + this.dmcConfig.getBucket() + "/share";
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.APPLICATION_JSON);
        header.add("digi-middleware-auth-user", token);
        header.add("digi-middleware-auth-app", appToken);
        JSONObject body = new JSONObject();
        body.put("fileId", (Object)fileId);
        ResponseEntity exchange = this.dmcRestTemplate.postForEntity(url, (Object)new HttpEntity((Object)body, (MultiValueMap)header), MidWareResponse.class, new Object[0]);
        MidWareResponse midWareResponse = (MidWareResponse)exchange.getBody();
        if (Objects.equals(Boolean.TRUE, midWareResponse.getSuccess())) {
            return (Map)midWareResponse.getData();
        }
        log.error("shareFile.is error msg:{}", (Object)midWareResponse.getMessage());
        throw new BusinessException(midWareResponse.getMessage());
    }

    public void closeShareFile(String compiledDataShareKeyId) {
        String token = this.dmcTokenBean.getToken();
        String appToken = this.dmcConfig.getAppToken();
        String url = this.dmcConfig.getUrl() + "/api/dmc/v2/file/" + this.dmcConfig.getBucket() + "/share/delete";
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.APPLICATION_JSON);
        header.add("digi-middleware-auth-user", token);
        header.add("digi-middleware-auth-app", appToken);
        JSONObject body = new JSONObject();
        body.put("shareIds", (Object)new String[]{compiledDataShareKeyId});
        ResponseEntity exchange = this.dmcRestTemplate.postForEntity(url, (Object)new HttpEntity((Object)body, (MultiValueMap)header), MidWareResponse.class, new Object[0]);
        MidWareResponse midWareResponse = (MidWareResponse)exchange.getBody();
        if (Objects.equals(Boolean.FALSE, midWareResponse.getSuccess())) {
            log.error("shareFile.is error msg:{}", (Object)midWareResponse.getMessage());
            throw new BusinessException(midWareResponse.getMessage());
        }
    }

    public String uploadFile2Dmc(File file, Date expireDate) {
        String token = this.dmcTokenBean.getToken();
        if (StrUtil.isBlank((CharSequence)token)) {
            this.refreshToken();
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.setDisplayName(file.getName());
        fileInfo.setDirectoryId("0");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        fileInfo.setExpireDate(formatter.format(expireDate));
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        String fileId = this.upload(file, StringUtils.isEmpty((CharSequence)contentType) ? "multipart/form-data" : contentType, fileInfo);
        return fileId;
    }
}

