/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.config.ModuleConfig;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import com.digiwin.athena.athenadeployer.domain.esp.EspResponse;
import com.digiwin.athena.athenadeployer.domain.esp.EspResponseSuccess;
import com.digiwin.athena.athenadeployer.domain.pageView.Multilingual;
import com.digiwin.athena.athenadeployer.service.ESPService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ESPServiceImpl
implements ESPService {
    @Generated
    private static final Logger log = LogManager.getLogger(ESPServiceImpl.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ModuleConfig moduleConfig;

    public List<String> getCloudProductNames(String tenantId) {
        String apiMetadataUrl = this.moduleConfig.getEsp().getDomain() + "/ESP/MetadataCache/TenantProductOperationList/Get";
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        httpHeaders.setContentType(type);
        JSONObject body = new JSONObject();
        body.put("tenant_id", (Object)tenantId);
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
        log.info("tenantProductList request:{}", (Object)httpEntity);
        JSONObject response = (JSONObject)this.restTemplate.postForObject(apiMetadataUrl, (Object)httpEntity, JSONObject.class, new Object[0]);
        log.info("tenantProductList response:{}", (Object)response);
        JSONArray prodEocMappings = Objects.requireNonNull(response).getJSONArray("prod_eoc_mapping");
        ArrayList<String> productNameList = new ArrayList<String>();
        HashSet<String> productSet = new HashSet<String>();
        for (Object prodEocMapping : prodEocMappings) {
            String product = ((JSONObject)prodEocMapping).getString("prod_name");
            if (productSet.contains(product)) continue;
            productNameList.add(product);
            productSet.add(product);
        }
        return productNameList;
    }

    public EspResponse getApiInfoById(String apiName) {
        String apiMetadataUrl = this.moduleConfig.getEsp().getDomain() + "/ESP/MetadataCache/ApiMetadata/Get";
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        httpHeaders.setContentType(type);
        JSONObject body = new JSONObject();
        body.put("api_name", (Object)apiName);
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
        JSONObject response = (JSONObject)this.restTemplate.postForObject(apiMetadataUrl, (Object)httpEntity, JSONObject.class, new Object[0]);
        JSONObject execution = response.getJSONObject("execution");
        String code = execution.getString("code");
        if (!"000".equals(code)) {
            throw new BusinessException(String.format(execution.getString("description") + ":%s", apiName));
        }
        JSONObject data = response.getJSONObject("data");
        JSONObject dataMetadata = data.getJSONObject("data_metadata");
        JSONObject responseSuccess = dataMetadata.getJSONObject("response_success");
        EspResponseSuccess espResponseSuccess = (EspResponseSuccess)responseSuccess.toJavaObject(EspResponseSuccess.class);
        JSONObject description = data.getJSONObject("description");
        Multilingual descriptionMultilingual = (Multilingual)description.toJavaObject(Multilingual.class);
        EspResponse espResponse = new EspResponse().setEspResponseSuccess(espResponseSuccess).setDescription(descriptionMultilingual);
        return espResponse;
    }
}

