/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.dao.mongo.EnvDao;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.Env;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import com.digiwin.athena.athenadeployer.http.DesignerApiHelper;
import com.digiwin.athena.athenadeployer.service.EnvService;
import jakarta.annotation.Resource;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class EnvServiceImpl
implements EnvService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnvServiceImpl.class);
    @Value(value="${environment}")
    private String environment;
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate mongoTemplate;
    @Autowired
    private DesignerApiHelper designerApiHelper;
    private EnvDao envDao;

    @Autowired
    public void setEnvDao(EnvDao envDao) {
        this.envDao = envDao;
    }

    public List<Env> queryByEnv(String env) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"env").is((Object)env));
        return this.mongoTemplate.find(query, Env.class, "env");
    }

    public Env queryByEnvAndModule(String env, String module) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"env").is((Object)env).and("module").is((Object)module));
        return (Env)this.mongoTemplate.findOne(query, Env.class, "env");
    }

    public List<Env> queryEnvs(String operate) {
        List envs = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"operate").is((Object)operate)), Env.class, "env");
        return envs;
    }

    public Map<String, String> getAllEnvMap() {
        HashMap<String, String> re = new HashMap<String, String>();
        try {
            List envList = this.mongoTemplate.findAll(Env.class, "env");
            envList.forEach(env -> {
                re.put(env.getEnv() + "-" + env.getModule(), env.getUri());
                JSONObject thirdModule = env.getThirdModule();
                if (null != thirdModule) {
                    for (String thirdModuleName : thirdModule.keySet()) {
                        String thirdModuleUri = thirdModule.getString(thirdModuleName);
                        re.put(env.getEnv() + "-" + thirdModuleName, thirdModuleUri);
                    }
                }
            });
            log.info("\u83b7\u53d6\u73af\u5883\u4fe1\u606f\u6210\u529f\uff01");
            return re;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u73af\u5883\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            return new HashMap<String, String>();
        }
    }

    public List<Env> queryEnvsWithoutAuth(String operate) {
        Query query = new Query();
        if (StringUtils.isNotEmpty((CharSequence)operate)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"operate").is((Object)operate));
        }
        query.fields().include("env").include("envName").include("region").include("thirdModule");
        List envList = this.mongoTemplate.find(query, Env.class, "env");
        List<Env> uniqueEnvs = envList.stream().collect(Collectors.groupingBy(Env::getEnv)).values().stream().map(list -> (Env)list.get(0)).collect(Collectors.toList());
        return uniqueEnvs;
    }

    public Map<String, String> getAllEnvNameMap() {
        HashMap<String, String> re = new HashMap<String, String>();
        try {
            List env = this.mongoTemplate.findAll(Env.class, "env");
            env.forEach(e -> re.put(e.getEnv(), e.getEnvName()));
            return re;
        }
        catch (Exception e2) {
            throw new BusinessException("\u83b7\u53d6\u73af\u5883\u4fe1\u606f\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
        }
    }

    public List<Env> queryWithAuth(String operate) {
        List resourceRoles = this.designerApiHelper.queryResourceRole("publish");
        boolean present = resourceRoles.stream().filter(item -> item.getUserId().equals(AthenaUserLocal.getUser().getUserId()) && ("publish:mgr".equals(item.getRole()) || "tenant:super".equals(item.getRole()))).findFirst().isPresent();
        if (present) {
            return this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"operate").is((Object)operate).and("serviceId").ne(null)), Env.class, "env");
        }
        return this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"operate").is((Object)operate).and("region").is((Object)"test").and("serviceId").ne(null)), Env.class, "env");
    }

    public List<String> queryFormalZone() {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"operate").is((Object)"publish").and("region").is((Object)"prod"));
        List envs = this.mongoTemplate.find(query, Env.class);
        return envs.stream().map(Env::getEnv).collect(Collectors.toList());
    }

    public Env queryEnvsByOperateAndServiceId(String operate, String serviceId) {
        return (Env)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"operate").is((Object)operate).and("serviceId").is((Object)serviceId)), Env.class, "env");
    }

    public Env insertEnv(Env env) {
        String userId = AthenaUserLocal.getUser().getUserId();
        env.setCreateBy(userId).setCreateDate(new Date()).setEditBy(userId).setEditDate(new Date());
        env.setObjectId(null);
        return (Env)this.mongoTemplate.insert((Object)env);
    }

    public Env updateEnv(Env env) {
        String userId = AthenaUserLocal.getUser().getUserId();
        env.setEditBy(userId).setEditDate(new Date());
        return (Env)this.mongoTemplate.save((Object)env);
    }

    public void deleteEnvByServiceId(String serviceId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"serviceId").is((Object)serviceId));
        this.mongoTemplate.remove(query, Env.class);
    }

    public List<Env> queryEnvsByServiceId(String serviceId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"serviceId").is((Object)serviceId));
        return this.mongoTemplate.find(query, Env.class);
    }

    public List<Env> queryEnv(String serviceId) {
        return this.envDao.selectByServiceId(serviceId);
    }
}

