/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.config.ModuleConfig;
import com.digiwin.athena.athenadeployer.dto.tenant.TenantDTO;
import com.digiwin.athena.athenadeployer.dto.user.UserDTO;
import com.digiwin.athena.athenadeployer.service.IAMService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class IAMServiceImpl
implements IAMService {
    @Generated
    private static final Logger log = LogManager.getLogger(IAMServiceImpl.class);
    @Autowired
    private ModuleConfig moduleConfig;
    @Value(value="${secretKey}")
    private String secretKey;
    @Autowired
    private RestTemplate restTemplate;

    public String getTenantToken() {
        String url = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/identity/login";
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        httpHeaders.setContentType(type);
        JSONObject body = new JSONObject();
        body.put("secretKey", (Object)this.secretKey);
        body.put("identityType", (Object)"secretKey");
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
        log.info("getTenantToken request:{}", (Object)httpEntity);
        JSONObject response = (JSONObject)this.restTemplate.postForObject(url, (Object)httpEntity, JSONObject.class, new Object[0]);
        log.info("getTenantToken response:{}", (Object)response);
        return Objects.requireNonNull(response).getString("token");
    }

    public String getTenantId() {
        String url = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/identity/login";
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        httpHeaders.setContentType(type);
        JSONObject body = new JSONObject();
        body.put("secretKey", (Object)this.secretKey);
        body.put("identityType", (Object)"secretKey");
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
        log.info("getTenantToken request:{}", (Object)httpEntity);
        JSONObject response = (JSONObject)this.restTemplate.postForObject(url, (Object)httpEntity, JSONObject.class, new Object[0]);
        log.info("getTenantToken response:{}", (Object)response);
        return Objects.requireNonNull(response).getString("tenantId");
    }

    public UserDTO digiwinLogin(String userId, String password) {
        String url = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/identity/login";
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        httpHeaders.setContentType(type);
        JSONObject body = new JSONObject();
        body.put("tenantId", (Object)"99990000");
        body.put("userId", (Object)userId);
        body.put("password", (Object)password);
        body.put("identityType", (Object)"service");
        body.put("serviceName", (Object)"digiwin");
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
        log.info("digiwinLogin request:{}", (Object)httpEntity);
        UserDTO user = (UserDTO)this.restTemplate.postForObject(url, (Object)httpEntity, UserDTO.class, new Object[0]);
        log.info("digiwinLogin response:{}", (Object)user);
        return user;
    }

    public UserDTO tokenAnalyze(String token) {
        String url = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/identity/token/analyze";
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        httpHeaders.setContentType(type);
        httpHeaders.add("digi-middleware-auth-user", token);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)httpHeaders);
        log.info("tokenAnalyze request:{}", (Object)httpEntity);
        UserDTO user = (UserDTO)this.restTemplate.postForObject(url, (Object)httpEntity, UserDTO.class, new Object[0]);
        log.info("tokenAnalyze response:{}", (Object)user);
        return user;
    }

    public List<TenantDTO> tenantsByCustomer(String token) {
        String url = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/tenant/tenants/by/customer";
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        httpHeaders.setContentType(type);
        httpHeaders.add("digi-middleware-auth-user", token);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)httpHeaders);
        log.info("tenantsByCustomer request:{}", (Object)httpEntity);
        ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, Map.class, new Object[0]);
        List tenants = JSONObject.parseArray((String)JSON.toJSONString(((Map)result.getBody()).get("data")), TenantDTO.class);
        log.info("tenantsByCustomer response:{}", (Object)tenants);
        return tenants;
    }
}

