/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import com.digiwin.athena.athenadeployer.config.neo4j.Neo4jManager;
import com.digiwin.athena.athenadeployer.domain.Application;
import com.digiwin.athena.athenadeployer.enums.DeployerProgressEnum;
import com.digiwin.athena.athenadeployer.service.AthenaDataService;
import com.digiwin.athena.athenadeployer.service.DeployerProgressService;
import com.digiwin.athena.athenadeployer.service.InitService;
import com.google.common.collect.Lists;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class InitServiceImpl
implements InitService {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate deployerMongoTemplate;
    @Autowired
    private DeployerProgressService deployerProgressService;
    @Autowired
    private AthenaDataService athenaDataService;

    public void initData() {
        Application application = new Application((List)Lists.newArrayList((Object[])new String[]{"1.0"}), "1.0", (List)Lists.newArrayList((Object[])new String[]{"1.0"}));
        this.deployerProgressService.addPublishEvent(application);
        List initMongoList = this.athenaDataService.getMongoCollection();
        Bson filter = Filters.ne((String)"version", (Object)application.getVersion());
        Document update = new Document("$set", (Object)new Document().append("version", (Object)application.getVersion()));
        for (HashMap initMongo : initMongoList) {
            ((List)initMongo.get("collectionName")).forEach(arg_0 -> this.lambda$initData$0(initMongo, filter, (Bson)update, arg_0));
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", application.getVersion());
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("match (node) set node.version=$version", param);
        List tenantList = Neo4jManager.getNeo4jManager().ExecuteQuery("match (tenant:TenantEntity) return tenant.tenantId as tenantId,tenant.tenantName as tenantName");
        String tenantVersion = "1.x";
        tenantList.forEach(tenant -> {
            Bson tenantFilter = Filters.eq((String)"tenantId", tenant.get("tenantId"));
            FindIterable documents = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantConfig").find(tenantFilter);
            AtomicInteger prodCount = new AtomicInteger();
            documents.forEach(document -> prodCount.getAndIncrement());
            if (prodCount.get() > 0) {
                Document tenantUpdate = new Document("$set", (Object)new Document().append("version", (Object)tenantVersion)).append("$set", (Object)new Document().append("tenantName", tenant.get("tenantName")));
                this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantConfig").updateMany(tenantFilter, (Bson)tenantUpdate);
            } else {
                Document document2 = new Document();
                document2.put("tenantId", tenant.get("tenantId"));
                document2.put("tenantName", tenant.get("tenantName"));
                document2.put("version", (Object)tenantVersion);
                this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantConfig").insertOne((Object)document2);
            }
            HashMap param2 = new HashMap();
            param2.put("tenantId", tenant.get("tenantId"));
            List tenantUseAppList = Neo4jManager.getNeo4jManager().ExecuteQuery("match (tenant:TenantEntity)-[:USE]-(app:AppEntity) where tenant.tenantId=$tenantId return app.code as appCode,app.namespace as appNamespace", param2);
            tenantUseAppList.forEach(tenantUseApp -> {
                Bson tenantUseAppFilter = Filters.eq((String)"application", tenantUseApp.get("appNamespace"));
                FindIterable projectDocuments = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("project").find(tenantUseAppFilter);
                projectDocuments.forEach(projectDocument -> {
                    Bson tenantProductRelationFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"tenantId", tenant.get("tenantId")), Filters.eq((String)"objectType", (Object)"project"), Filters.eq((String)"objectCode", (Object)projectDocument.getString((Object)"code"))});
                    FindIterable tenantProductRelationDocuments = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantProductRelation").find(tenantProductRelationFilter);
                    AtomicInteger tenantProductRelationCount = new AtomicInteger();
                    tenantProductRelationDocuments.forEach(tenantProductRelationDocument -> tenantProductRelationCount.getAndIncrement());
                    if (tenantProductRelationCount.get() < 1) {
                        Document tenantProductRelation = new Document();
                        tenantProductRelation.put("tenantId", tenant.get("tenantId"));
                        tenantProductRelation.put("objectType", (Object)"project");
                        tenantProductRelation.put("objectCode", (Object)projectDocument.getString((Object)"code"));
                        this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantProductRelation").insertOne((Object)tenantProductRelation);
                    }
                });
            });
        });
        this.deployerProgressService.updatePublishEvent(application, DeployerProgressEnum.UPDATECOMPLETE);
        this.deployerProgressService.updateProdVersion(application);
    }

    public void deleteData(String version) {
        List initMongoList = this.athenaDataService.getMongoCollection();
        Bson filter = Filters.eq((String)"version", (Object)version);
        for (HashMap initMongo : initMongoList) {
            ((List)initMongo.get("collectionName")).forEach(collection -> this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase((String)initMongo.get("dbName")).getCollection(collection).deleteMany(filter));
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", version);
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("match (node) where not any(label in labels(node) WHERE label in ['AppEntity','TenantEntity']) and node.version=$version detach delete node", param);
    }

    public void resetData() {
        String prodVersion = this.deployerProgressService.getProdVersion();
        List initMongoList = this.athenaDataService.getMongoCollection();
        Bson filter = Filters.ne((String)"version", (Object)prodVersion);
        for (HashMap initMongo : initMongoList) {
            ((List)initMongo.get("collectionName")).forEach(collection -> this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase((String)initMongo.get("dbName")).getCollection(collection).deleteMany(filter));
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", prodVersion);
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("match (node) where not any(label in labels(node) WHERE label in ['AppEntity','TenantEntity']) and node.version <> $version detach delete node", param);
        Bson updateFilter = Filters.eq((String)"version", (Object)prodVersion);
        Document update = new Document("$set", (Object)new Document().append("version", (Object)"1.0"));
        for (HashMap initMongo : initMongoList) {
            ((List)initMongo.get("collectionName")).forEach(arg_0 -> this.lambda$resetData$8(initMongo, updateFilter, (Bson)update, arg_0));
        }
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("match (node) where node.version = $version set node.version='1.0'", param);
        Bson tenantConfigFilter = Filters.ne((String)"version", (Object)(prodVersion.split("\\.")[0] + ".x"));
        Document tenantConfigUpdate = new Document("$set", (Object)new Document().append("version", (Object)"1.x"));
        this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantConfig").updateMany(tenantConfigFilter, (Bson)tenantConfigUpdate);
        Bson oldProdFilter = Filters.eq((String)"prod", (Object)true);
        Document oldProdUpdate = new Document("$set", (Object)new Document().append("prod", (Object)false));
        this.deployerMongoTemplate.getCollection("publishProgressResult").updateOne(oldProdFilter, (Bson)oldProdUpdate);
        Bson newFilter = Filters.eq((String)"code", (Object)"[1.0]_[1.0](1.0)");
        Document newUpdate = new Document("$set", (Object)new Document().append("prod", (Object)true));
        this.deployerMongoTemplate.getCollection("publishProgressResult").updateOne(newFilter, (Bson)newUpdate);
    }

    private /* synthetic */ void lambda$resetData$8(HashMap initMongo, Bson updateFilter, Bson update, String collection) {
        this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase((String)initMongo.get("dbName")).getCollection(collection).updateMany(updateFilter, update);
    }

    private /* synthetic */ void lambda$initData$0(HashMap initMongo, Bson filter, Bson update, String collection) {
        this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase((String)initMongo.get("dbName")).getCollection(collection).updateMany(filter, update);
    }
}

