/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.athenadeployer.domain.JSONDiff;
import com.digiwin.athena.athenadeployer.service.JsonDiffService;
import com.digiwin.athena.athenadeployer.utils.JSONCompare;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class JsonDiffServiceImpl
implements JsonDiffService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonDiffServiceImpl.class);
    @Autowired(required=false)
    @Qualifier(value="designerMongoTemplate")
    private MongoTemplate designerMongoTemplate;

    public void compare(String source, String target, String module, String appCode, String from) {
        JSONDiff jsonDiff;
        try {
            jsonDiff = JSONCompare.compare((String)source, (String)target, (boolean)true);
        }
        catch (JsonProcessingException e) {
            log.error("json\u89e3\u6790\u5931\u8d25");
            return;
        }
        if (!jsonDiff.isEqual() && MapUtil.isNotEmpty((Map)jsonDiff.getOnlyOnSource())) {
            String code = UUID.randomUUID().toString();
            log.info("json\u5bf9\u6bd4\u7ed3\u679c:{}", (Object)code);
            jsonDiff.setCode(code).setModule(module).setApplication(appCode).setDate(new Date()).setFrom(from);
            this.designerMongoTemplate.save((Object)jsonDiff, "jsonDiff");
        }
    }

    public Set<String> statisticDiff(String module) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"module").is((Object)module));
        List jsonDiffList = this.designerMongoTemplate.find(query, JSONDiff.class, "jsonDiff");
        HashSet<String> diff = new HashSet<String>();
        jsonDiffList.forEach(jd -> {
            Map onlyOnSource = jd.getOnlyOnSource();
            for (Map.Entry entry : onlyOnSource.entrySet()) {
                diff.add((String)entry.getKey());
            }
        });
        return diff;
    }
}

