/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.config.ModuleConfig;
import com.digiwin.athena.athenadeployer.config.neo4j.Neo4jManager;
import com.digiwin.athena.athenadeployer.service.IAMService;
import com.digiwin.athena.athenadeployer.service.PublishAfterService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class PublishAfterServiceImpl
implements PublishAfterService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PublishAfterServiceImpl.class);
    @Autowired
    private IAMService iamService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ModuleConfig moduleConfig;

    public void createTenantEntityDependency(String applicationCode) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("applicationCode", applicationCode);
        List records = Neo4jManager.getNeo4jManager().ExecuteQuery("MATCH (t:TenantEntity)-[:USE]->(app:AppEntity) where app.code=$applicationCode return t.tenantId as tenantId", param);
        for (Map record : records) {
            record.put("applicationCode", applicationCode);
            Neo4jManager.getNeo4jManager().ExecuteNoQuery("match(t:TenantEntity) where t.tenantId=$tenantId match(task:Task) where task.athena_namespace=$applicationCode merge (t)-[:TASK]->(task)", record);
            Neo4jManager.getNeo4jManager().ExecuteNoQuery("match(t:TenantEntity) where t.tenantId=$tenantId match(activity:Activity) where activity.athena_namespace=$applicationCode and activity.inclusionTenant is null merge (t)-[:ACTIVITY]->(activity)", record);
            Neo4jManager.getNeo4jManager().ExecuteNoQuery("match(t:TenantEntity) where t.tenantId=$tenantId match(activity:Activity) where activity.athena_namespace=$applicationCode and activity.inclusionTenant is not null and t.tenantId in activity.inclusionTenant merge (t)-[:ACTIVITY]->(activity)", record);
            Neo4jManager.getNeo4jManager().ExecuteNoQuery("match(t:TenantEntity) where t.tenantId=$tenantId match(monitorRule:MonitorRule) where monitorRule.athena_namespace=$applicationCode and monitorRule.inclusionTenant is null merge (t)-[:USE]->(monitorRule)", record);
            Neo4jManager.getNeo4jManager().ExecuteNoQuery("match(t:TenantEntity) where t.tenantId=$tenantId match(monitorRule:MonitorRule) where monitorRule.athena_namespace=$applicationCode and monitorRule.inclusionTenant is not null and t.tenantId in monitorRule.inclusionTenant merge (t)-[:USE]->(monitorRule)", record);
            Neo4jManager.getNeo4jManager().ExecuteNoQuery("match(t:TenantEntity) where t.tenantId=$tenantId match(me:Mechanism) where me.athena_namespace=$applicationCode merge (t)-[:MECHANISM]->(me)", record);
            Neo4jManager.getNeo4jManager().ExecuteNoQuery("match(t:TenantEntity) where t.tenantId=$tenantId match(action:Action) where action.athena_namespace=$applicationCode merge (t)-[:ACTION]->(action)", record);
        }
    }

    public void cacheReset() {
        this.kmCacheReset();
        this.atmcCacheReset();
    }

    public void dataMapGraphRebuild() {
        try {
            String tenantToken = this.iamService.getTenantToken();
            String tenantId = this.iamService.getTenantId();
            String url = this.moduleConfig.getKm().getDomain() + "/restful/standard/datamap/generic/graphRebuild";
            HttpHeaders httpHeaders = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            httpHeaders.setContentType(type);
            httpHeaders.add("token", tenantToken);
            httpHeaders.add("routerKey", tenantId);
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)httpHeaders);
            this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, Object.class, new Object[0]);
            url = this.moduleConfig.getKm().getDomain() + "/restful/standard/datamap/generic/cleanOld";
            this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, Object.class, new Object[0]);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            log.error("dataMapGraphRebuild\u5931\u8d25\uff01");
        }
    }

    private void kmCacheReset() {
        String url = this.moduleConfig.getKm().getDomain() + "/restful/service/knowledgegraph/Cache/withPattern";
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        httpHeaders.setContentType(type);
        JSONObject body = new JSONObject();
        body.put("keyPatterns", Arrays.asList("knowledgegraph*", "tagsystem*"));
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
        log.info("km CacheReset request:{}", (Object)httpEntity);
        this.restTemplate.exchange(url, HttpMethod.DELETE, httpEntity, Object.class, new Object[0]);
    }

    private void atmcCacheReset() {
        String tenantToken = this.iamService.getTenantToken();
        String url = this.moduleConfig.getAtmc().getDomain() + "/api/atmc/v1/cache/reset";
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        httpHeaders.setContentType(type);
        httpHeaders.add("token", tenantToken);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)httpHeaders);
        log.info("atmc CacheReset request:{}", (Object)httpEntity);
        this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, Object.class, new Object[0]);
    }
}

