/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployLogDao;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployServiceInfoDao;
import com.digiwin.athena.athenadeployer.dao.mongo.TenantPipeLineDao;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployServiceInfo;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.AppCompileDataResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.AppTenantResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.DeployExecutingInfo;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.DeployLogParam;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.DeployLogResult;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Env;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.EnvApp;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Group;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Node;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.TenantPipeLine;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.http.DesignerApiHelper;
import com.digiwin.athena.athenadeployer.service.EnvService;
import com.digiwin.athena.athenadeployer.service.ReleasePipeLineService;
import com.digiwin.athena.athenadeployer.utils.TenantPipelineHelper;
import com.digiwin.athena.auth.annotation.DataAuth;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.SortOperation;
import org.springframework.data.mongodb.core.aggregation.UnwindOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class ReleasePipeLineServiceImpl
implements ReleasePipeLineService {
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate mongoTemplate;
    @Autowired
    private DeployLogDao deployLogDao;
    @Autowired
    private DesignerApiHelper designerApiHelper;
    @Autowired
    private EnvService envService;
    @Autowired
    private TenantPipeLineDao tenantPipeLineDao;
    @Autowired
    private DeployServiceInfoDao deployServiceInfoDao;

    @DataAuth(resourceType="env", resourceId="Var:0||$tenantId")
    public List<com.digiwin.athena.athenadeployer.domain.Env> queryEnvsByApplication(String application) {
        List envs = this.mongoTemplate.find(new Query(), com.digiwin.athena.athenadeployer.domain.Env.class, "env");
        return envs;
    }

    public TenantPipeLine queryTenantPipelineByApplication(String application) {
        TenantPipeLine tenantPipeLine = this.getTenantPipeLine();
        List envsWithAuth = this.queryEnvsByApplication(application);
        List groupList = tenantPipeLine.getGroups();
        List deployServiceInfos = this.deployServiceInfoDao.queryBriefDeployServiceInfo();
        for (Group group : groupList) {
            this.filterAuth(group.getNode(), envsWithAuth, deployServiceInfos);
        }
        return tenantPipeLine;
    }

    public TenantPipeLine queryTenantPipeline4IndexPage() {
        TenantPipeLine tenantPipeLine = this.getTenantPipeLine();
        List groupList = tenantPipeLine.getGroups();
        List deployServiceInfos = this.deployServiceInfoDao.queryBriefDeployServiceInfo();
        for (Group group : groupList) {
            Node node = group.getNode();
            String serviceId = group.getNode().getServiceId();
            if (!CollUtil.isNotEmpty((Collection)deployServiceInfos)) continue;
            DeployServiceInfo deployServiceInfo = deployServiceInfos.stream().filter(dsi -> dsi.getServiceId().equals(serviceId)).findFirst().orElse(new DeployServiceInfo());
            node.setServiceName(deployServiceInfo.getServiceName());
            node.setLang(deployServiceInfo.getLang());
            node.setFriendlyLinkList(deployServiceInfo.getFriendlyLinkList());
        }
        return tenantPipeLine;
    }

    public TenantPipeLine queryTenantPipelineByOperate(String operate) {
        TenantPipeLine tenantPipeLine = this.getTenantPipeLine();
        List envsWithAuth = this.envService.queryWithAuth(operate);
        List groupList = tenantPipeLine.getGroups();
        List deployServiceInfos = this.deployServiceInfoDao.queryBriefDeployServiceInfo();
        for (Group group : groupList) {
            this.filterAuth(group.getNode(), envsWithAuth, deployServiceInfos);
        }
        return tenantPipeLine;
    }

    private TenantPipeLine getTenantPipeLine() {
        TenantPipeLine tenantPipeLine = (TenantPipeLine)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)AthenaUserLocal.getUser().getTenantId())), TenantPipeLine.class, "tenantPipeline");
        if (tenantPipeLine == null && (tenantPipeLine = (TenantPipeLine)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)"SYSTEM")), TenantPipeLine.class, "tenantPipeline")) == null) {
            tenantPipeLine = this.generateSystemPipeLine();
        }
        return tenantPipeLine;
    }

    public void verifyCompileData(DeployParamV3 deployParamV3) {
        List<String> checkStatus;
        List switchingApps;
        Env switchEnv;
        Node node;
        String publishEnvServiceId = deployParamV3.getEnvServiceId();
        List applicationDataList = deployParamV3.getApplicationDataList();
        Set appCodeList = applicationDataList.stream().map(item -> item.getApplication()).collect(Collectors.toSet());
        TenantPipeLine tenantPipeLine = this.queryTenantPipelineByOperate("publish");
        List parentEnvServiceIdList = TenantPipelineHelper.findAllParentServiceIds((TenantPipeLine)tenantPipeLine, (String)publishEnvServiceId);
        if (CollUtil.isNotEmpty((Collection)parentEnvServiceIdList)) {
            node = TenantPipelineHelper.findNodeByServiceId((TenantPipeLine)tenantPipeLine, (String)((String)parentEnvServiceIdList.get(parentEnvServiceIdList.size() - 1)));
            Env testPublishEnv = node.getEnvs().stream().filter(item -> "publish".equals(item.getOperate())).findAny().orElseThrow(() -> new BusinessException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53d1\u7248\u73af\u5883!"));
            List deployLogs = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"application").in(appCodeList).and("deployParam.env").is((Object)testPublishEnv.getEnv()).and("result").is((Object)"success")), DeployLog.class, "deployLog");
            Set publishedApplicationList = deployLogs.stream().map(item -> item.getApplication()).collect(Collectors.toSet());
            Collection unpublishedAppCodes = CollUtil.disjunction(appCodeList, publishedApplicationList);
            if (CollUtil.isNotEmpty((Collection)unpublishedAppCodes)) {
                throw new BusinessException("\u4ee5\u4e0b\u5e94\u7528\u672a\u53d1\u5e03\u8fc7\u6d4b\u8bd5\u73af\u5883,\u4e0d\u5141\u8bb8\u53d1\u7248\u5230\u6b63\u5f0f\u73af\u5883:" + String.join((CharSequence)",", unpublishedAppCodes));
            }
        }
        if ((switchEnv = (node = TenantPipelineHelper.findNodeByServiceId((TenantPipeLine)(tenantPipeLine = this.queryTenantPipelineByOperate("switch")), (String)publishEnvServiceId)).getEnvByOperate("switch")) != null && CollUtil.isNotEmpty((Collection)(switchingApps = this.deployLogDao.selectApplicationByApplicationAndStatusAndEnvAndType(appCodeList, checkStatus = Arrays.asList("executing", "waiting"), switchEnv.getEnv(), EnvOperateEnum.SWITCH)))) {
            throw new BusinessException("\u4ee5\u4e0b\u5e94\u7528\u6b63\u5728\u5207\u7248\uff0c\u4e0d\u5141\u8bb8\u53d1\u7248:" + String.join((CharSequence)",", switchingApps));
        }
    }

    public void verifyPublishLog(DeployParamV3 deployParamV3) {
        String envServiceId = deployParamV3.getEnvServiceId();
        TenantPipeLine tenantPipeLine = this.queryTenantPipelineByOperate("publish");
        Node node = TenantPipelineHelper.findNodeByServiceId((TenantPipeLine)tenantPipeLine, (String)envServiceId);
        Env publishEnv = node.getEnvByOperate("publish");
        List applicationDataList = deployParamV3.getApplicationDataList();
        Set appCodeList = applicationDataList.stream().map(item -> item.getApplication()).collect(Collectors.toSet());
        List<String> checkStatus = Arrays.asList("executing", "waiting");
        List existsApplication = this.deployLogDao.selectApplicationByApplicationAndStatusAndEnvAndType(appCodeList, checkStatus, publishEnv.getEnv(), EnvOperateEnum.PUBLISH);
        if (CollUtil.isNotEmpty((Collection)existsApplication)) {
            throw new BusinessException("\u4ee5\u4e0b\u5e94\u7528\u6b63\u5728\u53d1\u7248\uff0c\u8bf7\u52ff\u5207\u7248:" + String.join((CharSequence)",", existsApplication));
        }
        existsApplication = this.deployLogDao.selectApplicationByApplicationAndStatusAndEnvAndType(appCodeList, checkStatus, deployParamV3.getEnv(), EnvOperateEnum.SWITCH);
        if (CollUtil.isNotEmpty((Collection)existsApplication)) {
            throw new BusinessException("\u4ee5\u4e0b\u5e94\u7528\u6b63\u5728\u5207\u7248\uff0c\u8bf7\u52ff\u91cd\u590d\u5207\u7248:" + String.join((CharSequence)",", existsApplication));
        }
        List deployLogs = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"application").in(appCodeList).and("deployParam.env").is((Object)publishEnv.getEnv()).and("result").is((Object)"success")), DeployLog.class, "deployLog");
        Set publishedApplicationList = deployLogs.stream().map(item -> item.getApplication()).collect(Collectors.toSet());
        Collection unpublishedAppCodes = CollUtil.disjunction(appCodeList, publishedApplicationList);
        if (CollUtil.isNotEmpty((Collection)unpublishedAppCodes)) {
            throw new BusinessException("\u4ee5\u4e0b\u5e94\u7528\u672a\u53d1\u5e03\u8fc7\u6c99\u7bb1\u73af\u5883,\u4e0d\u5141\u8bb8\u5207\u7248:" + String.join((CharSequence)",", unpublishedAppCodes));
        }
    }

    public List<DeployLogResult> queryDeployLogByEnv(DeployLogParam deployLogParam) {
        List envList = this.queryEnvsByApplication(deployLogParam.getApplication());
        List envs = deployLogParam.getEnvs();
        List mappedResults = this.getLatestDeployLog(deployLogParam, envs, deployLogParam.getResult());
        List<DeployLogResult> result = mappedResults.stream().map(mappedResult -> {
            Document latestDocument = (Document)mappedResult.get((Object)"latestDocument", Document.class);
            DeployLog item = (DeployLog)JSON.parseObject((String)JSON.toJSONString((Object)latestDocument), DeployLog.class);
            DeployParamV3 deployParam = item.getDeployParam();
            com.digiwin.athena.athenadeployer.domain.Env env = envList.stream().filter(e -> e.getEnv().equals(deployParam.getEnv()) && e.getServiceId().equals(deployParam.getEnvServiceId())).findAny().orElse(null);
            DeployLogResult deployLogResult = new DeployLogResult();
            deployLogResult.setServiceId(deployParam.getEnvServiceId()).setDeployNo(item.getDeployNo()).setOperate(env.getOperate()).setResult(item.getResult()).setEnv(deployParam.getEnv());
            return deployLogResult;
        }).collect(Collectors.toList());
        mappedResults = this.getLatestDeployLog(deployLogParam, envs, (List)ListUtil.toList((Object[])new String[]{"success"}));
        block0: for (DeployLogResult deployLogResult : result) {
            for (Document mappedResult2 : mappedResults) {
                Document latestDocument = (Document)mappedResult2.get((Object)"latestDocument", Document.class);
                DeployLog item = (DeployLog)JSON.parseObject((String)JSON.toJSONString((Object)latestDocument), DeployLog.class);
                JSONObject compileData = item.getCompileData();
                DeployParamV3 deployParam = item.getDeployParam();
                if (!deployParam.getEnv().equals(deployLogResult.getEnv()) || !deployParam.getEnvServiceId().equals(deployLogResult.getServiceId())) continue;
                deployLogResult.setCompileVersion(compileData.getString("version")).setDate(item.getDate()).setCompileCode(compileData.getString("code"));
                continue block0;
            }
        }
        return result;
    }

    private List<Document> getLatestDeployLog(DeployLogParam deployLogParam, List<DeployLogParam.Env> envs, List<String> result) {
        List criteriaList = envs.stream().map(item -> {
            String env = item.getEnv();
            String serviceId = item.getServiceId();
            return Criteria.where((String)"deployParam.env").is((Object)env).and("deployParam.envServiceId").is((Object)serviceId);
        }).collect(Collectors.toList());
        Criteria criteria = new Criteria();
        criteria.orOperator((Criteria[])ArrayUtil.toArray(criteriaList, Criteria.class));
        Criteria condition = new Criteria();
        ArrayList criteriList = ListUtil.toList((Object[])new Criteria[]{Criteria.where((String)"application").is((Object)deployLogParam.getApplication()), criteria});
        if (CollUtil.isNotEmpty(result)) {
            criteriList.add(Criteria.where((String)"result").in(result));
        }
        condition.andOperator((Criteria[])ArrayUtil.toArray((Collection)criteriList, Criteria.class));
        MatchOperation matchOperation = Aggregation.match((Criteria)condition);
        SortOperation sortOperation = Aggregation.sort((Sort)Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"date")}));
        GroupOperation groupOperation = Aggregation.group((String[])new String[]{"deployParam.env"}).first("$$ROOT").as("latestDocument");
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{matchOperation, sortOperation, groupOperation});
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, "deployLog", Document.class);
        List mappedResults = results.getMappedResults();
        return mappedResults;
    }

    public DeployExecutingInfo queryDeployLog(String application, String envServiceId, String result, String type) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("type").is((Object)type).and("deployParam.envServiceId").is((Object)envServiceId)).with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"date"}));
        DeployLog deployLog = (DeployLog)this.mongoTemplate.findOne(query, DeployLog.class, "deployLog");
        if (deployLog == null) {
            return null;
        }
        DeployExecutingInfo deployExecutingInfo = new DeployExecutingInfo();
        deployExecutingInfo.setDeployTime(deployLog.getDate()).setDeployExecutor(deployLog.getUser()).setDeployNo(deployLog.getDeployNo()).setTargetTenantList(deployLog.getDeployParam().getTenantUsers()).setVersion(deployLog.getCompileData().getString("version")).setDescription(deployLog.getCompileData().getString("description"));
        return deployExecutingInfo;
    }

    public List<AppTenantResult> queryAppTenantResult(String application, String envServiceId, String operate) {
        ArrayList<AppTenantResult> result = new ArrayList<AppTenantResult>();
        TenantPipeLine tenantPipeLine = this.queryTenantPipelineByApplication(application);
        Node node = TenantPipelineHelper.findNodeByServiceId((TenantPipeLine)tenantPipeLine, (String)envServiceId);
        if (node == null) {
            throw new BusinessException("\u627e\u4e0d\u5230\u73af\u5883:" + envServiceId);
        }
        List envs = node.getEnvs();
        String env = envs.stream().filter(item -> operate.equals(item.getOperate())).findAny().orElse(new Env()).getEnv();
        MatchOperation match = Aggregation.match((Criteria)Criteria.where((String)"type").is((Object)operate).and("application").is((Object)application).and("deployParam.env").is((Object)env).and("result").is((Object)"success"));
        UnwindOperation unwind = Aggregation.unwind((String)"deployParam.tenantUsers");
        SortOperation sort = Aggregation.sort((Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"date"}));
        GroupOperation groupOperation = Aggregation.group((String[])new String[]{"deployParam.tenantUsers.tenantId"}).first("compileData.version").as("latestVersion").first("compileData.description").as("description").first("user").as("user").first("date").as("date");
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, unwind, sort, groupOperation});
        AggregationResults deployLogs = this.mongoTemplate.aggregate(aggregation, "deployLog", JSONObject.class);
        List mappedResults = deployLogs.getMappedResults();
        for (JSONObject mappedResult : mappedResults) {
            AppTenantResult appTenantResult = new AppTenantResult().setTenantId(mappedResult.getString("_id")).setDescription(mappedResult.getString("description")).setVersion(mappedResult.getString("latestVersion")).setDeployExecutor((AthenaUser)mappedResult.getJSONObject("user").toJavaObject(AthenaUser.class)).setDeployTime(mappedResult.getDate("date"));
            result.add(appTenantResult);
        }
        return result;
    }

    public List<AppCompileDataResult> queryTestEnvCompileCodeList(List<String> applicationList, String envServiceId) {
        ArrayList<AppCompileDataResult> result = new ArrayList<AppCompileDataResult>();
        for (String application : applicationList) {
            TenantPipeLine tenantPipeLine = this.queryTenantPipelineByApplication(application);
            List parentEnvServiceIdList = TenantPipelineHelper.findAllParentServiceIds((TenantPipeLine)tenantPipeLine, (String)envServiceId);
            if (CollUtil.isNotEmpty((Collection)parentEnvServiceIdList)) {
                String prodEnvLatestCompileCode = this.getProdEnvLatestCompileCode(application, tenantPipeLine, parentEnvServiceIdList);
                List deployLogs = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"deployParam.envServiceId").in((Collection)parentEnvServiceIdList).and("type").is((Object)"publish").and("application").is((Object)application).and("result").is((Object)"success")), DeployLog.class, "deployLog");
                List compileCodeList = deployLogs.stream().filter(item -> item.getCompileData() != null && StrUtil.isNotBlank((CharSequence)item.getCompileData().getString("code"))).map(item -> item.getCompileData().getString("code")).collect(Collectors.toList());
                this.moveProdEnvLatestCompileCodeToFirst(prodEnvLatestCompileCode, compileCodeList);
                AppCompileDataResult appCompileDataResult = new AppCompileDataResult().setApplication(application).setCompileCodeList(compileCodeList);
                result.add(appCompileDataResult);
                continue;
            }
            AppCompileDataResult appCompileDataResult = new AppCompileDataResult().setApplication(application).setCompileCodeList((List)ListUtil.toList((Object[])new String[]{"all"}));
            result.add(appCompileDataResult);
        }
        return result;
    }

    private void moveProdEnvLatestCompileCodeToFirst(String prodEnvLatestCompileCode, List<String> compileCodeList) {
        if (StrUtil.isNotBlank((CharSequence)prodEnvLatestCompileCode)) {
            int index = -1;
            for (int i = 0; i < compileCodeList.size(); ++i) {
                if (!compileCodeList.get(i).equals(prodEnvLatestCompileCode)) continue;
                index = i;
                break;
            }
            if (index > -1) {
                compileCodeList.remove(index);
                compileCodeList.add(0, prodEnvLatestCompileCode);
            }
        }
    }

    private String getProdEnvLatestCompileCode(String application, TenantPipeLine tenantPipeLine, List<String> parentEnvServiceIdList) {
        Node node = TenantPipelineHelper.findNodeByServiceId((TenantPipeLine)tenantPipeLine, (String)parentEnvServiceIdList.get(parentEnvServiceIdList.size() - 1));
        Env envByOperate = node.getEnvByOperate("switch");
        DeployLogParam deployLogParam = new DeployLogParam();
        DeployLogParam.Env env = new DeployLogParam.Env();
        env.setEnv(envByOperate.getEnv());
        env.setServiceId(parentEnvServiceIdList.get(parentEnvServiceIdList.size() - 1));
        env.setOperate(envByOperate.getOperate());
        deployLogParam.setApplication(application).setEnvs((List)ListUtil.toList((Object[])new DeployLogParam.Env[]{env})).setResult((List)ListUtil.toList((Object[])new String[]{"success"}));
        List deployLogResults = this.queryDeployLogByEnv(deployLogParam);
        DeployLogResult deployLogResult = deployLogResults.stream().filter(item -> item.getEnv().equals(env.getEnv())).findAny().orElse(null);
        if (deployLogResult != null) {
            String compileCode = deployLogResult.getCompileCode();
            return compileCode;
        }
        envByOperate = node.getEnvByOperate("publish");
        env.setEnv(envByOperate.getEnv());
        env.setOperate(envByOperate.getOperate());
        deployLogParam.setEnvs((List)ListUtil.toList((Object[])new DeployLogParam.Env[]{env}));
        deployLogResults = this.queryDeployLogByEnv(deployLogParam);
        deployLogResult = deployLogResults.stream().filter(item -> item.getEnv().equals(env.getEnv())).findAny().orElse(null);
        if (deployLogResult != null) {
            String compileCode = deployLogResult.getCompileCode();
            return compileCode;
        }
        return null;
    }

    public List<EnvApp> queryAppListByEnvServiceId(String envServiceId, String operate) {
        if ("publish".equals(operate)) {
            TenantPipeLine tenantPipeLine = this.queryTenantPipelineByOperate(operate);
            List parentServiceIds = TenantPipelineHelper.findAllParentServiceIds((TenantPipeLine)tenantPipeLine, (String)envServiceId);
            if (CollUtil.isEmpty((Collection)parentServiceIds)) {
                return ListUtil.toList((Object[])new EnvApp[]{new EnvApp().setApplication("all")});
            }
            List deployLogs = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"deployParam.envServiceId").in((Collection)parentServiceIds).and("type").is((Object)"publish")), DeployLog.class, "deployLog");
            return this.collectionAppCodeList(deployLogs);
        }
        TenantPipeLine tenantPipeLine = this.queryTenantPipelineByOperate("publish");
        Node node = TenantPipelineHelper.findNodeByServiceId((TenantPipeLine)tenantPipeLine, (String)envServiceId);
        List envs = node.getEnvs();
        Env env = envs.stream().filter(item -> "publish".equals(item.getOperate())).findAny().orElse(null);
        if (env == null) {
            return new ArrayList<EnvApp>();
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"deployParam.env").in(new Object[]{env.getEnv()}).and("type").is((Object)"publish"));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"date"}));
        List deployLogs = this.mongoTemplate.find(query, DeployLog.class, "deployLog");
        return this.collectionAppCodeList(deployLogs);
    }

    public List<com.digiwin.athena.athenadeployer.domain.Env> queryEnvsByOperate(String operate) {
        TenantPipeLine tenantPipeLine = this.queryTenantPipelineByOperate(operate);
        List allEnvs = TenantPipelineHelper.getAllEnvs((TenantPipeLine)tenantPipeLine);
        return this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"env").in((Collection)allEnvs)), com.digiwin.athena.athenadeployer.domain.Env.class, "env");
    }

    public List<Node> queryAllNode() {
        TenantPipeLine tenantPipeLine = this.queryTenantPipelineByOperate("publish");
        return TenantPipelineHelper.getAllNode((TenantPipeLine)tenantPipeLine);
    }

    private List<EnvApp> collectionAppCodeList(List<DeployLog> deployLogs) {
        ArrayList<EnvApp> result = new ArrayList<EnvApp>();
        for (DeployLog deployLog : deployLogs) {
            EnvApp envApp = new EnvApp();
            envApp.setApplication(deployLog.getApplication());
            envApp.setVersion(deployLog.getCompileData().getString("version"));
            envApp.setDescription(deployLog.getCompileData().getString("description"));
            result.add(envApp);
        }
        return result;
    }

    public void filterAuth(Node node, List<com.digiwin.athena.athenadeployer.domain.Env> envsWithAuth, List<DeployServiceInfo> deployServiceInfos) {
        String serviceId = node.getServiceId();
        if (CollUtil.isNotEmpty(deployServiceInfos)) {
            DeployServiceInfo deployServiceInfo = deployServiceInfos.stream().filter(dsi -> dsi.getServiceId().equals(serviceId)).findFirst().orElse(new DeployServiceInfo());
            node.setServiceName(deployServiceInfo.getServiceName());
            node.setLang(deployServiceInfo.getLang());
            node.setFriendlyLinkList(deployServiceInfo.getFriendlyLinkList());
        }
        Iterator iterator = node.getEnvs().iterator();
        while (iterator.hasNext()) {
            com.digiwin.athena.athenadeployer.domain.Env inAuth;
            Env env = (Env)iterator.next();
            if (!env.getVisible().booleanValue()) {
                iterator.remove();
            }
            if ((inAuth = this.inAuth(envsWithAuth, serviceId, env.getEnv())) == null) continue;
            env.setOperate(inAuth.getOperate());
            env.setDisable(Boolean.valueOf(false));
            env.setUrl(inAuth.getUri());
        }
        List children = node.getChildren();
        if (CollUtil.isNotEmpty((Collection)children)) {
            for (Node child : children) {
                this.filterAuth(child, envsWithAuth, deployServiceInfos);
            }
        }
    }

    private com.digiwin.athena.athenadeployer.domain.Env inAuth(List<com.digiwin.athena.athenadeployer.domain.Env> envs, String serviceId, String env) {
        for (com.digiwin.athena.athenadeployer.domain.Env item : envs) {
            if (!item.getEnv().equals(env) || !item.getServiceId().equals(serviceId)) continue;
            return item;
        }
        return null;
    }

    private TenantPipeLine generateSystemPipeLine() {
        DeployServiceInfo sameAreaInfo = this.deployServiceInfoDao.getSameAreaInfo();
        if (sameAreaInfo == null) {
            return new TenantPipeLine().setGroups(new ArrayList());
        }
        List envs = this.envService.queryEnvsByServiceId(sameAreaInfo.getServiceId());
        Node node = new Node().setServiceId(sameAreaInfo.getServiceId()).setServiceName(sameAreaInfo.getServiceName()).setLang(sameAreaInfo.getLang()).setFriendlyLinkList(sameAreaInfo.getFriendlyLinkList());
        ArrayList piplineEnvList = new ArrayList();
        envs.forEach(env -> {
            Env piplineEnv = new Env().setEnv(env.getEnv()).setOperate(env.getOperate()).setUrl(env.getUri());
            piplineEnvList.add(piplineEnv);
        });
        node.setEnvs(piplineEnvList);
        Group group = new Group().setGroupName(sameAreaInfo.getServiceName()).setNode(node);
        TenantPipeLine tenantPipeLineSys = new TenantPipeLine().setTenantId("SYSTEM").setGroups(Arrays.asList(group));
        return this.tenantPipeLineDao.insert(tenantPipeLineSys);
    }

    public TenantPipeLine getTenantPipeLineByTenantId(String tenantId) {
        TenantPipeLine tenantPipeLine = this.tenantPipeLineDao.getTenantPipeLineByTenantId(tenantId);
        if (tenantPipeLine == null) {
            return null;
        }
        List deployServiceInfos = this.deployServiceInfoDao.queryBriefDeployServiceInfo();
        for (Group group : tenantPipeLine.getGroups()) {
            this.filterServiceInfo(group.getNode(), deployServiceInfos);
        }
        return tenantPipeLine;
    }

    private void filterServiceInfo(Node node, List<DeployServiceInfo> deployServiceInfos) {
        List children;
        String serviceId = node.getServiceId();
        if (CollUtil.isNotEmpty(deployServiceInfos)) {
            DeployServiceInfo deployServiceInfo = deployServiceInfos.stream().filter(dsi -> dsi.getServiceId().equals(serviceId)).findFirst().orElse(new DeployServiceInfo());
            node.setServiceName(deployServiceInfo.getServiceName());
            node.setLang(deployServiceInfo.getLang());
            node.setFriendlyLinkList(deployServiceInfo.getFriendlyLinkList());
        }
        if (CollUtil.isNotEmpty((Collection)(children = node.getChildren()))) {
            for (Node child : children) {
                this.filterServiceInfo(child, deployServiceInfos);
            }
        }
    }

    public TenantPipeLine insert(TenantPipeLine tenantPipeLine) {
        TenantPipeLine tpl = this.tenantPipeLineDao.getTenantPipeLineByTenantId(tenantPipeLine.getTenantId());
        if (tpl != null) {
            throw new BusinessException("\u79df\u6237\u7ea7\u6570\u636e\u5df2\u5b58\u5728\uff0c\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return this.tenantPipeLineDao.insert(tenantPipeLine);
    }

    public TenantPipeLine update(TenantPipeLine tenantPipeLine) {
        TenantPipeLine tpl = this.tenantPipeLineDao.getTenantPipeLineByTenantId(tenantPipeLine.getTenantId());
        if (tpl == null) {
            throw new BusinessException("\u79df\u6237\u7ea7\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u66f4\u65b0\u5931\u8d25\uff01");
        }
        tenantPipeLine.setObjectId(tpl.getObjectId());
        return this.tenantPipeLineDao.update(tenantPipeLine);
    }

    public void delete(String tenantId) {
        this.tenantPipeLineDao.delete(tenantId);
    }
}

