/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.config.neo4j.Neo4jManager;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.Env;
import com.digiwin.athena.athenadeployer.domain.TenantApplication;
import com.digiwin.athena.athenadeployer.domain.TenantApplicationParam;
import com.digiwin.athena.athenadeployer.domain.TenantUser;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Node;
import com.digiwin.athena.athenadeployer.dto.deployer.CurrentUserExistInTenantResp;
import com.digiwin.athena.athenadeployer.dto.deployer.Pagination;
import com.digiwin.athena.athenadeployer.dto.deployer.TenantAndEnvReq;
import com.digiwin.athena.athenadeployer.dto.tenant.TenantVersionDto;
import com.digiwin.athena.athenadeployer.http.BackendApiHelper;
import com.digiwin.athena.athenadeployer.http.CacApiHelper;
import com.digiwin.athena.athenadeployer.service.ReleasePipeLineService;
import com.digiwin.athena.athenadeployer.service.TenantService;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class TenantServiceImpl
implements TenantService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantServiceImpl.class);
    @Autowired(required=false)
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate mongoTemplate;
    @Autowired
    private BackendApiHelper backendApiHelper;
    @Autowired
    private ReleasePipeLineService releasePipeLineService;
    @Autowired
    private CacApiHelper cacApiHelper;

    public List<Map<String, Object>> queryAllTenantId() {
        List maps = Neo4jManager.getNeo4jManager().ExecuteQuery("match (tenant:TenantEntity) return tenant.tenantId as tenantId");
        return ListUtil.toList((Collection)maps);
    }

    public List<Map<String, Object>> queryTenantApplication(TenantApplicationParam tenantApplicationParam) {
        String application = tenantApplicationParam.getApplication();
        String tenantId = tenantApplicationParam.getTenantId();
        String version = tenantApplicationParam.getVersion();
        String tenantCql = "match (n:TenantEntity) {} return n.tenantId as tenantId";
        tenantCql = StrUtil.isNotBlank((CharSequence)tenantId) ? StrUtil.format((CharSequence)tenantCql, (Object[])new Object[]{"where n.tenantId =~ '.*" + tenantId + ".*'"}) : StrUtil.format((CharSequence)tenantCql, (Object[])new Object[]{""});
        String appCql = "match (n:AppEntity) {} return properties(n) as app";
        appCql = StrUtil.isNotBlank((CharSequence)application) ? StrUtil.format((CharSequence)appCql, (Object[])new Object[]{"where n.name =~ '.*" + application + ".*'"}) : StrUtil.format((CharSequence)appCql, (Object[])new Object[]{""});
        String tenantAppCql = "match (n:TenantEntity) -[r:USE] -> (m:AppEntity) where n.version = m.version {} return n.tenantId as tenantId,m.code as appCode,m.version as version";
        tenantAppCql = StrUtil.isNotBlank((CharSequence)version) ? StrUtil.format((CharSequence)tenantAppCql, (Object[])new Object[]{"where m.version = '" + version + "'"}) : StrUtil.format((CharSequence)tenantAppCql, (Object[])new Object[]{""});
        List tenantIdIterable = Neo4jManager.getNeo4jManager().ExecuteQuery(tenantCql);
        List appIterable = Neo4jManager.getNeo4jManager().ExecuteQuery(appCql);
        List tenantAppIterable = Neo4jManager.getNeo4jManager().ExecuteQuery(tenantAppCql);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Map map : tenantIdIterable) {
            String tenant = String.valueOf(map.get("tenantId"));
            for (Map appMap : appIterable) {
                JSONObject app = JSON.parseObject((String)JSON.toJSONString(appMap.get("app")));
                String applicationName = app.getString("name");
                String code = app.getString("code");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("applicationName", applicationName);
                hashMap.put("tenantId", tenant);
                hashMap.put("code", code);
                result.add(hashMap);
            }
        }
        block2: for (Map map : result) {
            for (Map tenantApp : tenantAppIterable) {
                String tenant = String.valueOf(map.get("tenantId"));
                String appCode = String.valueOf(map.get("code"));
                if (!tenant.equals(tenantApp.get("tenantId")) || !appCode.equals(tenantApp.get("appCode"))) continue;
                map.put("version", tenantApp.get("version"));
                continue block2;
            }
        }
        return result;
    }

    public List<String> queryAllApplicationTenantId(String application) {
        String cql = "match (n:TenantEntity) -[:USE]-> (m:AppEntity{code:$application}) return n.tenantId as tenantId";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("application", application);
        List maps = Neo4jManager.getNeo4jManager().ExecuteQuery(cql, param);
        ArrayList<String> tenantIdList = new ArrayList<String>();
        for (Map map : maps) {
            tenantIdList.add(String.valueOf(map.get("application")));
        }
        return tenantIdList;
    }

    public List<TenantApplication> queryByApplication(String application) {
        FindIterable documents = this.mongoTemplate.getCollection("tenant_application").find(Filters.eq((String)"application", (Object)application));
        ArrayList<TenantApplication> tenantApplicationList = new ArrayList<TenantApplication>();
        for (Document document : documents) {
            TenantApplication tenantApplication = new TenantApplication();
            tenantApplication.setApplication(document.getString((Object)"application"));
            tenantApplication.setTenantId(document.getString((Object)"tenantId"));
            tenantApplicationList.add(tenantApplication);
        }
        return tenantApplicationList;
    }

    public void addTenantApplication(String tenantId, String application) {
        TenantApplication tenantApplication = new TenantApplication();
        tenantApplication.setApplication(application);
        tenantApplication.setTenantId(tenantId);
        Document document = Document.parse((String)JSON.toJSONString((Object)tenantApplication));
        this.mongoTemplate.getCollection("tenant_application").insertOne((Object)document);
    }

    public List<CurrentUserExistInTenantResp> queryCurrentUserExistInTenantList(TenantAndEnvReq tenantAndEnvReq) {
        List tenantIdList = tenantAndEnvReq.getTenantIdList();
        String env = tenantAndEnvReq.getEnv();
        ArrayList<CurrentUserExistInTenantResp> currentUserExistInTenants = new ArrayList<CurrentUserExistInTenantResp>();
        if (CollectionUtils.isEmpty((Collection)tenantIdList) || StrUtil.isEmpty((CharSequence)env)) {
            return currentUserExistInTenants;
        }
        try {
            AthenaUser user = AthenaUserLocal.getUser();
            tenantIdList.forEach(tenantId -> {
                boolean re = this.backendApiHelper.currentUserExistInTenant(user.getUserId(), tenantId, user.getToken(), env);
                currentUserExistInTenants.add(new CurrentUserExistInTenantResp().setTenantId(tenantId).setExistUser(Boolean.valueOf(re)));
            });
            return currentUserExistInTenants;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5f53\u524d\u7528\u6237\u662f\u5426\u5728\u79df\u6237\u7528\u6237\u5217\u8868\u5931\u8d25:", (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
    }

    public Pagination queryTenantVersionByTenantId(String tenantId, String envServiceId, Integer pageNum, Integer pageSize) {
        List envs = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"serviceId").is((Object)envServiceId)), Env.class, "env");
        if (CollUtil.isEmpty((Collection)envs)) {
            throw new BusinessException("\u627e\u4e0d\u5230\u73af\u5883");
        }
        Object dataObj = StrUtil.isEmpty((CharSequence)tenantId) ? this.backendApiHelper.queryTenantVersionBySameCustomId(AthenaUserLocal.getUser().getTenantId(), ((Env)envs.get(0)).getEnv()) : this.backendApiHelper.queryTenantVersion(tenantId, ((Env)envs.get(0)).getEnv());
        if (ObjectUtils.isEmpty((Object)dataObj)) {
            return Pagination.builder().curPageNum(pageNum).totalPageNum(Integer.valueOf(0)).limit(pageSize).total(Long.valueOf(0L)).data(new ArrayList()).build();
        }
        return this.handlePageAddEnvData(dataObj, envServiceId, pageNum, pageSize);
    }

    public Pagination queryAppRelatenantVersion(String appCode, String env, Integer pageNum, Integer pageSize) {
        Object dataObj = this.backendApiHelper.queryAppRelatenantVersion(appCode, env);
        if (ObjectUtils.isEmpty((Object)dataObj)) {
            return Pagination.builder().curPageNum(pageNum).totalPageNum(Integer.valueOf(0)).limit(pageSize).total(Long.valueOf(0L)).data(new ArrayList()).build();
        }
        return this.handlePageAddEnvData(dataObj, env, pageNum, pageSize);
    }

    private Pagination handlePageAddEnvData(Object dataObj, String envServiceId, Integer pageNum, Integer pageSize) {
        List tenantVersionDtos = JSONObject.parseArray((String)JSON.toJSONString((Object)dataObj), TenantVersionDto.class);
        int total = tenantVersionDtos.size();
        int totalPageNum = (int)Math.ceil((double)total / (double)pageSize.intValue());
        Pagination pagination = Pagination.builder().curPageNum(pageNum).totalPageNum(Integer.valueOf(totalPageNum)).limit(pageSize).total(Long.valueOf(total)).data(new ArrayList()).build();
        if (pageNum > totalPageNum) {
            return pagination;
        }
        List data = pageNum * pageSize > total ? tenantVersionDtos.subList((pageNum - 1) * pageSize, total) : tenantVersionDtos.subList((pageNum - 1) * pageSize, pageNum * pageSize);
        List nodes = this.releasePipeLineService.queryAllNode();
        Node node = nodes.stream().filter(item -> item.getServiceId().equals(envServiceId)).findAny().orElse(null);
        if (node != null) {
            data.forEach(da -> da.setEnvName(node.getServiceName()));
        }
        pagination.setData(data);
        return pagination;
    }

    public List<TenantUser> getTenantByGoodsCode(String token, String goodsCode) {
        return this.cacApiHelper.getTenantByGoodsCode(token, goodsCode);
    }
}

