/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.service.itda.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.config.ModuleConfig;
import com.digiwin.athena.athenadeployer.config.neo4j.Neo4jManager;
import com.digiwin.athena.athenadeployer.dto.itda.ITDAPublishHistoryDTO;
import com.digiwin.athena.athenadeployer.dto.itda.PublishITDADTO;
import com.digiwin.athena.athenadeployer.service.IAMService;
import com.digiwin.athena.athenadeployer.service.itda.ITDAService;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class ITDAServiceImpl
implements ITDAService {
    @Generated
    private static final Logger log = LogManager.getLogger(ITDAServiceImpl.class);
    @Resource(name="itdaMongoTemplate")
    private MongoTemplate itdaMongoTemplate;
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate deployerMongoTemplate;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private ModuleConfig moduleConfig;
    @Autowired
    private IAMService iamService;
    @Autowired
    private RestTemplate restTemplate;

    public void publishITDAAthenaData(String code, List<String> tenantIdList) {
        String ITDAversion = "1.0";
        Bson bson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"dataPackage_ITDA", (Object)code), Filters.eq((String)"version", (Object)ITDAversion)});
        FindIterable taskDocument = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("task").find(bson);
        AtomicInteger dataCount = new AtomicInteger();
        taskDocument.forEach(document -> dataCount.getAndIncrement());
        Bson itdaBson = Filters.eq((String)"dataPackageItda", (Object)code);
        ArrayList ITDAAthenaDataList = new ArrayList();
        FindIterable action = this.itdaMongoTemplate.getCollection("action").find(itdaBson);
        HashMap<String, Object> actionMap = new HashMap<String, Object>();
        actionMap.put("data", action);
        actionMap.put("db", "neo4j");
        actionMap.put("labelPK", "actionId");
        ITDAAthenaDataList.add(actionMap);
        FindIterable activity = this.itdaMongoTemplate.getCollection("activity").find(itdaBson);
        HashMap<String, Object> activityMap = new HashMap<String, Object>();
        activityMap.put("data", activity);
        activityMap.put("db", "datamap");
        activityMap.put("collection", "activity");
        ITDAAthenaDataList.add(activityMap);
        FindIterable rules = this.itdaMongoTemplate.getCollection("rules").find(itdaBson);
        HashMap<String, Object> rulesMap = new HashMap<String, Object>();
        rulesMap.put("data", rules);
        rulesMap.put("db", "preset");
        rulesMap.put("collection", "rules");
        ITDAAthenaDataList.add(rulesMap);
        FindIterable bkInfo = this.itdaMongoTemplate.getCollection("bkInfo").find(itdaBson);
        HashMap<String, Object> bkInfoMap = new HashMap<String, Object>();
        bkInfoMap.put("data", bkInfo);
        bkInfoMap.put("db", "knowledgegraphSystem");
        bkInfoMap.put("collection", "bkInfo");
        ITDAAthenaDataList.add(bkInfoMap);
        FindIterable dataDescription = this.itdaMongoTemplate.getCollection("dataDescription").find(itdaBson);
        HashMap<String, Object> dataDescriptionMap = new HashMap<String, Object>();
        dataDescriptionMap.put("data", dataDescription);
        dataDescriptionMap.put("db", "datamap");
        dataDescriptionMap.put("collection", "dataDescription");
        ITDAAthenaDataList.add(dataDescriptionMap);
        FindIterable dataState = this.itdaMongoTemplate.getCollection("dataState").find(itdaBson);
        HashMap<String, Object> dataStateMap = new HashMap<String, Object>();
        dataStateMap.put("data", dataState);
        dataStateMap.put("db", "datamap");
        dataStateMap.put("collection", "dataState");
        ITDAAthenaDataList.add(dataStateMap);
        FindIterable flowGraph = this.itdaMongoTemplate.getCollection("flowGraph").find(itdaBson);
        HashMap<String, Object> flowGraphMap = new HashMap<String, Object>();
        flowGraphMap.put("data", flowGraph);
        flowGraphMap.put("db", "datamap");
        flowGraphMap.put("collection", "flowGraph");
        ITDAAthenaDataList.add(flowGraphMap);
        FindIterable monitorRuleAdapter = this.itdaMongoTemplate.getCollection("monitorRuleAdapter").find(itdaBson);
        HashMap<String, Object> monitorRuleAdapterMap = new HashMap<String, Object>();
        monitorRuleAdapterMap.put("data", monitorRuleAdapter);
        monitorRuleAdapterMap.put("db", "datamap");
        monitorRuleAdapterMap.put("collection", "monitorRuleAdapter");
        ITDAAthenaDataList.add(monitorRuleAdapterMap);
        FindIterable monitorRuleProduct = this.itdaMongoTemplate.getCollection("monitorRuleProduct").find(itdaBson);
        HashMap<String, Object> monitorRuleProductMap = new HashMap<String, Object>();
        monitorRuleProductMap.put("data", monitorRuleProduct);
        monitorRuleProductMap.put("db", "knowledgegraphSystem");
        monitorRuleProductMap.put("collection", "monitorRuleProductConfig");
        ITDAAthenaDataList.add(monitorRuleProductMap);
        FindIterable monitorRule = this.itdaMongoTemplate.getCollection("monitorRule").find(itdaBson);
        HashMap<String, Object> monitorRuleMap = new HashMap<String, Object>();
        monitorRuleMap.put("data", monitorRule);
        monitorRuleMap.put("db", "neo4j");
        monitorRuleMap.put("labelPK", "code");
        ITDAAthenaDataList.add(monitorRuleMap);
        FindIterable pageView = this.itdaMongoTemplate.getCollection("pageView").find(itdaBson);
        HashMap<String, Object> pageViewMap = new HashMap<String, Object>();
        pageViewMap.put("data", pageView);
        pageViewMap.put("db", "datamap");
        pageViewMap.put("collection", "pageView");
        ITDAAthenaDataList.add(pageViewMap);
        FindIterable project = this.itdaMongoTemplate.getCollection("project").find(itdaBson);
        HashMap<String, Object> projectMap = new HashMap<String, Object>();
        projectMap.put("data", project);
        projectMap.put("db", "datamap");
        projectMap.put("collection", "project");
        ITDAAthenaDataList.add(projectMap);
        FindIterable task = this.itdaMongoTemplate.getCollection("task").find(itdaBson);
        HashMap<String, Object> taskMap = new HashMap<String, Object>();
        taskMap.put("data", task);
        taskMap.put("db", "datamap");
        taskMap.put("collection", "task");
        ITDAAthenaDataList.add(taskMap);
        if (dataCount.get() < 1) {
            log.info("===========\u5f00\u59cb\u65b0\u589eITDA:" + code + "==========");
            this.addITDAAthenaData(ITDAAthenaDataList, code, ITDAversion);
        } else {
            log.info("===========\u5f00\u59cb\u66f4\u65b0ITDA:" + code + "==========");
            this.updateITDAAthenaData(ITDAAthenaDataList, code, ITDAversion);
        }
        log.info("===========\u5f00\u59cb\u66f4\u65b0ITDA\u79df\u6237\u7ed1\u5b9a\u5173\u7cfb==========");
        this.createTenantEntityDependency(code, tenantIdList, ITDAversion);
        log.info("===========\u66f4\u65b0\u4fa6\u6d4b==========");
        this.updateMonitorRule(code, tenantIdList, monitorRule, monitorRuleProduct);
    }

    private void updateMonitorRule(String code, List<String> tenantIdList, FindIterable<Document> monitorRule, FindIterable<Document> monitorRuleProduct) {
        String tenantToken = this.iamService.getTenantToken();
        tenantIdList.forEach(tenantId -> monitorRule.forEach(document -> {
            AtomicReference<String> productName = new AtomicReference<String>("");
            monitorRuleProduct.forEach(documentProduct -> {
                if (documentProduct.get((Object)"monitorRuleId").equals(document.get((Object)"code"))) {
                    productName.set(documentProduct.getString((Object)"productName"));
                }
            });
            String url = this.moduleConfig.getKm().getDomain() + "/restful/service/knowledgegraph/MonitorRuleConfig";
            HttpHeaders httpHeaders = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            httpHeaders.setContentType(type);
            httpHeaders.add("token", tenantToken);
            httpHeaders.add("routerKey", tenantId);
            JSONObject body = new JSONObject();
            JSONObject config = new JSONObject();
            config.put("configId", (Object)"configId");
            config.put("tenantId", tenantId);
            config.put("monitorRuleId", document.get((Object)"code"));
            config.put("productName", (Object)productName.get());
            config.put("status", (Object)1);
            config.put("standardPollingRule", (Object)JSONObject.parseObject((String)((String)document.get((Object)"standardPollingRule"))));
            body.put("config", (Object)config);
            HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
            log.info("km updateMonitorRule request:{}", (Object)httpEntity);
            ResponseEntity exchange = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, Object.class, new Object[0]);
            log.info("km updateMonitorRule response:{}", (Object)exchange);
        }));
    }

    public void addITDAAthenaData(List<Map<String, Object>> ITDAAthenaDataList, String code, String ITDAversion) {
        HashMap relationTableMap = new HashMap();
        ITDAAthenaDataList.forEach(ITDAAthenaData -> {
            AtomicBoolean hasData = new AtomicBoolean(false);
            FindIterable documents = (FindIterable)ITDAAthenaData.get("data");
            String db = (String)ITDAAthenaData.get("db");
            if ("neo4j".equals(db)) {
                String labelPK = (String)ITDAAthenaData.get("labelPK");
                documents.forEach(document -> {
                    hasData.set(true);
                    document.remove((Object)"_id");
                    String json = document.toJson();
                    this.executeNode(json, code, labelPK, ITDAversion, relationTableMap);
                });
            } else {
                String collection = (String)ITDAAthenaData.get("collection");
                documents.forEach(document -> {
                    hasData.set(true);
                    document.remove((Object)"_id");
                    document.put("dataPackage_ITDA", (Object)code);
                    document.put("athena_namespace", (Object)"ITDA");
                    document.put("version", (Object)ITDAversion);
                    this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(db).getCollection(collection).insertOne(document);
                });
            }
            if (!hasData.get()) {
                log.info("===========" + String.valueOf(ITDAAthenaData.get("db")) + String.valueOf(ITDAAthenaData.get("collection")) + String.valueOf(ITDAAthenaData.get("labelPK")) + "\u6570\u636e\u83b7\u53d6\u4e3a\u7a7a\u8bf7\u68c0\u67e5==========");
            }
        });
        JSONObject neo4jNodeKeyJson = new JSONObject();
        neo4jNodeKeyJson.put("Action", (Object)"actionId");
        neo4jNodeKeyJson.put("MonitorRule", (Object)"code");
        this.executeNodeRelationTable(neo4jNodeKeyJson, relationTableMap);
    }

    public void updateITDAAthenaData(List<Map<String, Object>> ITDAAthenaDataList, String code, String ITDAversion) {
        ITDAAthenaDataList.forEach(ITDAAthenaData -> {
            FindIterable documents = (FindIterable)ITDAAthenaData.get("data");
            String db = (String)ITDAAthenaData.get("db");
            if (!"neo4j".equals(db)) {
                String collection = (String)ITDAAthenaData.get("collection");
                Bson itdaBson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"dataPackage_ITDA", (Object)code), Filters.eq((String)"version", (Object)ITDAversion)});
                this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(db).getCollection(collection).deleteMany(itdaBson);
            }
        });
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("dataPackage_ITDA", code);
        param.put("version", ITDAversion);
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("match (node{athena_namespace:'ITDA',dataPackage_ITDA:$dataPackage_ITDA,version:$version}) where not any(label in labels(node) WHERE label in ['TenantEntity','AppEntity']) detach delete node", param);
        this.addITDAAthenaData(ITDAAthenaDataList, code, ITDAversion);
    }

    private void executeNode(String node, String code, String labelPK, String version, Map<JSONObject, JSONArray> relationTableMap) {
        JSONObject nodeJson = JSON.parseObject((String)node);
        JSONArray labels = nodeJson.getJSONArray("labels");
        JSONArray relationTables = nodeJson.getJSONArray("relationTable");
        StringBuffer nodeCypher = new StringBuffer("create (node");
        labels.forEach(label -> nodeCypher.append(String.format(":%s", label)));
        nodeCypher.append("{");
        Set nodeProperties = nodeJson.entrySet();
        nodeProperties.stream().filter(nodeProperty -> !"application".equals(nodeProperty.getKey()) && !"version".equals(nodeProperty.getKey()) && !"nameSpace".equals(nodeProperty.getKey()) && !"labels".equals(nodeProperty.getKey()) && !"relationTable".equals(nodeProperty.getKey())).forEach(nodeProperty -> {
            if (nodeProperty.getValue() instanceof String) {
                nodeCypher.append(String.format("%s:'%s',", nodeProperty.getKey(), nodeProperty.getValue()));
            } else {
                nodeCypher.append(String.format("%s:%s,", nodeProperty.getKey(), nodeProperty.getValue()));
            }
        });
        nodeCypher.append(String.format("athena_namespace:'ITDA',dataPackage_ITDA:'%s',tenantId:'%s',version:'%s'})", code, code, version));
        Neo4jManager.getNeo4jManager().ExecuteNoQuery(nodeCypher.toString());
        JSONObject nodeKey = new JSONObject();
        nodeKey.put("label", labels.get(0));
        nodeKey.put("labelPK", nodeJson.get((Object)labelPK));
        if (relationTables != null) {
            relationTableMap.put(nodeKey, relationTables);
        }
    }

    private void executeNodeRelationTable(JSONObject neo4jNodeKeyJson, Map<JSONObject, JSONArray> relationTableMap) {
        for (Map.Entry<JSONObject, JSONArray> entry : relationTableMap.entrySet()) {
            JSONObject fromNodeJson = entry.getKey();
            JSONArray toNodesJson = entry.getValue();
            toNodesJson.forEach(toNodeJson -> {
                String cypher = String.format("match (fromNode:%s) where fromNode.%s='%s' and fromNode.athena_namespace='ITDA' match(toNode:%s) where toNode.%s='%s' merge (fromNode)-[:%s]->(toNode)", fromNodeJson.get((Object)"label"), neo4jNodeKeyJson.getString(fromNodeJson.getString("label")), fromNodeJson.get((Object)"labelPK"), ((JSONObject)toNodeJson).get((Object)"targetLabel"), neo4jNodeKeyJson.getString(((JSONObject)toNodeJson).getString("targetLabel")), ((JSONObject)toNodeJson).get((Object)"targetId"), ((JSONObject)toNodeJson).get((Object)"type"));
                Neo4jManager.getNeo4jManager().ExecuteNoQuery(cypher);
            });
        }
    }

    private void createTenantEntityDependency(String code, List<String> tenantIdList, String ITDAversion) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantIdList", tenantIdList);
        param.put("code", code);
        param.put("version", ITDAversion);
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("match(t:TenantEntity) where t.tenantId in $tenantIdList match(action:Action) where action.athena_namespace='ITDA' and action.dataPackage_ITDA=$code and action.version=$version merge (t)-[:ACTION]->(action)", param);
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("match(t:TenantEntity) where t.tenantId in $tenantIdList match(monitorRule:MonitorRule) where monitorRule.athena_namespace='ITDA' and monitorRule.dataPackage_ITDA=$code and monitorRule.version=$version merge (t)-[:USE]->(monitorRule)", param);
    }

    public List<String> getITDAPublishedTenantByCode(String code) {
        ArrayList<String> tenantList = new ArrayList<String>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("code", code);
        List ITDATenantList = Neo4jManager.getNeo4jManager().ExecuteQuery("match(t:TenantEntity)-[:USE]->(monitorRule:MonitorRule) where monitorRule.athena_namespace='ITDA' and monitorRule.dataPackage_ITDA=$code return t.tenantId as tenantId", param);
        ITDATenantList.forEach(tenant -> tenantList.add((String)tenant.get("tenantId")));
        return tenantList;
    }

    public List<String> getITDAOpenTenantByCodeAndTenantList(String code, List<String> tenantIdList) {
        ArrayList<String> openTenantList = new ArrayList<String>();
        tenantIdList.forEach(tenantId -> {
            String url = this.moduleConfig.getKm().getDomain() + "/restful/service/knowledgegraph/monitorRuleConfig?ruleId=monitorRule_" + code + "&tenantId=" + tenantId;
            HttpHeaders httpHeaders = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            httpHeaders.setContentType(type);
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)httpHeaders);
            ResponseEntity monitorRuleConfig = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, Map.class, new Object[0]);
            log.info("km getMonitorRuleConfig response:{}", (Object)monitorRuleConfig);
            Object response = ((Map)monitorRuleConfig.getBody()).get("response");
            if (!ObjectUtils.isEmpty(response) && ((Map)response).get("status").equals(1)) {
                openTenantList.add((String)tenantId);
            }
        });
        return openTenantList;
    }

    public void addITDAPublishHistory(String code, List<String> tenantIdList) {
        Document document = new Document();
        document.put("code", (Object)code);
        document.put("tenantList", tenantIdList);
        document.put("publishDate", (Object)new Date());
        this.deployerMongoTemplate.getCollection("ITDAPublishHistory").insertOne((Object)document);
    }

    public List<ITDAPublishHistoryDTO> getITDAPublishHistory(String code) {
        ArrayList<ITDAPublishHistoryDTO> ITDAPublishHistory = new ArrayList<ITDAPublishHistoryDTO>();
        Bson bson = Filters.eq((String)"code", (Object)code);
        FindIterable documents = this.deployerMongoTemplate.getCollection("ITDAPublishHistory").find(bson);
        documents.forEach(document -> {
            ITDAPublishHistoryDTO itdaPublishHistoryDTO = (ITDAPublishHistoryDTO)JSONObject.parseObject((String)document.toJson(), ITDAPublishHistoryDTO.class);
            ITDAPublishHistory.add(itdaPublishHistoryDTO);
        });
        return ITDAPublishHistory;
    }

    public void updateITDATenantState(PublishITDADTO publishITDADTO) {
        String tenantToken = this.iamService.getTenantToken();
        List tenantIdList = publishITDADTO.getTenantId();
        for (String tenantId : tenantIdList) {
            String getUrl = this.moduleConfig.getKm().getDomain() + "/restful/service/knowledgegraph/monitorRuleConfig?ruleId=monitorRule_" + publishITDADTO.getCode() + "&tenantId=" + tenantId;
            HttpHeaders getHttpHeaders = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            getHttpHeaders.setContentType(type);
            HttpEntity getHttpEntity = new HttpEntity((MultiValueMap)getHttpHeaders);
            ResponseEntity monitorRuleConfig = this.restTemplate.exchange(getUrl, HttpMethod.GET, getHttpEntity, Map.class, new Object[0]);
            log.info("km getMonitorRuleConfig response:{}", (Object)monitorRuleConfig);
            Object response = ((Map)monitorRuleConfig.getBody()).get("response");
            if (ObjectUtils.isEmpty(response)) {
                throw new IllegalArgumentException(tenantId + " is not published," + publishITDADTO.getCode() + " is unable to open temporarily");
            }
            String url = this.moduleConfig.getKm().getDomain() + "/restful/service/knowledgegraph/MonitorRuleConfig";
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.setContentType(type);
            httpHeaders.add("token", tenantToken);
            httpHeaders.add("routerKey", tenantId);
            JSONObject body = new JSONObject();
            JSONObject config = new JSONObject();
            config.put("configId", (Object)"configId");
            config.put("tenantId", (Object)tenantId);
            config.put("monitorRuleId", (Object)("monitorRule_" + publishITDADTO.getCode()));
            config.put("productName", ((Map)response).get("productName"));
            config.put("status", (Object)("enable".equals(publishITDADTO.getState()) ? 1 : 0));
            config.put("standardPollingRule", ((Map)response).get("standardPollingRule"));
            body.put("config", (Object)config);
            HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
            log.info("km updateMonitorRule request:{}", (Object)httpEntity);
            ResponseEntity exchange = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, Object.class, new Object[0]);
            log.info("km updateMonitorRule response:{}", (Object)exchange);
        }
    }
}

