/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.config.neo4j.Neo4jManager;
import com.digiwin.athena.athenadeployer.domain.Cql;
import com.digiwin.athena.athenadeployer.domain.MongoData;
import com.digiwin.athena.athenadeployer.neo4j.CqlMapper;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import com.digiwin.athena.athenadeployer.utils.SafeFileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * Exception performing whole class analysis ignored.
 */
public class DeployUtil {
    public static List<MongoData> getMongoDataFromLocal(String application, String version) {
        ArrayList<MongoData> mongoDataList = new ArrayList<MongoData>();
        File applicationFile = SafeFileUtils.createFile((String)(FileUtils.gitFilePath + "athenaData/" + application + "/mongo"));
        File[] mongoDbsFile = applicationFile.listFiles();
        if (mongoDbsFile == null) {
            return new ArrayList<MongoData>();
        }
        for (File mongoDbFile : mongoDbsFile) {
            File[] mongoCollectionsFile;
            String directorName = mongoDbFile.getName();
            for (File mongoCollectionFile : mongoCollectionsFile = mongoDbFile.listFiles()) {
                File[] mongoDocumentsFile;
                String fileName = mongoCollectionFile.getName();
                for (File mongoDocumentFile : mongoDocumentsFile = mongoCollectionFile.listFiles()) {
                    JSONObject jsonObject = (JSONObject)FileUtils.readObjectFromFilePath2((String)mongoDocumentFile.getPath(), JSONObject.class);
                    jsonObject.put("athena_namespace", (Object)application);
                    jsonObject.put("version", (Object)version);
                    MongoData mongoData = new MongoData().setData(jsonObject).setCollectionName(fileName).setDbName(directorName);
                    mongoDataList.add(mongoData);
                }
            }
        }
        return mongoDataList;
    }

    public static List<Cql> getNeo4jDataFromLocal(String application, String tenantId, String version) {
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        JSONObject neo4jNodeKeyJson = (JSONObject)FileUtils.readObjectFromFilePath((String)"neo4jNodeKey.json", JSONObject.class);
        ArrayList labelList = new ArrayList();
        HashMap newNode = new HashMap();
        HashMap modifiedNode = new HashMap();
        DeployUtil.filterCreateAndModifyNode((String)application, (JSONObject)neo4jNodeKeyJson, labelList, newNode, modifiedNode);
        List deleteRelationCqlList = DeployUtil.deleteTenantRelation((String)tenantId, (String)application, (String)version, labelList);
        DeployUtil.cqlStr2Cql((List)deleteRelationCqlList, cqlList);
        List createNodeCql = DeployUtil.createNode(newNode);
        createNodeCql.addAll(DeployUtil.createNode(modifiedNode));
        DeployUtil.cqlStr2Cql((List)createNodeCql, cqlList);
        Map nodeRelation = DeployUtil.getRelationNodes((String)application, (JSONObject)neo4jNodeKeyJson, newNode, (String)version);
        Map modifyNodeRelation = DeployUtil.getRelationNodes((String)application, (JSONObject)neo4jNodeKeyJson, modifiedNode, (String)version);
        nodeRelation.putAll(modifyNodeRelation);
        List relationCypherList = DeployUtil.getRelationCypherList((JSONObject)neo4jNodeKeyJson, (Map)nodeRelation);
        DeployUtil.cqlStr2Cql((List)relationCypherList, cqlList);
        List createRelationList = DeployUtil.createRelation((JSONObject)neo4jNodeKeyJson, newNode);
        createRelationList.addAll(DeployUtil.createRelation((JSONObject)neo4jNodeKeyJson, modifiedNode));
        DeployUtil.cqlStr2Cql((List)createRelationList, cqlList);
        List tenantNodeRelationCqlList = DeployUtil.createTenantNodeRelation((String)tenantId, (String)application);
        cqlList.addAll(tenantNodeRelationCqlList);
        return cqlList;
    }

    private static void cqlStr2Cql(List<String> deleteRelationCqlList, List<Cql> cqlList) {
        for (String cqlStr : deleteRelationCqlList) {
            Cql cql = new Cql();
            cql.setCql(cqlStr);
            cqlList.add(cql);
        }
    }

    private static Map<JSONObject, JSONArray> getRelationNodes(String application, JSONObject neo4jNodeKeyJson, Map<String, List<JSONObject>> newNode, String version) {
        HashMap<JSONObject, JSONArray> relationTableMap = new HashMap<JSONObject, JSONArray>();
        Set<Map.Entry<String, List<JSONObject>>> entries = newNode.entrySet();
        for (Map.Entry<String, List<JSONObject>> entry : entries) {
            String labelName = entry.getKey();
            String labelPk = neo4jNodeKeyJson.getString(labelName);
            List<JSONObject> nodes = entry.getValue();
            for (JSONObject node : nodes) {
                JSONArray relationTableArray = node.getJSONArray("relationTable");
                if (!CollUtil.isNotEmpty((Collection)relationTableArray)) continue;
                JSONObject nodeKey = new JSONObject();
                nodeKey.put("label", node.getJSONArray("labels").get(0));
                nodeKey.put("labelPK", node.get((Object)labelPk));
                nodeKey.put("application", (Object)application);
                nodeKey.put("version", (Object)version);
                relationTableMap.put(nodeKey, relationTableArray);
            }
        }
        return relationTableMap;
    }

    public static List<String> getRelationCypherList(JSONObject neo4jNodeKeyJson, Map<JSONObject, JSONArray> relationTableMap) {
        ArrayList<String> relationCypherList = new ArrayList<String>();
        for (Map.Entry<JSONObject, JSONArray> entry : relationTableMap.entrySet()) {
            JSONObject fromNodeJson = entry.getKey();
            JSONArray toNodesJson = entry.getValue();
            toNodesJson.forEach(toNodeJson -> {
                StringBuffer relationCypher = new StringBuffer(String.format("match (fromNode:%s) where fromNode.%s=", fromNodeJson.get((Object)"label"), neo4jNodeKeyJson.getString(fromNodeJson.getString("label"))));
                if (fromNodeJson.get((Object)"labelPK") instanceof String) {
                    relationCypher.append(String.format("'%s'", fromNodeJson.get((Object)"labelPK")));
                } else {
                    relationCypher.append(String.format("%s", fromNodeJson.get((Object)"labelPK")));
                }
                relationCypher.append(String.format(" and fromNode.athena_namespace='%s' and fromNode.version='%s' match(toNode:%s) where toNode.%s=", fromNodeJson.get((Object)"application"), fromNodeJson.get((Object)"version"), ((JSONObject)toNodeJson).get((Object)"targetLabel"), neo4jNodeKeyJson.getString(((JSONObject)toNodeJson).getString("targetLabel"))));
                if (((JSONObject)toNodeJson).get((Object)"targetId") instanceof String) {
                    relationCypher.append(String.format("'%s'", ((JSONObject)toNodeJson).get((Object)"targetId")));
                } else {
                    relationCypher.append(String.format("%s", ((JSONObject)toNodeJson).get((Object)"targetId")));
                }
                relationCypher.append(String.format(" and toNode.version='%s' merge (fromNode)-[:%s]->(toNode)", fromNodeJson.get((Object)"version"), ((JSONObject)toNodeJson).get((Object)"type")));
                relationCypherList.add(relationCypher.toString());
            });
        }
        return relationCypherList;
    }

    private static void filterCreateAndModifyNode(String application, JSONObject neo4jNodeKeyJson, List<String> labelList, Map<String, List<JSONObject>> newNode, Map<String, List<JSONObject>> modifiedNode) {
        String cql = "match (n:{}) where n.{} = '{}' return count(n) as count";
        File applicationFile = SafeFileUtils.createFile((String)(FileUtils.gitFilePath + "athenaData/" + application + "/neo4j"));
        File[] labelFiles = applicationFile.listFiles();
        if (labelFiles == null) {
            return;
        }
        HashSet labelSet = new HashSet();
        for (File labelFile : labelFiles) {
            File[] nodeFiles;
            for (File nodeFile : nodeFiles = labelFile.listFiles()) {
                String json = FileUtil.readString((File)nodeFile, (String)"utf-8");
                JSONObject node = JSON.parseObject((String)json);
                List labels = node.getJSONArray("labels").toJavaList(String.class);
                labelSet.addAll(labels);
                for (String labelName : labels) {
                    List<JSONObject> nodes;
                    String labelPk = neo4jNodeKeyJson.getString(labelName);
                    String pkValue = node.getString(labelPk);
                    String formatCql = StrUtil.format((CharSequence)cql, (Object[])new Object[]{labelName, labelPk, pkValue});
                    List query = Neo4jManager.getNeo4jManager().ExecuteQuery(formatCql);
                    Long count = (Long)((Map)query.get(0)).get("count");
                    if (count != null && count > 0L) {
                        nodes = modifiedNode.get(labelName);
                        if (nodes == null) {
                            nodes = new ArrayList<JSONObject>();
                        }
                        nodes.add(node);
                        modifiedNode.put(labelName, nodes);
                        continue;
                    }
                    nodes = newNode.get(labelName);
                    if (nodes == null) {
                        nodes = new ArrayList<JSONObject>();
                    }
                    nodes.add(node);
                    newNode.put(labelName, nodes);
                }
            }
        }
        labelList.addAll(labelSet);
    }

    private static List<String> deleteTenantRelation(String tenantId, String application, String version, List<String> labelList) {
        ArrayList<String> deleteRelationCqlList = new ArrayList<String>();
        for (String labelName : labelList) {
            String relationName = "MonitorRule".equals(labelName) ? "USE" : labelName.toUpperCase();
            String deleteRelationCql = "MATCH (t:TenantEntity{tenantId:'{}'}) -[r:{}]->(n:{}{nameSpace:'{}',version:'{}'}) delete r";
            String deleteRelationCqlFormat = StrUtil.format((CharSequence)deleteRelationCql, (Object[])new Object[]{tenantId, relationName, labelName, application, version});
            deleteRelationCqlList.add(deleteRelationCqlFormat);
        }
        return deleteRelationCqlList;
    }

    private static List<String> createRelation(JSONObject neo4jNodeKeyJson, Map<String, List<JSONObject>> newNode) {
        ArrayList<String> createRelationCqlList = new ArrayList<String>();
        newNode.forEach((labelName, nodes) -> {
            String relationName = "MonitorRule".equals(labelName) ? "USE" : labelName.toUpperCase();
            String existsRelationCql = StrUtil.format((CharSequence)"MATCH p=()-[r:{}]->() RETURN count(p) as count", (Object[])new Object[]{relationName});
            List query = Neo4jManager.getNeo4jManager().ExecuteQuery(existsRelationCql);
            Long count = (Long)((Map)query.get(0)).get("count");
            if (count > 0L) {
                String labelPk = neo4jNodeKeyJson.getString(labelName);
                for (JSONObject node : nodes) {
                    String createRelationCql = "match (te:TenantEntity{tenantId:$tenantId}) match(n:{}) where n.{}='{}' merge (te)-[:{}]->(n)";
                    String createRelationCqlFormat = StrUtil.format((CharSequence)createRelationCql, (Object[])new Object[]{labelName, labelPk, node.getString(labelPk), relationName});
                    createRelationCqlList.add(createRelationCqlFormat);
                }
            }
        });
        return createRelationCqlList;
    }

    private static List<String> createNode(Map<String, List<JSONObject>> newNode) {
        ArrayList<String> createNodeCqlList = new ArrayList<String>();
        newNode.forEach((labelName, nodes) -> {
            for (JSONObject node : nodes) {
                String nodeCql = "create (:{}{{}})";
                StringBuilder stringBuilder = new StringBuilder();
                node.forEach((k, v) -> {
                    Object transformV = v instanceof JSONObject || v instanceof Map ? "'" + JSON.toJSONString((Object)v) + "'" : v;
                    String property = StrUtil.format((CharSequence)"{}:'{}'", (Object[])new Object[]{k, transformV});
                    stringBuilder.append(property).append(",");
                });
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                String createNodeCql = StrUtil.format((CharSequence)nodeCql, (Object[])new Object[]{labelName, stringBuilder.toString()});
                createNodeCqlList.add(createNodeCql);
            }
        });
        return createNodeCqlList;
    }

    public static List<Cql> createTenantNodeRelation(String tenantId, String application) {
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        Cql tenantTaskRelationCql = CqlMapper.mergeTenantAndTaskExcludeTenantTask((String)application, (String)tenantId);
        cqlList.add(tenantTaskRelationCql);
        List tenantActivityRelationCqlList = CqlMapper.mergeTenantAndActivityExcludeTenantActivity((String)application, (String)tenantId);
        cqlList.addAll(tenantActivityRelationCqlList);
        Cql tenantMechanismCql = CqlMapper.mergeTenantAndMechanismExcludeTenantMechanism((String)application, (String)tenantId);
        cqlList.add(tenantMechanismCql);
        Cql tenantActionCql = CqlMapper.mergeTenantAndActionExcludeTenantAction((String)application, (String)tenantId);
        cqlList.add(tenantActionCql);
        List tenantMonitorRuleCql = CqlMapper.mergeTenantAndActivityExcludeTenantMonitorRule((String)application, (String)tenantId);
        cqlList.addAll(tenantMonitorRuleCql);
        return cqlList;
    }

    private static List<String> getTenantTaskCodeList(String application, String tenantId) {
        String filterEnterpriseTaskNodeCql = "match (n:Task) where n.tenantId = '{}' and n.nameSpace = '{}' return n.code as code";
        return DeployUtil.executeCql((String)application, (String)tenantId, (String)filterEnterpriseTaskNodeCql);
    }

    private static List<String> getTenantActivityCodeList(String application, String tenantId) {
        String filterEnterpriseActivityNodeCql = "match (n:Activity) where n.tenantId = '{}' and n.nameSpace = '{}' return n.code as code";
        return DeployUtil.executeCql((String)application, (String)tenantId, (String)filterEnterpriseActivityNodeCql);
    }

    private static List<String> getTenantActionIdList(String application, String tenantId) {
        String filterEnterpriseActivityNodeCql = "match (n:Action) where n.tenantId = '{}' and n.nameSpace = '{}' return n.actionId as code";
        return DeployUtil.executeCql((String)application, (String)tenantId, (String)filterEnterpriseActivityNodeCql);
    }

    private static List<String> getTenantMechanismKeyList(String application, String tenantId) {
        String filterEnterpriseActivityNodeCql = "match (n:Mechanism) where n.tenantId = '{}' and n.nameSpace = '{}' return n.key as code";
        return DeployUtil.executeCql((String)application, (String)tenantId, (String)filterEnterpriseActivityNodeCql);
    }

    private static List<String> executeCql(String application, String tenantId, String cql) {
        cql = StrUtil.format((CharSequence)cql, (Object[])new Object[]{tenantId, application});
        List maps = Neo4jManager.getNeo4jManager().ExecuteQuery(cql);
        ArrayList<String> tenantCodeList = new ArrayList<String>();
        for (Map map : maps) {
            tenantCodeList.add(String.valueOf(map.get("code")));
        }
        return tenantCodeList;
    }
}

