/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.utils;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.athenadeployer.utils.NullValueHandleUtils;
import com.digiwin.athena.athenadeployer.utils.SafeFileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    public static final String gitFilePath;

    public static File createFile(String filePath) {
        File file = SafeFileUtils.createFile((String)filePath);
        if (file.exists()) {
            return file;
        }
        int index = filePath.lastIndexOf("/");
        String folderPath = filePath.substring(0, index + 1);
        File folder = SafeFileUtils.createFile((String)folderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        FileUtil.touch((File)file);
        return file;
    }

    public static void clearFolder(String folderPath) {
        File[] files;
        File folder = SafeFileUtils.createFile((String)folderPath);
        if (!folder.exists()) {
            return;
        }
        for (File f : files = folder.listFiles()) {
            if (f.isDirectory()) {
                FileUtils.clearFolder((String)f.getAbsolutePath());
                continue;
            }
            FileUtil.del((File)f);
        }
        FileUtil.del((File)folder);
    }

    public static void writeObjectToJson(String filePath, Object obj) {
        FileUtils.createFile((String)filePath);
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(SafeFileUtils.getPath((String)filePath), new OpenOption[0]);){
            String pretty = JSON.toJSONString((Object)obj);
            bufferedWriter.write(pretty);
        }
        catch (IOException e) {
            log.error("{}\u5199\u5165{}\u5931\u8d25 fail.msg = {}", new Object[]{obj, filePath, e.getMessage()});
        }
    }

    public static void writeXSSToFile(String filePath, Workbook obj) {
        FileUtils.createFile((String)filePath);
        try (FileOutputStream os = new FileOutputStream(filePath);){
            obj.write((OutputStream)os);
        }
        catch (IOException e) {
            log.error("{}\u5199\u5165{}\u5931\u8d25 fail.msg = {}", new Object[]{obj, filePath, e.getMessage()});
        }
    }

    public static <T> T readObjectFromFilePath(String filePath, Class<T> clazz) {
        byte[] bytes = new byte[]{};
        try (InputStream in = FileUtils.class.getClassLoader().getResourceAsStream(filePath);){
            bytes = in.readAllBytes();
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6{}\u6570\u636e\u5931\u8d25 fail.msg = {}", (Object)filePath, (Object)e.getMessage());
        }
        return (T)JSON.parseObject((String)new String(bytes), clazz);
    }

    public static <T> T readObjectFromFullFilePath(String filePath, Class<T> clazz) {
        Object resultObject = null;
        File file = SafeFileUtils.createFile((String)filePath);
        if (!file.exists()) {
            return (T)resultObject;
        }
        StringBuffer result = new StringBuffer();
        try (BufferedReader bufferedReader = Files.newBufferedReader(SafeFileUtils.getPath((String)file.getAbsolutePath()));){
            Object o;
            String objStr;
            while ((objStr = bufferedReader.readLine()) != null) {
                result.append(objStr);
            }
            resultObject = o = JSON.parseObject((String)result.toString(), clazz);
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6{}\u6570\u636e\u5931\u8d25 fail.msg = {}", (Object)file.getPath(), (Object)e.getMessage());
        }
        return (T)resultObject;
    }

    public static <T> T readObjectFromInputStream(InputStream inputStream, Class<T> clazz) {
        StringBuffer result = new StringBuffer();
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String objStr;
            while ((objStr = bufferedReader.readLine()) != null) {
                result.append(objStr);
            }
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u6570\u636e\u5931\u8d25 fail.msg = {}", (Object)e.getMessage());
        }
        return (T)JSON.parseObject((String)result.toString(), clazz);
    }

    public static <T> List<T> readAllObjectFromFilePath(String filePath, Class<T> clazz) {
        File[] files;
        ArrayList<Object> resultObjects = new ArrayList<Object>();
        File folder = SafeFileUtils.createFile((String)filePath);
        if (!folder.exists()) {
            return resultObjects;
        }
        for (File file : files = folder.listFiles()) {
            StringBuffer result = new StringBuffer();
            try (BufferedReader bufferedReader = Files.newBufferedReader(SafeFileUtils.getPath((String)file.getAbsolutePath()));){
                String objStr;
                while ((objStr = bufferedReader.readLine()) != null) {
                    result.append(objStr);
                }
                Object o = JSON.parseObject((String)result.toString(), clazz);
                resultObjects.add(o);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6{}\u6570\u636e\u5931\u8d25 fail.msg = {}", (Object)file.getPath(), (Object)e.getMessage());
                return resultObjects;
            }
        }
        return resultObjects;
    }

    public static void copyFolder(String sourceFolder, String targetFolder) {
        File src = SafeFileUtils.createFile((String)sourceFolder);
        if (!src.exists()) {
            return;
        }
        if (!SafeFileUtils.createFile((String)targetFolder).exists()) {
            SafeFileUtils.createFile((String)targetFolder).mkdirs();
        }
        for (File file : src.listFiles()) {
            if (file.isFile()) {
                FileUtils.copyFile((String)file.getPath(), (String)(targetFolder + File.separator + file.getName()));
                continue;
            }
            FileUtils.copyFolder((String)file.getPath(), (String)(targetFolder + File.separator + file.getName()));
        }
    }

    private static void copyFile(String sourceFile, String targetFile) {
        File src = SafeFileUtils.createFile((String)sourceFile);
        File dest = SafeFileUtils.createFile((String)targetFile);
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(src));
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));){
            byte[] flush = new byte[1024];
            int len = -1;
            while ((len = ((InputStream)is).read(flush)) != -1) {
                ((OutputStream)out).write(flush, 0, len);
            }
            ((OutputStream)out).flush();
        }
        catch (FileNotFoundException e) {
            log.error("{}\u4e0d\u5b58\u5728 fail.msg = {}", (Object)sourceFile, (Object)e.getMessage());
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6{}\u6570\u636e\u5931\u8d25 fail.msg = {}", (Object)sourceFile, (Object)e.getMessage());
        }
    }

    public static void copyFolderWithoutNullValue(String sourceFolder, String targetFolder) {
        File src = SafeFileUtils.createFile((String)sourceFolder);
        if (!src.exists()) {
            return;
        }
        if (!SafeFileUtils.createFile((String)targetFolder).exists()) {
            SafeFileUtils.createFile((String)targetFolder).mkdirs();
        }
        for (File file : src.listFiles()) {
            if (file.isFile()) {
                FileUtils.copyFileWithoutNullValue((String)file.getPath(), (String)(targetFolder + File.separator + file.getName()));
                continue;
            }
            FileUtils.copyFolderWithoutNullValue((String)file.getPath(), (String)(targetFolder + File.separator + file.getName()));
        }
    }

    private static void copyFileWithoutNullValue(String sourceFile, String targetFile) {
        HashMap jsonValue = (HashMap)FileUtils.readObjectFromFilePath2((String)sourceFile, HashMap.class);
        NullValueHandleUtils.processNullValue((Map)jsonValue);
        FileUtils.writeObjectToJson((String)targetFile, (Object)jsonValue);
    }

    public static <T> T readObjectFromFilePath2(String filePath, Class<T> clazz) {
        byte[] bytes = new byte[]{};
        try (FileInputStream in = new FileInputStream(filePath);){
            bytes = ((InputStream)in).readAllBytes();
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6{}\u6570\u636e\u5931\u8d25 fail.msg = {}", (Object)filePath, (Object)e.getMessage());
        }
        return (T)JSON.parseObject((String)new String(bytes), clazz);
    }

    static {
        YamlPropertiesFactoryBean yamlMapFactoryBean = new YamlPropertiesFactoryBean();
        yamlMapFactoryBean.setResources(new Resource[]{new ClassPathResource("application.yml")});
        Properties properties = yamlMapFactoryBean.getObject();
        String activeProperties = properties.getProperty("spring.profiles.active");
        if (StrUtil.isNotBlank((CharSequence)activeProperties)) {
            yamlMapFactoryBean.setResources(new Resource[]{new ClassPathResource("application-" + activeProperties + ".yml")});
            properties = yamlMapFactoryBean.getObject();
        }
        gitFilePath = properties.getProperty("gitfile-path");
    }
}

