/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.utils;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IdWorker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdWorker.class);
    private final long twepoch = 1514736000000L;
    private final long workerIdBits = 5L;
    private final long datacenterIdBits = 5L;
    private final long maxWorkerId = 31L;
    private final long maxDatacenterId = 31L;
    private final long sequenceBits = 12L;
    private final long sequenceBits2 = 8L;
    private final long sequenceBits3 = 4L;
    private final long workerIdShift = 12L;
    private final long workerIdShift2 = 8L;
    private final long datacenterIdShift = 17L;
    private final long timestampLeftShift = 22L;
    private final long timestampLeftShift2 = 13L;
    private final long timestampLeftShift3 = 4L;
    private final long sequenceMask = 4095L;
    private final long sequenceMask2 = 255L;
    private final long sequenceMask3 = 15L;
    private long workerId;
    private long datacenterId;
    private long sequence = 0L;
    private long sequence2 = 0L;
    private long sequence3 = 0L;
    private long lastTimestamp = -1L;
    private long lastTimestamp2 = -1L;
    private long lastTimestamp3 = -1L;

    public IdWorker() {
        this.workerId = 0L;
        this.datacenterId = 0L;
    }

    public IdWorker(long workerId, long datacenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (datacenterId > 31L || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1514736000000L << 22 | this.datacenterId << 17 | this.workerId << 12 | this.sequence;
    }

    public synchronized long nextMiniId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp2) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp2 - timestamp));
        }
        if (this.lastTimestamp2 == timestamp) {
            this.sequence2 = this.sequence2 + 1L & 0xFFL;
            if (this.sequence2 == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp2);
            }
        } else {
            this.sequence2 = 0L;
        }
        this.lastTimestamp2 = timestamp;
        return timestamp - 1514736000000L << 13 | this.workerId << 8 | this.sequence2;
    }

    public String nextMiniHex() {
        return Long.toHexString(this.nextMiniId()).toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextIntId() {
        IdWorker idWorker = this;
        synchronized (idWorker) {
            long timestamp = this.timeGen();
            if (timestamp < this.lastTimestamp3) {
                throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp3 - timestamp));
            }
            int result = (int)((timestamp - 1514736000000L) / 1000L);
            while ((long)result == this.lastTimestamp3) {
                try {
                    this.wait(501L);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                timestamp = this.timeGen();
                result = (int)((timestamp - 1514736000000L) / 1000L);
            }
            this.lastTimestamp3 = result;
            return result;
        }
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }
}

