/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.utils;

import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SafeFileUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SafeFileUtils.class);
    private static final List<String> BLACKLISTED_DIRECTORIES = Arrays.asList("/etc", "/bin", "/sbin", "/root", "/dev", "/proc");

    public static boolean isValidPath(String path) {
        if (path == null || path.isEmpty()) {
            log.error("current absolute path is empty ,path is:{}", (Object)path);
            return true;
        }
        try {
            Path resolvedPath = Paths.get(path, new String[0]).toAbsolutePath();
            if (!resolvedPath.normalize().toString().equals(resolvedPath.toString())) {
                return true;
            }
            for (String blacklistedDir : BLACKLISTED_DIRECTORIES) {
                if (!resolvedPath.startsWith(blacklistedDir)) continue;
                log.error("Path starts with a blacklisted directory: {}", (Object)blacklistedDir);
                return true;
            }
        }
        catch (InvalidPathException e) {
            log.error("Invalid path format: {}", (Object)path, (Object)e);
            return true;
        }
        return false;
    }

    public static File createFile(String path) {
        if (SafeFileUtils.isValidPath((String)path)) {
            throw new IllegalArgumentException("Invalid file path: " + path);
        }
        return new File(path);
    }

    public static String filterPath(String path) {
        if (SafeFileUtils.isValidPath((String)path)) {
            throw new IllegalArgumentException("Invalid file path: " + path);
        }
        return path;
    }

    public static Path getPath(String path) {
        return Paths.get(SafeFileUtils.filterPath((String)path), new String[0]);
    }
}

