/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.utils;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Group;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.Node;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.TenantPipeLine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class TenantPipelineHelper {
    public static Node findNodeByServiceId(TenantPipeLine pipeline, String serviceId) {
        for (Group group : pipeline.getGroups()) {
            Node childNode;
            Node node = group.getNode();
            if (node.getServiceId().equals(serviceId)) {
                return node;
            }
            if (node.getChildren() == null || node.getChildren().isEmpty() || (childNode = TenantPipelineHelper.findInChildren((List)node.getChildren(), (String)serviceId)) == null) continue;
            return childNode;
        }
        return null;
    }

    private static Node findInChildren(List<Node> children, String serviceId) {
        for (Node child : children) {
            Node result;
            if (child.getServiceId().equals(serviceId)) {
                return child;
            }
            if (child.getChildren() == null || child.getChildren().isEmpty() || (result = TenantPipelineHelper.findInChildren((List)child.getChildren(), (String)serviceId)) == null) continue;
            return result;
        }
        return null;
    }

    public static List<String> findAllParentServiceIds(TenantPipeLine pipeline, String targetServiceId) {
        ArrayList<String> allParents = new ArrayList<String>();
        for (Group group : pipeline.getGroups()) {
            Node node = group.getNode();
            List parents = TenantPipelineHelper.findParents((Node)node, (String)targetServiceId, new ArrayList());
            if (parents.isEmpty()) continue;
            allParents.addAll(parents);
        }
        return allParents;
    }

    private static List<String> findParents(Node currentNode, String targetServiceId, List<String> accumulator) {
        if (currentNode == null || accumulator.contains(currentNode.getServiceId())) {
            return accumulator;
        }
        if (currentNode.getChildren() != null) {
            for (Node child : currentNode.getChildren()) {
                if (child.getServiceId().equals(targetServiceId)) {
                    accumulator.add(currentNode.getServiceId());
                    return accumulator;
                }
                List result = TenantPipelineHelper.findParents((Node)child, (String)targetServiceId, new ArrayList<String>(accumulator));
                if (result.isEmpty()) continue;
                result.add(0, currentNode.getServiceId());
                return result;
            }
        }
        return accumulator;
    }

    public static List<String> getAllEnvs(TenantPipeLine pipeline) {
        List groups = pipeline.getGroups();
        ArrayList<String> envList = new ArrayList<String>();
        for (Group group : groups) {
            Node node = group.getNode();
            TenantPipelineHelper.addEnv((Node)node, envList);
        }
        return envList;
    }

    private static void addEnv(Node node, List<String> envList) {
        List envs = node.getEnvs();
        envs.stream().filter(item -> item.getDisable() == null || item.getDisable() == false).forEach(item -> envList.add(item.getEnv()));
        List children = node.getChildren();
        if (CollUtil.isNotEmpty((Collection)children)) {
            for (Node child : children) {
                TenantPipelineHelper.addEnv((Node)child, envList);
            }
        }
    }

    public static List<Node> getAllNode(TenantPipeLine pipeline) {
        ArrayList<Node> result = new ArrayList<Node>();
        List groups = pipeline.getGroups();
        for (Group group : groups) {
            Node node = group.getNode();
            TenantPipelineHelper.addNode((Node)node, result);
        }
        return result;
    }

    private static void addNode(Node node, List<Node> result) {
        List children = node.getChildren();
        node.setChildren(null);
        node.setFriendlyLinkList(null);
        result.add(node);
        if (CollUtil.isNotEmpty((Collection)children)) {
            for (Node child : children) {
                TenantPipelineHelper.addNode((Node)child, result);
            }
        }
    }
}

