
let req = axios.create({
        timeout: 30000
    });

    req.interceptors.request.use((config) => {
        return config;
    })

    req.interceptors.response.use((response) => {
        console.log("response", response);
        return response.data;
    }, (error) => {
        let message = ''
        const status = error.response.status;
        switch (status) {
            case 401:
                message = '没有权限';
                break;
            case 404:
                message = '没有对应请求';
                break;
            case 500:
            case 501:
            case 502:
            case 503:
                message = '服务器异常';
                break;
        }

        return Promise.reject(message);
    });
