/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.aop;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class RequestLogAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestLogAspect.class);

    @Pointcut(value="execution(* com.digiwin.athena.athena_deployer_service.controller..*.*(..))")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        try {
            Object[] args;
            this.getLocalIp();
            MDC.put((String)"RequestId", (String)IdUtil.fastSimpleUUID());
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HashMap<String, String> requestInfo = new HashMap<String, String>();
            if (servletRequestAttributes != null) {
                HttpServletRequest request = servletRequestAttributes.getRequest();
                requestInfo.put("method", request.getMethod());
                requestInfo.put("requestUri", request.getRequestURI());
                this.collectHeaderParam(request, requestInfo);
            }
            if ((args = point.getArgs()) != null && args.length > 0) {
                ArrayList<Object> arguments = new ArrayList<Object>();
                for (Object arg : args) {
                    if (arg instanceof ServletRequest || arg instanceof ServletResponse || arg instanceof BindingResult) continue;
                    arguments.add(arg);
                }
                requestInfo.put("requestParam", JSONObject.toJSONString(arguments));
            }
            log.info("request result:{}", requestInfo);
        }
        catch (Exception e) {
            log.error("RequestLogAspect exception:{}", (Object)e.getMessage(), (Object)e);
        }
        try {
            Object proceed = point.proceed();
            try {
                log.info("request end:{}", (Object)JSONObject.toJSONString((Object)proceed));
            }
            catch (Exception e) {
                log.error("json exception:{}", (Object)e.getMessage(), (Object)e);
            }
            Object object = proceed;
            return object;
        }
        catch (Exception e) {
            log.error("point proceed exception:{}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
        finally {
            MDC.clear();
        }
    }

    private void collectHeaderParam(HttpServletRequest request, HashMap<String, Object> requestInfo) {
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (!"routerkey".equals(headerName)) continue;
            requestInfo.put(headerName, request.getHeader(headerName));
        }
        this.getRemoteIp(request, requestInfo);
    }

    private void getLocalIp() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String ip = localHost.getHostAddress();
            MDC.put((String)"hostIp", (String)ip);
        }
        catch (UnknownHostException e) {
            log.error("getLocalIp exception:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void getRemoteIp(HttpServletRequest request, Map<String, Object> requestInfo) {
        String clientIP = request.getHeader("X-Forwarded-For");
        if (StringUtils.isBlank((CharSequence)clientIP) || "unknown".equalsIgnoreCase(clientIP)) {
            clientIP = request.getHeader("X-Real-IP");
        }
        if (StringUtils.isBlank((CharSequence)clientIP) || "unknown".equalsIgnoreCase(clientIP)) {
            clientIP = request.getRemoteAddr();
        }
        requestInfo.put("remoteIp", clientIP);
    }
}

