/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.config.http;

import com.digiwin.athena.athena_deployer_service.util.CurThreadInfoUtils;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RestTemplateAddHeadersInterceptor
implements ClientHttpRequestInterceptor {
    @Value(value="${appToken}")
    private String appToken;

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        String tenantId;
        HttpHeaders headers = request.getHeaders();
        if (!headers.containsKey((Object)"locale")) {
            headers.add("locale", LocaleContextHolder.getLocale().toString());
        }
        if (!headers.containsKey((Object)"digi-middleware-auth-app")) {
            headers.add("digi-middleware-auth-app", this.appToken);
        }
        if (!headers.containsKey((Object)"routerKey") && !StringUtils.isEmpty((Object)(tenantId = CurThreadInfoUtils.getRouterKey()))) {
            headers.add("routerKey", tenantId);
        }
        ClientHttpResponse clientHttpResponse = execution.execute(request, body);
        return clientHttpResponse;
    }
}

