/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.config.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.config.MongoConfigurationSupport;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;

@Configuration
public class DeployerMongoConfig
extends MongoConfigurationSupport {
    @Value(value="${spring.data.mongodb.deployerDatabase}")
    private String deployerDatabase;

    @Bean
    public MongoClient deployerMongoClient(MongoProperties properties) {
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(properties.getUri())).applyToConnectionPoolSettings(builder -> builder.maxSize(30).minSize(10).maxConnectionIdleTime(10L, TimeUnit.MINUTES).maxConnectionLifeTime(10L, TimeUnit.MINUTES).maxWaitTime(15L, TimeUnit.MINUTES)).build();
        return MongoClients.create((MongoClientSettings)mongoClientSettings);
    }

    @Bean
    public MongoDatabaseFactory deployerMongoDbFactory(@Qualifier(value="deployerMongoClient") MongoClient deployerMongoClient) {
        return new SimpleMongoClientDatabaseFactory(deployerMongoClient, this.deployerDatabase);
    }

    @Bean
    public MappingMongoConverter mappingMongoConverter(@Qualifier(value="deployerMongoDbFactory") MongoDatabaseFactory deployerMongoDbFactory) throws Exception {
        return this.getMappingMongoConverter(new DefaultDbRefResolver(deployerMongoDbFactory));
    }

    private MappingMongoConverter getMappingMongoConverter(DefaultDbRefResolver defaultDbRefResolver) throws ClassNotFoundException {
        DefaultDbRefResolver dbRefResolver = defaultDbRefResolver;
        MappingMongoConverter converter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)this.mongoMappingContext(this.customConversions(), this.mongoManagedTypes()));
        return converter;
    }

    @Bean
    public MongoTemplate deployerMongoTemplate(@Qualifier(value="deployerMongoDbFactory") MongoDatabaseFactory deployerMongoDbFactory, MappingMongoConverter mappingMongoConverter) throws Exception {
        return new MongoTemplate(deployerMongoDbFactory, (MongoConverter)mappingMongoConverter);
    }

    protected String getDatabaseName() {
        return "deployer";
    }
}

