/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.config.mongodb;

import com.digiwin.athena.athena_deployer_service.config.mongodb.MySimpleMongoClientDbFactory;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.connection.ConnectionPoolSettings;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;

@Primary
@Configuration
public class MongoConfig {
    @Value(value="${mongo.suffix}")
    private String mongoSuffix;

    @Bean
    @Primary
    MongoTemplate mongoTemplate(MongoDatabaseFactory mongoDbFactory, MongoConverter converter) {
        return new MongoTemplate(mongoDbFactory, converter);
    }

    @Bean
    @Primary
    public MongoClient mongo(MongoProperties properties, ObjectProvider<ConnectionPoolSettings> settingsProvider) {
        String uri = properties.getUri();
        ConnectionString connectionString = new ConnectionString(uri);
        MongoClientSettings.Builder settingsBuilder = MongoClientSettings.builder().applyConnectionString(connectionString);
        ConnectionPoolSettings customSettings = (ConnectionPoolSettings)settingsProvider.getIfAvailable();
        if (customSettings != null) {
            settingsBuilder.applyToConnectionPoolSettings(poolBuilder -> poolBuilder.applySettings(customSettings));
        } else {
            settingsBuilder.applyToConnectionPoolSettings(builder -> builder.maxSize(30).minSize(10).maxConnectionIdleTime(10L, TimeUnit.MINUTES).maxConnectionLifeTime(10L, TimeUnit.MINUTES).maxWaitTime(15L, TimeUnit.MINUTES));
        }
        MongoClientSettings finalSettings = settingsBuilder.build();
        return MongoClients.create((MongoClientSettings)finalSettings);
    }

    @Bean
    @Primary
    MySimpleMongoClientDbFactory mongoDbFactory(ObjectProvider<MongoClient> mongo, ObjectProvider<MongoClient> mongoClient, MongoProperties properties) {
        MongoClient preferredClient = (MongoClient)mongo.getIfAvailable();
        if (preferredClient != null) {
            return new MySimpleMongoClientDbFactory(preferredClient, properties.getMongoClientDatabase(), this.mongoSuffix);
        }
        MongoClient fallbackClient = (MongoClient)mongoClient.getIfAvailable();
        if (fallbackClient != null) {
            return new MySimpleMongoClientDbFactory(fallbackClient, properties.getMongoClientDatabase(), this.mongoSuffix);
        }
        throw new IllegalStateException("Expected to find at least one MongoDB client.");
    }
}

