/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.config.neo4j;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.neo4j.Neo4jProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jTemplate;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionManager;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableNeo4jRepositories(basePackages={"com.digiwin.athena.athena_deployer_service.neo4jbasepkg.backup"}, transactionManagerRef="domain2TransactionManager")
@ConditionalOnProperty(prefix="spring.neo4j.domain2", name={"enable"}, havingValue="true")
public class BackupNeo4jConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BackupNeo4jConfig.class);
    public static final String NEO4J_CLIENT = "domain2Neo4jClient";
    public static final String NEO4J_TEMPLATE = "domain2Neo4jTemplate";
    public static final String TRANSACTION_MANAGER = "domain2TransactionManager";
    public static final String NEO4J_DRIVER_SESSION = "domain2DriverSession";
    public static final String NEO4J_DRIVER = "domain2Driver";
    static final String BASE_PACKAGE = "com.digiwin.athena.athena_deployer_service.neo4jbasepkg.backup";

    @Bean(name={"domain2Neo4jProperties"})
    @ConfigurationProperties(value="spring.neo4j.domain2")
    public Neo4jProperties neo4jProperties() {
        return new Neo4jProperties();
    }

    @Bean(name={"domain2Driver"})
    public Driver driver() {
        Config config = Config.builder().withConnectionTimeout(10L, TimeUnit.SECONDS).withConnectionLivenessCheckTimeout(2L, TimeUnit.MINUTES).withMaxConnectionLifetime(4L, TimeUnit.MINUTES).withMaxConnectionPoolSize(50).withConnectionAcquisitionTimeout(1L, TimeUnit.MINUTES).build();
        Driver driver = GraphDatabase.driver((URI)this.neo4jProperties().getUri(), (AuthToken)AuthTokens.basic((String)this.neo4jProperties().getAuthentication().getUsername(), (String)this.neo4jProperties().getAuthentication().getPassword()), (Config)config);
        try {
            driver.verifyConnectivity();
        }
        catch (Exception e) {
            log.error("back\u5e93\u521d\u59cb\u5316\u5931\u8d25");
            driver = null;
        }
        return driver;
    }

    @Bean(name={"domain2Neo4jClient"})
    public Neo4jClient neo4jClient(@Qualifier(value="domain2Driver") Driver driver) {
        return Neo4jClient.create((Driver)driver);
    }

    @Bean(name={"domain2Neo4jTemplate"})
    public Neo4jTemplate neo4jTemplate(@Qualifier(value="domain2Neo4jClient") Neo4jClient neo4jClient, @Qualifier(value="domain2TransactionManager") Neo4jTransactionManager transactionManager) {
        return new Neo4jTemplate(neo4jClient, new Neo4jMappingContext(), (PlatformTransactionManager)transactionManager);
    }

    @Bean(name={"domain2DriverSession"})
    public Session neo4jSession(@Qualifier(value="domain2Driver") Driver driver) {
        return driver.session();
    }

    @Bean(name={"domain2TransactionManager"})
    public Neo4jTransactionManager neo4jTransactionManager(@Qualifier(value="domain2Driver") Driver driver) {
        return new Neo4jTransactionManager(driver);
    }
}

