/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.config.redis;

import cn.hutool.core.util.StrUtil;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.config.Config;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RedissionConfig {
    @Value(value="${spring.data.redis.host}")
    private String redisHost;
    @Value(value="${spring.data.redis.password}")
    private String password;
    @Value(value="${spring.data.redis.port}")
    private int port;
    @Value(value="${spring.data.redis.database}")
    private Integer database;

    @Bean
    public RedissonClient getRedisson() {
        Config config = new Config();
        config.useSingleServer().setAddress("redis://" + this.redisHost + ":" + this.port).setDatabase(this.database.intValue());
        if (StrUtil.isNotBlank((CharSequence)this.password)) {
            config.useSingleServer().setPassword(this.password);
        }
        config.setCodec((Codec)new JsonJacksonCodec());
        return Redisson.create((Config)config);
    }
}

