/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.domain.action.ActionEnumKeyDTO;
import com.digiwin.athena.athena_deployer_service.domain.action.EspActionIdSwitchResDto;
import com.digiwin.athena.athena_deployer_service.domain.system.ResultBean;
import com.digiwin.athena.athena_deployer_service.enums.EspSwitchMsgEnum;
import com.digiwin.athena.athena_deployer_service.service.deploy.ActionService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/action"})
public class ActionController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActionController.class);
    @Autowired
    private ActionService actionService;
    @Autowired
    private RedissonClient redissonClient;
    public static final String LOCK_KEY = "increment_switch_espAction_lock";

    @PostMapping(value={"/updateEspActionEnumKey"})
    public ResultBean<?> updateEspActionEnumKey(@RequestBody ActionEnumKeyDTO espActionEnumKey) {
        try {
            Map map;
            JSONObject actionEnumKey = espActionEnumKey.getEnumKeyMapping();
            Map actionEnumKeyMap = map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)actionEnumKey), Map.class);
            this.actionService.updateEspActionEnumKey(actionEnumKeyMap);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0espAction\u679a\u4e3e\u503c\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/incrementEspActionInSwitch/{id}"})
    public ResultBean<?> incrementSwitchEspAction(@PathVariable String id) {
        RLock rLock = this.redissonClient.getLock(LOCK_KEY);
        boolean lockRes = rLock.tryLock();
        if (lockRes) {
            try {
                log.info("\u5f00\u59cb\u8fdb\u884c\u589e\u91cf\u66f4\u65b0EspAction\u64cd\u4f5c\uff0c\u64cd\u4f5cid\uff1a{}", (Object)id);
                this.actionService.incrementSwitchEspAction(id);
                log.info("\u589e\u91cf\u66f4\u65b0EspAction\u6210\u529f\uff0c\u64cd\u4f5cid\uff1a{}", (Object)id);
                ResultBean resultBean = ResultBean.success();
                return resultBean;
            }
            catch (Exception e) {
                log.error("\u589e\u91cf\u5207\u7248espAction\u5931\u8d25:", (Throwable)e);
                ResultBean resultBean = ResultBean.fail((Integer)-2, (String)e.getMessage());
                return resultBean;
            }
            finally {
                rLock.unlock();
            }
        }
        log.info("\u589e\u91cf\u66f4\u65b0EspAction\u64cd\u4f5c\u88ab\u9501\uff0c\u8bf7\u7b49\u5f85\u89e3\u9501\u540e\u91cd\u8bd5\uff01");
        return ResultBean.fail((Integer)-1, (String)"\u589e\u91cf\u66f4\u65b0EspAction\u64cd\u4f5c\u88ab\u9501\uff0c\u8bf7\u7b49\u5f85\u89e3\u9501\u540e\u91cd\u8bd5\uff01");
    }

    @GetMapping(value={"/assignSwitchEspAction"})
    public ResultBean<List<EspActionIdSwitchResDto>> assignSwitchEspAction(String id, String actionIds) {
        String[] actionIdArr = actionIds.split(",");
        List actionIdList = Arrays.stream(actionIdArr).distinct().collect(Collectors.toList());
        ArrayList<EspActionIdSwitchResDto> data = new ArrayList<EspActionIdSwitchResDto>();
        ArrayList createdActionIdList = new ArrayList();
        for (String actionId : actionIdList) {
            try {
                data.add(this.actionService.assignSwitchEspAction(id, actionId, createdActionIdList));
            }
            catch (Exception e) {
                log.error("assignSwitchEspAction exception:{}", (Object)e.getMessage(), (Object)e);
                data.add(new EspActionIdSwitchResDto(EspSwitchMsgEnum.UPDATE_FAIL.getType(), EspSwitchMsgEnum.UPDATE_FAIL.formatMsg(actionId, e.getMessage())));
            }
        }
        if (!createdActionIdList.isEmpty()) {
            this.actionService.createEspActionRelaWithVirtualTenant();
        }
        return ResultBean.success(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/kmAssignSwitchEspAction"})
    public ResultBean<List<EspActionIdSwitchResDto>> kmAssignSwitchEspAction(HttpServletRequest request, String id, String actionIds) {
        String token = request.getHeader("token");
        RLock rLock = this.redissonClient.getLock(LOCK_KEY);
        boolean lockRes = rLock.tryLock();
        if (lockRes) {
            try {
                log.info("\u5f00\u59cb\u8fdb\u884c\u589e\u91cf\u66f4\u65b0EspAction\u64cd\u4f5c\uff0c\u64cd\u4f5cid\uff1a{}", (Object)id);
                List res = this.actionService.kmAssignSwitchEspAction(token, id, actionIds);
                log.info("\u589e\u91cf\u66f4\u65b0EspAction\u6210\u529f\uff0c\u64cd\u4f5cid\uff1a{}", (Object)id);
                ResultBean resultBean = ResultBean.success((Object)res);
                return resultBean;
            }
            catch (Exception e) {
                log.error("\u589e\u91cf\u5207\u7248espAction\u5931\u8d25:", (Throwable)e);
                ResultBean resultBean = ResultBean.fail((Integer)-2, (String)e.getMessage());
                return resultBean;
            }
            finally {
                rLock.unlock();
            }
        }
        log.info("\u589e\u91cf\u66f4\u65b0EspAction\u64cd\u4f5c\u88ab\u9501\uff0c\u8bf7\u7b49\u5f85\u89e3\u9501\u540e\u91cd\u8bd5\uff01");
        return ResultBean.fail((Integer)-1, (String)"\u589e\u91cf\u66f4\u65b0EspAction\u64cd\u4f5c\u88ab\u9501\uff0c\u8bf7\u7b49\u5f85\u89e3\u9501\u540e\u91cd\u8bd5\uff01");
    }
}

