/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.controller;

import com.digiwin.athena.athena_deployer_service.domain.param.ApplicationCopyParam;
import com.digiwin.athena.athena_deployer_service.domain.param.CreateApplicationRelationParam;
import com.digiwin.athena.athena_deployer_service.domain.param.UpdateVersionParam;
import com.digiwin.athena.athena_deployer_service.domain.system.ResultBean;
import com.digiwin.athena.athena_deployer_service.service.deploy.ApplicationService;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/application"})
public class ApplicationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationController.class);
    @Autowired
    private ApplicationService applicationService;

    @PostMapping(value={"/copy"})
    public ResultBean<?> copy(@RequestBody ApplicationCopyParam applicationCopyParam) {
        try {
            this.applicationService.copy(applicationCopyParam);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("\u590d\u5236\u5e94\u7528\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/updateVersion"})
    public ResultBean<?> updateVersion(@RequestBody UpdateVersionParam updateVersionParam) {
        try {
            this.applicationService.updateVersion(updateVersionParam);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5e94\u7528\u7248\u672c\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/getUpdateVersionCqlList"})
    public ResultBean<?> getUpdateVersionCqlList(@RequestBody UpdateVersionParam updateVersionParam) {
        try {
            List cqlList = this.applicationService.getUpdateVersionCqlList(updateVersionParam);
            return ResultBean.success((Object)cqlList);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6cql\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/createApplication2CommonRelation"})
    public ResultBean<?> createApplication2CommonRelation(@RequestBody CreateApplicationRelationParam createApplicationRelationParam) {
        try {
            this.applicationService.createApplication2CommonRelation(createApplicationRelationParam);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u5e94\u7528\u4e0ecommon\u7684relation\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/getCqlByRelation"})
    public ResultBean<?> getCqlByRelation(@RequestBody CreateApplicationRelationParam createApplicationRelationParam) {
        try {
            List cqlList = this.applicationService.getCqlByRelation(createApplicationRelationParam);
            return ResultBean.success((Object)cqlList);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u5e94\u7528\u4e0ecommon\u7684relation\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }
}

