/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.thread.ThreadUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.constant.BusinessExceptionCode;
import com.digiwin.athena.athena_deployer_service.domain.deploy.CustomPublishParam;
import com.digiwin.athena.athena_deployer_service.domain.deploy.DataPublishStatusReqDto;
import com.digiwin.athena.athena_deployer_service.domain.deploy.DataPublishStatusResDto;
import com.digiwin.athena.athena_deployer_service.domain.kmDeployer.KmDeploySwitchParam;
import com.digiwin.athena.athena_deployer_service.domain.neo4j.Cql;
import com.digiwin.athena.athena_deployer_service.domain.param.CleanMongoParam;
import com.digiwin.athena.athena_deployer_service.domain.param.CleanNeo4jParam;
import com.digiwin.athena.athena_deployer_service.domain.param.DeployParam;
import com.digiwin.athena.athena_deployer_service.domain.param.ExecuteBsonParam;
import com.digiwin.athena.athena_deployer_service.domain.param.SwitchVersionParam;
import com.digiwin.athena.athena_deployer_service.domain.param.Tenant2NodeRelationParam;
import com.digiwin.athena.athena_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.athena_deployer_service.domain.system.ResultBean;
import com.digiwin.athena.athena_deployer_service.http.assistant.AssistantApiHelper;
import com.digiwin.athena.athena_deployer_service.http.assistant.dto.AssistantPublishParam;
import com.digiwin.athena.athena_deployer_service.http.atmc.AtmcApiHelper;
import com.digiwin.athena.athena_deployer_service.http.designer.DesignerApiHelper;
import com.digiwin.athena.athena_deployer_service.http.iam.IamApiHelper;
import com.digiwin.athena.athena_deployer_service.http.km.KmApiHelper;
import com.digiwin.athena.athena_deployer_service.http.km.dto.DeployAppReqDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.DeployAppResDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.KmRevokeAppParamDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.SwitchAppReqDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.SyncPushDataDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.TenantDeployParamDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.TenantVersionUpdateReqDto;
import com.digiwin.athena.athena_deployer_service.http.kmDeployerService.KmDeployerServiceApiHelper;
import com.digiwin.athena.athena_deployer_service.http.scrumbi.ScrumbiApiHelper;
import com.digiwin.athena.athena_deployer_service.http.scrumbi.dto.PushSynonymDto;
import com.digiwin.athena.athena_deployer_service.service.deploy.CustomPublishService;
import com.digiwin.athena.athena_deployer_service.service.deploy.DeployService;
import com.digiwin.athena.athena_deployer_service.service.deploy.KmDeployRecordService;
import com.digiwin.athena.athena_deployer_service.service.deploy.StatementService;
import com.digiwin.athena.athena_deployer_service.service.deploy.TenantService;
import com.digiwin.athena.athena_deployer_service.service.dmc.DmcService;
import com.digiwin.athena.athena_deployer_service.util.Neo4jMultipleUtil;
import com.mongodb.client.model.InsertOneModel;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bson.Document;
import org.neo4j.driver.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/deploy"})
public class DeployController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployController.class);
    @Autowired
    private DeployService deployService;
    @Autowired
    private StatementService statementService;
    @Autowired
    private DmcService dmcService;
    @Autowired
    private KmApiHelper kmApiHelper;
    @Autowired
    private AtmcApiHelper atmcApiHelper;
    @Autowired
    private Driver driver1;
    @Autowired
    private ScrumbiApiHelper scrumbiApiHelper;
    @Autowired
    private AssistantApiHelper assistantApiHelper;
    @Autowired(required=false)
    @Qualifier(value="domain2Driver")
    private Driver driver2;
    @Autowired
    private CustomPublishService customPublishService;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private KmDeployerServiceApiHelper kmDeployerServiceApiHelper;
    @Autowired
    private KmDeployRecordService kmDeployRecordService;
    @Autowired
    private IamApiHelper iamApiHelper;
    @Autowired
    private DesignerApiHelper designerApiHelper;

    @PostMapping
    public ResultBean<?> deploy(@RequestBody DeployParam deployParam) {
        try {
            this.deployService.deploy(deployParam);
        }
        catch (BusinessException e) {
            if ("\u65e7\u7248\u6570\u636e\u590d\u5236\u5931\u8d25!".equals(e.getMessage())) {
                return ResultBean.fail((Integer)-1, (String)e.getMessage());
            }
            if (e.getCode() != null && e.getCode() == BusinessExceptionCode.LOCKED) {
                return ResultBean.fail((Integer)-1, (String)e.getMessage());
            }
            log.error("\u53d1\u7248\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)"Publishing failed. Please contact the administrator to view the log");
        }
        return ResultBean.success();
    }

    @PostMapping(value={"/downloadFile"})
    public ResultBean<?> downloadFile(@RequestBody Map<String, String> param) {
        String fileId = param.get("fileId");
        String destPath = param.get("destPath");
        InputStream inputStream = this.dmcService.download(fileId);
        FileUtil.writeFromStream((InputStream)inputStream, (String)destPath);
        return ResultBean.success();
    }

    @GetMapping(value={"/addApplicationVersion"})
    public ResultBean<?> addApplicationVersion(@RequestParam(value="deployVersion") String deployVersion, @RequestParam(value="currentVersion") String currentVersion) {
        ThreadUtil.execute(() -> this.deployService.copyApplicationData(currentVersion, deployVersion));
        return ResultBean.success();
    }

    @PostMapping(value={"/addReportPolicy"})
    public ResultBean<?> addReportPolicy(@RequestBody DeployParam deployParam) {
        try {
            this.deployService.addReportPolicy(deployParam);
        }
        catch (BusinessException e) {
            log.error("\u53d1\u5e03\u62a5\u8868\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)"Failed to publish report. Please contact the administrator to check the log");
        }
        catch (Exception e) {
            log.error("\u53d1\u5e03\u62a5\u8868\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        return ResultBean.success();
    }

    @GetMapping(value={"/updateDataVersion"})
    public ResultBean<?> updateDataVersion(@RequestParam(value="oldVersion") String oldVersion, @RequestParam(value="newVersion") String newVersion) {
        try {
            this.deployService.updateDataVersion(oldVersion, newVersion);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("\u5199\u5165\u6570\u636e\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/switchVersion"})
    public ResultBean<?> switchVersion(@RequestBody SwitchVersionParam switchVersionParam) {
        try {
            this.deployService.switchVersion(switchVersionParam);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("switchVersion\u7ed1\u5b9a\u79df\u6237\u4e0e\u5e94\u7528\u6210\u679c\u5173\u7cfb\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/createAllTenantEntityAndCommonRelation"})
    public ResultBean<?> createTenantEntityAndCommonRelation(@RequestBody SwitchVersionParam switchVersionParam) {
        try {
            this.deployService.createAllTenantEntityAndCommonRelation(switchVersionParam);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u6240\u6709\u79df\u6237\u4e0ecommon\u7684relation\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @GetMapping(value={"/kmCacheReset/{tenantId}"})
    public ResultBean<?> kmCacheReset(@PathVariable String tenantId) {
        try {
            this.kmApiHelper.cacheReset(tenantId);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("\u6e05\u9664\u7f13\u5b58\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @GetMapping(value={"/atmcCacheReset"})
    public ResultBean<?> atmcCacheReset() {
        try {
            this.atmcApiHelper.cacheReset();
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("\u6e05\u9664\u7f13\u5b58\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @GetMapping(value={"/appPublishStatus/{appCode}"})
    public ResultBean<?> getAppPublishStatus(@PathVariable String appCode) {
        try {
            Boolean re = this.deployService.appPublishStatus(appCode);
            return ResultBean.success((Object)re);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5e94\u7528\u662f\u5426\u53d1\u7248\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/executeCqlTrans"})
    public ResultBean<?> executeCqlTrans(@RequestBody List<Cql> cqlList) {
        try {
            Neo4jMultipleUtil.executeCqlTrans(cqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("\u6267\u884ccql\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/cleanNeo4jData"})
    public ResultBean<?> cleanNeo4jData(@RequestBody CleanNeo4jParam cleanNeo4jParam) {
        try {
            this.deployService.cleanNeo4jData(cleanNeo4jParam);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("\u5220\u9664neo4j\u6570\u636e\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/cleanMongoData"})
    public ResultBean<?> cleanMongoData(@RequestBody CleanMongoParam cleanMongoParam) {
        try {
            this.deployService.cleanMongoData(cleanMongoParam);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("\u5220\u9664mongo\u6570\u636e\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/executeBson"})
    public ResultBean<?> executeBson(@RequestBody ExecuteBsonParam executeBsonParam) {
        try {
            List documentList = executeBsonParam.getDocumentList();
            ArrayList<InsertOneModel> requests = new ArrayList<InsertOneModel>();
            if (CollectionUtil.isEmpty((Collection)documentList)) {
                return ResultBean.success();
            }
            for (Document document : documentList) {
                InsertOneModel iom = new InsertOneModel((Object)document);
                requests.add(iom);
            }
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(executeBsonParam.getDbName()).getCollection(executeBsonParam.getCollectionName()).bulkWrite(requests);
            return ResultBean.success();
        }
        catch (Exception e) {
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/modifyDifferenceData"})
    public ResultBean<?> modifyDifferenceData(@RequestParam(value="application") String application, @RequestParam(value="version") String version) {
        try {
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("modifyDifferenceData error:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/tbbStatementPublish"})
    public ResultBean<JSONObject> tbbStatementPublish(@RequestBody JSONObject jsonObject) {
        try {
            JSONObject jsonObject1 = this.statementService.tbbStatementPublish(jsonObject);
            return ResultBean.success((Object)jsonObject1);
        }
        catch (Exception e) {
            log.error("\u53d1\u5e03tbb\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/abiStatementPublish"})
    public ResultBean<JSONObject> abiStatementPublish(@RequestBody JSONObject jsonObject) {
        try {
            JSONObject jsonObject1 = this.statementService.abiStatementPublish(jsonObject);
            return ResultBean.success((Object)jsonObject1);
        }
        catch (Exception e) {
            log.error("\u53d1\u5e03abi\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/customPublish"})
    public ResultBean<?> customPublish(@RequestBody CustomPublishParam customPublishParam) {
        try {
            this.customPublishService.customPublish(customPublishParam);
            return ResultBean.success();
        }
        catch (BusinessException e) {
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u6309\u9700\u53d1\u5e03\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/customTenantDtdPublish"})
    public ResultBean<?> customTenantDtdPublish(@RequestBody CustomPublishParam customPublishParam) {
        try {
            this.customPublishService.customTenantDtdPublish(customPublishParam);
            return ResultBean.success();
        }
        catch (BusinessException e) {
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u6309\u9700\u53d1\u5e03\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/customModelPublish"})
    public ResultBean<?> customModelPublish(@RequestBody CustomPublishParam customPublishParam) {
        try {
            this.customPublishService.customModelPublish(customPublishParam);
            return ResultBean.success();
        }
        catch (BusinessException e) {
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u6309\u9700\u53d1\u5e03\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/customKitPublish"})
    public ResultBean<?> customKitPublish(@RequestBody CustomPublishParam customPublishParam) {
        try {
            this.customPublishService.customKitPublish(customPublishParam);
            return ResultBean.success();
        }
        catch (BusinessException e) {
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u6309\u9700\u53d1\u5e03\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/customDataViewPublish"})
    public ResultBean<?> customDataViewPublish(@RequestBody CustomPublishParam customPublishParam) {
        try {
            this.customPublishService.customDataViewPublish(customPublishParam);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("\u6309\u9700\u53d1\u5e03\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/customMobilePageDesignPublish"})
    public ResultBean<?> customMobilePageDesignPublish(@RequestBody CustomPublishParam customPublishParam) {
        try {
            this.customPublishService.customMobilePageDesignPublish(customPublishParam);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("\u6309\u9700\u53d1\u5e03\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/customProcessPublish"})
    public ResultBean<?> customProcessPublish(@RequestBody CustomPublishParam customPublishParam) {
        try {
            this.customPublishService.customProcessPublish(customPublishParam);
            return ResultBean.success();
        }
        catch (BusinessException e) {
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u6309\u9700\u53d1\u5e03\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/customEventPublish"})
    public ResultBean<?> customEventPublish(@RequestBody CustomPublishParam customPublishParam) {
        try {
            this.customPublishService.customEventPublish(customPublishParam);
            return ResultBean.success();
        }
        catch (BusinessException e) {
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u6309\u9700\u53d1\u5e03\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/customDataFlowPublish"})
    public ResultBean<?> customDataFlowPublish(@RequestBody CustomPublishParam customPublishParam) {
        try {
            this.customPublishService.customDataFlowPublish(customPublishParam);
            return ResultBean.success();
        }
        catch (BusinessException e) {
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u6309\u9700\u53d1\u5e03\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/customScenePublish"})
    public ResultBean<?> customScenePublish(@RequestBody CustomPublishParam customPublishParam) {
        try {
            this.customPublishService.customScenePublish(customPublishParam);
            return ResultBean.success();
        }
        catch (BusinessException e) {
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u6309\u9700\u53d1\u5e03\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @GetMapping(value={"/kmUpdateAppComponentList/{appCode}/{tenantId}/{version}"})
    public ResultBean<?> kmUpdateAppComponentList(@PathVariable String appCode, @PathVariable String tenantId, @PathVariable String version) {
        try {
            this.kmApiHelper.updateApplicationComponentList(appCode, version, tenantId);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u8303\u5f0f\u7ec4\u4ef6\u6e05\u5355\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/compileAndSaveSets"})
    public ResultBean<?> compileAndSaveSets(@RequestBody JSONObject sets, @RequestHeader(value="token") String token) {
        try {
            this.kmApiHelper.compileAndSaveSets(sets);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("\u53d1\u5e03\u5957\u4ef6\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/deployAppDataByKm"})
    public ResultBean<?> deployAppDataByKm(@RequestBody KmDeploySwitchParam kmDeploySwitchParam) {
        try {
            String eventId = this.kmDeployerServiceApiHelper.deployAppDataByKm(kmDeploySwitchParam);
            return ResultBean.success((Object)eventId);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528km\u53d1\u7248\u63a5\u53e3\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/switchAppDataByKm"})
    public ResultBean<?> switchAppDataByKm(@RequestBody KmDeploySwitchParam kmDeploySwitchParam) {
        try {
            String eventId = this.kmDeployerServiceApiHelper.switchAppDataByKm(kmDeploySwitchParam);
            return ResultBean.success((Object)eventId);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528km\u5207\u7248\u63a5\u53e3\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/processLogsByKm"})
    public ResultBean<?> processLogsByKm(@RequestBody KmDeploySwitchParam kmDeploySwitchParam) {
        try {
            JSONArray process = this.kmDeployerServiceApiHelper.processLogsByKm(kmDeploySwitchParam.getEventId(), kmDeploySwitchParam.getCurTenantId());
            return ResultBean.success((Object)process);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528km\u63a5\u53e3\u83b7\u53d6\u5e94\u7528\u53d1\u7248\u6216\u5207\u7248\u8fdb\u5ea6\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/mergeCommonAppRelaWithVirtualTenant"})
    public ResultBean<?> mergeCommonAppRelaWithVirtualTenant(@RequestBody Tenant2NodeRelationParam tenant2NodeRelationParam) {
        try {
            this.kmApiHelper.mergeCommonAppRelaWithVirtualTenant(tenant2NodeRelationParam.getApplication(), tenant2NodeRelationParam.getAppVersion(), tenant2NodeRelationParam.getTenantVersion());
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u516c\u5171\u7c7b\u578b\u5e94\u7528\u4e0e\u865a\u62df\u79df\u6237\u5173\u7cfb\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/deleteCommonAppRelaWithVirtualTenant"})
    public ResultBean<?> deleteCommonAppRelaWithVirtualTenant(@RequestBody Tenant2NodeRelationParam tenant2NodeRelationParam) {
        try {
            this.kmApiHelper.deleteCommonAppRelaWithVirtualTenant(tenant2NodeRelationParam.getApplication(), tenant2NodeRelationParam.getAppVersion(), tenant2NodeRelationParam.getTenantVersion());
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u516c\u5171\u7c7b\u578b\u5e94\u7528\u4e0e\u865a\u62df\u79df\u6237\u5173\u7cfb\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @GetMapping(value={"/testKgRouterKey"})
    public ResultBean<?> testKgRouterKey(String routerKey) {
        try {
            this.kmApiHelper.testKgRouterKey(routerKey);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("\u8c03\u7528km\u63a5\u53e3testKgRouterKey\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/kmDeployTenant"})
    public ResultBean kmDeployTenant(@RequestBody TenantDeployParamDto tenantDeployParam) {
        try {
            this.kmApiHelper.kmDeployTenant(tenantDeployParam);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("/kmDeployTenant \u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/kmRevokeDeployTenant"})
    public ResultBean kmRevokeDeployTenant(@RequestBody TenantDeployParamDto tenantDeployParam) {
        try {
            KmRevokeAppParamDto kmRevokeAppParamDto = KmRevokeAppParamDto.create((TenantDeployParamDto)tenantDeployParam);
            this.kmApiHelper.revokeApp(kmRevokeAppParamDto, tenantDeployParam.getToken());
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("/kmRevokeDeployTenant \u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/syncPushData"})
    public ResultBean syncPushData(@RequestBody SyncPushDataDto dto) {
        try {
            this.kmApiHelper.syncPushData(dto);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("/syncPushData \u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/syncVariableData"})
    public ResultBean syncVariableData(@RequestBody SyncPushDataDto dto) {
        try {
            this.kmApiHelper.syncVariableData(dto);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("/syncVariableData \u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/pushSynonym"})
    public ResultBean pushSynonym(@RequestBody PushSynonymDto dto) {
        try {
            this.scrumbiApiHelper.pushSynonym(dto);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("/pushSynonym \u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @GetMapping(value={"/syncBackUri"})
    public ResultBean syncBackUri(@RequestParam(value="application") String application, @RequestParam(value="appType") String appType, @RequestHeader(value="routerKey") String tenantId) {
        try {
            this.iamApiHelper.syncBackUri(application, appType, tenantId);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("/syncBackUri \u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/pushNounKnowledge"})
    public ResultBean pushNounKnowledge(@RequestBody PushSynonymDto dto) {
        try {
            this.scrumbiApiHelper.pushNounKnowledge(dto);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("/pushNounKnowledge \u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/pushHabitKnowledge"})
    public ResultBean pushHabitKnowledge(@RequestBody PushSynonymDto dto) {
        try {
            this.scrumbiApiHelper.pushHabitKnowledge(dto);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("/pushHabitKnowledge \u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/assistantPublish"})
    public ResultBean assistantPublish(@RequestBody AssistantPublishParam assistantPublishParam, @RequestHeader(value="routerKey") String tenantId) {
        try {
            this.assistantApiHelper.assistantPublish(assistantPublishParam, tenantId);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("/assistantPublish exception:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/pushSynonymToAI"})
    public ResultBean pushSynonymToAI(@RequestBody PushSynonymDto dto) {
        try {
            this.scrumbiApiHelper.pushSynonymToAI(dto);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("/pushSynonym \u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/pushStandardParams"})
    public ResultBean pushStandardParams(@RequestBody PushSynonymDto dto) {
        try {
            this.scrumbiApiHelper.pushStandardParams(dto);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("/pushStandardParams \u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/deployApp"})
    public ResultBean<DeployAppResDto> deployApp(@RequestBody DeployAppReqDto deployAppReqDto) {
        try {
            DeployAppResDto res = this.kmDeployRecordService.deployApp(deployAppReqDto);
            return ResultBean.success((Object)res);
        }
        catch (Exception e) {
            log.error("/deployApp exception:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/switchApp"})
    public ResultBean<DeployAppResDto> switchApp(@RequestBody SwitchAppReqDto switchAppReqDto) {
        try {
            DeployAppResDto res = this.kmDeployRecordService.switchApp(switchAppReqDto);
            return ResultBean.success((Object)res);
        }
        catch (Exception e) {
            log.error("/switchApp exception:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/customTenantProcessPublish"})
    public ResultBean customTenantProcessPublish(@RequestBody CustomPublishParam customPublishParam) {
        try {
            this.customPublishService.customTenantProcessPublish(customPublishParam);
            return ResultBean.success();
        }
        catch (BusinessException e) {
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u6309\u9700\u53d1\u5e03\u5931\u8d25:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/updateVersion"})
    public ResultBean updateVersion(@RequestBody TenantVersionUpdateReqDto tenantVersionUpdateReqDto) {
        try {
            String tenantId = tenantVersionUpdateReqDto.getDeployTenantId();
            tenantVersionUpdateReqDto.setDeployTenantId(null);
            this.kmApiHelper.updateVersion(tenantVersionUpdateReqDto, tenantId);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("/updateVersion exception:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/checkKmTaskStatus"})
    public ResultBean<List<DataPublishStatusResDto>> checkKmTaskStatus(@RequestBody List<DataPublishStatusReqDto> dataPublishStatusReqs) {
        try {
            return ResultBean.success((Object)this.kmDeployRecordService.checkKmTaskStatus(dataPublishStatusReqs));
        }
        catch (Exception e) {
            log.error("/checkKmTaskStatus exception:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/singleModulePublish"})
    public ResultBean<Boolean> singleModulePublishV2(@RequestBody CustomPublishParam customPublishParam) {
        try {
            this.customPublishService.singleModulePublishV2(customPublishParam);
            return ResultBean.success((Object)true);
        }
        catch (Exception e) {
            log.error("/singleModulePublish exception:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/newModulePublish"})
    public ResultBean<Object> newModulePublish(@RequestBody JSONObject jsonObject) {
        try {
            String iamIntegrationToken = this.iamApiHelper.getIamIntegrationToken(jsonObject.getString("tenantId"));
            Object res = this.designerApiHelper.newModulePublish(jsonObject, iamIntegrationToken);
            return ResultBean.success((Object)res);
        }
        catch (Exception e) {
            log.error("/newModulePublish exception:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }
}

