/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.domain.iam.IamCleanTenantReqDto;
import com.digiwin.athena.athena_deployer_service.domain.param.IamAddPolicyParam;
import com.digiwin.athena.athena_deployer_service.domain.param.IamAssignmentAuthorizeParam;
import com.digiwin.athena.athena_deployer_service.domain.system.ResultBean;
import com.digiwin.athena.athena_deployer_service.http.iam.dto.BuyApplicationReqDto;
import com.digiwin.athena.athena_deployer_service.http.iam.dto.DeletePermissionReqDto;
import com.digiwin.athena.athena_deployer_service.http.iam.dto.TenantInfoDto;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam"})
@Tag(name="iam\u8bf7\u6c42", description="ae88ed51-6d51-42e4-bb11-3197d961508a")
public class IamController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamController.class);
    @Autowired
    private IamService iamService;

    @PostMapping(value={"/iamAssignmentAuthorize"})
    public ResultBean<?> iamAssignmentAuthorize(@RequestBody IamAssignmentAuthorizeParam iamAssignmentAuthorizeParam) {
        try {
            this.iamService.iamAssignmentAuthorize(iamAssignmentAuthorizeParam);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("iam assignment authorize error:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/iamAddPolicy"})
    public ResultBean<?> iamAddPolicy(@RequestBody IamAddPolicyParam iamAddPolicyParam) {
        try {
            this.iamService.addPolicy(iamAddPolicyParam);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("iam add policy error:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/getIsvCode"})
    public ResultBean<?> getIsvCode(@RequestParam(value="tenantId") String tenantId) {
        try {
            String isvCode = this.iamService.getIsvCode(tenantId);
            return ResultBean.success((Object)isvCode);
        }
        catch (Exception e) {
            log.error("get IsvCode error:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/commonIamAssignmentAuthorize"})
    public ResultBean<?> commonIamAssignmentAuthorize(@RequestBody IamAssignmentAuthorizeParam iamAssignmentAuthorizeParam) {
        try {
            Long appSid = this.iamService.getAppSid(iamAssignmentAuthorizeParam.getApplication(), iamAssignmentAuthorizeParam.getCurrentUser().getTenantId());
            this.iamService.commonAppModuleCreate(iamAssignmentAuthorizeParam, appSid);
            this.iamService.commonmAssignmentAuthorize(iamAssignmentAuthorizeParam);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("commonAppModuleCreate error:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/commonIamAddPolicy"})
    public ResultBean<?> commonIamAddPolicy(@RequestBody IamAddPolicyParam iamAddPolicyParam) {
        try {
            this.iamService.addCommonPolicy(iamAddPolicyParam);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("iam add policy error:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/iamCleanTenant"})
    @Operation(summary="iam\u6e05\u9664\u7ed1\u5b9a\u79df\u6237")
    public ResultBean<String> iamCleanTenant(@RequestBody IamCleanTenantReqDto iamCleanTenantReqDto) {
        try {
            this.iamService.iamCleanTenant(iamCleanTenantReqDto);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("iamCleanTenant \u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/iamModuleSupplement"})
    @Operation(summary="\u8865\u5145iam\u6a21\u7ec4\u4fe1\u606f")
    public ResultBean<String> iamModuleSupplement(@RequestBody JSONObject param, @RequestHeader(value="routerKey") String tenantId) {
        try {
            String appCode = param.getString("appCode");
            JSONArray moduleParam = param.getJSONArray("moduleParam");
            this.iamService.iamModuleSupplement(appCode, tenantId, moduleParam);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("iamModuleSupplement \u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @GetMapping(value={"/iamPublicActions/{appCode}"})
    @Operation(summary="\u67e5\u8be2iam\u516c\u5171\u4f5c\u4e1a\u4fe1\u606f")
    public ResultBean<JSONArray> getAppPublicActions(@PathVariable String appCode, @RequestHeader(value="routerKey") String tenantId) {
        try {
            JSONArray publicActions = this.iamService.getAppPublicActions(appCode, tenantId);
            return ResultBean.success((Object)publicActions);
        }
        catch (Exception e) {
            log.error("iamPublicActions \u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/buyApplicationTenantInfos"})
    public ResultBean<List<TenantInfoDto>> buyApplicationTenantInfos(@RequestBody BuyApplicationReqDto buyApplicationReqDto) {
        try {
            return ResultBean.success((Object)this.iamService.buyApplicationTenantInfos(buyApplicationReqDto));
        }
        catch (Exception e) {
            log.error(String.format("buyApplicationTenantInfos \u5f02\u5e38:%s", e.getMessage()), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/iamBatchDeletePermissions"})
    public ResultBean<Boolean> iamBatchDeletePermissions(@RequestBody DeletePermissionReqDto deletePermissionReqDto) {
        try {
            return ResultBean.success((Object)this.iamService.iamBatchDeletePermissions(deletePermissionReqDto));
        }
        catch (Exception e) {
            log.error(String.format("iamBatchDeletePermissions \u5f02\u5e38:%s", e.getMessage()), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @GetMapping(value={"/appActionAttribute/{appCode}"})
    @Operation(summary="\u67e5\u8be2iam\u4f5c\u4e1a\u4fe1\u606f")
    public ResultBean<JSONObject> getAppActionAttribute(@PathVariable String appCode, @RequestHeader(value="routerKey") String tenantId) {
        try {
            return ResultBean.success((Object)this.iamService.getAppActionAttribute(appCode, tenantId));
        }
        catch (Exception e) {
            log.error("appActionAttribute \u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }
}

