/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.controller;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.dao.KmDeployCleanApp;
import com.digiwin.athena.athena_deployer_service.domain.system.ResultBean;
import com.digiwin.athena.athena_deployer_service.http.km.KmApiHelper;
import com.digiwin.athena.athena_deployer_service.http.kmDeployerService.KmDeployerServiceApiHelper;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/km"})
public class KmController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KmController.class);
    @Autowired
    private KmApiHelper kmApiHelper;
    private KmDeployerServiceApiHelper kmDeployerServiceApiHelper;

    @Autowired
    public void setKmDeployerServiceApiHelper(KmDeployerServiceApiHelper kmDeployerServiceApiHelper) {
        this.kmDeployerServiceApiHelper = kmDeployerServiceApiHelper;
    }

    @PostMapping(value={"/monitorChange"})
    public ResultBean<?> publish(@RequestBody JSONObject requestBody) {
        try {
            this.kmApiHelper.publishEventToKM(requestBody);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("km monitorChange error:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/applyMechanisms/{tenantId}"})
    public ResultBean<?> applyMechanisms(@PathVariable String tenantId, @RequestBody JSONObject requestBody) {
        try {
            this.kmApiHelper.applyMechanisms(requestBody, tenantId);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("km applyMechanisms error:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/deployCleanApp"})
    public ResultBean<?> deployCleanApp(@RequestBody KmDeployCleanApp kmDeployCleanApp) {
        try {
            this.kmApiHelper.deployCleanApp(kmDeployCleanApp.getTenantId(), kmDeployCleanApp.getSourceId(), kmDeployCleanApp.getAppId());
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("km deployCleanApp error:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @GetMapping(value={"/kmCheckApp"})
    public ResultBean<Boolean> kmCheckApp(String sourceId, String tenantId) {
        try {
            return ResultBean.success((Object)this.kmDeployerServiceApiHelper.checkApp(sourceId, tenantId));
        }
        catch (Exception e) {
            log.error(String.format("kmCheckApp \u5f02\u5e38:%s", e.getMessage()), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)String.format("kmCheckApp \u5f02\u5e38:%s", e.getMessage()));
        }
    }
}

