/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.controller;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.athena_deployer_service.domain.system.ResultBean;
import com.digiwin.athena.athena_deployer_service.publish.ModelDrivenPublish;
import com.digiwin.athena.athena_deployer_service.service.deploy.AsyncService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/modulePublish"})
@RestController
public class ModulePublishRecordController {
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private ModelDrivenPublish modelDrivenPublish;
    @Value(value="${envMode}")
    private String envMode;

    @PostMapping(value={"/record"})
    public ResultBean<?> publishRecord(@RequestBody JSONObject modulePublishRecordParam) {
        try {
            String targetTenantId = modulePublishRecordParam.getString("targetTenantId");
            String application = modulePublishRecordParam.getString("application");
            String code = modulePublishRecordParam.getString("code");
            String operateType = modulePublishRecordParam.getString("sourceType");
            String serviceCode = modulePublishRecordParam.getString("serviceCode");
            JSONObject modelSchema = modulePublishRecordParam.getJSONObject("modelSchema");
            this.asyncService.moduleAssignPublishRecord(targetTenantId, this.envMode, application, code, operateType, serviceCode, modelSchema);
            return ResultBean.success();
        }
        catch (BusinessException e) {
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/checkIsNeedPublish"})
    public ResultBean<?> checkIsNeedPublish(@RequestBody JSONObject modulePublishRecordParam) {
        String targetTenantId = modulePublishRecordParam.getString("targetTenantId");
        String application = modulePublishRecordParam.getString("application");
        String code = modulePublishRecordParam.getString("code");
        Date editDate = modulePublishRecordParam.getDate("editDate");
        String serviceCode = modulePublishRecordParam.getString("serviceCode");
        JSONObject modelSchema = modulePublishRecordParam.getJSONObject("modelSchema");
        return ResultBean.success((Object)this.modelDrivenPublish.checkIsNeedPublish(targetTenantId, this.envMode, application, code, editDate, serviceCode, modelSchema));
    }
}

