/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.domain.apimgmt.ApiMgmtBaseInfo;
import com.digiwin.athena.athena_deployer_service.domain.param.DeleteFormSchemaParam;
import com.digiwin.athena.athena_deployer_service.domain.param.IamPublishParam;
import com.digiwin.athena.athena_deployer_service.domain.param.KmPublishParam;
import com.digiwin.athena.athena_deployer_service.domain.param.SchemaPublishParam;
import com.digiwin.athena.athena_deployer_service.domain.param.TbbPublishParam;
import com.digiwin.athena.athena_deployer_service.domain.system.ResultBean;
import com.digiwin.athena.athena_deployer_service.service.apimgmt.ApimgmtService;
import com.digiwin.athena.athena_deployer_service.service.deploy.ActivityService;
import com.digiwin.athena.athena_deployer_service.service.deploy.PageDesignService;
import com.digiwin.athena.athena_deployer_service.service.deploy.TenantService;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pageDesign"})
public class PageDesignController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PageDesignController.class);
    @Autowired
    private PageDesignService pageDesignService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ApimgmtService apimgmtService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private IamService iamService;

    @PostMapping(value={"/schemaPublish"})
    public ResultBean<?> schemaPublish(@RequestBody SchemaPublishParam schemaPublishParam) {
        try {
            this.pageDesignService.schemaPublish(schemaPublishParam.getToken(), schemaPublishParam.getAppToken(), schemaPublishParam.getTargetTenantIds(), schemaPublishParam.getForm(), schemaPublishParam.getParams());
        }
        catch (Exception e) {
            log.error("schema publish error:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        return ResultBean.success();
    }

    @PostMapping(value={"/iamPublish"})
    public ResultBean<?> iamPublish(@RequestBody IamPublishParam iamPublishParam) {
        try {
            String integrationToken = this.iamService.getIntegrationToken(iamPublishParam.getTenantId());
            this.pageDesignService.iamPublish(integrationToken, iamPublishParam.getApplication(), iamPublishParam.getTenantSids(), iamPublishParam.getActivityList(), iamPublishParam.getModuleId());
        }
        catch (Exception e) {
            log.error("iam publish error:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        return ResultBean.success();
    }

    @PostMapping(value={"/kmPublish"})
    public ResultBean<?> kmPublish(@RequestBody KmPublishParam kmPublishParam) {
        try {
            List activityList = this.pageDesignService.kmPublish(kmPublishParam.getApplication(), kmPublishParam.getPageDesignDataList(), kmPublishParam.getTenantIds());
            return ResultBean.success((Object)activityList);
        }
        catch (Exception e) {
            log.error("km publish error:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/tbbPublish"})
    public ResultBean<?> tbbPublish(@RequestBody TbbPublishParam tbbPublishParam) {
        try {
            JSONObject jsonObject = this.pageDesignService.tbbPublish(tbbPublishParam.getToken(), null, tbbPublishParam.getLevel(), tbbPublishParam.getApplication(), tbbPublishParam.getTableinfo());
            return ResultBean.success((Object)jsonObject);
        }
        catch (Exception e) {
            log.error("km publish error:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/deleteFormSchema"})
    public ResultBean<?> deleteFormSchema(@RequestBody DeleteFormSchemaParam deleteFormSchemaParam) {
        try {
            this.pageDesignService.deleteSchema(deleteFormSchemaParam.getToken(), deleteFormSchemaParam.getAppToken(), deleteFormSchemaParam.getFormId());
        }
        catch (Exception e) {
            log.error("iam publish error:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        return ResultBean.success();
    }

    @GetMapping(value={"/queryActivity"})
    public ResultBean<?> queryActivity(@RequestParam(value="code") String code) {
        JSONObject jsonObject = this.activityService.queryByCode(code);
        return ResultBean.success((Object)jsonObject);
    }

    @PostMapping(value={"/publishModel"})
    public ResultBean<?> publishModel(@RequestBody JSONObject data) {
        try {
            String token = data.getString("token");
            String appToken = data.getString("appToken");
            JSONObject publishModel = data.getJSONObject("publishModel");
            String tenantId = data.getString("tenantId");
            String serviceCode = data.getString("serviceCode");
            String modelCode = data.getString("code");
            JSONArray apiBaseInfos = data.getJSONArray("apiBaseInfos");
            this.pageDesignService.publishModel(token, appToken, publishModel, tenantId, serviceCode, modelCode, apiBaseInfos);
        }
        catch (Exception e) {
            log.error("Failed to publish modelDriven:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        return ResultBean.success();
    }

    @PostMapping(value={"/deleteModel"})
    public ResultBean<?> deleteModel(@RequestBody JSONObject data) {
        try {
            String tenantId = data.getString("tenantId");
            String token = this.iamService.getIntegrationToken(tenantId);
            String appToken = data.getString("appToken");
            JSONObject deleteModelDrivenInfo = data.getJSONObject("deleteModelDrivenInfo");
            this.pageDesignService.deleteModel(token, appToken, deleteModelDrivenInfo, tenantId);
        }
        catch (Exception e) {
            log.error("Failed to delete modelDriven:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        return ResultBean.success();
    }

    @PostMapping(value={"/publishActionMetaData"})
    public ResultBean<List<ApiMgmtBaseInfo>> publishActionMetaData(@RequestBody JSONObject data) {
        List apiMgmtBaseInfos;
        try {
            String apimgmtUrl = data.getString("apimgmtUrl");
            String apimgmtIntegrationToken = data.getString("apimgmtIntegrationToken");
            JSONArray publishActionMetaDataInfo = data.getJSONArray("publishActionMetaDataInfo");
            List noPublishApis = (List)data.get((Object)"noPublishApis");
            log.info("noPublishApis:{}", (Object)JSONObject.toJSONString((Object)noPublishApis));
            apiMgmtBaseInfos = this.apimgmtService.publishActionMeataDataToApimgmt(publishActionMetaDataInfo, apimgmtIntegrationToken, noPublishApis, apimgmtUrl);
        }
        catch (Exception e) {
            log.error("The application failed to publish metadata to the API management platform:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        return ResultBean.success((Object)apiMgmtBaseInfos);
    }

    @PostMapping(value={"/deleteActionMetaData"})
    public ResultBean<?> overallPublishModel(@RequestBody JSONObject data) {
        try {
            String apimgmtIntegrationToken = data.getString("apimgmtIntegrationToken");
            String apimgmtUrl = data.getString("apimgmtUrl");
            JSONObject deleteActionMetaDataInfo = data.getJSONObject("deleteActionMetaDataInfo");
            this.apimgmtService.deleteActionMeataDataInApimgmt(deleteActionMetaDataInfo, apimgmtIntegrationToken, apimgmtUrl);
        }
        catch (Exception e) {
            log.error("Application failed to delete actionMetaData in API management platform:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        return ResultBean.success();
    }

    @PostMapping(value={"/deleteApiMetaData"})
    public ResultBean<?> deleteApiMetaData(@RequestBody JSONObject data) {
        try {
            String apimgmtIntegrationToken = data.getString("apimgmtIntegrationToken");
            String apimgmtUrl = data.getString("apimgmtUrl");
            JSONArray deleteApiMetaDataInfo = data.getJSONArray("deleteApiMetaDataInfos");
            this.apimgmtService.deleteApiMetaData(deleteApiMetaDataInfo, apimgmtIntegrationToken, apimgmtUrl);
        }
        catch (Exception e) {
            log.error("Application failed to delete actionMetaData in API management platform:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        return ResultBean.success();
    }

    @PostMapping(value={"/deleteAppModel"})
    public ResultBean<?> deleteAppModel(@RequestBody JSONObject data) {
        try {
            String tenantId = data.getString("tenantId");
            String token = this.iamService.getIntegrationToken(tenantId);
            String appToken = data.getString("appToken");
            this.pageDesignService.deleteAppModel(token, appToken, data, tenantId);
        }
        catch (Exception e) {
            log.error("Failed to delete modelDriven:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        return ResultBean.success();
    }
}

