/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.controller;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.domain.deploy.PublishJobAndModelDataParam;
import com.digiwin.athena.athena_deployer_service.domain.deploy.PublishSyncDataParam;
import com.digiwin.athena.athena_deployer_service.domain.system.ResultBean;
import com.digiwin.athena.athena_deployer_service.http.emc.EmcApiHelper;
import com.digiwin.athena.athena_deployer_service.service.esp.ESPService;
import com.digiwin.athena.athena_deployer_service.util.VersionCompareUtils;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/publish/sync"})
public class PublishSyncDataController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PublishSyncDataController.class);
    @Autowired
    private ESPService eSPService;
    @Autowired
    private EmcApiHelper dapApiHelper;

    @PostMapping(value={"/syncDataViewToLcdpDataView"})
    public void syncDataViewToLcdp(@RequestBody PublishSyncDataParam publishSyncDataParam) {
        this.eSPService.callDataViewEspServiceApi(publishSyncDataParam.getDataViewMap(), publishSyncDataParam.getTenantId(), publishSyncDataParam.getAppToken(), publishSyncDataParam.getServiceCode());
    }

    @PostMapping(value={"/syncActivityAndModelToLcdp"})
    public void syncActivityAndModelToLcdp(@RequestBody PublishJobAndModelDataParam publishJobAndModelDataParam) {
        this.eSPService.callActivityEspServiceApi(publishJobAndModelDataParam.getActivityAndModelMap(), publishJobAndModelDataParam.getApplication(), publishJobAndModelDataParam.getPublishFlag(), publishJobAndModelDataParam.getTenantId(), publishJobAndModelDataParam.getAppToken(), publishJobAndModelDataParam.getServiceCode());
    }

    @PostMapping(value={"/judgeModelDrivenEvnVersion"})
    public ResultBean<String> judgeModelDrivenEvnVersion(@RequestBody PublishJobAndModelDataParam publishJobAndModelDataParam) {
        List serviceCodes = publishJobAndModelDataParam.getServiceCodes();
        if (CollUtil.isNotEmpty((Collection)serviceCodes)) {
            try {
                String compareVersion = publishJobAndModelDataParam.getCompareVersion();
                String tenantId = publishJobAndModelDataParam.getTenantId();
                String appToken = publishJobAndModelDataParam.getAppToken();
                for (String serviceCode : serviceCodes) {
                    String version = this.eSPService.getModelDrivenEvnVersion(tenantId, appToken, serviceCode, compareVersion);
                    String[] versions = version.split("-");
                    int compare = VersionCompareUtils.compareVersion((String)versions[0], (String)compareVersion);
                    if (compare >= 0) continue;
                    return ResultBean.fail((Integer)-1, (String)String.format("%s\u670d\u52a1SDK\u7248\u672c\u9700\u8981\u5347\u7ea7\u81f3%s\uff0cDAP\u7248\u672c\u9700\u8981\u5347\u7ea7\u81f35.2.0.1136(\u542b)\u4ee5\u4e0a\uff01", serviceCode, compareVersion));
                }
            }
            catch (Exception e) {
                return ResultBean.fail((Integer)-1, (String)e.getMessage());
            }
        }
        return ResultBean.success();
    }

    @PostMapping(value={"/syncMessageCenterToDap"})
    public ResultBean<?> syncMessageCenterToDap(@RequestBody JSONObject jsonObject) {
        try {
            this.dapApiHelper.publishSyncDap(jsonObject);
        }
        catch (Exception e) {
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        return ResultBean.success();
    }
}

