/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.domain.param.AuthUserParam;
import com.digiwin.athena.athena_deployer_service.domain.param.GmcUpdateParam;
import com.digiwin.athena.athena_deployer_service.domain.param.PolicyBatchAddParam;
import com.digiwin.athena.athena_deployer_service.domain.param.Tenant2NodeRelationParam;
import com.digiwin.athena.athena_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.athena_deployer_service.domain.system.ResultBean;
import com.digiwin.athena.athena_deployer_service.domain.system.TenantUserResult;
import com.digiwin.athena.athena_deployer_service.service.deploy.TenantService;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tenant"})
public class TenantController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantController.class);
    @Autowired
    private TenantService tenantService;
    @Autowired
    private IamService iamService;

    @PostMapping(value={"authTenantUser"})
    public JSONObject authTenantUser(@RequestBody AuthUserParam authUserParam, @RequestHeader(value="digi-middleware-auth-user") String token) {
        JSONObject jsonObject = this.tenantService.authUser(authUserParam, token);
        return jsonObject;
    }

    @PostMapping(value={"policyBatchAdd"})
    public JSONObject policyBatchAdd(@RequestBody PolicyBatchAddParam policyBatchAddParam, @RequestHeader(value="routerKey") String tenantId) {
        if (StrUtil.isEmpty((CharSequence)tenantId)) {
            throw new BusinessException("The header data is missing the routerKey information.");
        }
        String curToken = this.iamService.getIntegrationToken(tenantId);
        JSONObject jsonObject = this.tenantService.policyBatch(policyBatchAddParam, curToken, null);
        return jsonObject;
    }

    @PostMapping(value={"updateGmcMoudle"})
    public JSONObject updateGmcMoudle(@RequestBody GmcUpdateParam gmcUpdateParam, @RequestHeader(value="digi-middleware-auth-user") String token) {
        JSONObject jsonObject = this.tenantService.updateGmcModule(gmcUpdateParam, token);
        return jsonObject;
    }

    @PostMapping(value={"updateCommonGmcModule"})
    public JSONObject updateCommonGmcModule(@RequestBody GmcUpdateParam gmcUpdateParam) {
        JSONObject jsonObject = this.tenantService.updateCommonGmcModule(gmcUpdateParam);
        return jsonObject;
    }

    @PostMapping(value={"gmcModuleSupplement"})
    public JSONObject gmcModuleSupplement(@RequestBody GmcUpdateParam gmcUpdateParam) {
        JSONObject jsonObject = this.tenantService.gmcModuleSupplement(gmcUpdateParam);
        return jsonObject;
    }

    @GetMapping(value={"allTenant"})
    public JSONObject allTenant(@RequestParam String tenantId) {
        JSONObject jsonObject = this.tenantService.queryUserTenants(tenantId);
        return jsonObject;
    }

    @GetMapping(value={"allUserInTenant"})
    public TenantUserResult allUserInTenant(@RequestParam String tenantId, @RequestHeader(value="digi-middleware-auth-user") String token, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(defaultValue="1") Integer pageNum) {
        String curToken = this.iamService.getIntegrationToken(tenantId);
        return this.tenantService.queryUserInTenant(tenantId, curToken, pageSize, pageNum);
    }

    @PostMapping(value={"getAuthAppTenantIdList"})
    public ResultBean allUserInTenant(@RequestBody Tenant2NodeRelationParam tenant2NodeRelationParam) {
        List authAppTenantIdList = this.tenantService.getAuthAppTenantIdList(tenant2NodeRelationParam.getApplication(), tenant2NodeRelationParam.getTenantVersion(), tenant2NodeRelationParam.getTenantIds());
        return ResultBean.success((Object)authAppTenantIdList);
    }

    @PostMapping(value={"createTenantAndApplicationRelation"})
    public ResultBean createTenantAndApplicationRelation(@RequestBody Tenant2NodeRelationParam tenant2NodeRelationParam) {
        this.tenantService.createTenantAndApplicationRelation(tenant2NodeRelationParam.getApplication(), tenant2NodeRelationParam.getTenantVersion(), tenant2NodeRelationParam.getAppVersion(), tenant2NodeRelationParam.getTenantIds());
        return ResultBean.success();
    }

    @PostMapping(value={"createAllAuthTenantAndApplicationRelation"})
    public ResultBean createAllAuthTenantAndApplicationRelation(@RequestBody Tenant2NodeRelationParam tenant2NodeRelationParam) {
        this.tenantService.createAllAuthTenantAndApplicationRelation(tenant2NodeRelationParam.getApplication(), tenant2NodeRelationParam.getTenantVersion(), tenant2NodeRelationParam.getAppVersion());
        return ResultBean.success();
    }

    @PostMapping(value={"createTenantAndCommonRelation"})
    public ResultBean createTenantAndCommonRelation(@RequestBody Tenant2NodeRelationParam tenant2NodeRelationParam) {
        this.tenantService.createTenantAndCommonRelation(tenant2NodeRelationParam.getTenantIds(), tenant2NodeRelationParam.getTenantVersion());
        return ResultBean.success();
    }

    @GetMapping(value={"createAllTenantAndCommonRelation/{version}"})
    public ResultBean createAllTenantAndCommonRelation(@PathVariable String version) {
        this.tenantService.createAllTenantAndCommonRelation(version);
        return ResultBean.success();
    }

    @GetMapping(value={"currentUserExistInTenant"})
    public boolean currentUserExistInTenant(@RequestParam String userId, @RequestParam String tenantId, @RequestHeader(value="digi-middleware-auth-user") String token) {
        boolean exist = this.tenantService.currentUserExistInTenant(userId, tenantId, token);
        return exist;
    }

    @PostMapping(value={"modifyTenantRelaWithNotMatchAppDataInSwitch"})
    public ResultBean modifyTenantRelaWithNotMatchAppDataInSwitch(@RequestBody Tenant2NodeRelationParam tenant2NodeRelationParam) {
        this.tenantService.modifyTenantRelaWithNotMatchAppDataInSwitch(tenant2NodeRelationParam.getApplication(), tenant2NodeRelationParam.getTenantIds(), tenant2NodeRelationParam.getCommonApp());
        return ResultBean.success();
    }

    @PostMapping(value={"modifyTenantRelaWithNotMatchAppDataInPublish"})
    public ResultBean modifyTenantRelaWithNotMatchAppDataInPublish(@RequestBody Tenant2NodeRelationParam tenant2NodeRelationParam) {
        this.tenantService.modifyTenantRelaWithNotMatchAppDataInPublish(tenant2NodeRelationParam.getApplication(), tenant2NodeRelationParam.getTenantIds());
        return ResultBean.success();
    }

    @PostMapping(value={"modifyTenantConfig"})
    public ResultBean modifyTenantConfig(@RequestBody Tenant2NodeRelationParam tenant2NodeRelationParam) {
        this.tenantService.modifyTenantConfig(tenant2NodeRelationParam.getTenantVersion(), tenant2NodeRelationParam.getTenantIds());
        return ResultBean.success();
    }

    @GetMapping(value={"tenantVersion/{tenantId}"})
    public ResultBean getTenantVersionByTenantId(@PathVariable String tenantId) {
        List tenantVersionByTenantId = this.tenantService.getTenantVersionByTenantId(tenantId);
        return ResultBean.success((Object)tenantVersionByTenantId);
    }

    @GetMapping(value={"appRelatenantVersion/{appCode}"})
    public ResultBean getAppRelatenantVersion(@PathVariable String appCode) {
        List tenantVersionByTenantId = this.tenantService.getTenantVersionByApp(appCode);
        return ResultBean.success((Object)tenantVersionByTenantId);
    }

    @GetMapping(value={"/getIntegrationToken"})
    public ResultBean<String> getIntegrationToken(@RequestParam String tenantId) {
        String curToken = this.iamService.getIntegrationToken(tenantId);
        return ResultBean.success((Object)curToken);
    }

    @PostMapping(value={"curTenantVersion"})
    public ResultBean getAppRelatenantVersion(@RequestBody List<String> tenantIdList) {
        Map tenantVersion = this.tenantService.getTenantVersion(tenantIdList);
        return ResultBean.success((Object)tenantVersion);
    }

    @PostMapping(value={"mergeRelationBetweenTenantAndAppInVersionChange"})
    public ResultBean mergeRelationBetweenTenantAndAppInVersionChange(@RequestBody Tenant2NodeRelationParam tenant2NodeRelationParam) {
        this.tenantService.mergeRelationBetweenTenantAndAppInVersionChange(tenant2NodeRelationParam.getApplication(), tenant2NodeRelationParam.getTenantIds(), tenant2NodeRelationParam.getTargetVersion(), tenant2NodeRelationParam.getTenantVersionMap());
        return ResultBean.success();
    }

    @GetMapping(value={"sameCustomIdTenantVersion/{tenantId}"})
    public ResultBean getTenantVersion(@PathVariable String tenantId) {
        List tenantVersionByTenantId = this.tenantService.getTenantVersionBySameCustomId(tenantId);
        return ResultBean.success((Object)tenantVersionByTenantId);
    }
}

