/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.domain.dsl;

import com.digiwin.athena.athena_deployer_service.domain.dsl.GroupMetadataField;
import com.digiwin.athena.athena_deployer_service.domain.dsl.OperationDTO;
import com.digiwin.athena.athena_deployer_service.domain.dsl.Precision;
import com.digiwin.athena.athena_deployer_service.domain.dsl.TagDefinition;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MetadataField
implements Serializable {
    private String name;
    private String path;
    private boolean required;
    private String description;
    private String remark;
    private String dataKey;
    private boolean businessKey;
    private String dataType;
    @JsonIgnore
    private int displayWidth;
    private Precision precision;
    private Object objectData;
    private Boolean canSort;
    private String fieldType;
    private boolean canEdit;
    private List<TagDefinition> tagDefinitions;
    private List<MetadataField> subFields;
    @JsonIgnore
    private List<MetadataField> exportTableFields;
    private boolean array;
    @JsonIgnore
    private String sourceApi;
    @JsonIgnore
    private String clientAgent;
    private String enumKey;
    @JsonIgnore
    private Map<String, MetadataField> fieldMap;
    @JsonIgnore
    private MetadataField parentField;
    @JsonIgnore
    private List<GroupMetadataField> groupMetadataFields;
    @JsonIgnore
    private List<OperationDTO> operations;
    private String uiBot;

    @JsonIgnore
    public boolean isSimpleField() {
        if ("object".equals(this.getDataType())) {
            return false;
        }
        return !this.isArray();
    }

    @JsonIgnore
    public boolean isObjectField() {
        return "object".equals(this.getDataType());
    }

    public MetadataField findByFullPath(String fullName) {
        if (StringUtils.isEmpty((Object)fullName)) {
            return null;
        }
        if (this.getFullName().equals(fullName)) {
            return this;
        }
        if (fullName.startsWith(this.getName() + ".")) {
            String path = fullName.replace(this.getName() + ".", "");
            return this.findByPath(path.split("\\."));
        }
        return null;
    }

    public void addField(MetadataField metadataField) {
        if (this.exist(metadataField.getName())) {
            return;
        }
        this.getSubFields().add(metadataField);
        if (this.getFieldMap() == null) {
            this.setFieldMap(new HashMap());
        }
        this.getFieldMap().put(metadataField.getName(), metadataField);
    }

    public MetadataField getField(String name) {
        if (this.exist(name)) {
            return null;
        }
        return (MetadataField)this.getFieldMap().get(name);
    }

    public boolean exist(String name) {
        if (this.getFieldMap() == null) {
            this.flatMetaData(this.getParentField());
        }
        return this.getFieldMap() != null && this.getFieldMap().containsKey(name);
    }

    public MetadataField clone(MetadataField parentMetadataField, List<MetadataField> sonTagFields) {
        MetadataField newMetadataField = new MetadataField();
        newMetadataField.setDataType(this.getDataType());
        newMetadataField.setDataKey(this.getDataKey());
        newMetadataField.setRemark(this.getRemark());
        newMetadataField.setDescription(this.getDescription());
        newMetadataField.setRequired(this.isRequired());
        newMetadataField.setName(this.getName());
        newMetadataField.setArray(this.isArray());
        newMetadataField.setCanEdit(this.isCanEdit());
        newMetadataField.setTagDefinitions(this.getTagDefinitions());
        newMetadataField.setFieldType(this.getFieldType());
        newMetadataField.setSubFields(sonTagFields);
        newMetadataField.setPath(this.getPath());
        newMetadataField.setParentField(parentMetadataField);
        newMetadataField.setEnumKey(this.getEnumKey());
        return newMetadataField;
    }

    public void flatMetaData(MetadataField parentField) {
        if (CollectionUtils.isEmpty((Collection)this.getSubFields())) {
            return;
        }
        HashMap<String, MetadataField> fieldMap = new HashMap<String, MetadataField>();
        this.setFieldMap(fieldMap);
        this.setParentField(parentField);
        for (MetadataField subField : this.getSubFields()) {
            fieldMap.put(subField.getName(), subField);
            String path = this.getFullName();
            subField.setPath(path);
            subField.flatMetaData(this);
        }
    }

    public void flatMetaDataNotFlatPath(MetadataField parentField) {
        if (CollectionUtils.isEmpty((Collection)this.getSubFields())) {
            return;
        }
        HashMap<String, MetadataField> fieldMap = new HashMap<String, MetadataField>();
        this.setFieldMap(fieldMap);
        this.setParentField(parentField);
        for (MetadataField subField : this.getSubFields()) {
            fieldMap.put(subField.getName(), subField);
            subField.setPath(subField.getPath());
            subField.flatMetaDataNotFlatPath(this);
        }
    }

    public MetadataField findByPath(String[] paths) {
        if (paths == null || paths.length == 0) {
            return null;
        }
        String firstPath = paths[0];
        if (this.getFieldMap() == null || !this.getFieldMap().containsKey(firstPath)) {
            return null;
        }
        if (paths.length == 1) {
            return (MetadataField)this.getFieldMap().get(firstPath);
        }
        return ((MetadataField)this.getFieldMap().get(firstPath)).findByPath((String[])ArrayUtils.subarray((Object[])paths, (int)1, (int)paths.length));
    }

    public static MetadataField createArrayField(String name, String description, String path, boolean canEdit) {
        MetadataField detailField = new MetadataField();
        detailField.setFieldType("object");
        detailField.setName(name);
        detailField.setDescription(description);
        detailField.setDataType("object");
        detailField.setArray(true);
        detailField.setCanEdit(canEdit);
        detailField.setSubFields(new ArrayList());
        detailField.setPath((String)(StringUtils.isEmpty((Object)path) ? name : path + "." + name));
        return detailField;
    }

    public static MetadataField createObjectField(String name, String description, String path, boolean canEdit) {
        MetadataField detailField = new MetadataField();
        detailField.setFieldType("object");
        detailField.setName(name);
        detailField.setDescription(description);
        detailField.setDataType("object");
        detailField.setArray(false);
        detailField.setSubFields(new ArrayList());
        detailField.setCanEdit(canEdit);
        detailField.setPath((String)(StringUtils.isEmpty((Object)path) ? name : path + "." + name));
        return detailField;
    }

    public static MetadataField createSimpleField(String name, String description, String type, String path, boolean canEdit) {
        MetadataField detailField = new MetadataField();
        detailField.setFieldType(type);
        detailField.setName(name);
        detailField.setDescription(description);
        detailField.setDataType(type);
        detailField.setArray(false);
        detailField.setCanEdit(canEdit);
        detailField.setPath((String)(StringUtils.isEmpty((Object)path) ? name : path + "." + name));
        return detailField;
    }

    @JsonIgnore
    public String getFullName() {
        if (StringUtils.hasText((String)this.getPath())) {
            return this.getPath() + "." + this.getName();
        }
        return this.getName();
    }

    public String toString() {
        return this.getName();
    }

    @Generated
    public MetadataField() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public boolean isRequired() {
        return this.required;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getRemark() {
        return this.remark;
    }

    @Generated
    public String getDataKey() {
        return this.dataKey;
    }

    @Generated
    public boolean isBusinessKey() {
        return this.businessKey;
    }

    @Generated
    public String getDataType() {
        return this.dataType;
    }

    @Generated
    public int getDisplayWidth() {
        return this.displayWidth;
    }

    @Generated
    public Precision getPrecision() {
        return this.precision;
    }

    @Generated
    public Object getObjectData() {
        return this.objectData;
    }

    @Generated
    public Boolean getCanSort() {
        return this.canSort;
    }

    @Generated
    public String getFieldType() {
        return this.fieldType;
    }

    @Generated
    public boolean isCanEdit() {
        return this.canEdit;
    }

    @Generated
    public List<TagDefinition> getTagDefinitions() {
        return this.tagDefinitions;
    }

    @Generated
    public List<MetadataField> getSubFields() {
        return this.subFields;
    }

    @Generated
    public List<MetadataField> getExportTableFields() {
        return this.exportTableFields;
    }

    @Generated
    public boolean isArray() {
        return this.array;
    }

    @Generated
    public String getSourceApi() {
        return this.sourceApi;
    }

    @Generated
    public String getClientAgent() {
        return this.clientAgent;
    }

    @Generated
    public String getEnumKey() {
        return this.enumKey;
    }

    @Generated
    public Map<String, MetadataField> getFieldMap() {
        return this.fieldMap;
    }

    @Generated
    public MetadataField getParentField() {
        return this.parentField;
    }

    @Generated
    public List<GroupMetadataField> getGroupMetadataFields() {
        return this.groupMetadataFields;
    }

    @Generated
    public List<OperationDTO> getOperations() {
        return this.operations;
    }

    @Generated
    public String getUiBot() {
        return this.uiBot;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Generated
    public void setDataKey(String dataKey) {
        this.dataKey = dataKey;
    }

    @Generated
    public void setBusinessKey(boolean businessKey) {
        this.businessKey = businessKey;
    }

    @Generated
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    @JsonIgnore
    @Generated
    public void setDisplayWidth(int displayWidth) {
        this.displayWidth = displayWidth;
    }

    @Generated
    public void setPrecision(Precision precision) {
        this.precision = precision;
    }

    @Generated
    public void setObjectData(Object objectData) {
        this.objectData = objectData;
    }

    @Generated
    public void setCanSort(Boolean canSort) {
        this.canSort = canSort;
    }

    @Generated
    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    @Generated
    public void setCanEdit(boolean canEdit) {
        this.canEdit = canEdit;
    }

    @Generated
    public void setTagDefinitions(List<TagDefinition> tagDefinitions) {
        this.tagDefinitions = tagDefinitions;
    }

    @Generated
    public void setSubFields(List<MetadataField> subFields) {
        this.subFields = subFields;
    }

    @JsonIgnore
    @Generated
    public void setExportTableFields(List<MetadataField> exportTableFields) {
        this.exportTableFields = exportTableFields;
    }

    @Generated
    public void setArray(boolean array) {
        this.array = array;
    }

    @JsonIgnore
    @Generated
    public void setSourceApi(String sourceApi) {
        this.sourceApi = sourceApi;
    }

    @JsonIgnore
    @Generated
    public void setClientAgent(String clientAgent) {
        this.clientAgent = clientAgent;
    }

    @Generated
    public void setEnumKey(String enumKey) {
        this.enumKey = enumKey;
    }

    @JsonIgnore
    @Generated
    public void setFieldMap(Map<String, MetadataField> fieldMap) {
        this.fieldMap = fieldMap;
    }

    @JsonIgnore
    @Generated
    public void setParentField(MetadataField parentField) {
        this.parentField = parentField;
    }

    @JsonIgnore
    @Generated
    public void setGroupMetadataFields(List<GroupMetadataField> groupMetadataFields) {
        this.groupMetadataFields = groupMetadataFields;
    }

    @JsonIgnore
    @Generated
    public void setOperations(List<OperationDTO> operations) {
        this.operations = operations;
    }

    @Generated
    public void setUiBot(String uiBot) {
        this.uiBot = uiBot;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetadataField)) {
            return false;
        }
        MetadataField other = (MetadataField)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isRequired() != other.isRequired()) {
            return false;
        }
        if (this.isBusinessKey() != other.isBusinessKey()) {
            return false;
        }
        if (this.getDisplayWidth() != other.getDisplayWidth()) {
            return false;
        }
        if (this.isCanEdit() != other.isCanEdit()) {
            return false;
        }
        if (this.isArray() != other.isArray()) {
            return false;
        }
        Boolean this$canSort = this.getCanSort();
        Boolean other$canSort = other.getCanSort();
        if (this$canSort == null ? other$canSort != null : !((Object)this$canSort).equals(other$canSort)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        String this$dataKey = this.getDataKey();
        String other$dataKey = other.getDataKey();
        if (this$dataKey == null ? other$dataKey != null : !this$dataKey.equals(other$dataKey)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        Precision this$precision = this.getPrecision();
        Precision other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !this$precision.equals(other$precision)) {
            return false;
        }
        Object this$objectData = this.getObjectData();
        Object other$objectData = other.getObjectData();
        if (this$objectData == null ? other$objectData != null : !this$objectData.equals(other$objectData)) {
            return false;
        }
        String this$fieldType = this.getFieldType();
        String other$fieldType = other.getFieldType();
        if (this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType)) {
            return false;
        }
        List this$tagDefinitions = this.getTagDefinitions();
        List other$tagDefinitions = other.getTagDefinitions();
        if (this$tagDefinitions == null ? other$tagDefinitions != null : !((Object)this$tagDefinitions).equals(other$tagDefinitions)) {
            return false;
        }
        List this$subFields = this.getSubFields();
        List other$subFields = other.getSubFields();
        if (this$subFields == null ? other$subFields != null : !((Object)this$subFields).equals(other$subFields)) {
            return false;
        }
        List this$exportTableFields = this.getExportTableFields();
        List other$exportTableFields = other.getExportTableFields();
        if (this$exportTableFields == null ? other$exportTableFields != null : !((Object)this$exportTableFields).equals(other$exportTableFields)) {
            return false;
        }
        String this$sourceApi = this.getSourceApi();
        String other$sourceApi = other.getSourceApi();
        if (this$sourceApi == null ? other$sourceApi != null : !this$sourceApi.equals(other$sourceApi)) {
            return false;
        }
        String this$clientAgent = this.getClientAgent();
        String other$clientAgent = other.getClientAgent();
        if (this$clientAgent == null ? other$clientAgent != null : !this$clientAgent.equals(other$clientAgent)) {
            return false;
        }
        String this$enumKey = this.getEnumKey();
        String other$enumKey = other.getEnumKey();
        if (this$enumKey == null ? other$enumKey != null : !this$enumKey.equals(other$enumKey)) {
            return false;
        }
        Map this$fieldMap = this.getFieldMap();
        Map other$fieldMap = other.getFieldMap();
        if (this$fieldMap == null ? other$fieldMap != null : !((Object)this$fieldMap).equals(other$fieldMap)) {
            return false;
        }
        MetadataField this$parentField = this.getParentField();
        MetadataField other$parentField = other.getParentField();
        if (this$parentField == null ? other$parentField != null : !this$parentField.equals(other$parentField)) {
            return false;
        }
        List this$groupMetadataFields = this.getGroupMetadataFields();
        List other$groupMetadataFields = other.getGroupMetadataFields();
        if (this$groupMetadataFields == null ? other$groupMetadataFields != null : !((Object)this$groupMetadataFields).equals(other$groupMetadataFields)) {
            return false;
        }
        List this$operations = this.getOperations();
        List other$operations = other.getOperations();
        if (this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations)) {
            return false;
        }
        String this$uiBot = this.getUiBot();
        String other$uiBot = other.getUiBot();
        return !(this$uiBot == null ? other$uiBot != null : !this$uiBot.equals(other$uiBot));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetadataField;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRequired() ? 79 : 97);
        result = result * 59 + (this.isBusinessKey() ? 79 : 97);
        result = result * 59 + this.getDisplayWidth();
        result = result * 59 + (this.isCanEdit() ? 79 : 97);
        result = result * 59 + (this.isArray() ? 79 : 97);
        Boolean $canSort = this.getCanSort();
        result = result * 59 + ($canSort == null ? 43 : ((Object)$canSort).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        String $dataKey = this.getDataKey();
        result = result * 59 + ($dataKey == null ? 43 : $dataKey.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        Precision $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : $precision.hashCode());
        Object $objectData = this.getObjectData();
        result = result * 59 + ($objectData == null ? 43 : $objectData.hashCode());
        String $fieldType = this.getFieldType();
        result = result * 59 + ($fieldType == null ? 43 : $fieldType.hashCode());
        List $tagDefinitions = this.getTagDefinitions();
        result = result * 59 + ($tagDefinitions == null ? 43 : ((Object)$tagDefinitions).hashCode());
        List $subFields = this.getSubFields();
        result = result * 59 + ($subFields == null ? 43 : ((Object)$subFields).hashCode());
        List $exportTableFields = this.getExportTableFields();
        result = result * 59 + ($exportTableFields == null ? 43 : ((Object)$exportTableFields).hashCode());
        String $sourceApi = this.getSourceApi();
        result = result * 59 + ($sourceApi == null ? 43 : $sourceApi.hashCode());
        String $clientAgent = this.getClientAgent();
        result = result * 59 + ($clientAgent == null ? 43 : $clientAgent.hashCode());
        String $enumKey = this.getEnumKey();
        result = result * 59 + ($enumKey == null ? 43 : $enumKey.hashCode());
        Map $fieldMap = this.getFieldMap();
        result = result * 59 + ($fieldMap == null ? 43 : ((Object)$fieldMap).hashCode());
        MetadataField $parentField = this.getParentField();
        result = result * 59 + ($parentField == null ? 43 : $parentField.hashCode());
        List $groupMetadataFields = this.getGroupMetadataFields();
        result = result * 59 + ($groupMetadataFields == null ? 43 : ((Object)$groupMetadataFields).hashCode());
        List $operations = this.getOperations();
        result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
        String $uiBot = this.getUiBot();
        result = result * 59 + ($uiBot == null ? 43 : $uiBot.hashCode());
        return result;
    }
}

