/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.domain.kmDeployer;

import com.digiwin.athena.athena_deployer_service.http.km.dto.DeployAppReqDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.EventLog;
import com.digiwin.athena.athena_deployer_service.http.km.dto.SwitchAppReqDto;
import java.util.Date;
import java.util.List;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="kmDeployRecord")
public class KmDeployRecord {
    public static final String SUCCESS_STATUS = "success";
    public static final String WARN_STATUS = "warn";
    public static final String FAIL_STATUS = "fail";
    public static final String EXECUTING_STATUS = "executing";
    public static final String WAITING_STATUS = "waiting";
    public static final String DEPLOY_TYPE = "publish";
    public static final String SWITCH_TYPE = "switch";
    public static final Integer EXECUTING_DEPLOY_EVENT_STATUS = 1;
    public static final Integer FINISH_DEPLOY_EVENT_STATUS = 2;
    public static final Integer ERROR_DEPLOY_EVENT_STATUS = 3;
    public static final Integer REVOKE_DEPLOY_EVENT_STATUS = 4;
    public static final Integer TIMEOUT_DEPLOY_EVENT_STATUS = 5;
    public static final Integer WARN_DEPLOY_EVENT_STATUS = 7;
    @Id
    private String id;
    private String deployTenantId;
    private String kmDeployId;
    private String deployerToken;
    private String deployerDomain;
    private String deployerLogId;
    private String application;
    private String eventId;
    private Integer eventStatus;
    private List<EventLog> eventLog;
    private String status;
    private String type;
    private Date createDate;
    private Date editDate;
    private String createBy;
    private String editBy;

    public static KmDeployRecord create(DeployAppReqDto deployAppReqDto) {
        KmDeployRecord kmDeployRecord = new KmDeployRecord();
        kmDeployRecord.setKmDeployId(deployAppReqDto.getDeployId());
        kmDeployRecord.setDeployerToken(deployAppReqDto.getDeployerToken());
        kmDeployRecord.setDeployerDomain(deployAppReqDto.getDeployerDomain());
        kmDeployRecord.setStatus(WAITING_STATUS);
        kmDeployRecord.setType(DEPLOY_TYPE);
        kmDeployRecord.setDeployTenantId(deployAppReqDto.getDeployTenantId());
        kmDeployRecord.setDeployerLogId(deployAppReqDto.getDeployerLogId());
        kmDeployRecord.setApplication(deployAppReqDto.getApplication());
        kmDeployRecord.setCreateDate(new Date());
        kmDeployRecord.setEditDate(new Date());
        kmDeployRecord.setCreateBy("SYSTEM");
        kmDeployRecord.setEditBy("SYSTEM");
        return kmDeployRecord;
    }

    public static KmDeployRecord create(SwitchAppReqDto switchAppReqDto) {
        KmDeployRecord kmDeployRecord = new KmDeployRecord();
        kmDeployRecord.setKmDeployId(switchAppReqDto.getDeployId());
        kmDeployRecord.setDeployerToken(switchAppReqDto.getDeployerToken());
        kmDeployRecord.setDeployerDomain(switchAppReqDto.getDeployerDomain());
        kmDeployRecord.setStatus(WAITING_STATUS);
        kmDeployRecord.setType(SWITCH_TYPE);
        kmDeployRecord.setDeployTenantId(switchAppReqDto.getDeployTenantId());
        kmDeployRecord.setDeployerLogId(switchAppReqDto.getDeployerLogId());
        kmDeployRecord.setApplication(switchAppReqDto.getApplication());
        kmDeployRecord.setCreateDate(new Date());
        kmDeployRecord.setEditDate(new Date());
        kmDeployRecord.setCreateBy("SYSTEM");
        kmDeployRecord.setEditBy("SYSTEM");
        return kmDeployRecord;
    }

    public String getDeployerLogId() {
        return this.deployerLogId;
    }

    public void setDeployerLogId(String deployerLogId) {
        this.deployerLogId = deployerLogId;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getEditDate() {
        return this.editDate;
    }

    public void setEditDate(Date editDate) {
        this.editDate = editDate;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public String getEditBy() {
        return this.editBy;
    }

    public void setEditBy(String editBy) {
        this.editBy = editBy;
    }

    public String getDeployTenantId() {
        return this.deployTenantId;
    }

    public void setDeployTenantId(String deployTenantId) {
        this.deployTenantId = deployTenantId;
    }

    public Integer getEventStatus() {
        return this.eventStatus;
    }

    public void setEventStatus(Integer eventStatus) {
        this.eventStatus = eventStatus;
    }

    public List<EventLog> getEventLog() {
        return this.eventLog;
    }

    public void setEventLog(List<EventLog> eventLog) {
        this.eventLog = eventLog;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKmDeployId() {
        return this.kmDeployId;
    }

    public void setKmDeployId(String kmDeployId) {
        this.kmDeployId = kmDeployId;
    }

    public String getDeployerToken() {
        return this.deployerToken;
    }

    public void setDeployerToken(String deployerToken) {
        this.deployerToken = deployerToken;
    }

    public String getDeployerDomain() {
        return this.deployerDomain;
    }

    public void setDeployerDomain(String deployerDomain) {
        this.deployerDomain = deployerDomain;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

