/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.http.bmd;

import cn.hutool.core.util.IdUtil;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.config.ModuleConfig;
import com.digiwin.athena.athena_deployer_service.domain.TenantUser;
import com.digiwin.athena.athena_deployer_service.util.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class BmdApiHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BmdApiHelper.class);
    @Autowired
    private ModuleConfig moduleConfig;

    public void modelRelease(String appId, String envCode, List<TenantUser> tenantUsers, String token, String version, String source, String appName) {
        String message = "\u8c03\u6a21\u578b\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
        String timeout = "\u8c03\u6a21\u578b\u4e2d\u5fc3\u63a5\u53e3\u8d85\u65f6\uff0c\u5931\u8d25\u539f\u56e0:%s";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("appId", appId);
        log.info("\u6a21\u578b\u4e2d\u5fc3\u5bf9\u5e94\u7684\u73af\u5883:{}", (Object)envCode);
        if (StringUtils.isEmpty((Object)envCode)) {
            log.info("\u6a21\u578b\u4e2d\u5fc3\u6ca1\u6709\u5bf9\u5e94\u7684\u73af\u5883");
            return;
        }
        body.put("envCode", envCode);
        body.put("tenantsidList", tenantUsers);
        body.put("type", version);
        body.put("source", source);
        body.put("appName", appName);
        String url = this.moduleConfig.getBmd().getDomain() + "/server/semantic/api/v1/public/common/model/release";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=UTF-8");
        headers.put("token", token);
        log.info("modelRelease url:{}", (Object)url);
        log.info("modelRelease headers:{}", headers);
        log.info("modelRelease body:{}", body);
        String response = null;
        String messageId = IdUtil.fastUUID().replace("-", "");
        try {
            response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).addHeaders(headers)).body(JSON.toJSONString(body)).execute().body();
        }
        catch (HttpException e) {
            LogUtils.buildAgileLog((String)appId, (String)LogUtils.MODULE_AADCS, (String)"modelRelease", (String)LogUtils.AADCS_504_0007, (String)JSON.toJSONString(body), (String)String.format(timeout, e.getMessage()), (String)String.format("\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\u68c0\u67e5%s\u670d\u52a1", LogUtils.THIRD_BMD), (String)messageId);
        }
        log.info("modelRelease response:{}", (Object)response);
        JSONObject responseObj = JSON.parseObject((String)response);
        if (Objects.nonNull(responseObj) && responseObj.getInteger("code") != 200) {
            LogUtils.buildAgileLog((String)appId, (String)LogUtils.MODULE_AADCS, (String)"modelRelease", (String)LogUtils.AADCS_500_0015, (String)JSON.toJSONString(body), (String)String.format(message, response), (String)String.format("\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff0c\u5e76\u63d0\u4f9b\u6d88\u606f\u5e8f\u5217\u53f7\uff08%s\uff09", messageId), (String)messageId);
            return;
        }
        LogUtils.buildAgileLog((String)appId, (String)LogUtils.MODULE_AADCS, (String)"modelRelease", (String)LogUtils.SUCCESS, (String)JSON.toJSONString(body), (String)response, (String)"", (String)messageId);
    }
}

