/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.http.esp;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.config.ModuleConfig;
import com.digiwin.athena.athena_deployer_service.dao.DeleteModelByEnvAndAppDto;
import com.digiwin.athena.athena_deployer_service.domain.apimgmt.ApiMgmtBaseInfo;
import com.digiwin.athena.athena_deployer_service.domain.apimgmt.ApiMgmtBmdInfo;
import com.digiwin.athena.athena_deployer_service.domain.designer.ModelDigitalVo;
import com.digiwin.athena.athena_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class EspApiHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EspApiHelper.class);
    @Autowired
    private ModuleConfig moduleConfig;
    @Autowired
    private IamService iamService;

    public void serviceRegisterToEsp(JSONObject publishModel, String serviceCode, String token, String appToken, String tenantId) {
        this.callEspService(publishModel, token, appToken, tenantId, serviceCode, "update");
    }

    public void serviceDelToEsp(JSONObject publishModelDrivenInfo, String token, String appToken, String tenantId) {
        if (Objects.isNull(publishModelDrivenInfo)) {
            log.info("no model info to be deleted");
            return;
        }
        String serviceCode = publishModelDrivenInfo.getString("serviceCode");
        JSONArray publishModels = publishModelDrivenInfo.getJSONArray("publishModels");
        if (Objects.isNull(publishModels)) {
            log.info("no models to be deleted");
            return;
        }
        for (int i = 0; i < publishModels.size(); ++i) {
            this.callEspService(publishModels.getJSONObject(i), token, appToken, tenantId, serviceCode, "delete");
        }
    }

    private void callEspService(JSONObject registerModel, String token, String appToken, String tenantId, String serviceCode, String callType) {
        String integrationToken = this.iamService.getIntegrationToken(tenantId);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("digi-middleware-auth-app", appToken);
        headers.put("token", integrationToken);
        headers.put("Content-Type", "application/json");
        headers.put("digi-type", "sync");
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String formatTime = sdf.format(date);
        HashMap<String, String> headMapDigi_Host = new HashMap<String, String>();
        headMapDigi_Host.put("prod", "Athena");
        headMapDigi_Host.put("ver", "1.0");
        headMapDigi_Host.put("lang", "zh_CN");
        headMapDigi_Host.put("timestamp", formatTime);
        headMapDigi_Host.put("ip", "");
        headMapDigi_Host.put("eoc_acct", "athena");
        headMapDigi_Host.put("acct", "athena");
        headers.put("digi-host", JSON.toJSONString(headMapDigi_Host));
        HashMap<String, String> headMapDigi_Service = new HashMap<String, String>();
        headMapDigi_Service.put("prod", serviceCode);
        headMapDigi_Service.put("uid", serviceCode);
        headMapDigi_Service.put("tenant_id", tenantId);
        if ("update".equals(callType)) {
            headMapDigi_Service.put("name", "modeldriven.schema.update");
        } else if ("delete".equals(callType)) {
            headMapDigi_Service.put("name", "modeldriven.schema.delete");
        }
        headers.put("digi-service", JSON.toJSONString(headMapDigi_Service));
        HashMap requestMap = new HashMap();
        HashMap parameter = new HashMap();
        HashMap<String, JSONObject> model = new HashMap<String, JSONObject>();
        model.put("model", registerModel);
        parameter.put("parameter", model);
        requestMap.put("std_data", parameter);
        String requestJson = JSON.toJSONString(requestMap);
        String logKey = "update".equals(callType) ? "serviceRegisterToEsp, modeldriven.schema.update" : "serviceDelToEsp, modeldriven.schema.delete";
        try {
            String fileMD5 = DigestUtils.md5Hex((String)(JSON.toJSONString(headMapDigi_Host) + JSON.toJSONString(headMapDigi_Service)));
            headers.put("digi-key", fileMD5);
            log.info("headers headers is ={}", (Object)JSON.toJSONString(headers));
            log.info(logKey + " request is ={}", (Object)requestJson);
            String url = this.moduleConfig.getEsp().getDomain() + "/CROSS/RESTful";
            String StdResponse = ((HttpRequest)HttpUtil.createPost((String)url).body(requestJson).addHeaders(headers)).execute().body();
            log.info("espService." + logKey + " response is ={}", (Object)StdResponse);
            String result = "-2";
            JSONObject responseObj = JSON.parseObject((String)StdResponse);
            JSONObject std_data = responseObj.getJSONObject("std_data");
            if (Objects.nonNull(std_data)) {
                JSONObject execution = std_data.getJSONObject("execution");
                result = execution.getString("code");
                if ("0".equals(result)) {
                    log.info("espService." + logKey + " execute success");
                } else if ("-1".equals(result)) {
                    execution = std_data.getJSONObject("execution");
                    String description = execution.getString("description");
                    throw new BusinessException(description);
                }
            }
            if (!result.equals("0")) {
                throw new BusinessException(StdResponse);
            }
        }
        catch (Exception e) {
            throw new BusinessException(logKey + " have exception: " + e.getMessage());
        }
    }

    public void callBMEspService(String modelCode, String appToken, String tenantId, String serviceCode, String targetProd, List<ApiMgmtBaseInfo> apiMgmtBaseInfos, Map<String, String> modelComeFromMap) {
        String integrationToken = this.iamService.getIntegrationToken(tenantId);
        String[] split = targetProd.split("\\-");
        String last = split[split.length - 1];
        String api_prefix = targetProd.replace("-" + last, "").replace("-", ".").toLowerCase();
        String serviceName = api_prefix + ".metaData.generate.process";
        HashMap<String, Object> requestDigital = new HashMap<String, Object>();
        requestDigital.put("deleteInfoFlag", false);
        requestDigital.put("songshenflag", true);
        requestDigital.put("api_prefix", api_prefix);
        requestDigital.put("is_std", true);
        requestDigital.put("category_id", "99");
        requestDigital.put("token", integrationToken);
        requestDigital.put("modelComeFrom", modelComeFromMap.get(modelCode));
        ArrayList<ApiMgmtBmdInfo> apiMgmtBmdInfos = new ArrayList<ApiMgmtBmdInfo>();
        if (!CollectionUtils.isEmpty(apiMgmtBaseInfos)) {
            for (ApiMgmtBaseInfo apiMgmtBaseInfo : apiMgmtBaseInfos) {
                ApiMgmtBmdInfo apiMgmtBmdInfo = new ApiMgmtBmdInfo();
                apiMgmtBmdInfo.setModel_come_from(apiMgmtBaseInfo.getModelComeFrom());
                apiMgmtBmdInfo.setApi_name(apiMgmtBaseInfo.getApiName());
                apiMgmtBmdInfo.setApi_version(apiMgmtBaseInfo.getVersion());
                apiMgmtBmdInfos.add(apiMgmtBmdInfo);
            }
        }
        requestDigital.put("bm_api_info", apiMgmtBmdInfos);
        ArrayList<ModelDigitalVo> modelDigitalVos = new ArrayList<ModelDigitalVo>();
        ModelDigitalVo modelDigitalVo = new ModelDigitalVo();
        modelDigitalVo.setModel_code(modelCode);
        modelDigitalVo.setRequest_type("CURD");
        modelDigitalVos.add(modelDigitalVo);
        requestDigital.put("model_info", modelDigitalVos);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("digi-middleware-auth-app", appToken);
        headers.put("token", integrationToken);
        headers.put("Content-Type", "application/json");
        headers.put("digi-type", "sync");
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String formatTime = sdf.format(date);
        HashMap<String, String> headMapDigi_Host = new HashMap<String, String>();
        headMapDigi_Host.put("prod", "Athena");
        headMapDigi_Host.put("ver", "1.0");
        headMapDigi_Host.put("lang", "zh_CN");
        headMapDigi_Host.put("timestamp", formatTime);
        headMapDigi_Host.put("ip", "");
        headMapDigi_Host.put("eoc_acct", "athena");
        headMapDigi_Host.put("acct", "athena");
        headers.put("digi-host", JSON.toJSONString(headMapDigi_Host));
        HashMap<String, Object> headMapDigi_Service = new HashMap<String, Object>();
        headMapDigi_Service.put("prod", targetProd);
        headMapDigi_Service.put("uid", targetProd);
        headMapDigi_Service.put("tenant_id", tenantId);
        headMapDigi_Service.put("name", serviceName);
        headers.put("digi-service", JSON.toJSONString(headMapDigi_Service));
        HashMap requestMap = new HashMap();
        HashMap<String, HashMap<String, Object>> parameter = new HashMap<String, HashMap<String, Object>>();
        parameter.put("parameter", requestDigital);
        requestMap.put("std_data", parameter);
        String requestJson = JSON.toJSONString(requestMap);
        String logKey = serviceName + " to create digital api ";
        String fileMD5 = DigestUtils.md5Hex((String)(JSON.toJSONString(headMapDigi_Host) + JSON.toJSONString(headMapDigi_Service)));
        headers.put("digi-key", fileMD5);
        log.info("headers headers is ={}", (Object)JSON.toJSONString(headers));
        log.info(logKey + " request is ={}", (Object)requestJson);
        String url = this.moduleConfig.getEsp().getDomain() + "/CROSS/RESTful";
        String StdResponse = ((HttpRequest)HttpUtil.createPost((String)url).body(requestJson).addHeaders(headers)).execute().body();
        log.info("espService." + logKey + " response is ={}", (Object)StdResponse);
        String result = "-2";
        JSONObject responseObj = JSON.parseObject((String)StdResponse);
        JSONObject std_data = responseObj.getJSONObject("std_data");
        if (Objects.nonNull(std_data)) {
            JSONObject execution = std_data.getJSONObject("execution");
            result = execution.getString("code");
            if ("0".equals(result)) {
                log.info("espService." + logKey + " execute success");
            } else if ("-1".equals(result)) {
                execution = std_data.getJSONObject("execution");
                String description = execution.getString("description");
                throw new BusinessException(description);
            }
        }
        if (!result.equals("0")) {
            throw new BusinessException(StdResponse);
        }
    }

    public void serviceDelModelToEsp(JSONObject publishModelDrivenInfo, String token, String appToken, String tenantId) {
        if (Objects.isNull(publishModelDrivenInfo)) {
            log.info("no model info to be deleted");
            return;
        }
        List publishModelsList = JSON.parseArray((String)JSON.toJSONString((Object)publishModelDrivenInfo.getJSONArray("publishModels")), DeleteModelByEnvAndAppDto.class);
        if (CollectionUtils.isEmpty((Collection)publishModelsList)) {
            log.info("no models to be deleted");
            return;
        }
        for (DeleteModelByEnvAndAppDto item : publishModelsList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code", (Object)item.getCode());
            jsonObject.put("appInfo", (Object)item.getAppInfo());
            String serviceCode = item.getAppInfo().getProd();
            this.callEspService(jsonObject, token, appToken, tenantId, serviceCode, "delete");
        }
    }
}

