/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.http.gmc;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.config.ModuleConfig;
import com.digiwin.athena.athena_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class GmcApiHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GmcApiHelper.class);
    @Autowired
    private ModuleConfig moduleConfig;
    @Autowired
    private IamService iamService;
    @Value(value="${appToken}")
    private String appToken;
    private static String createCommodity = "/api/cloudgoods/auto/deploy";
    private static String updateCommodity = "/api/cloudgoods/code";
    private static String updateModules = "/api/cloudgoods/modules";
    private static final String GMC_MODULE_SEARCH = "/api/cloudgoods/{}/simple";

    public void createOrUpdateGmcCommodity(String appCode, String appName, String tenantId) {
        String url = this.moduleConfig.getGmc().getDomain() + createCommodity;
        String integrationToken = this.iamService.getIntegrationToken(tenantId);
        String tenantTeamId = this.iamService.getTenantTeamId(integrationToken);
        String productCode = "4".equals(tenantTeamId) ? "ODM" : "all";
        JSONObject param = new JSONObject();
        param.put("sysId", (Object)appCode);
        param.put("platformCode", (Object)"Athena");
        param.put("paymentType ", (Object)"\u4eba/\u6708");
        param.put("tenancyPeriod", (Object)"12");
        param.put("productCode", (Object)productCode);
        param.put("usersNumber", (Object)"50");
        param.put("userNumberCode", (Object)"0");
        param.put("showConsole", (Object)false);
        try {
            String response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)url).body(JSON.toJSONString((Object)param)).header("digi-middleware-auth-user", integrationToken)).header("digi-middleware-auth-app", this.appToken)).execute().body();
            JSONObject responseObj = JSON.parseObject((String)response);
            Boolean success = responseObj.getBoolean("success");
            if (!success.booleanValue()) {
                log.error("GMC\u521b\u5efa\u5546\u54c1\u5931\u8d25\uff0curl:{}\uff0c\u53c2\u6570:{}\uff0c\u8fd4\u56de:{}", new Object[]{url, JSON.toJSONString((Object)param), response});
                throw new BusinessException("GMC\u521b\u5efa\u5546\u54c1\u5931\u8d25:" + responseObj.getString("errorMessage"));
            }
        }
        catch (Exception e) {
            log.error("GMC\u521b\u5efa\u5546\u54c1\u5931\u8d25\uff0curl:{}\uff0c\u53c2\u6570:{}\uff0c\u8fd4\u56de:{}", new Object[]{url, JSON.toJSONString((Object)param), e.getMessage()});
            throw new BusinessException("GMC\u521b\u5efa\u5546\u54c1\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        this.updateCommodity(appCode, appName, tenantId);
    }

    public void updateCommodity(String appCode, String appName, String tenantId) {
        String integrationToken = this.iamService.getIntegrationToken(tenantId);
        String url = this.moduleConfig.getGmc().getDomain() + updateCommodity;
        JSONObject param = new JSONObject();
        param.put("code", (Object)appCode);
        param.put("displayName", (Object)appName);
        try {
            String response = ((HttpRequest)((HttpRequest)HttpRequest.put((String)url).header("digi-middleware-auth-user", integrationToken)).header("digi-middleware-auth-app", this.appToken)).body(JSON.toJSONString((Object)param)).execute().body();
            JSONObject responseObj = JSON.parseObject((String)response);
            Boolean success = responseObj.getBoolean("success");
            if (!success.booleanValue()) {
                log.error("GMC\u4fee\u6539\u5546\u54c1\u540d\u79f0\u5931\u8d25\uff0curl:{}\uff0c\u53c2\u6570:{}\uff0c\u8fd4\u56de:{}", new Object[]{url, JSON.toJSONString((Object)param), response});
            }
        }
        catch (Exception e) {
            log.error("GMC\u4fee\u6539\u5546\u54c1\u540d\u79f0\u5931\u8d25\uff0curl:{}\uff0c\u53c2\u6570:{}\uff0c\u8fd4\u56de:{}", new Object[]{url, JSON.toJSONString((Object)param), e.getMessage()});
            log.error("GMC\u4fee\u6539\u5546\u54c1\u540d\u79f0\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
    }

    public JSONObject getGmcInfo(String gmcCode) {
        String url = this.moduleConfig.getGmc().getDomain() + StrUtil.format((CharSequence)GMC_MODULE_SEARCH, (Object[])new Object[]{gmcCode});
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("digi-middleware-auth-app", this.appToken);
        try {
            HttpResponse response = ((HttpRequest)HttpUtil.createGet((String)url).addHeaders(header)).execute();
            if (response != null && 200 == response.getStatus()) {
                String responseStr = response.body();
                JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
                return jsonObject;
            }
            throw new BusinessException("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5f02\u5e38\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a" + String.valueOf(response));
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
            throw new BusinessException("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
    }
}

