/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.http.iam;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.athena_deployer_service.config.BackUriConfig;
import com.digiwin.athena.athena_deployer_service.config.ModuleConfig;
import com.digiwin.athena.athena_deployer_service.domain.iam.IamCleanTenantReqDto;
import com.digiwin.athena.athena_deployer_service.http.iam.dto.BuyApplicationReqDto;
import com.digiwin.athena.athena_deployer_service.http.iam.dto.DeletePermissionReqDto;
import com.digiwin.athena.athena_deployer_service.http.iam.dto.ResultDto;
import com.digiwin.athena.athena_deployer_service.http.iam.dto.TenantInfoDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class IamApiHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamApiHelper.class);
    @Autowired
    private ModuleConfig moduleConfig;
    @Value(value="${appToken}")
    private String appToken;
    @Value(value="${dmc.appToken}")
    private String athenaAppToken;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private BackUriConfig backUriConfig;
    private static final String INTEGRATION_ACCOUNT = "integration";
    private static final String PASSWORD_HASH = "6826CC688C4AF1BD0A8DDA2DBDF8897B";

    public String getIamIntegrationToken(String tenantId) {
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("tenantId", tenantId);
        requestBody.put("userId", INTEGRATION_ACCOUNT);
        requestBody.put("passwordHash", PASSWORD_HASH);
        String url = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/identity/login/internal";
        try {
            String response = ((HttpRequest)HttpUtil.createPost((String)url).body(JSON.toJSONString(requestBody)).header("digi-middleware-auth-app", this.appToken)).execute().body();
            JSONObject responseObj = JSON.parseObject((String)response);
            String resultToken = responseObj.getString("token");
            return resultToken;
        }
        catch (Exception e) {
            log.info("getUserToken by integration have exception,{}", (Object)e.getMessage());
            return null;
        }
    }

    public void iamCleanTenant(IamCleanTenantReqDto iamCleanTenantReqDto) {
        String iamIntegrationToken = this.getIamIntegrationToken(iamCleanTenantReqDto.getTenantId());
        String url = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/app/action/tenant/detach";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("digi-middleware-auth-user", iamIntegrationToken);
        httpHeaders.add("digi-middleware-auth-app", this.appToken);
        HttpEntity iamCleanTenantReqDtoHttpEntity = new HttpEntity((Object)iamCleanTenantReqDto, (MultiValueMap)httpHeaders);
        ResponseEntity response = null;
        try {
            response = this.restTemplate.postForEntity(url, (Object)iamCleanTenantReqDtoHttpEntity, String.class, new Object[0]);
        }
        catch (RestClientException e) {
            log.error("/api/iam/v2/app/action/tenant/detach exception:" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("/api/iam/v2/app/action/tenant/detach\u5931\u8d25\uff0c" + e.getMessage());
        }
        ResultDto resultDto = (ResultDto)JSONObject.parseObject((String)((String)response.getBody()), ResultDto.class);
        if (!resultDto.getSuccess().booleanValue()) {
            throw new RuntimeException("/api/iam/v2/app/action/tenant/detach\u5931\u8d25\uff0c" + resultDto.getMessage());
        }
    }

    public List<TenantInfoDto> buyApplicationTenantInfos(BuyApplicationReqDto buyApplicationReqDto) {
        String iamIntegrationToken = this.getIamIntegrationToken(buyApplicationReqDto.getTenantId());
        String url = String.format(this.moduleConfig.getCac().getDomain() + "/api/cac/v4/authorizations/tenants/goods/search?goodsCode=%s&queryExpire=%s&pageNum=%d&pageSize=%d&tenantId=%s&tenantName=%s", buyApplicationReqDto.getGoodsCode(), buyApplicationReqDto.getQueryExpire(), buyApplicationReqDto.getPageNum(), buyApplicationReqDto.getPageSize(), StringUtils.isEmpty((CharSequence)buyApplicationReqDto.getSearchTenantId()) ? "" : buyApplicationReqDto.getSearchTenantId(), StringUtils.isEmpty((CharSequence)buyApplicationReqDto.getTenantName()) ? "" : buyApplicationReqDto.getTenantName());
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("digi-middleware-auth-user", iamIntegrationToken);
        httpHeaders.add("digi-middleware-auth-app", this.appToken);
        HttpEntity entity = new HttpEntity((MultiValueMap)httpHeaders);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
        ResultDto resultDto = (ResultDto)JSONObject.parseObject((String)((String)response.getBody()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (!resultDto.getSuccess().booleanValue()) {
            log.error(String.format("buyApplicationTenantInfos \u8bf7\u6c42\u5f02\u5e38:%s", response.getBody()));
            throw new RuntimeException("buyApplicationTenantInfos \u8bf7\u6c42\u5f02\u5e38");
        }
        JSONArray list = ((JSONObject)resultDto.getData()).getJSONArray("list");
        return CollectionUtils.isEmpty((Collection)list) ? new ArrayList<TenantInfoDto>() : (List)JSONObject.parseObject((String)list.toJSONString(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
    }

    public Boolean iamBatchDeletePermissions(DeletePermissionReqDto deletePermissionReqDto) {
        String iamIntegrationToken = this.getIamIntegrationToken(deletePermissionReqDto.getTenantId());
        String url = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/app/action/batch/del";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("digi-middleware-auth-user", iamIntegrationToken);
        httpHeaders.add("digi-middleware-auth-app", this.appToken);
        HttpEntity httpEntity = new HttpEntity((Object)deletePermissionReqDto, (MultiValueMap)httpHeaders);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        ResultDto resultDto = (ResultDto)JSONObject.parseObject((String)((String)response.getBody()), ResultDto.class);
        if (!resultDto.getSuccess().booleanValue()) {
            log.error(String.format("iamBatchDeletePermissions \u5931\u8d25:%s", response.getBody()));
            throw new RuntimeException("\u6279\u91cf\u5220\u9664\u9f0e\u6377\u4e91\u6743\u9650\u5931\u8d25\uff0c" + resultDto.getMessage());
        }
        return true;
    }

    public void syncBackUri(String application, String appType, String tenantId) {
        String iamIntegrationToken = this.getIamIntegrationToken(tenantId);
        String url = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/sys/metauri";
        String queryUrl = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/sys/" + application;
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("digi-middleware-auth-user", iamIntegrationToken);
        httpHeaders.add("digi-middleware-auth-app", this.athenaAppToken);
        Map backUriMap = this.backUriConfig.getUrls();
        String backUri = (String)backUriMap.get(appType);
        if (StringUtils.isEmpty((CharSequence)backUri)) {
            log.info("\u5e94\u7528\u7c7b\u578b:{}\u6ca1\u6709\u914d\u7f6e\u56de\u8c03\u5730\u5740,\u5e94\u7528:{}", (Object)appType, (Object)application);
            return;
        }
        try {
            String uriInBase;
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)httpHeaders);
            ResponseEntity queryResponse = this.restTemplate.exchange(queryUrl, HttpMethod.GET, requestEntity, JSONObject.class, new Object[]{application});
            JSONObject body = (JSONObject)queryResponse.getBody();
            JSONObject data = body.getJSONObject("data");
            if (Objects.nonNull(data) && Objects.equals(uriInBase = data.getString("metaUri"), backUri)) {
                log.info("\u6570\u636e\u5e93\u4e2d\u7684\u56de\u8c03\u5730\u5740\u4e0e\u5f53\u524d\u73af\u5883\u4e00\u81f4");
                return;
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2iam\u6743\u9650\u56de\u8c03\u63a5\u53e3\u5931\u8d25");
        }
        JSONObject param = new JSONObject();
        param.put("id", (Object)application);
        param.put("metaUri", (Object)backUri);
        param.put("type", (Object)"app");
        param.put("enableMultiRow", (Object)false);
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)httpHeaders);
        ResponseEntity response = null;
        try {
            response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        }
        catch (RestClientException e) {
            throw new RuntimeException("\u540c\u6b65\u6743\u9650\u56de\u8c03\u5730\u5740\u5931\u8d25");
        }
        String body = (String)JSONObject.parseObject((String)((String)response.getBody()), String.class);
        JSONObject result = JSONObject.parseObject((String)body);
        if (result.getInteger("code") != 200) {
            log.error(String.format("syncBackUri \u5931\u8d25:%s", response.getBody()));
            throw new RuntimeException("\u540c\u6b65\u6743\u9650\u56de\u8c03\u5730\u5740\u5931\u8d25");
        }
        log.info("\u540c\u6b65\u6743\u9650\u56de\u8c03\u5730\u5740\u6210\u529f");
    }
}

