/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.http.km;

import cn.hutool.core.util.IdUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.athena_deployer_service.config.ModuleConfig;
import com.digiwin.athena.athena_deployer_service.domain.TenantUser;
import com.digiwin.athena.athena_deployer_service.domain.action.EspActionIdSwitchResDto;
import com.digiwin.athena.athena_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.athena_deployer_service.http.km.dto.CommonParadigmDeployDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.DeployAppReqDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.DeployAppResDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.DeployLogResDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.KmRevokeAppParamDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.ResultDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.SwitchAppReqDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.SyncPushDataDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.TenantDeployParamDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.TenantVersionUpdateReqDto;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import com.digiwin.athena.athena_deployer_service.util.CurThreadInfoUtils;
import com.digiwin.athena.athena_deployer_service.util.HttpRequsetUtil;
import com.digiwin.athena.athena_deployer_service.util.LogUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class KmApiHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KmApiHelper.class);
    @Autowired
    private ModuleConfig moduleConfig;
    @Autowired
    private IamService iamService;
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${deleteApplication:true}")
    private boolean deleteFlag;

    public void cacheReset(String tenantId) {
        String token = this.iamService.getIntegrationToken(tenantId);
        String url = this.moduleConfig.getKm().getDomain() + "/restful/service/knowledgegraph/Cache/withPattern";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=UTF-8");
        headers.put("token", token);
        JSONObject body = new JSONObject();
        body.put("keyPatterns", Arrays.asList("knowledgegraph*", "tagsystem*", "presetlibrary*"));
        log.info("km cache reset url:{}", (Object)url);
        log.info("km cache reset headers:{}", headers);
        log.info("km cache reset request:{}", (Object)body);
        String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.DELETE, (String)url).addHeaders(headers)).body(JSON.toJSONString((Object)body)).execute().body();
        log.info("km cache reset response:{}", (Object)response);
        JSONObject responseObj = JSON.parseObject((String)response);
        if (responseObj.getInteger("status") != 200) {
            throw new BusinessException("\u8c03\u7528/restful/service/knowledgegraph/Cache/withPattern\u63a5\u53e3\u6e05\u7406\u7f13\u5b58\u5931\u8d25\uff01\u8fd4\u56de\u4fe1\u606f\uff1a" + response);
        }
    }

    public void updateApplicationComponentList(String appCode, String version, String tenantId) {
        String token = this.iamService.getIntegrationToken(tenantId);
        String url = this.moduleConfig.getKm().getDomain() + "/restful/service/knowledgegraph/Component/UpdateApplicationComponentList";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=UTF-8");
        headers.put("token", token);
        JSONObject body = new JSONObject();
        body.put("appCode", (Object)appCode);
        body.put("version", (Object)version);
        log.info("updateApplicationComponentList url is -->{}", (Object)url);
        log.info("updateApplicationComponentList headers is -->{}", headers);
        log.info("updateApplicationComponentList request is -->{}", (Object)body);
        String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).addHeaders(headers)).body(JSON.toJSONString((Object)body)).execute().body();
        log.info("updateApplicationComponentList response is -->{}", (Object)response);
        JSONObject responseObj = JSON.parseObject((String)response);
        if (responseObj.getInteger("status") != 200) {
            throw new BusinessException("\u8c03\u7528/restful/service/knowledgegraph/Component/UpdateApplicationComponentList\u63a5\u53e3\u66f4\u65b0\u7ec4\u4ef6\u6e05\u5355\u5931\u8d25\uff01\u8fd4\u56de\u4fe1\u606f\uff1a" + response);
        }
    }

    public void compileAndSaveSets(JSONObject body) {
        String tenantId = body.getString("tenantId");
        String token = this.iamService.getIntegrationToken(tenantId);
        String url = this.moduleConfig.getKm().getDomain() + "/restful/service/knowledgegraph/Set/CompileAndSaveSets";
        log.info("km url is:" + url);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=UTF-8");
        headers.put("token", token);
        headers.put("routerKey", tenantId);
        body.remove((Object)"tenantId");
        log.info("compileAndSaveSets request is -->{}", (Object)body);
        String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).addHeaders(headers)).body(JSON.toJSONString((Object)body)).execute().body();
        log.info("compileAndSaveSets response is -->{}", (Object)response);
        JSONObject responseObj = JSON.parseObject((String)response);
        if (Objects.isNull(responseObj) || responseObj.getInteger("status") != 200) {
            throw new BusinessException("\u8c03\u7528/restful/service/knowledgegraph/Set/CompileAndSaveSets\u63a5\u53e3\u53d1\u5e03\u5957\u4ef6\u5931\u8d25\uff01\u8fd4\u56de\u4fe1\u606f\uff1a" + response);
        }
    }

    public void publishEventToKM(JSONObject body) {
        String tenantId = body.getString("tenantId");
        String token = this.iamService.getIntegrationToken(tenantId);
        String url = this.moduleConfig.getKmDeployerService().getDomain() + "/km-deployer-service/publish/event";
        log.info("publish to km url is:" + url);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=UTF-8");
        headers.put("token", token);
        headers.put("routerKey", tenantId);
        body.remove((Object)"tenantId");
        log.info("publishEventToKM request is -->{}", (Object)body);
        String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).addHeaders(headers)).body(JSON.toJSONString((Object)body)).execute().body();
        log.info("publishEventToKM response is -->{}", (Object)response);
    }

    public void mergeCommonAppRelaWithVirtualTenant(String application, String appVersion, String tenantVersion) throws BusinessException {
        String tenantId = CurThreadInfoUtils.getRouterKey();
        String token = this.iamService.getIntegrationToken(tenantId);
        String url = this.moduleConfig.getKm().getDomain() + "/restful/service/knowledgegraph/tenant/connectVirtualTenantToNodes";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=UTF-8");
        headers.put("token", token);
        JSONObject body = new JSONObject();
        JSONObject virtualTenantParams = new JSONObject();
        virtualTenantParams.put("application", (Object)application);
        virtualTenantParams.put("appVersion", (Object)appVersion);
        virtualTenantParams.put("tenantVersion", (Object)tenantVersion);
        body.put("virtualTenantParams", (Object)virtualTenantParams);
        log.info("mergeCommonAppRelaWithTenant url is:" + url);
        log.info("mergeCommonAppRelaWithTenant headers is -->{}", headers);
        log.info("mergeCommonAppRelaWithTenant request is -->{}", (Object)body);
        JSONObject response = HttpRequsetUtil.sendHttpRequest((Method)Method.POST, (String)url, headers, (JSONObject)body);
        log.info("mergeCommonAppRelaWithTenant response is -->{}", (Object)response);
        if (Objects.isNull(response) || response.getInteger("status") != 200) {
            throw new BusinessException("\u8c03\u7528/restful/service/knowledgegraph/tenant/connectVirtualTenantToNodes\u63a5\u53e3\u589e\u52a0\u5e94\u7528\u6570\u636e\u548c\u865a\u62df\u79df\u6237\u5173\u7cfb\u5931\u8d25\uff01\u8fd4\u56de\u4fe1\u606f\uff1a" + String.valueOf(response));
        }
    }

    public void deleteCommonAppRelaWithVirtualTenant(String application, String appVersion, String tenantVersion) throws BusinessException {
        String tenantId = CurThreadInfoUtils.getRouterKey();
        String token = this.iamService.getIntegrationToken(tenantId);
        String url = this.moduleConfig.getKm().getDomain() + "/restful/service/knowledgegraph/tenant/deleteVirtualTenantToNodes";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=UTF-8");
        headers.put("token", token);
        JSONObject body = new JSONObject();
        JSONObject virtualTenantParams = new JSONObject();
        virtualTenantParams.put("application", (Object)application);
        virtualTenantParams.put("appVersion", (Object)appVersion);
        virtualTenantParams.put("tenantVersion", (Object)tenantVersion);
        body.put("virtualTenantParams", (Object)virtualTenantParams);
        log.info("deleteCommonAppRelaWithVirtualTenant url is:" + url);
        log.info("deleteCommonAppRelaWithVirtualTenant headers is -->{}", headers);
        log.info("deleteCommonAppRelaWithVirtualTenant request is -->{}", (Object)body);
        JSONObject response = HttpRequsetUtil.sendHttpRequest((Method)Method.POST, (String)url, headers, (JSONObject)body);
        log.info("deleteCommonAppRelaWithVirtualTenant response is -->{}", (Object)response);
        if (Objects.isNull(response) || response.getInteger("status") != 200) {
            throw new BusinessException("\u8c03\u7528/restful/service/knowledgegraph/tenant/deleteVirtualTenantToNodes\u63a5\u53e3\u5220\u9664\u5e94\u7528\u6570\u636e\u548c\u865a\u62df\u79df\u6237\u5173\u7cfb\u5931\u8d25\uff01\u8fd4\u56de\u4fe1\u606f\uff1a" + String.valueOf(response));
        }
    }

    public void testKgRouterKey(String routerKey) {
        String url = this.moduleConfig.getKm().getDomain() + "/restful/service/knowledgegraph/test/test03?input=1234";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=UTF-8");
        headers.put("routerkey", routerKey);
        log.info("testKgRouterKey url is -->{}", (Object)url);
        String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.GET, (String)url).addHeaders(headers)).execute().body();
        log.info("testKgRouterKey response is -->{}", (Object)response);
        JSONObject responseObj = JSON.parseObject((String)response);
        if (responseObj.getInteger("status") != 200) {
            throw new BusinessException("\u8c03\u7528/restful/service/knowledgegraph/test/test03\u63a5\u53e3\u5931\u8d25\uff01\u8fd4\u56de\u4fe1\u606f\uff1a" + response);
        }
    }

    public void kmDeployTenant(TenantDeployParamDto tenantDeployParam) {
        String url = this.moduleConfig.getKmDeployerService().getDomain() + "/km-deployer-service/publish/deployTenant";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("token", tenantDeployParam.getToken());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("dataId", tenantDeployParam.getDataId());
        param.put("fileId", tenantDeployParam.getFieldId());
        param.put("tenantId", tenantDeployParam.getTenantId());
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)httpHeaders);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            log.error("km-deployer-service/publish/deployTenant \u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCodeValue() + " body:" + (String)response.getBody());
            throw new BusinessException("/km-deployer-service/publish/deployTenant\u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCodeValue());
        }
        ResultDto resultDto = (ResultDto)JSONObject.parseObject((String)((String)response.getBody()), ResultDto.class);
        if (!ResultDto.SUCCESS_CODE.equals(resultDto.getCode())) {
            log.error("km-deployer-service/publish/deployTenant \u54cd\u5e94\u5f02\u5e38:" + (String)response.getBody());
            throw new BusinessException("/km-deployer-service/publish/deployTenant \u54cd\u5e94\u5f02\u5e38\uff1a" + (String)response.getBody());
        }
    }

    public void kmRevokeDeployTenant(TenantDeployParamDto tenantDeployParam) {
        String url = this.moduleConfig.getKmDeployerService().getDomain() + "/km-deployer-service/publish/revokeDeployTenant";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("token", tenantDeployParam.getToken());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("dataId", tenantDeployParam.getDataId());
        param.put("fileId", tenantDeployParam.getFieldId());
        param.put("tenantId", tenantDeployParam.getTenantId());
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)httpHeaders);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            log.error("km-deployer-service/publish/revokeDeployTenant \u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCodeValue() + " body:" + (String)response.getBody());
            throw new BusinessException("/km-deployer-service/publish/revokeDeployTenant \u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCodeValue());
        }
        ResultDto resultDto = (ResultDto)JSONObject.parseObject((String)((String)response.getBody()), ResultDto.class);
        if (!ResultDto.SUCCESS_CODE.equals(resultDto.getCode())) {
            log.error("km-deployer-service/publish/revokeDeployTenant \u54cd\u5e94\u5f02\u5e38:" + (String)response.getBody());
            throw new BusinessException("/km-deployer-service/publish/revokeDeployTenant \u54cd\u5e94\u5f02\u5e38\uff1a" + (String)response.getBody());
        }
    }

    public void syncPushData(SyncPushDataDto dto) {
        String tenantId = dto.getCurrTenantId();
        String token = this.iamService.getIntegrationToken(tenantId);
        String url = this.moduleConfig.getAdq().getDomain() + "/restful/service/knowledgegraph/scene/pushData";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=UTF-8");
        headers.put("token", token);
        dto.setCurrTenantId(null);
        log.info("syncPushData url is:" + url);
        log.info("syncPushData headers is -->{}", headers);
        log.info("syncPushData request is -->{}", (Object)dto);
        JSONObject response = HttpRequsetUtil.sendHttpRequest((Method)Method.POST, (String)url, headers, (JSONObject)JSONObject.parseObject((String)JSON.toJSONString((Object)dto)));
        log.info("syncPushData response is -->{}", (Object)response);
        if (Objects.isNull(response) || response.getInteger("status") != 200) {
            throw new BusinessException("\u8c03\u7528/restful/service/knowledgegraph/scene/pushData\u63a5\u53e3\u63a8\u9001\u6570\u636e\u5931\u8d25\u3002\u8fd4\u56de\u4fe1\u606f\uff1a" + String.valueOf(response));
        }
        if (Objects.nonNull(response.getJSONObject("response")) && Objects.equals(response.getJSONObject("response").getInteger("code"), 500)) {
            throw new BusinessException("\u8c03\u7528/restful/service/knowledgegraph/scene/pushData\u63a5\u53e3\u63a8\u9001\u6570\u636e\u5931\u8d25\uff01\u8fd4\u56de\u4fe1\u606f\uff1a" + String.valueOf(response));
        }
    }

    public DeployAppResDto deployApp(DeployAppReqDto deployAppReqDto, String tenantId) {
        String message = "\u8c03KM\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
        String timeout = "\u8c03KM\u63a5\u53e3\u8d85\u65f6\uff0c\u5931\u8d25\u539f\u56e0:%s";
        String token = this.iamService.getIntegrationToken(tenantId);
        String url = this.moduleConfig.getKmDeployerService().getDomain() + "/km-deployer-service/deploy/deployApp";
        log.info("deployApp url:" + url);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("token", token);
        HttpEntity httpEntity = new HttpEntity((Object)deployAppReqDto, (MultiValueMap)httpHeaders);
        String messageId = IdUtil.fastUUID().replace("-", "");
        try {
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
            if (response.getStatusCode() != HttpStatus.OK) {
                log.error("/km-deployer-service/deploy/deployApp \u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCodeValue() + " body:" + (String)response.getBody());
                LogUtils.buildAgileLog((String)deployAppReqDto.getAppId(), (String)LogUtils.MODULE_AADCS, (String)"deployApp", (String)LogUtils.AADCS_500_0007, (String)JSON.toJSONString((Object)deployAppReqDto), (String)String.format(message, response.getBody()), (String)String.format("\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff0c\u5e76\u63d0\u4f9b\u6d88\u606f\u5e8f\u5217\u53f7\uff08%s\uff09", messageId), (String)messageId);
                throw new BusinessException("/km-deployer-service/deploy/deployApp \u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCodeValue());
            }
            DeployAppResDto deployAppResDto = (DeployAppResDto)JSONObject.parseObject((String)((String)response.getBody()), DeployAppResDto.class);
            if (ResultDto.SUCCESS_CODE.equals(deployAppResDto.getCode()) || ResultDto.REPEAT_DEPLOY_CODE.equals(deployAppResDto.getCode())) {
                LogUtils.buildAgileLog((String)deployAppReqDto.getAppId(), (String)LogUtils.MODULE_AADCS, (String)"deployApp", (String)LogUtils.SUCCESS, (String)JSON.toJSONString((Object)deployAppReqDto), (String)((String)response.getBody()), (String)"", (String)messageId);
                return deployAppResDto;
            }
            log.error("/km-deployer-service/deploy/deployApp \u54cd\u5e94\u5f02\u5e38:" + (String)response.getBody());
            LogUtils.buildAgileLog((String)deployAppReqDto.getAppId(), (String)LogUtils.MODULE_AADCS, (String)"deployApp", (String)LogUtils.AADCS_500_0008, (String)JSON.toJSONString((Object)deployAppReqDto), (String)String.format(message, response.getBody()), (String)String.format("\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff0c\u5e76\u63d0\u4f9b\u6d88\u606f\u5e8f\u5217\u53f7\uff08%s\uff09", messageId), (String)messageId);
            throw new BusinessException("/km-deployer-service/deploy/deployApp \u54cd\u5e94\u5f02\u5e38\uff1a" + (String)response.getBody());
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)deployAppReqDto.getAppId(), (String)LogUtils.MODULE_AADCS, (String)"deployApp", (String)LogUtils.AADCS_504_0002, (String)JSON.toJSONString((Object)deployAppReqDto), (String)String.format(timeout, e.getMessage()), (String)String.format("\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\u68c0\u67e5%s\u670d\u52a1", LogUtils.THIRD_KM), (String)messageId);
            throw e;
        }
    }

    public DeployAppResDto switchApp(SwitchAppReqDto switchAppReqDto, String tenantId) {
        String message = "\u8c03KM\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
        String timeout = "\u8c03KM\u63a5\u53e3\u8d85\u65f6\uff0c\u5931\u8d25\u539f\u56e0:%s";
        String tenant = StringUtils.isNotBlank((CharSequence)switchAppReqDto.getDeployTenantId()) ? switchAppReqDto.getDeployTenantId() : tenantId;
        String token = this.iamService.getIntegrationToken(tenant);
        String url = this.moduleConfig.getKmDeployerService().getDomain() + "/km-deployer-service/deploy/switchApp";
        log.info("switchApp url:" + url);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("token", token);
        HttpEntity httpEntity = new HttpEntity((Object)switchAppReqDto, (MultiValueMap)httpHeaders);
        String messageId = IdUtil.fastUUID().replace("-", "");
        try {
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
            if (response.getStatusCode() != HttpStatus.OK) {
                log.error("/km-deployer-service/deploy/switchApp \u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCodeValue() + " body:" + (String)response.getBody());
                LogUtils.buildAgileLog((String)switchAppReqDto.getApplication(), (String)LogUtils.MODULE_AADCS, (String)"deployApp", (String)LogUtils.AADCS_500_0013, (String)JSON.toJSONString((Object)switchAppReqDto), (String)String.format(message, response.getBody()), (String)String.format("\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff0c\u5e76\u63d0\u4f9b\u6d88\u606f\u5e8f\u5217\u53f7\uff08%s\uff09", messageId), (String)messageId);
                throw new BusinessException("/km-deployer-service/deploy/switchApp \u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCodeValue());
            }
            DeployAppResDto deployAppResDto = (DeployAppResDto)JSONObject.parseObject((String)((String)response.getBody()), DeployAppResDto.class);
            if (ResultDto.SUCCESS_CODE.equals(deployAppResDto.getCode()) || ResultDto.REPEAT_DEPLOY_CODE.equals(deployAppResDto.getCode())) {
                LogUtils.buildAgileLog((String)switchAppReqDto.getApplication(), (String)LogUtils.MODULE_AADCS, (String)"deployApp", (String)LogUtils.SUCCESS, (String)JSON.toJSONString((Object)switchAppReqDto), (String)((String)response.getBody()), (String)"", (String)messageId);
                return deployAppResDto;
            }
            log.error("/km-deployer-service/deploy/switchApp \u54cd\u5e94\u5f02\u5e38:" + (String)response.getBody());
            LogUtils.buildAgileLog((String)switchAppReqDto.getApplication(), (String)LogUtils.MODULE_AADCS, (String)"deployApp", (String)LogUtils.AADCS_500_0014, (String)JSON.toJSONString((Object)switchAppReqDto), (String)String.format(message, response.getBody()), (String)String.format("\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff0c\u5e76\u63d0\u4f9b\u6d88\u606f\u5e8f\u5217\u53f7\uff08%s\uff09", messageId), (String)messageId);
            throw new BusinessException("/km-deployer-service/deploy/deployApp switchApp\uff1a" + (String)response.getBody());
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)switchAppReqDto.getApplication(), (String)LogUtils.MODULE_AADCS, (String)"deployApp", (String)LogUtils.AADCS_504_0006, (String)JSON.toJSONString((Object)switchAppReqDto), (String)String.format(timeout, e.getMessage()), (String)String.format("\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\u68c0\u67e5%s\u670d\u52a1", LogUtils.THIRD_KM), (String)messageId);
            throw e;
        }
    }

    public DeployLogResDto deployLogs(String eventId, String tenantId) {
        String token = this.iamService.getIntegrationToken(tenantId);
        String url = this.moduleConfig.getKmDeployerService().getDomain() + "/km-deployer-service/deploy/deployLogs";
        log.info("deployLogs url:" + url);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("token", token);
        httpHeaders.add("routerKey", tenantId);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("eventId", eventId);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)httpHeaders);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            log.error("/km-deployer-service/publish/deployLogs \u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCodeValue() + " body:" + (String)response.getBody());
            throw new BusinessException("/km-deployer-service/publish/deployLogs \u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCodeValue());
        }
        DeployLogResDto resultDto = (DeployLogResDto)JSONObject.parseObject((String)((String)response.getBody()), DeployLogResDto.class);
        if (ResultDto.SUCCESS_CODE.equals(resultDto.getCode())) {
            return resultDto;
        }
        log.error("/km-deployer-service/publish/deployLogs \u54cd\u5e94\u5f02\u5e38:" + (String)response.getBody());
        throw new BusinessException("/km-deployer-service/publish/deployLogs\uff1a" + (String)response.getBody());
    }

    public List<EspActionIdSwitchResDto> assignSwitchEspAction(String token, String id, String actionIds) {
        String url = this.moduleConfig.getKmDeployerService().getDomain() + "/km-deployer-service/deploy/assignSwitchEspAction?id=" + id + "&actionIds=" + actionIds;
        log.info("assignSwitchEspAction url:" + url);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("token", token);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)httpHeaders);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            log.error("/km-deployer-service/deploy/assignSwitchEspAction \u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCodeValue() + " body:" + (String)response.getBody());
            throw new BusinessException("/km-deployer-service/deploy/assignSwitchEspAction \u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCodeValue());
        }
        ResultDto resultDto = (ResultDto)JSONObject.parseObject((String)((String)response.getBody()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (ResultDto.SUCCESS_CODE.equals(resultDto.getCode())) {
            return (List)resultDto.getData();
        }
        log.error("/km-deployer-service/deploy/assignSwitchEspAction \u54cd\u5e94\u5f02\u5e38:" + (String)response.getBody());
        throw new BusinessException("/km-deployer-service/deploy/assignSwitchEspAction\uff1a" + (String)response.getBody());
    }

    public void revokeApp(KmRevokeAppParamDto kmRevokeAppParam, String token) {
        String url = this.moduleConfig.getKmDeployerService().getDomain() + "/km-deployer-service/deploy/revokeApp";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("token", token);
        HashMap params = new HashMap();
        HttpEntity httpEntity = new HttpEntity((Object)kmRevokeAppParam, (MultiValueMap)httpHeaders);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        DeployLogResDto resultDto = (DeployLogResDto)JSONObject.parseObject((String)((String)response.getBody()), DeployLogResDto.class);
        if (ResultDto.SUCCESS_CODE.equals(resultDto.getCode())) {
            return;
        }
        log.error("/km-deployer-service/deploy/revokeApp \u54cd\u5e94\u5f02\u5e38:" + (String)response.getBody());
        throw new BusinessException("/km-deployer-service/deploy/revokeApp\uff1a" + (String)response.getBody());
    }

    public void updateVersion(TenantVersionUpdateReqDto tenantVersionUpdateReqDto, String tenantId) {
        String token = this.iamService.getIntegrationToken(tenantId);
        String url = this.moduleConfig.getKmDeployerService().getDomain() + "/km-deployer-service/deploy/updateVersion";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("token", token);
        HttpEntity httpEntity = new HttpEntity((Object)tenantVersionUpdateReqDto, (MultiValueMap)httpHeaders);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        DeployLogResDto resultDto = (DeployLogResDto)JSONObject.parseObject((String)((String)response.getBody()), DeployLogResDto.class);
        if (ResultDto.SUCCESS_CODE.equals(resultDto.getCode())) {
            return;
        }
        log.error("/km-deployer-service/deploy/updateVersion \u54cd\u5e94\u5f02\u5e38:" + (String)response.getBody());
        throw new BusinessException("/km-deployer-service/deploy/updateVersion\uff1a" + (String)response.getBody());
    }

    public void applyMechanisms(JSONObject requestBody, String tenantId) {
        String token = this.iamService.getIntegrationToken(tenantId);
        String url = this.moduleConfig.getKm().getDomain() + "/restful/service/knowledgegraph/mechanismDesign/applyMechanisms";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=UTF-8");
        headers.put("token", token);
        String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).addHeaders(headers)).body(JSON.toJSONString((Object)requestBody)).execute().body();
        log.info("applyMechanisms response is -->{}", (Object)response);
        JSONObject responseObj = JSON.parseObject((String)response);
        if (responseObj.getInteger("status") != 200) {
            throw new BusinessException("\u8c03\u7528/restful/service/knowledgegraph/mechanismDesign/applyMechanisms \u63a5\u53e3\u673a\u5236\u4e00\u6b21\u7f16\u8bd1\u5931\u8d25\uff01\u8fd4\u56de\u4fe1\u606f\uff1a" + response);
        }
    }

    public void deployCleanApp(String tenantId, String sourceId, String appId) {
        if (this.deleteFlag) {
            String token = this.iamService.getIntegrationToken(tenantId);
            String url = this.moduleConfig.getKmDeployerService().getDomain() + "/km-deployer-service/deploy/cleanApp";
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json; charset=UTF-8");
            headers.put("token", token);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("sourceId", sourceId);
            paramMap.put("appId", appId);
            log.info("request deployCleanApp method param is:{}", (Object)JSON.toJSONString(paramMap));
            String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).addHeaders(headers)).body(JSON.toJSONString(paramMap)).execute().body();
            log.info("deployCleanApp response is -->{}", (Object)response);
            JSONObject responseObj = JSON.parseObject((String)response);
            if (responseObj.getInteger("code") != 0) {
                throw new BusinessException("\u8c03\u7528/km-deployer-service/deploy/cleanApp km\u6e05\u9664\u5e94\u7528\u5931\u8d25\uff01\u8fd4\u56de\u4fe1\u606f\uff1a" + response);
            }
        } else {
            throw new BusinessException("km \u6b63\u5f0f\u533a\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664");
        }
    }

    public void syncVariableData(SyncPushDataDto dto) {
        String tenantId = dto.getCurrTenantId();
        String token = this.iamService.getIntegrationToken(tenantId);
        String url = this.moduleConfig.getTdd().getDomain() + "/deliverydesigner/businessVariablesValueController/syncData";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=UTF-8");
        headers.put("token", token);
        log.info("syncVariableData url is:" + url);
        log.info("syncVariableData headers is -->{}", headers);
        List tenantUsers = dto.getTenantUsers();
        for (TenantUser user : tenantUsers) {
            JSONObject body = new JSONObject();
            body.put("tenantId", (Object)user.getTenantId());
            body.put("appCode", dto.getAppCodes().get(0));
            log.info("syncVariableData request is -->{}", (Object)body);
            JSONObject response = HttpRequsetUtil.sendHttpRequest((Method)Method.POST, (String)url, headers, (JSONObject)JSONObject.parseObject((String)JSON.toJSONString((Object)body)));
            log.info("syncVariableData response is -->{}", (Object)response);
            if (!Objects.isNull(response) && response.getInteger("code") == 0) continue;
            throw new BusinessException("\u8c03\u7528/deliverydesigner/businessVariablesValueController/syncData\u63a5\u53e3\u63a8\u9001\u6570\u636e\u5931\u8d25\uff01\u8fd4\u56de\u4fe1\u606f\uff1a" + String.valueOf(response));
        }
    }

    public DeployAppResDto commonParadigmDeploy(CommonParadigmDeployDto deployDto, String tenantId) {
        String token = this.iamService.getIntegrationToken(tenantId);
        String url = this.moduleConfig.getKmDeployerService().getDomain() + "/km-deployer-service/paradigm/deploy/deployApp";
        log.info("commonParadigmDeploy url:{}", (Object)url);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("token", token);
        HttpEntity httpEntity = new HttpEntity((Object)deployDto, (MultiValueMap)httpHeaders);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            log.error("/km-deployer-service/paradigm/deploy/deployApp \u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCodeValue() + " body:" + (String)response.getBody());
            throw new BusinessException("/km-deployer-service/paradigm/deploy/deployApp \u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCodeValue());
        }
        DeployAppResDto deployAppResDto = (DeployAppResDto)JSONObject.parseObject((String)((String)response.getBody()), DeployAppResDto.class);
        if (ResultDto.SUCCESS_CODE.equals(deployAppResDto.getCode()) || ResultDto.REPEAT_DEPLOY_CODE.equals(deployAppResDto.getCode())) {
            return deployAppResDto;
        }
        log.error("/km-deployer-service/paradigm/deploy/deployApp \u54cd\u5e94\u5f02\u5e38:" + (String)response.getBody());
        throw new BusinessException("/km-deployer-service/paradigm/deploy/deployApp \u54cd\u5e94\u5f02\u5e38\uff1a" + (String)response.getBody());
    }
}

