/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.http.km.dto;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.domain.TenantUser;
import com.digiwin.athena.athena_deployer_service.domain.application.CollectionDomain;
import com.digiwin.athena.athena_deployer_service.domain.deploy.CustomPublishParam;
import com.digiwin.athena.athena_deployer_service.http.km.dto.KmSingleModuleJobDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.KmSingleModuleParamDto;
import com.digiwin.athena.athena_deployer_service.util.KmSecurityUtils;
import com.digiwin.athena.athena_deployer_service.util.SafeFileUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DeployAppReqDto {
    private static final List<BiConsumer<DeployAppReqDto, CustomPublishParam>> collectHandles = new ArrayList();
    public static final String APP_TYPE = "app";
    public static final String TENANT_APP_TYPE = "tenantApp";
    public static final String TENANT_CUSTOM_TYPE = "tenantCustom";
    private String deployTenantId;
    private String deployerToken;
    private String deployerDomain;
    private String deployerLogId;
    private String application;
    private String signature;
    private String nonce;
    private Long timestamp;
    private String appId;
    private String appName;
    private Boolean commonApp;
    private String sourceId;
    private String deployId;
    private String type;
    private String fileId;
    private KmSingleModuleParamDto appData = new KmSingleModuleParamDto();
    private List<String> tenantIds;
    private List<KmSingleModuleJobDto> jobList = new ArrayList();
    private JSONObject cleanSourceTenants;
    private Boolean sync;
    private String sourceApplicationCode;
    private Boolean individualAll;

    public Boolean getIndividualAll() {
        return this.individualAll;
    }

    public void setIndividualAll(Boolean individualAll) {
        this.individualAll = individualAll;
    }

    public static DeployAppReqDto create(CustomPublishParam customPublishParam) {
        DeployAppReqDto deployAppReqDto = new DeployAppReqDto();
        deployAppReqDto.setAppId("tenantApp".equals(customPublishParam.getKmDeployAppType()) ? customPublishParam.getSourceApplicationCode() : customPublishParam.getApplication());
        deployAppReqDto.setType(StringUtils.isNotBlank((CharSequence)customPublishParam.getEocId()) ? "eocCustom" : customPublishParam.getKmDeployAppType());
        deployAppReqDto.setSync(Boolean.valueOf(true));
        deployAppReqDto.setCommonApp(customPublishParam.getCommonApp());
        deployAppReqDto.setSourceId(StringUtils.isBlank((CharSequence)customPublishParam.getSourceId()) ? customPublishParam.getApplication() : customPublishParam.getSourceId());
        deployAppReqDto.setIndividualAll(customPublishParam.getIndividualAll());
        if (!CollectionUtils.isEmpty((Collection)customPublishParam.getTenantUsers())) {
            deployAppReqDto.setTenantIds(customPublishParam.getTenantUsers().stream().map(TenantUser::getTenantId).collect(Collectors.toList()));
        }
        Date currentDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.add(11, 1);
        deployAppReqDto.setNonce(IdUtil.fastSimpleUUID());
        deployAppReqDto.setTimestamp(Long.valueOf(calendar.getTimeInMillis()));
        deployAppReqDto.setDeployId(StringUtils.isEmpty((CharSequence)customPublishParam.getKmDeployId()) ? IdUtil.fastSimpleUUID() : customPublishParam.getKmDeployId());
        deployAppReqDto.setSignature(KmSecurityUtils.sign((String)(deployAppReqDto.getDeployId() + deployAppReqDto.getNonce() + deployAppReqDto.getTimestamp())));
        return deployAppReqDto;
    }

    public void setSinglePublishNeo4jData(List<String> cyphers, List<Object> pkValueList, CollectionDomain collectionDomain) {
        if (!CollectionUtils.isEmpty(cyphers)) {
            if (this.appData != null) {
                this.getAppData().getCyphers().addAll(cyphers);
            } else {
                KmSingleModuleParamDto kmSingleModuleParamDto = new KmSingleModuleParamDto();
                kmSingleModuleParamDto.setCyphers(cyphers);
                this.setAppData(kmSingleModuleParamDto);
            }
        }
        if (!CollectionUtils.isEmpty(pkValueList)) {
            KmSingleModuleJobDto kmSingleModuleJobDto = new KmSingleModuleJobDto();
            kmSingleModuleJobDto.setDb("neo4j");
            kmSingleModuleJobDto.setTable(collectionDomain.getCollection());
            List keys = pkValueList.stream().map(o -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(collectionDomain.getPrimaryKey(), o);
                map.put("version", "1.0");
                if (!StringUtils.isEmpty((CharSequence)collectionDomain.getApplication())) {
                    map.put("athena_namespace", collectionDomain.getApplication());
                }
                return map;
            }).collect(Collectors.toList());
            kmSingleModuleJobDto.setKeys(keys);
            this.getJobList().add(kmSingleModuleJobDto);
        }
    }

    public void setSinglePublishMongoData(List<JSONObject> mongoData, List<Object> pkValueList, CollectionDomain collectionDomain) {
        if (!CollectionUtils.isEmpty(mongoData)) {
            KmSingleModuleParamDto.MongoParamData mongoParamData = new KmSingleModuleParamDto.MongoParamData();
            mongoParamData.getDocs().addAll(mongoData);
            mongoParamData.setDb(collectionDomain.getDatabaseName());
            mongoParamData.setCol(collectionDomain.getCollection());
            if (this.appData != null) {
                this.getAppData().getMongoData().add(mongoParamData);
            } else {
                KmSingleModuleParamDto kmSingleModuleParamDto = new KmSingleModuleParamDto();
                kmSingleModuleParamDto.getMongoData().add(mongoParamData);
                this.setAppData(kmSingleModuleParamDto);
            }
        }
        if (!CollectionUtils.isEmpty(pkValueList)) {
            KmSingleModuleJobDto kmSingleModuleJobDto = new KmSingleModuleJobDto();
            kmSingleModuleJobDto.setDb(collectionDomain.getDatabaseName());
            kmSingleModuleJobDto.setTable(collectionDomain.getCollection());
            List keys = pkValueList.stream().map(o -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(collectionDomain.getPrimaryKey(), o);
                map.put("version", "1.0");
                if (!StringUtils.isEmpty((CharSequence)collectionDomain.getApplication())) {
                    map.put("athena_namespace", collectionDomain.getApplication());
                }
                return map;
            }).collect(Collectors.toList());
            kmSingleModuleJobDto.setKeys(keys);
            this.getJobList().add(kmSingleModuleJobDto);
        }
    }

    public String getSourceApplicationCode() {
        return this.sourceApplicationCode;
    }

    public void setSourceApplicationCode(String sourceApplicationCode) {
        this.sourceApplicationCode = sourceApplicationCode;
    }

    public String getDeployerLogId() {
        return this.deployerLogId;
    }

    public void setDeployerLogId(String deployerLogId) {
        this.deployerLogId = deployerLogId;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getDeployerToken() {
        return this.deployerToken;
    }

    public void setDeployerToken(String deployerToken) {
        this.deployerToken = deployerToken;
    }

    public String getDeployerDomain() {
        return this.deployerDomain;
    }

    public void setDeployerDomain(String deployerDomain) {
        this.deployerDomain = deployerDomain;
    }

    public String getDeployTenantId() {
        return this.deployTenantId;
    }

    public void setDeployTenantId(String deployTenantId) {
        this.deployTenantId = deployTenantId;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Boolean getCommonApp() {
        return this.commonApp;
    }

    public void setCommonApp(Boolean commonApp) {
        this.commonApp = commonApp;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getDeployId() {
        return this.deployId;
    }

    public void setDeployId(String deployId) {
        this.deployId = deployId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public KmSingleModuleParamDto getAppData() {
        return this.appData;
    }

    public void setAppData(KmSingleModuleParamDto appData) {
        this.appData = appData;
    }

    public List<String> getTenantIds() {
        return this.tenantIds;
    }

    public void setTenantIds(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    public List<KmSingleModuleJobDto> getJobList() {
        return this.jobList;
    }

    public void setJobList(List<KmSingleModuleJobDto> jobList) {
        this.jobList = jobList;
    }

    public JSONObject getCleanSourceTenants() {
        return this.cleanSourceTenants;
    }

    public void setCleanSourceTenants(JSONObject cleanSourceTenants) {
        this.cleanSourceTenants = cleanSourceTenants;
    }

    public Boolean getSync() {
        return this.sync;
    }

    public void setSync(Boolean sync) {
        this.sync = sync;
    }

    public boolean appDataIsEmpty() {
        if (this.getAppData() == null) {
            return true;
        }
        return CollectionUtils.isEmpty((Collection)this.getAppData().getMongoData()) && CollectionUtils.isEmpty((Collection)this.getAppData().getCyphers());
    }

    public void collectPublishData(CustomPublishParam customPublishParam) {
        for (BiConsumer collectHandle : collectHandles) {
            collectHandle.accept(this, customPublishParam);
        }
    }

    public static void neo4jRelation(DeployAppReqDto deployAppReqDto, CustomPublishParam customPublishParam) {
        List cqlList = DeployAppReqDto.collectNeo4jRelation((CustomPublishParam)customPublishParam);
        if (!cqlList.isEmpty()) {
            for (int i = 0; i < cqlList.size(); ++i) {
                String cql = (String)cqlList.get(i);
                if (!cql.startsWith("match (fromNode:RelatedObject) where fromNode.id='charge'") && !cql.startsWith("match (fromNode:RelatedObject) where fromNode.id='performer'")) continue;
                cqlList.set(i, cql.replace("fromNode.version='{athena_version}'", "fromNode.version='1.0'"));
            }
            deployAppReqDto.setSinglePublishNeo4jData(cqlList, new ArrayList(), null);
        }
    }

    public static void neo4jActivityData(DeployAppReqDto deployAppReqDto, CustomPublishParam customPublishParam) {
        CollectionDomain collectionDomain = new CollectionDomain().setCollection("Activity").setPrimaryKey("code").setApplication(customPublishParam.getApplication());
        List pkValueList = customPublishParam.getPublishEntityList().stream().filter(publishEntity -> "DataEntry".equals(publishEntity.getType())).map(publishEntity -> publishEntity.getPkValue()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(pkValueList)) {
            List cyphers = DeployAppReqDto.collectNeo4jData((CustomPublishParam)customPublishParam, (CollectionDomain)collectionDomain, pkValueList);
            deployAppReqDto.setSinglePublishNeo4jData(cyphers, pkValueList, collectionDomain);
        }
    }

    public static void neo4jTagData(DeployAppReqDto deployAppReqDto, CustomPublishParam customPublishParam) {
        CollectionDomain collectionDomain = new CollectionDomain().setCollection("Tag").setPrimaryKey("namespacePath").setApplication(customPublishParam.getApplication());
        List namespacePathList = customPublishParam.getPublishEntityList().stream().filter(publishEntity -> publishEntity.getType().equals("task") || publishEntity.getType().equals("DataEntry") || publishEntity.getType().equals("Statement")).map(relatedEntity -> relatedEntity.getType() + "&" + String.valueOf(relatedEntity.getPkValue())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(namespacePathList)) {
            List cqlList = DeployAppReqDto.collectNeo4jData((CustomPublishParam)customPublishParam, (CollectionDomain)collectionDomain, namespacePathList);
            deployAppReqDto.setSinglePublishNeo4jData(cqlList, namespacePathList, collectionDomain);
        }
    }

    public static void neo4jLanguageData(DeployAppReqDto deployAppReqDto, CustomPublishParam customPublishParam) {
        CollectionDomain collectionDomain = new CollectionDomain().setCollection("Language").setPrimaryKey("namespacePath").setApplication(customPublishParam.getApplication());
        List namespacePathList = customPublishParam.getPublishEntityList().stream().filter(publishEntity -> publishEntity.getType().equals("task") || publishEntity.getType().equals("DataEntry") || publishEntity.getType().equals("Statement")).map(relatedEntity -> relatedEntity.getType() + "&" + String.valueOf(relatedEntity.getPkValue())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(namespacePathList)) {
            List cqlList = DeployAppReqDto.collectNeo4jData((CustomPublishParam)customPublishParam, (CollectionDomain)collectionDomain, namespacePathList);
            deployAppReqDto.setSinglePublishNeo4jData(cqlList, namespacePathList, collectionDomain);
        }
    }

    public static void neo4jRelatedObjectData(DeployAppReqDto deployAppReqDto, CustomPublishParam customPublishParam) {
        CollectionDomain collectionDomain = new CollectionDomain().setCollection("RelatedObject").setPrimaryKey("namespacePath").setApplication(customPublishParam.getApplication());
        List namespacePathList = customPublishParam.getPublishEntityList().stream().filter(publishEntity -> publishEntity.getType().equals("task") || publishEntity.getType().equals("DataEntry") || publishEntity.getType().equals("Statement")).map(relatedEntity -> relatedEntity.getType() + "&" + String.valueOf(relatedEntity.getPkValue())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(namespacePathList)) {
            List cqlList = DeployAppReqDto.collectNeo4jData((CustomPublishParam)customPublishParam, (CollectionDomain)collectionDomain, namespacePathList);
            deployAppReqDto.setSinglePublishNeo4jData(cqlList, namespacePathList, collectionDomain);
        }
    }

    public static void mongoTaggingDataData(DeployAppReqDto deployAppReqDto, CustomPublishParam customPublishParam) {
        CollectionDomain collectionDomain = new CollectionDomain().setCollection("taggingData").setDatabaseName("tagSystem").setPrimaryKey("namespacePath").setApplication(customPublishParam.getApplication());
        List namespacePathList = customPublishParam.getPublishEntityList().stream().filter(publishEntity -> publishEntity.getType().equals("task") || publishEntity.getType().equals("DataEntry") || publishEntity.getType().equals("Statement")).map(relatedEntity -> relatedEntity.getType() + "&" + String.valueOf(relatedEntity.getPkValue())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(namespacePathList)) {
            List cqlList = DeployAppReqDto.collectMongoData((CustomPublishParam)customPublishParam, (CollectionDomain)collectionDomain, namespacePathList);
            deployAppReqDto.setSinglePublishMongoData(cqlList, namespacePathList, collectionDomain);
        }
    }

    public static void mongoActivityConfigsData(DeployAppReqDto deployAppReqDto, CustomPublishParam customPublishParam) {
        List pkValueList = customPublishParam.getPublishEntityList().stream().filter(publishEntity -> publishEntity.getType().equals("DataEntry") || publishEntity.getType().equals("Statement")).map(pe -> pe.getPkValue()).collect(Collectors.toList());
        CollectionDomain collectionDomain = new CollectionDomain().setCollection("activityConfigs").setDatabaseName("knowledgegraphSystem").setPrimaryKey("code").setApplication(customPublishParam.getApplication());
        if (!CollectionUtils.isEmpty(pkValueList)) {
            List cqlList = DeployAppReqDto.collectMongoData((CustomPublishParam)customPublishParam, (CollectionDomain)collectionDomain, pkValueList);
            deployAppReqDto.setSinglePublishMongoData(cqlList, pkValueList, collectionDomain);
        }
    }

    public static void mongoApplicationRelationData(DeployAppReqDto deployAppReqDto, CustomPublishParam customPublishParam) {
        List pkValueList = customPublishParam.getPublishEntityList().stream().map(pe -> pe.getPkValue()).collect(Collectors.toList());
        CollectionDomain collectionDomain = new CollectionDomain().setCollection("applicationRelation").setDatabaseName("knowledgegraphSystem").setPrimaryKey("code").setApplication(customPublishParam.getApplication());
        if (!CollectionUtils.isEmpty(pkValueList)) {
            List cqlList = DeployAppReqDto.collectMongoData((CustomPublishParam)customPublishParam, (CollectionDomain)collectionDomain, pkValueList);
            deployAppReqDto.setSinglePublishMongoData(cqlList, pkValueList, collectionDomain);
        }
    }

    public static void mongoRuleData(DeployAppReqDto deployAppReqDto, CustomPublishParam customPublishParam) {
        List cqlList;
        List pkValueList = customPublishParam.getPublishEntityList().stream().filter(publishEntity -> publishEntity.getType().equals("task") || publishEntity.getType().equals("DataEntry") || publishEntity.getType().equals("Statement")).map(pe -> pe.getPkValue()).collect(Collectors.toList());
        CollectionDomain collectionDomain = new CollectionDomain().setCollection("rules").setDatabaseName("preset").setPrimaryKey("domainId").setApplication(customPublishParam.getApplication());
        if (!CollectionUtils.isEmpty(pkValueList)) {
            cqlList = DeployAppReqDto.collectMongoData((CustomPublishParam)customPublishParam, (CollectionDomain)collectionDomain, pkValueList);
            deployAppReqDto.setSinglePublishMongoData(cqlList, pkValueList, collectionDomain);
        }
        collectionDomain.setCollection("tenantRules");
        if (!CollectionUtils.isEmpty(pkValueList)) {
            cqlList = DeployAppReqDto.collectMongoData((CustomPublishParam)customPublishParam, (CollectionDomain)collectionDomain, pkValueList);
            deployAppReqDto.setSinglePublishMongoData(cqlList, pkValueList, collectionDomain);
        }
    }

    public static void mongoPageUIElementData(DeployAppReqDto deployAppReqDto, CustomPublishParam customPublishParam) {
        List pkValueList = customPublishParam.getPublishEntityList().stream().filter(publishEntity -> publishEntity.getType().equals("DataEntry")).map(pe -> pe.getPkValue()).collect(Collectors.toList());
        CollectionDomain collectionDomain = new CollectionDomain().setCollection("pageUIElement").setDatabaseName("datamap").setPrimaryKey("activityId").setApplication(customPublishParam.getApplication());
        if (!CollectionUtils.isEmpty(pkValueList)) {
            List cqlList = DeployAppReqDto.collectMongoData((CustomPublishParam)customPublishParam, (CollectionDomain)collectionDomain, pkValueList);
            deployAppReqDto.setSinglePublishMongoData(cqlList, pkValueList, collectionDomain);
        }
    }

    public static void mongoExportAndImportConfig(DeployAppReqDto deployAppReqDto, CustomPublishParam customPublishParam) {
        List pkValueList = customPublishParam.getPublishEntityList().stream().filter(publishEntity -> publishEntity.getType().equals("DataEntry")).map(pe -> pe.getPkValue()).collect(Collectors.toList());
        CollectionDomain collectionDomain = new CollectionDomain().setCollection("exportAndImportConfig").setDatabaseName("knowledgegraphSystem").setPrimaryKey("code").setApplication(customPublishParam.getApplication());
        if (!CollectionUtils.isEmpty(pkValueList)) {
            List cqlList = DeployAppReqDto.collectMongoData((CustomPublishParam)customPublishParam, (CollectionDomain)collectionDomain, pkValueList);
            deployAppReqDto.setSinglePublishMongoData(cqlList, pkValueList, collectionDomain);
        }
    }

    private static void mongoActivityConfigsBasicData(DeployAppReqDto deployAppReqDto, CustomPublishParam customPublishParam) {
        List pkValueList = customPublishParam.getPublishEntityList().stream().filter(publishEntity -> publishEntity.getType().equals("DataEntry") || publishEntity.getType().equals("Statement")).map(pe -> pe.getPkValue()).collect(Collectors.toList());
        CollectionDomain collectionDomain = new CollectionDomain().setCollection("activityConfigsBasic").setDatabaseName("knowledgegraphSystem").setPrimaryKey("code").setApplication(customPublishParam.getApplication());
        if (!CollectionUtils.isEmpty(pkValueList)) {
            List cqlList = DeployAppReqDto.collectMongoData((CustomPublishParam)customPublishParam, (CollectionDomain)collectionDomain, pkValueList);
            deployAppReqDto.setSinglePublishMongoData(cqlList, pkValueList, collectionDomain);
        }
    }

    public static List<JSONObject> collectMongoData(CustomPublishParam customPublishParam, CollectionDomain collectionDomain, List<Object> pkValueList) {
        ArrayList<JSONObject> res = new ArrayList<JSONObject>();
        if (CollUtil.isEmpty(pkValueList)) {
            return res;
        }
        File compileDataDirector = customPublishParam.getCompileDataDirector();
        String path = compileDataDirector.getPath();
        String compileVersion = customPublishParam.getCompileVersion();
        File file = SafeFileUtils.createFile((String)(path + File.separator + collectionDomain.getDatabaseName() + File.separator + collectionDomain.getCollection() + File.separator + compileVersion + ".json"));
        if (file.exists()) {
            List data = FileUtil.readLines((File)file, (Charset)Charset.forName("utf-8"));
            for (String line : data) {
                JSONObject jsonObject = JSONObject.parseObject((String)line);
                if (!pkValueList.contains(jsonObject.getString(collectionDomain.getPrimaryKey()))) continue;
                jsonObject.remove((Object)"_id");
                jsonObject.remove((Object)"isMigrate");
                jsonObject.put("version", (Object)"1.0");
                res.add(jsonObject);
            }
        }
        return res;
    }

    public static List<String> collectNeo4jRelation(CustomPublishParam customPublishParam) {
        String compileVersion;
        ArrayList<String> res = new ArrayList<String>();
        File compileDataDirector = customPublishParam.getCompileDataDirector();
        String path = compileDataDirector.getPath();
        File cypherFile = SafeFileUtils.createFile((String)(path + File.separator + "cypher" + File.separator + (compileVersion = customPublishParam.getCompileVersion()) + ".json"));
        if (cypherFile.exists()) {
            List<String> cqlList = FileUtil.readLines((File)cypherFile, (Charset)Charset.forName("utf-8"));
            cqlList = cqlList.stream().filter(cql -> cql.startsWith("match (fromNode:")).collect(Collectors.toList());
            return cqlList;
        }
        return res;
    }

    public static List<String> collectNeo4jData(CustomPublishParam customPublishParam, CollectionDomain collectionDomain, List<Object> pkValueList) {
        String compileVersion;
        ArrayList<String> res = new ArrayList<String>();
        if (CollUtil.isEmpty(pkValueList)) {
            return res;
        }
        File compileDataDirector = customPublishParam.getCompileDataDirector();
        String path = compileDataDirector.getPath();
        File cypherFile = SafeFileUtils.createFile((String)(path + File.separator + "cypher" + File.separator + (compileVersion = customPublishParam.getCompileVersion()) + ".json"));
        if (cypherFile.exists()) {
            List cqlList = FileUtil.readLines((File)cypherFile, (Charset)Charset.forName("utf-8"));
            cqlList = cqlList.stream().filter(cql -> cql.contains(StrUtil.format((CharSequence)"create (node:{}", (Object[])new Object[]{collectionDomain.getCollection()}))).collect(Collectors.toList());
            for (String cql2 : cqlList) {
                Boolean isPublishEntity = false;
                for (Object pkValue : pkValueList) {
                    String primaryKey = collectionDomain.getPrimaryKey();
                    if (!cql2.contains(primaryKey + ":'" + String.valueOf(pkValue) + "'")) continue;
                    isPublishEntity = true;
                    break;
                }
                if (!isPublishEntity.booleanValue()) continue;
                res.add(cql2);
            }
        }
        return res;
    }

    static {
        collectHandles.add((d, c) -> DeployAppReqDto.neo4jActivityData((DeployAppReqDto)d, (CustomPublishParam)c));
        collectHandles.add((d, c) -> DeployAppReqDto.neo4jTagData((DeployAppReqDto)d, (CustomPublishParam)c));
        collectHandles.add((d, c) -> DeployAppReqDto.neo4jLanguageData((DeployAppReqDto)d, (CustomPublishParam)c));
        collectHandles.add((d, c) -> DeployAppReqDto.neo4jRelatedObjectData((DeployAppReqDto)d, (CustomPublishParam)c));
        collectHandles.add((d, c) -> DeployAppReqDto.mongoTaggingDataData((DeployAppReqDto)d, (CustomPublishParam)c));
        collectHandles.add((d, c) -> DeployAppReqDto.mongoActivityConfigsData((DeployAppReqDto)d, (CustomPublishParam)c));
        collectHandles.add((d, c) -> DeployAppReqDto.mongoApplicationRelationData((DeployAppReqDto)d, (CustomPublishParam)c));
        collectHandles.add((d, c) -> DeployAppReqDto.mongoRuleData((DeployAppReqDto)d, (CustomPublishParam)c));
        collectHandles.add((d, c) -> DeployAppReqDto.mongoPageUIElementData((DeployAppReqDto)d, (CustomPublishParam)c));
        collectHandles.add((d, c) -> DeployAppReqDto.mongoExportAndImportConfig((DeployAppReqDto)d, (CustomPublishParam)c));
        collectHandles.add((d, c) -> DeployAppReqDto.mongoActivityConfigsBasicData((DeployAppReqDto)d, (CustomPublishParam)c));
        collectHandles.add((d, c) -> DeployAppReqDto.neo4jRelation((DeployAppReqDto)d, (CustomPublishParam)c));
    }
}

