/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.http.kmDeployerService;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.config.ModuleConfig;
import com.digiwin.athena.athena_deployer_service.domain.kmDeployer.KmDeploySwitchParam;
import com.digiwin.athena.athena_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class KmDeployerServiceApiHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KmDeployerServiceApiHelper.class);
    @Autowired
    private ModuleConfig moduleConfig;
    @Autowired
    private IamService iamService;
    private RestTemplate restTemplate;

    @Autowired
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public String deployAppDataByKm(KmDeploySwitchParam kmDeploySwitchParam) {
        String token = this.iamService.getIntegrationToken(kmDeploySwitchParam.getCurTenantId());
        String url = this.moduleConfig.getKmDeployerService().getDomain() + "/km-deployer-service/publish/deployApp";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=UTF-8");
        headers.put("token", token);
        log.info("km-deployApp url:{}", (Object)url);
        log.info("km-deployApp headers:{}", headers);
        log.info("km-deployApp body:{}", (Object)kmDeploySwitchParam);
        String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).addHeaders(headers)).body(JSON.toJSONString((Object)kmDeploySwitchParam)).execute().body();
        log.info("km-deployApp response:{}", (Object)response);
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        return responseObj.getString("eventId");
    }

    public String switchAppDataByKm(KmDeploySwitchParam kmDeploySwitchParam) {
        String token = this.iamService.getIntegrationToken(kmDeploySwitchParam.getCurTenantId());
        String url = this.moduleConfig.getKmDeployerService().getDomain() + "/km-deployer-service/publish/switchApp";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=UTF-8");
        headers.put("token", token);
        log.info("km-switchApp url:{}", (Object)url);
        log.info("km-switchApp headers:{}", headers);
        log.info("km-switchApp body:{}", (Object)kmDeploySwitchParam);
        String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).addHeaders(headers)).body(JSON.toJSONString((Object)kmDeploySwitchParam)).execute().body();
        log.info("km-switchApp response:{}", (Object)response);
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        return responseObj.getString("eventId");
    }

    public JSONArray processLogsByKm(String eventId, String tenantId) {
        String token = this.iamService.getIntegrationToken(tenantId);
        String url = this.moduleConfig.getKmDeployerService().getDomain() + "/km-deployer-service/publish/deployLogs";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=UTF-8");
        headers.put("token", token);
        JSONObject body = new JSONObject();
        body.put("eventId", (Object)eventId);
        log.info("km-deployLogs url:{}", (Object)url);
        log.info("km-deployLogs headers:{}", headers);
        log.info("km-deployLogs body:{}", (Object)body);
        String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).addHeaders(headers)).body(JSON.toJSONString((Object)body)).execute().body();
        log.info("km-deployLogs response:{}", (Object)response);
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        return responseObj.getJSONArray("data");
    }

    public Boolean checkApp(String sourceId, String tenantId) {
        String token = this.iamService.getIntegrationToken(tenantId);
        String url = this.moduleConfig.getKmDeployerService().getDomain() + "/km-deployer-service/deploy/checkApp";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("token", token);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("sourceId", sourceId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)httpHeaders);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        JSONObject res = JSON.parseObject((String)((String)response.getBody()));
        if (!res.getInteger("code").equals(0)) {
            log.error(String.format("checkApp \u8bf7\u6c42\u5f02\u5e38:%s", response.getBody()));
            throw new RuntimeException("checkApp \u8bf7\u6c42\u5f02\u5e38");
        }
        return res.getBoolean("data");
    }

    public void parseResponse(JSONObject res) {
        Integer code = res.getInteger("code");
        if (code == null || code != 0) {
            throw new BusinessException(JSON.toJSONString((Object)res));
        }
    }
}

