/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.http.scrumbi;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.config.ModuleConfig;
import com.digiwin.athena.athena_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.athena_deployer_service.http.scrumbi.dto.DeleteData;
import com.digiwin.athena.athena_deployer_service.http.scrumbi.dto.DictionaryWordHttpVo;
import com.digiwin.athena.athena_deployer_service.http.scrumbi.dto.PushSynonymDto;
import com.digiwin.athena.athena_deployer_service.http.scrumbi.dto.RHSynonymHttpVo;
import com.digiwin.athena.athena_deployer_service.http.scrumbi.dto.StandardParams;
import com.digiwin.athena.athena_deployer_service.http.scrumbi.dto.Synonym;
import com.digiwin.athena.athena_deployer_service.http.scrumbi.dto.SynonymHttpVo;
import com.digiwin.athena.athena_deployer_service.http.scrumbi.dto.UpsertData;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import com.digiwin.athena.athena_deployer_service.util.LogUtils;
import com.digiwin.athena.athena_deployer_service.util.SynonymUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ScrumbiApiHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScrumbiApiHelper.class);
    public static final String UPSERT = "es/metadata/upsert";
    public static final String DELETE = "es/metadata/delete";
    @Autowired
    private ModuleConfig moduleConfig;
    @Autowired
    private IamService iamService;
    @Value(value="${appToken}")
    private String appToken;

    public void pushSynonym(PushSynonymDto dto) {
        String message = "\u8c03\u7528\u8bed\u4e49\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
        String timeout = "\u8c03\u7528\u8bed\u4e49\u63a5\u53e3\u8d85\u65f6\uff0c\u5931\u8d25\u539f\u56e0:%s";
        String url = this.moduleConfig.getScrumbi().getDomain() + "/scrumbi/pushAppStandardWord";
        String messageId = IdUtil.fastUUID().replace("-", "");
        try {
            List synonymHttpVos = this.parseSynonymHttpVo(dto.getSynonyms(), dto.getVersion());
            String tenantId = dto.getCurrTenantId();
            String token = this.iamService.getIntegrationToken(tenantId);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json; charset=UTF-8");
            headers.put("token", token);
            log.info("\u5f00\u59cb\u5411\u540c\u4e49\u8bcd\u5e93\u63a8\u9001\u6570\u636e\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a:{}\u63a8\u9001\u7684\u6570\u636e\u4e3a:{}", (Object)url, (Object)synonymHttpVos.size());
            String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).addHeaders(headers)).body(JSON.toJSONString((Object)synonymHttpVos)).execute().body();
            log.info("\u5f00\u59cb\u5411\u540c\u4e49\u8bcd\u5e93\u63a8\u9001\u6570\u636e response:{}", (Object)response);
            JSONObject responseObj = JSON.parseObject((String)response);
            if (responseObj.getInteger("code") != 200) {
                log.info("\u540c\u4e49\u8bcd\u5e93\u63a8\u9001\u6570\u636e\u5931\u8d25\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a:{},\u63a8\u9001\u5f02\u5e38\u4fe1\u606f:{}", (Object)url, (Object)responseObj);
                LogUtils.buildAgileLog((String)dto.getAppCode(), (String)LogUtils.MODULE_AADCS, (String)"pushSynonym", (String)LogUtils.AADCS_500_0009, (String)JSON.toJSONString((Object)dto), (String)String.format(message, JSON.toJSONString((Object)responseObj)), (String)String.format("\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff0c\u5e76\u63d0\u4f9b\u6d88\u606f\u5e8f\u5217\u53f7\uff08%s\uff09", messageId), (String)messageId);
                throw new BusinessException(responseObj.toJSONString());
            }
            LogUtils.buildAgileLog((String)dto.getAppCode(), (String)LogUtils.MODULE_AADCS, (String)"pushSynonym", (String)LogUtils.SUCCESS, (String)JSON.toJSONString((Object)dto), (String)JSON.toJSONString((Object)responseObj), (String)"", (String)messageId);
        }
        catch (Exception exception) {
            log.info("\u540c\u4e49\u8bcd\u5e93\u63a8\u9001\u6570\u636e\u5931\u8d25\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a:{},\u63a8\u9001\u5f02\u5e38\u4fe1\u606f:{}", (Object)url, (Object)exception.getMessage());
            LogUtils.buildAgileLog((String)dto.getAppCode(), (String)LogUtils.MODULE_AADCS, (String)"pushSynonym", (String)LogUtils.AADCS_504_0003, (String)JSON.toJSONString((Object)dto), (String)String.format(timeout, exception.getMessage()), (String)String.format("\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\u68c0\u67e5%s\u670d\u52a1", LogUtils.THIRD_SCRUMBI), (String)messageId);
            throw new BusinessException(exception.getMessage());
        }
    }

    public void pushSynonymToAI(PushSynonymDto dto) {
        String message = "\u8c03\u7528\u5927AI\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
        String timeout = "\u8c03\u7528\u5927AI\u63a5\u53e3\u8d85\u65f6\uff0c\u5931\u8d25\u539f\u56e0:%s";
        String messageId = IdUtil.fastUUID().replace("-", "");
        String url = this.moduleConfig.getRh().getDomain() + "/api/ai/RequestHDL";
        try {
            List sourceList = dto.getSynonyms();
            String tenantId = dto.getCurrTenantId();
            String token = this.iamService.getIntegrationToken(tenantId);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json; charset=UTF-8");
            headers.put("token", token);
            headers.put("digi-middleware-auth-user", token);
            headers.put("digi-middleware-auth-app", this.appToken);
            if (CollectionUtils.isEmpty((Collection)sourceList)) {
                return;
            }
            RHSynonymHttpVo delVo = new RHSynonymHttpVo();
            ArrayList<UpsertData> data = new ArrayList<UpsertData>();
            DeleteData deleteData = new DeleteData();
            deleteData.setAssistant_id(dto.getAppCode());
            SynonymUtil.generateRHHttpVo((RHSynonymHttpVo)delVo, (String)DELETE, null, (List)ListUtil.toList((Object[])new DeleteData[]{deleteData}), (String)dto.getVersion());
            JSONObject delBody = JSON.parseObject((String)JSON.toJSONString((Object)delVo));
            String delResponse = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).addHeaders(headers)).body(JSON.toJSONString((Object)delBody)).execute().body();
            log.info("\u5f00\u59cb\u5220\u9664\u540c\u4e49\u8bcd\u6570\u636e response:{}", (Object)delResponse);
            JSONObject responseObj = JSON.parseObject((String)delResponse);
            if (responseObj.getInteger("code") != 0 || responseObj.getJSONObject("data").getInteger("code") != 0) {
                log.error("\u5220\u9664\u540c\u4e49\u8bcd\u6570\u636e\u5931\u8d25\uff0c\u5220\u9664\u540c\u4e49\u8bcd\u6570\u636e\u5730\u5740\u4e3a:{},\u63a8\u9001\u5f02\u5e38\u4fe1\u606f:{}", (Object)url, (Object)responseObj);
                LogUtils.buildAgileLog((String)dto.getAppCode(), (String)LogUtils.MODULE_AADCS, (String)"pushSynonymToAI.delete", (String)LogUtils.AADCS_500_0010, (String)JSON.toJSONString((Object)delBody), (String)String.format(message, JSON.toJSONString((Object)responseObj)), (String)String.format("\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff0c\u5e76\u63d0\u4f9b\u6d88\u606f\u5e8f\u5217\u53f7\uff08%s\uff09", messageId), (String)messageId);
                return;
            }
            LogUtils.buildAgileLog((String)dto.getAppCode(), (String)LogUtils.MODULE_AADCS, (String)"pushSynonymToAI.delete", (String)LogUtils.SUCCESS, (String)JSON.toJSONString((Object)delBody), (String)JSON.toJSONString((Object)responseObj), (String)"", (String)messageId);
            RHSynonymHttpVo insertVo = new RHSynonymHttpVo();
            for (JSONObject jsonObject : sourceList) {
                Synonym synonym = (Synonym)JSON.parseObject((String)JSON.toJSONString((Object)jsonObject), Synonym.class);
                UpsertData upsertData = SynonymUtil.synonymToUpsertData((Synonym)synonym);
                data.add(upsertData);
            }
            SynonymUtil.generateRHHttpVo((RHSynonymHttpVo)insertVo, (String)UPSERT, data, null, (String)dto.getVersion());
            JSONObject instBody = JSON.parseObject((String)JSON.toJSONString((Object)insertVo));
            log.info("\u5f00\u59cb\u5411\u5927AI\u63a8\u9001\u540c\u4e49\u8bcd\u6570\u636e\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a:{}", (Object)url);
            String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).addHeaders(headers)).body(JSON.toJSONString((Object)instBody)).execute().body();
            log.info("\u5f00\u59cb\u5411\u5927AI\u63a8\u9001\u540c\u4e49\u8bcd\u6570\u636e response:{}", (Object)response);
            JSONObject respObj = JSON.parseObject((String)response);
            if (respObj.getInteger("code") != 0) {
                log.error("\u5411\u5927AI\u63a8\u9001\u540c\u4e49\u8bcd\u6570\u636e\u5931\u8d25\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a:{},\u63a8\u9001\u5f02\u5e38\u4fe1\u606f:{}", (Object)url, (Object)respObj);
                LogUtils.buildAgileLog((String)dto.getAppCode(), (String)LogUtils.MODULE_AADCS, (String)"pushSynonymToAI.insert", (String)LogUtils.AADCS_500_0011, (String)JSON.toJSONString((Object)instBody), (String)String.format(message, JSON.toJSONString((Object)respObj)), (String)String.format("\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff0c\u5e76\u63d0\u4f9b\u6d88\u606f\u5e8f\u5217\u53f7\uff08%s\uff09", messageId), (String)messageId);
                throw new BusinessException(respObj.toJSONString());
            }
            LogUtils.buildAgileLog((String)dto.getAppCode(), (String)LogUtils.MODULE_AADCS, (String)"pushSynonymToAI.insert", (String)LogUtils.SUCCESS, (String)JSON.toJSONString((Object)instBody), (String)JSON.toJSONString((Object)respObj), (String)"", (String)messageId);
        }
        catch (Exception e) {
            log.error("\u5411\u5927AI\u63a8\u9001\u540c\u4e49\u8bcd\u6570\u636e\u5931\u8d25\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a\uff1a{}\uff0c\u63a8\u9001\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)url, (Object)e.getMessage());
            LogUtils.buildAgileLog((String)dto.getAppCode(), (String)LogUtils.MODULE_AADCS, (String)"pushSynonymToAI", (String)LogUtils.AADCS_504_0004, (String)JSON.toJSONString((Object)dto), (String)String.format(message, e.getMessage()), (String)String.format(timeout, LogUtils.THIRD_AI), (String)messageId);
            throw new BusinessException(e.getMessage());
        }
    }

    public List<SynonymHttpVo> parseSynonymHttpVo(List<JSONObject> list, String version) {
        ArrayList<SynonymHttpVo> synonymHttpVos = new ArrayList<SynonymHttpVo>();
        if (CollectionUtils.isEmpty(list)) {
            return synonymHttpVos;
        }
        for (JSONObject jsonObject : list) {
            Synonym synonym = (Synonym)JSONObject.parseObject((String)JSON.toJSONString((Object)jsonObject), Synonym.class);
            SynonymHttpVo synonymHttpVo = new SynonymHttpVo();
            synonymHttpVo.setId(synonym.getCode() + "_" + version);
            synonymHttpVo.setVersion(version);
            synonymHttpVo.setDescription(synonym.getDescription());
            synonymHttpVo.setEntity_type(synonym.getEntityTypeName());
            synonymHttpVo.setApplication_code(synonym.getAppCode());
            synonymHttpVo.setStandard_name(synonym.getProperNoun());
            synonymHttpVo.setSynonyms((Collection)synonym.getZh_CN());
            synonymHttpVo.setDel_flag(synonym.getDelFlag());
            synonymHttpVos.add(synonymHttpVo);
        }
        return synonymHttpVos;
    }

    public void pushStandardParams(PushSynonymDto dto) {
        String message = "\u8c03\u7528\u8bed\u4e49\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
        String timeout = "\u8c03\u7528\u8bed\u4e49\u63a5\u53e3\u8d85\u65f6\uff0c\u5931\u8d25\u539f\u56e0:%s";
        String messageId = IdUtil.fastUUID().replace("-", "");
        String url = this.moduleConfig.getScrumbi().getDomain() + "/scrumbi/pushDictionary";
        try {
            List dictionaryHttpVos = this.parseDictionaryHttpVo(dto.getStandardParams(), dto.getVersion());
            String tenantId = dto.getCurrTenantId();
            String token = this.iamService.getIntegrationToken(tenantId);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json; charset=UTF-8");
            headers.put("token", token);
            log.info("\u5f00\u59cb\u63a8\u9001\u6807\u51c6\u53c2\u6570\u6570\u636e\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a:{},\u63a8\u9001\u7684\u6570\u636e\u4e3a:{}", (Object)url, (Object)dictionaryHttpVos.size());
            String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).addHeaders(headers)).body(JSON.toJSONString((Object)dictionaryHttpVos)).execute().body();
            log.info("\u5f00\u59cb\u63a8\u9001\u6807\u51c6\u53c2\u6570\u6570\u636e response:{}", (Object)response);
            JSONObject responseObj = JSON.parseObject((String)response);
            if (responseObj.getInteger("code") != 200) {
                LogUtils.buildAgileLog((String)dto.getAppCode(), (String)LogUtils.MODULE_AADCS, (String)"pushStandardParams", (String)LogUtils.AADCS_500_0012, (String)JSON.toJSONString((Object)dto), (String)String.format(message, JSON.toJSONString((Object)responseObj)), (String)String.format("\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff0c\u5e76\u63d0\u4f9b\u6d88\u606f\u5e8f\u5217\u53f7\uff08%s\uff09", messageId), (String)messageId);
                log.info("\u540c\u4e49\u8bcd\u5e93\u63a8\u9001\u6570\u636e\u5931\u8d25\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a:{},\u63a8\u9001\u5f02\u5e38\u4fe1\u606f:{}", (Object)url, (Object)responseObj);
            }
            LogUtils.buildAgileLog((String)dto.getAppCode(), (String)LogUtils.MODULE_AADCS, (String)"pushStandardParams", (String)LogUtils.SUCCESS, (String)JSON.toJSONString((Object)dto), (String)JSON.toJSONString((Object)responseObj), (String)"", (String)messageId);
        }
        catch (Exception exception) {
            LogUtils.buildAgileLog((String)dto.getAppCode(), (String)LogUtils.MODULE_AADCS, (String)"pushStandardParams", (String)LogUtils.AADCS_504_0005, (String)JSON.toJSONString((Object)dto), (String)String.format(timeout, exception.getMessage()), (String)String.format("\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\u68c0\u67e5%s\u670d\u52a1", LogUtils.THIRD_SCRUMBI), (String)messageId);
            log.info("\u63a8\u9001\u6807\u51c6\u53c2\u6570\u6570\u636e\u5931\u8d25\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a\uff1a" + url + "\u63a8\u9001\u5f02\u5e38\u4fe1\u606f" + exception.getMessage());
        }
    }

    private List<DictionaryWordHttpVo> parseDictionaryHttpVo(List<JSONObject> standardParams, String version) {
        ArrayList<DictionaryWordHttpVo> dictionaryWordHttpVos = new ArrayList<DictionaryWordHttpVo>();
        if (CollectionUtils.isEmpty(standardParams)) {
            return dictionaryWordHttpVos;
        }
        for (JSONObject jsonObject : standardParams) {
            StandardParams params = (StandardParams)JSONObject.parseObject((String)JSON.toJSONString((Object)jsonObject), StandardParams.class);
            DictionaryWordHttpVo dictionaryWordHttpVo = new DictionaryWordHttpVo();
            dictionaryWordHttpVo.setApplicationCode(params.getAthena_namespace());
            dictionaryWordHttpVo.setVersion(version);
            dictionaryWordHttpVo.setType(params.getData_type());
            dictionaryWordHttpVo.setName(params.getData_name());
            dictionaryWordHttpVo.setTitle(params.getName());
            dictionaryWordHttpVos.add(dictionaryWordHttpVo);
        }
        return dictionaryWordHttpVos;
    }

    public void pushNounKnowledge(PushSynonymDto dto) {
        String message = "\u8c03\u7528\u8bed\u4e49\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
        String timeout = "\u8c03\u7528\u8bed\u4e49\u63a5\u53e3\u8d85\u65f6\uff0c\u5931\u8d25\u539f\u56e0:%s";
        String url = this.moduleConfig.getScrumbi().getDomain() + "/scrumbi/nounKnowledge/push";
        String messageId = IdUtil.fastUUID().replace("-", "");
        try {
            List nounKnowledge = dto.getNounKnowledge();
            String tenantId = dto.getCurrTenantId();
            String token = this.iamService.getIntegrationToken(tenantId);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json; charset=UTF-8");
            headers.put("token", token);
            log.info("\u5f00\u59cb\u5411\u540d\u8bcd\u77e5\u8bc6\u5e93\u63a8\u9001\u6570\u636e\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a:{}\u63a8\u9001\u7684\u6570\u636e\u4e3a:{}", (Object)url, (Object)nounKnowledge.size());
            String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).addHeaders(headers)).body(JSON.toJSONString((Object)nounKnowledge)).execute().body();
            log.info("\u5f00\u59cb\u5411\u540d\u8bcd\u77e5\u8bc6\u5e93\u63a8\u9001\u6570\u636e response:{}", (Object)response);
            JSONObject responseObj = JSON.parseObject((String)response);
            if (responseObj.getInteger("code") != 200) {
                log.info("\u540d\u8bcd\u77e5\u8bc6\u63a8\u9001\u5931\u8d25\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a:{},\u63a8\u9001\u5f02\u5e38\u4fe1\u606f:{}", (Object)url, (Object)responseObj);
                LogUtils.buildAgileLog((String)dto.getAppCode(), (String)LogUtils.MODULE_AADCS, (String)"pushNounKnowledge", (String)LogUtils.AADCS_500_0009, (String)JSON.toJSONString((Object)dto), (String)String.format(message, JSON.toJSONString((Object)responseObj)), (String)String.format("\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff0c\u5e76\u63d0\u4f9b\u6d88\u606f\u5e8f\u5217\u53f7\uff08%s\uff09", messageId), (String)messageId);
                throw new BusinessException(responseObj.toJSONString());
            }
            LogUtils.buildAgileLog((String)dto.getAppCode(), (String)LogUtils.MODULE_AADCS, (String)"pushNounKnowledge", (String)LogUtils.SUCCESS, (String)JSON.toJSONString((Object)dto), (String)JSON.toJSONString((Object)responseObj), (String)"", (String)messageId);
        }
        catch (Exception exception) {
            log.info("\u540d\u8bcd\u77e5\u8bc6\u63a8\u9001\u5931\u8d25\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a:{},\u63a8\u9001\u5f02\u5e38\u4fe1\u606f:{}", (Object)url, (Object)exception.getMessage());
            LogUtils.buildAgileLog((String)dto.getAppCode(), (String)LogUtils.MODULE_AADCS, (String)"pushNounKnowledge", (String)LogUtils.AADCS_504_0003, (String)JSON.toJSONString((Object)dto), (String)String.format(timeout, exception.getMessage()), (String)String.format("\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\u68c0\u67e5%s\u670d\u52a1", LogUtils.THIRD_SCRUMBI), (String)messageId);
            throw new BusinessException(exception.getMessage());
        }
    }

    public void pushHabitKnowledge(PushSynonymDto dto) {
        String message = "\u8c03\u7528\u8bed\u4e49\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
        String timeout = "\u8c03\u7528\u8bed\u4e49\u63a5\u53e3\u8d85\u65f6\uff0c\u5931\u8d25\u539f\u56e0:%s";
        String url = this.moduleConfig.getScrumbi().getDomain() + "/scrumbi/habitualKnowledge/push";
        String messageId = IdUtil.fastUUID().replace("-", "");
        try {
            List habitKnowledge = dto.getHabitKnowledge();
            String tenantId = dto.getCurrTenantId();
            String token = this.iamService.getIntegrationToken(tenantId);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json; charset=UTF-8");
            headers.put("token", token);
            log.info("\u5f00\u59cb\u5411\u4e60\u60ef\u77e5\u8bc6\u5e93\u63a8\u9001\u6570\u636e\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a:{}\u63a8\u9001\u7684\u6570\u636e\u4e3a:{}", (Object)url, (Object)habitKnowledge.size());
            String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).addHeaders(headers)).body(JSON.toJSONString((Object)habitKnowledge)).execute().body();
            log.info("\u5f00\u59cb\u5411\u4e60\u60ef\u77e5\u8bc6\u5e93\u63a8\u9001\u6570\u636e response:{}", (Object)response);
            JSONObject responseObj = JSON.parseObject((String)response);
            if (responseObj.getInteger("code") != 200) {
                log.info("\u4e60\u60ef\u77e5\u8bc6\u63a8\u9001\u5931\u8d25\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a:{},\u63a8\u9001\u5f02\u5e38\u4fe1\u606f:{}", (Object)url, (Object)responseObj);
                LogUtils.buildAgileLog((String)dto.getAppCode(), (String)LogUtils.MODULE_AADCS, (String)"pushHabitKnowledge", (String)LogUtils.AADCS_500_0009, (String)JSON.toJSONString((Object)dto), (String)String.format(message, JSON.toJSONString((Object)responseObj)), (String)String.format("\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff0c\u5e76\u63d0\u4f9b\u6d88\u606f\u5e8f\u5217\u53f7\uff08%s\uff09", messageId), (String)messageId);
                throw new BusinessException(responseObj.toJSONString());
            }
            LogUtils.buildAgileLog((String)dto.getAppCode(), (String)LogUtils.MODULE_AADCS, (String)"pushHabitKnowledge", (String)LogUtils.SUCCESS, (String)JSON.toJSONString((Object)dto), (String)JSON.toJSONString((Object)responseObj), (String)"", (String)messageId);
        }
        catch (Exception exception) {
            log.info("\u4e60\u60ef\u77e5\u8bc6\u63a8\u9001\u5931\u8d25\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a:{},\u63a8\u9001\u5f02\u5e38\u4fe1\u606f:{}", (Object)url, (Object)exception.getMessage());
            LogUtils.buildAgileLog((String)dto.getAppCode(), (String)LogUtils.MODULE_AADCS, (String)"pushHabitKnowledge", (String)LogUtils.AADCS_504_0003, (String)JSON.toJSONString((Object)dto), (String)String.format(timeout, exception.getMessage()), (String)String.format("\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\u68c0\u67e5%s\u670d\u52a1", LogUtils.THIRD_SCRUMBI), (String)messageId);
            throw new BusinessException(exception.getMessage());
        }
    }
}

