/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.http.tenantdesigner;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.config.ModuleConfig;
import com.digiwin.athena.athena_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TenantDesignerApiHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantDesignerApiHelper.class);
    @Autowired
    private ModuleConfig moduleConfig;
    @Autowired
    private IamService iamService;
    @Value(value="${appToken}")
    private String appToken;
    private static final String DesignAppDataSync = "/athena-designer/tenant/application/publishData/sync";
    private static final String DesignAppDataDelete = "/athena-designer/tenant/application/delete";

    public void syncDesignAppDataToTadpDb(JSONObject data, String tenantId) {
        String url = this.moduleConfig.getAtdp().getDomain() + DesignAppDataSync;
        try {
            String integrationToken = this.iamService.getIntegrationToken(tenantId);
            String response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)url).body(JSON.toJSONString((Object)data)).header("digi-middleware-auth-app", this.appToken)).header("digi-middleware-auth-user", integrationToken)).execute().body();
            JSONObject responseObj = JSON.parseObject((String)response);
            if (!responseObj.getInteger("code").equals(0)) {
                log.error("\u540c\u6b65\u5e94\u7528\u6570\u636e\u5230\u79df\u6237\u7ea7\u5f00\u53d1\u5e73\u53f0\u5931\u8d25\uff0c\u8fd4\u56de\u6570\u636e\uff1a" + response);
                throw new BusinessException("\u540c\u6b65\u5e94\u7528\u6570\u636e\u5230\u79df\u6237\u7ea7\u5f00\u53d1\u5e73\u53f0\u5931\u8d25\uff0c\u8fd4\u56de\u6570\u636e\uff1a" + response);
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u540c\u6b65\u5e94\u7528\u6570\u636e\u5230\u79df\u6237\u7ea7\u5f00\u53d1\u5e73\u53f0\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public void deployCleanTenantApp(JSONObject data, String tenantId) {
        String url = this.moduleConfig.getAtdp().getDomain() + DesignAppDataDelete;
        try {
            String integrationToken = this.iamService.getIntegrationToken(tenantId);
            String response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)url).body(JSON.toJSONString((Object)data)).header("digi-middleware-auth-app", this.appToken)).header("digi-middleware-auth-user", integrationToken)).execute().body();
            JSONObject responseObj = JSON.parseObject((String)response);
            log.info("deleteTenantApplication-response:{}", (Object)responseObj);
            if (!responseObj.getInteger("code").equals(0)) {
                log.error("\u8bf7\u6c42\u79df\u6237\u7ea7\u5f00\u53d1\u5e73\u53f0\u63a5\u53e3\u5220\u9664\u5f02\u5e38\u5f02\u5e38\uff0c\u8fd4\u56de\u6570\u636e\uff1a" + response);
                throw new BusinessException("\u8bf7\u6c42\u79df\u6237\u7ea7\u5f00\u53d1\u5e73\u53f0\u63a5\u53e3\u5220\u9664\u5f02\u5e38\u5f02\u5e38\uff0c\u8fd4\u56de\u6570\u636e\uff1a" + response);
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u8bf7\u6c42\u79df\u6237\u7ea7\u5f00\u53d1\u5e73\u53f0\u63a5\u53e3\u5220\u9664\u5f02\u5e38\u5f02\u5e38\uff01", (Throwable)e);
        }
    }
}

