/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.publish;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.athena_deployer_service.domain.deploy.CustomPublishParam;
import com.digiwin.athena.athena_deployer_service.domain.system.AthenaUser;
import com.digiwin.athena.athena_deployer_service.domain.template.AdTemplate;
import com.digiwin.athena.athena_deployer_service.http.deployer.DeployerApiHelper;
import com.digiwin.athena.athena_deployer_service.publish.CustomPublish;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import com.digiwin.athena.athena_deployer_service.service.sd.SmartDataService;
import com.digiwin.athena.athena_deployer_service.util.SafeFileUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdTemplatePublish
implements CustomPublish {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdTemplatePublish.class);
    @Autowired
    private SmartDataService smartDataService;
    @Autowired
    private DeployerApiHelper deployerApiHelper;
    @Autowired
    private IamService iamService;

    public void publishWithCompile(CustomPublishParam customPublishParam) {
        List publishEntityList = customPublishParam.getPublishEntityList();
        File compileDataDirector = customPublishParam.getCompileDataDirector();
        String compileVersion = customPublishParam.getCompileVersion();
        AthenaUser currentUser = customPublishParam.getCurrentUser();
        List tenantUsers = customPublishParam.getTenantUsers();
        List tenantIds = tenantUsers.stream().map(t -> t.getTenantId()).collect(Collectors.toList());
        List adTemplateIdList = publishEntityList.stream().filter(publishEntity -> "adTemplate".equals(publishEntity.getType())).map(publishEntity -> String.format("%s_%s", String.valueOf(publishEntity.getPkValue()), publishEntity.getTenantId())).collect(Collectors.toList());
        String path = compileDataDirector.getPath();
        File adTemplateFile = SafeFileUtils.createFile((String)(path + File.separator + "athenadesigner" + File.separator + "adTemplate" + File.separator + compileVersion + ".json"));
        if (adTemplateFile.exists()) {
            List data = FileUtil.readLines((File)adTemplateFile, (Charset)Charset.forName("utf-8"));
            data = data.stream().map(s -> s.replaceAll("\\{athena_version}", "1.0")).collect(Collectors.toList());
            List adTemplateList = data.stream().map(item -> (AdTemplate)JSON.parseObject((String)item, AdTemplate.class)).collect(Collectors.toList());
            List<AdTemplate> needPublishAdTemplate = adTemplateList.stream().filter(adTemplate -> adTemplateIdList.contains(String.format("%s_%s", adTemplate.getId(), adTemplate.getTenantId()))).collect(Collectors.toList());
            ArrayList needPublishSysAdTemplate = new ArrayList();
            ArrayList needPublishUcAdTemplate = new ArrayList();
            needPublishAdTemplate.forEach(adTemplate -> {
                String integrationToken = this.iamService.getIntegrationToken(currentUser.getTenantId());
                if (adTemplate.getTenantId() != null && !adTemplate.getTenantId().equals("SYSTEM")) {
                    String[] ucTenantIdList;
                    for (String tenantId : ucTenantIdList = adTemplate.getTenantId().split(";")) {
                        this.smartDataService.batchPublishV2(integrationToken, (List)ListUtil.toList((Object[])new String[]{tenantId}), adTemplate, Integer.valueOf(1));
                    }
                    needPublishUcAdTemplate.add(adTemplate);
                } else {
                    this.smartDataService.batchPublishV2(integrationToken, tenantIds, adTemplate, Integer.valueOf(0));
                    needPublishSysAdTemplate.add(adTemplate);
                }
            });
        }
    }
}

